/// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.types.CqMatrix;

/**
 * Abstract base class from which all shaders must be defined.
 * 
 * 
 * @author NTT DATA Corporation
 */


public strictfp interface IqShader {
	
	//fXgN^
	abstract public void 	destruct();
	
	/**
	 * Get the shader matrix, the transformation at the time this shader was instantiated.
	 * 
	 * 
	 * @return
	 */
	abstract public	CqMatrix	matCurrent();
	
	/**
	 * Set the naem of the shader.<br>
	 * ̃VF[_̖Oݒ
	 * 
	 * @param strName	VF[_
	 */
	abstract public	void	SetstrName( final String strName );
	
	/**
	 * Get the name of this shader.<br>
	 * ̃VF[_̖O擾
	 * 
	 * @return	VF[_
	 */
	abstract public	String strName();
	
//	public	void	SetArgument( final String name, EqVariableType type, final String space, void* val );
	abstract public	void	SetArgument( final String name, EqVariableType type, final String space, Object val );
	abstract public	void	SetArgument( CqParameter pParam, IqSurface pSurface );
	
	/** 
	 * Find a named argument.
	 * @param name Character pointer to argument name.
	 * @return A pointer to the argument data if it exists, NULL otherwise.
	 */
	abstract public	IqShaderData	FindArgument( final String name );
	
	/** 
	 * Get the value of a named shader paramter.
	 * @param name The name of the shader paramter.
	 * @param res IqShaderData pointer to store the result in, will be typechecked for suitability.
	 * @return Boolean indicating the parameter existed and res was of an appropriate type.
	 */
	abstract public	boolean	GetValue( final String name, IqShaderData res );
	
	/** 
	 * Evaluate the shader code.
	 * @param pEnv The shader execution environment to evaluate within.
	 */
	abstract public	void	Evaluate( final IqShaderExecEnv pEnv );
	
	/** 
	 * Initialise the state of any arguments with default values.
	 */
	abstract public	void	PrepareDefArgs();
	
	/** 
	 * Prepare the shader for evaluation.
	 * @param uGridRes The resolution of the grid being shaded in u.
	 * @param vGridRes The resolution of the grid being shaded in v
	 * @param pEnv Pointer to the IqShaderExecEnv to evaluate within.
	 */
	abstract public void	Initialise( final int uGridRes, final int vGridRes, final IqShaderExecEnv pEnv );
	
	/** 
	 * Determine whether this shader is an aambient ligthsource shader.<br>
	 * i.e. A lightsource shader with no Illuminate or Solar finalructs.
	 * @return
	 */
	abstract public	boolean	fAmbient();
	
	/** 
	 * Duplicate this shader.
	 * @return A pointer to a new shader.
	 */
	abstract public IqShader		Clone();
	
	/** 
	 * Determine whether this shader uses the specified system variable.
	 * @param Var ID of the variable from EqEnvVars.
	 * @return
	 */
	abstract public	boolean	Uses( int Var );
	
	/** 
	 * Get a bit vector representing the system variables needed by this shader.
	 * @return
	 */
	abstract public	int	Uses();
	
	/**
	 * Variable creation function.
	 * 
	 * 
	 * @param Type
	 * @param Class
	 * @return
	 */
	abstract public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name, boolean fArgument, boolean fOutput );
	abstract public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name, boolean fArgument );
	abstract public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name );
//pNXŎB
//  final public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name, boolean fArgument );
//	{
//		return CreateVariable( Type, Class, name, fArgument, false );
//	}
//	final public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name ){
//		return CreateVariable( Type, Class, name, false, false );
//	}
	
	/** 
	 * Variable array creation function.
	 * 
	 * 
	 * @param Type
	 * @param Class
	 * @param name
	 * @param Count
	 * @param fArgument
	 * @return
	 */
	abstract public IqShaderData CreateVariableArray( EqVariableType Type, EqVariableClass Class, final String name, int Count, boolean fArgument, boolean fOutput  );
	abstract public IqShaderData CreateVariableArray( EqVariableType Type, EqVariableClass Class, final String name, int Count, boolean fArgument );
	abstract public IqShaderData CreateVariableArray( EqVariableType Type, EqVariableClass Class, final String name, int Count );
//	pNXŎB
//	final public IqShaderData CreateVariableArray( EqVariableType Type, EqVariableClass Class, final String name, int Count, boolean fArgument ){
//		return CreateVariableArray( Type, Class, name, Count, fArgument, false );
//	}
//	final public IqShaderData CreateVariableArray( EqVariableType Type, EqVariableClass Class, final String name, int Count ){
//		return CreateVariableArray( Type, Class, name, Count, false, false );
//	}
	
	/**
	 * Function to create some temporary storage which complies to the IqShaderData interface.
	 * 
	 * 
	 * @param type
	 * @param _class
	 * @return
	 */
	abstract public IqShaderData CreateTemporaryStorage( EqVariableType type, EqVariableClass _class );
	
	/**
	 * Function to destroy temporary storage created with CreateTemporaryStorage.
	 * 
	 * 
	 * @param pData
	 */
	abstract public void DeleteTemporaryStorage( IqShaderData pData );
	
	/** 
	 * Use the default surface shader for this implementation.
	 */
	abstract public void DefaultSurface( );
}
