// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import java.util.HashMap;

import net.cellcomputing.himawari.exception.DisplayNotFoundException;

/**
 * 
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp interface IqDDManager {
	
    /** 
     * Initialise the device manager.
     * @return
     */
    public	int	Initialise();
    
    /** 
     * Shutdown the device manager.
     * @return
     */
    public	int	Shutdown();
    
    /**
     * 
     * Add a display request to the managers list.
     * 
     * 
     * @param name
     * @param type
     * @param mode
     * @param modeID
     * @param dataOffset
     * @param dataSize
     * @param mapOfArguments
     * @return
     */
    public	int	AddDisplay( final String name, final String type, final String mode, int modeID, int dataOffset, int dataSize, HashMap<String,Object> mapOfArguments ) throws DisplayNotFoundException;
    
    /** 
     * Clear all display requests from the managers list.
     * @return
     */
    public	int	ClearDisplays();
    
    /** 
     * Open all displays in the managers list.
     * @return
     */
    public	int	OpenDisplays();
    
    /** 
     * Close all displays in the managers list, rendering is finished.
     * @return
     */
    public	int	CloseDisplays();
    
    /**
     * Display a bucket.
     * 
     * 
     * @param pBucket
     * @return
     */
    public	int	DisplayBucket( IqBucket pBucket );
    
    /**
     * Determine if any of the displays need the named shader variable.
     * 
     * 
     * @param var
     * @return
     */
    public boolean		fDisplayNeeds( final String var);
    
    /** 
     * Determine if any of the displays need the named shader variable.
     * @return
     */
    public int	Uses( );

}
