/// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * 
 * Agr[g̃C^[tF[X
 * 
 * @author NTT DATA Corporation
 */
public strictfp interface IqAttributes {
	
	public void destruct();
	
    /**
     * Get a named float attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	float[]		GetFloatAttribute( final String strName, final String strParam ) ;
    
    /**
     * Get a named integer attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	int[]		GetIntegerAttribute( final String strName, final String strParam ) ;
    
    /**
     * Get a named string attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	String[] 	GetStringAttribute( final String strName, final String strParam ) ;
    
    /**
     * Get a named point attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqVector3D[]	GetPointAttribute( final String strName, final String strParam ) ;
    
    /**
     * Get a named point attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqVector3D[]	GetVectorAttribute( final String strName, final String strParam ) ;
    
    /**
     * Get a named point attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqVector3D[]	GetNormalAttribute( final String strName, final String strParam ) ;
    
    /**
     * Get a named color attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqColor[]	GetColorAttribute( final String strName, final String strParam ) ;
    
    /**
     * Get a named matrix attribute as read only
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqMatrix[]	GetMatrixAttribute( final String strName, final String strParam ) ;

    /**
     * Get a named float attribute as writable
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	p_float[]		GetFloatAttributeWrite( final String strName, final String strParam );
    
    /**
     * Get a named integer attribute as writable
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	p_int[]		GetIntegerAttributeWrite( final String strName, final String strParam );
    
    /**
     * Get a named string attribute as writable
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	p_String[] 	GetStringAttributeWrite( final String strName, final String strParam );
    
    /**
     * Get a named point attribute as writable
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqVector3D[]	GetPointAttributeWrite( final String strName, final String strParam );
    
    /**
     * Get a named point attribute as writable
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqVector3D[]	GetVectorAttributeWrite( final String strName, final String strParam );
    
    /**
     * Get a named point attribute as writable
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqVector3D[]	GetNormalAttributeWrite( final String strName, final String strParam );
    
    /**
     * Get a named color attribute as writable
     * 
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqColor[]		GetColorAttributeWrite( final String strName, final String strParam );
    
    /** 
     * Get a named matrix attribute as writable
     * 
     * @param strName
     * @param strParam
     * @return
     */
    public	CqMatrix[]	GetMatrixAttributeWrite( final String strName, final String strParam );

    /** 
     * Get the current dislacement shader.
     * 
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     * @return a pointer to the displacement shader.
     */
    public	IqShader	pshadDisplacement( float time ) ;
    
    /** 
     * Set the current displacement shader.
     * 
     * @param pshadDisplacement a pointer to a shader to use as the displacement shader.
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     */
    public	void	SetpshadDisplacement( final IqShader pshadDisplacement, float time );

    /** 
     * Get the current area light source shader.
     * 
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     * @return a pointer to the displacement shader.
     */
    public	IqShader	pshadAreaLightSource( float time ) ;
    
    /** 
     * Set the current area light source shader.
     * 
     * @param pshadAreaLightSource a pointer to a shader to use as the area light source shader.
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     */
    public	void	SetpshadAreaLightSource( final IqShader pshadAreaLightSource, float time );

    /** 
     * Get the current surface shader.
     * 
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     * @return a pointer to the displacement shader.
     */
    public	IqShader	pshadSurface( float time ) ;
    
    /** 
     * Set the current surface shader.
     * 
     * @param pshadSurface a pointer to a shader to use as the surface shader.
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     */
    public	void	SetpshadSurface( final IqShader pshadSurface, float time );

    /** 
     * Get the current atmosphere shader.
     * 
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     * @return a pointer to the displacement shader.
     */
    public	IqShader	pshadAtmosphere( float time ) ;
    
    /** 
     * Set the current atmosphere shader.
     * 
     * @param pshadAtmosphere a pointer to a shader to use as the atmosphere shader.
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     */
    public	void	SetpshadAtmosphere( final IqShader pshadAtmosphere, float time );

    /**
     * Get the current external volume shader.
     * 
     * @param time the frame time to get the values in the case of a motion blurred attribute. (not used).
     * @return a pointer to the displacement shader.
     */
    public	IqShader	pshadExteriorVolume( float time ) ;
    
    /** 
     * Set the current external volume shader.
     * 
     * @param pshadExteriorVolume	a pointer to a shader to use as the exterior volume shader.
     * @param time	the frame time to get the values in the case of a motion blurred attribute. (not used).
     */
    public	void	SetpshadExteriorVolume( final IqShader pshadExteriorVolume, float time );

    /**
     * Get the current internal volume shader.
     * 
     * 
     * @param time	the frame time to get the values in the case of a motion blurred attribute. (not used).
     * @return	a pointer to the displacement shader.
     */
    public	IqShader	pshadAreaInteriorVolume( float time ) ;
    
    /**
     * Set the current internal volume shader.
     * 
     * 
     * @param pshadInteriorVolume	a pointer to a shader to use as the interior volume shader.
     * @param time	the frame time to get the values in the case of a motion blurred attribute. (not used).
     */
    public	void	SetpshadInteriorVolume( final IqShader pshadInteriorVolume, float time );

    /**
     * 
     * 
     * 
     * @return
     */
    public	int	cLights();
    
    /**
     * 
     * 
     * 
     * @param index
     * @return
     */
    public	IqLightsource	pLight( int index );
    
    //߂ƂƁB@2005.08.29 nttdata.
//#ifndef _DEBUG
    public	void	AddRef();
    public	void	Release();
//#else
//    public void AddRef(final String file, int line);
//    public void Release(final String file, int line);
//#endif
}
