// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.SqTransformation;

import static net.cellcomputing.himawari.library.RiGlobal.*;


/**
 * 
 * OtBbNXԂ̕ϊ`邽߂̃ReiB
 * 
 */
public strictfp class CqTransform extends CqMotionSpec<SqTransformation> implements IqTransform
{
	public static class Set {};
	public static class ConcatCurrent {};
	public static class SetCurrent {};
	
	private boolean		m_IsMoving = true;			///< Flag indicating this transformation describes a changing transform.
	private CqMatrix		m_StaticMatrix = new CqMatrix();		///< Matrix storing the transformation should there be no motion involved.
	private boolean		m_Handedness = true;		///< Current coordinate system orientation.@BtrueȂEnB
	
	
	//************************************************************************//
	//*** RXgN^̒`
	//************************************************************************//
	
	/**
	 * ftHgRXgN^B
	 */
	public CqTransform()  
	{
		super(new SqTransformation());
		m_IsMoving = false;
	}
	
//	/** Copy constructor.
//	*/
//	public CqTransform( final CqTransform From )
//	{
//	super( From );
//	
//	m_IsMoving = From.m_IsMoving;
//	m_StaticMatrix = From.m_StaticMatrix;
//	m_Handedness = From.m_Handedness;
//	/*    *this = From;
//	
//	// Get the state of the transformation at the last stack entry, and use this as the default value for new timeslots.
//	// if the previous level has motion specification, the value will be interpolated.
//	CqMatrix matOtoWLast;
//	TqBool handLast = TqFalse;
//	if ( !Transform_stack.empty() )
//	{
//	TqFloat time = QGetRenderContext()->Time();
//	matOtoWLast =  Transform_stack.front() ->matObjectToWorld( time );
//	handLast =  Transform_stack.front() ->GetHandedness( time );
//	}
//	
//	SqTransformation ct;
//	ct.m_Handedness = handLast;
//	ct.m_matTransform = matOtoWLast;
//	SetDefaultObject( ct );
//	*/
//	}
	
	/**
	 * Rs[RXgN^B<br>
	 * oϐ̃Rs[ȊOɃftHgIuWFNg̏sB
	 * 
	 * @param From	Rs[
	 */
	public CqTransform( final CqTransform From )
	{
		super(From);
		m_IsMoving = From.m_IsMoving;
		m_StaticMatrix.assignment( From.m_StaticMatrix );
		m_Handedness = From.m_Handedness;
		
		InitialiseDefaultObject( From );
	}
	
	
	/**
	 * w肵ړɑ΂ĈړsKpďRXgN^B
	 * 
	 * @param From	ړIuWFNg
	 * @param time	t[
	 * @param matTrans	ړ4x4s
	 * @param set	matTransuݒv邱Ƃ}[J[NXB
	 */
	public CqTransform( final CqTransform From, float time, final CqMatrix matTrans, final Set set )
	
	{
		super(From);
		m_IsMoving = From.m_IsMoving ;
		m_StaticMatrix.assignment( From.m_StaticMatrix );
		m_Handedness =  From.m_Handedness;
		
		SetTransform( time, matTrans );
	}
	
	/**
	 * w肵ړɑ΂ĈړsďRXgN^B
	 * 
	 * @param From	ړIuWFNg
	 * @param time	t[
	 * @param matTrans	ړ4x4s
	 * @param concatCurrent	matTransuv邱Ƃ}[J[NXB
	 */
	public CqTransform( final CqTransform From, float time, final CqMatrix matTrans, final ConcatCurrent concatCurrent )
	{
		super(From);  
		m_IsMoving = From.m_IsMoving;
		m_StaticMatrix.assignment( From.m_StaticMatrix );
		m_Handedness = From.m_Handedness;
		
		ConcatCurrentTransform( time, matTrans );
	}
	
	/**
	 * w肵ړɑ΂āA݂̍WnɂړsKpďRXgN^B
	 * 
	 * @param From	ړIuWFNg
	 * @param time	t[
	 * @param matTrans	ړ4x4s
	 * @param setCurrent	matTransu݂̍WnƂĐݒv邱Ƃ}[J[NXB
	 */
	public CqTransform( final CqTransform From, float time, final CqMatrix matTrans, final SetCurrent setCurrent )
	
	{
		super(From);
		m_IsMoving = From.m_IsMoving;
		m_StaticMatrix.assignment( From.m_StaticMatrix );
		m_Handedness =  From.m_Handedness;
		
		SetCurrentTransform( time, matTrans );
	}
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
	
	/**
	 * w莞Ԃ̃IuWFNgɑ΂āA݂̍WnɂړiTransformjݒ肷B
	 * 
	 * @param time	t[
	 * @param matTrans	ړ4x4s
	 */
	public void	SetCurrentTransform( float time, final CqMatrix matTrans )
	{
		float det = matTrans.Determinant();
		boolean flip = ( !matTrans.fIdentity() && det < 0 );
		
		SqTransformation ct = new SqTransformation();
		ct.m_matTransform.assignment( matTrans );
		
		if ( QGetRenderContext().pconCurrent().fMotionBlock() )
		{
			AddTimeSlot( time, ct );
			m_IsMoving = true;
		}
		else
		{
			if( m_IsMoving )
			{
				AddTimeSlot( time, ct );
			}
			else
			{
				m_StaticMatrix.assignment( matTrans );
				m_Handedness = flip;
				ct.m_Handedness = flip;
				SetDefaultObject( new SqTransformation(ct) );
			}
		}
	}
	
	/**
	 * ZbgB<br>
	 *  makeStatic truȅꍇASẴIuWFNgjAmathand͓IɕێB<br>
	 * falsȅꍇASẴIuWFNgw肳ꂽi݂̍Wnɂjړɐݒ肳B
	 * 
	 * @param mat	ړ4x4s
	 * @param hand	
	 * @param makeStatic	SẴIuWFNgj邩ǂB
	 */
	public void	ResetTransform(final CqMatrix mat, boolean hand, boolean makeStatic)
	{
		if( makeStatic )
		{
			Reset();
			m_IsMoving=false;
			m_StaticMatrix.assignment( mat );
			m_Handedness = hand;
		}
		else
		{
			int i;
			for(i=0; i<iTimes(); i++)
				SetCurrentTransform(Time(i), mat);
		}
	}
	
	final public void	ResetTransform(final CqMatrix mat, boolean hand)
	{
		ResetTransform(mat,hand,true);
	}
	
	
	private static CqMatrix matInt = new CqMatrix();
	/**
	 * 
	 * @see net.cellcomputing.himawari.library.IqTransform#matObjectToWorld(float)
	 */
	public 	CqMatrix	matObjectToWorld( float time )
	{
		if(m_IsMoving)
		{
			matInt = GetMotionObjectInterpolated( time ).m_matTransform;
			return ( new CqMatrix( matInt ) );
		}
		else
			return ( new CqMatrix( m_StaticMatrix ) );
	}
	
	/**
	 * wʒuɊi[Ăt[ԂԂB
	 * @see net.cellcomputing.himawari.library.CqMotionSpec#Time(int)
	 */
	public	float	Time( int index )
	{
		return( super.Time( index ) );
	}
	
	/**
	 * ^CXbgɊi[Ă鐔ԂB
	 * @see net.cellcomputing.himawari.library.CqMotionSpec#iTimes()
	 */
	public	int	cTimes()
	{
		if(m_IsMoving)
			return( super.iTimes() );
		else
			return( 1 );
	}
	
	
	/**
	 * w莞Ԃ̏擾B
	 * 
	 * @see net.cellcomputing.himawari.library.IqTransform#GetHandedness(float)
	 */
	public boolean GetHandedness( float time )
	{
		if( m_IsMoving )
			return ( GetMotionObject( time ).m_Handedness );
		else
			return ( m_Handedness );
	}
	
	//************************************************************************//
	//*** CqMotionSpec̒ۃ\bh̃I[o[Ch
	//************************************************************************//
	
	/**
	 * ړIuWFNg̃NAB
	 * 
	 * @param A	SqTransformationIuWFNg
	 */
	public void ClearMotionObject( SqTransformation A )
	{
		
	}	
	
	/**
	 * Q̈ړIuWFNgB<br>
	 * ̓Iɂ͈ړ͍sŎ̂ŁA̐ς߂B	
	 * 
	 * @param A	SqTransformationIuWFNg
	 * @param B	SqTransformationIuWFNg
	 * @return	
	 */
	public SqTransformation ConcatMotionObjects( final SqTransformation A, final SqTransformation B )
	{
		SqTransformation res = new SqTransformation();
		res.m_matTransform = A.m_matTransform.multiply(B.m_matTransform);
		boolean flip = ( B.m_matTransform.Determinant() < 0 );
		res.m_Handedness = (flip)? !A.m_Handedness : A.m_Handedness;
		return ( res );
	}
	
	/**
	 * Q̈ړIuWFNg̊Ԃ⊮B<br>
	 * PAԂB
	 * 
	 * @param Fraction	덷䗦iIɂ͖j
	 * @param A	⊮ΏۂÖʒuɂړIuWFNg
	 * @param B	⊮Ώۂ̈ʒuɂړIuWFNgiIɂ͖j
	 * @return	⊮ʁiAj
	 */
	public SqTransformation LinearInterpolateMotionObjects( float Fraction, final SqTransformation A, final SqTransformation B )
	{
		// TODO: Should we do anything with this???
		return ( A );
	}
	
	
	/**
	 * 
	 * ftHgIuWFNgB<br>
	 * w肳ꂽCqTransformIuWFNgŌ̃IuWFNg̏Ԃ擾AftHgIuWFNgƂB
	 * 
	 * @param From	̍ޗƂȂCqTransformIuWFNg
	 */
	private void InitialiseDefaultObject( final CqTransform From )
	{
		// Get the state of the transformation at the last stack entry, and use this as the default value for new timeslots.
		// if the previous level has motion specification, the value will be interpolated.
		float time = QGetRenderContext().Time();
		CqMatrix matOtoWLast =  From.matObjectToWorld( time );
		boolean handLast =  From.GetHandedness( time );
		
		SqTransformation ct = new SqTransformation();
		ct.m_Handedness = handLast;
		ct.m_matTransform = matOtoWLast;
		SetDefaultObject( ct );
	}
	
	/**
	 * w莞Ԃ̃IuWFNgɑ΂āAJWnɂړiTransformjݒ肷B
	 * 
	 * @param time	t[
	 * @param matTrans	ړ4x4s
	 */
	private void	SetTransform( float time, final CqMatrix matTrans )
	{
		float det = matTrans.Determinant();
		boolean flip = ( !matTrans.fIdentity() && det < 0 );
		CqMatrix matCtoW = QGetRenderContext().matSpaceToSpace("world", "camera",new CqMatrix(),new CqMatrix(), QGetRenderContext().Time());
		float camdet = matCtoW.Determinant();
		boolean camhand = ( !matCtoW.fIdentity() && camdet < 0 );
		
		if ( QGetRenderContext().pconCurrent().fMotionBlock() )
		{
			SqTransformation ct = new SqTransformation();
			ct.m_Handedness = (flip)? !camhand : camhand;
			ct.m_matTransform.assignment( matTrans );
			AddTimeSlot( time, ct );
			m_IsMoving = true;
		}
		else
		{
			// If not in a motion block, but we are moving, apply the transform to all keys.
			if( m_IsMoving )
			{
				CqMatrix mat0 = matObjectToWorld(Time(0));
				
				SqTransformation ct = new SqTransformation();
				ct.m_Handedness = (flip)? !camhand : camhand;
				boolean hand0 = ct.m_Handedness;
				ct.m_matTransform.assignment( matTrans );
				
				AddTimeSlot( Time(0), ct );
				int i;
				for(i=1; i<iTimes(); i++)
				{
					CqMatrix matOffset = mat0.multiply( matObjectToWorld(Time(i)).Inverse() );
					ct.m_matTransform = matOffset.multiply( matTrans );
					boolean flip2 = ( matOffset.Determinant() < 0 );
					ct.m_Handedness = (flip2)? !hand0 : hand0;
					AddTimeSlot( Time(i), new SqTransformation(ct) );
				}
			}
			else
			{
				m_StaticMatrix.assignment( matTrans );
				m_Handedness = (flip)? !camhand : camhand;
			}
		}
	}
	
	/**
	 * w莞Ԃ̃IuWFNgɑ΂ĈmatTransB<br>
	 * 
	 * @param time	t[
	 * @param matTrans	ړ4x4s
	 */
	private void	ConcatCurrentTransform( float time, final CqMatrix matTrans )
	{
		float det = matTrans.Determinant();
		boolean flip = ( !matTrans.fIdentity() && det < 0 );
		
		SqTransformation ct = new SqTransformation();
		ct.m_matTransform.assignment( matTrans );
		ct.m_Handedness = (flip)? !m_Handedness : m_Handedness;
		
		// If we are actually in a motion block, and we already describe a moving transform,
		// concatenate this transform with the existing one at that time slot,
		// ConcatTimeSlot will take care of making sure that the matrix is initially set to the 
		// static matrix, as long as we ensure that the default is kept up to date.
		if ( QGetRenderContext().pconCurrent().fMotionBlock() )
		{
			ConcatTimeSlot( time, ct );
			m_IsMoving = true;
		}
		else
			// else, if we are moving, apply this transform at all time slots, otherwise apply to static matrix.
		{
			if( m_IsMoving )
				ConcatAllTimeSlots( ct );
			else
			{
				m_StaticMatrix.assignment( m_StaticMatrix.multiply( matTrans ) );
				m_Handedness = (flip)? !m_Handedness : m_Handedness;
				ct.m_Handedness = m_Handedness;
				SetDefaultObject( ct );
			}
		}
	}
	
//	/**
//	 * 
//	 * w莞Ԃ̏𔽓]
//	 * 
//	 * @param time	t[
//	 */
//	private void FlipHandedness(float time )
//	{
//		m_Handedness = !m_Handedness;
//	}
	
	
	
	
	
	
}
