// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import java.io.RandomAccessFile;
import net.cellcomputing.himawari.library.types.CqFile;
import static net.cellcomputing.himawari.library.RiGlobal.*;

/**
 * Ot@C舵NX
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqRiFile extends CqFile{

	private static final long serialVersionUID = -6602043230433719468L;

	public CqRiFile()
	{
		 super(null);
	}
    /** Constructor taking an open stream pointer and a name.
     * \param Stream a pointer to an already opened input stream to attach this object to.
     * \param strRealName the name of the file associated with this stream.
     */
    public CqRiFile( RandomAccessFile Stream, final String strRealName )
    {
        super( Stream, strRealName );
    }
	
	public CqRiFile( final String strFilename, final String strSearchPathOption  )
	{
	        //									std::cout << "CqRiFile::CqRiFile() " << strFilename << " - " << strSearchPathOption << std::endl;
	        Open2( strFilename, strSearchPathOption );
	}
	    /** Destructor. Takes care of closing the stream if the constructor opened it.
	     */
	public void destract()
	{
	}
	
	public void Open2( final String strFilename )
    {
    	Open2( strFilename, "", "r" );
    }
	
	public void	Open2( final String strFilename, final String strSearchPathOption )
	{
		Open2(strFilename,strSearchPathOption,"r");
	}
	
	public void	Open2( final String strFilename, final String strSearchPathOption, final String mode )
	{
	        String SearchPath = "" ;
//	        if ( strSearchPathOption != "" )
	        if ( !strSearchPathOption.equals("") )
	        {
	            // if not found there, search in the specified option searchpath.
	            final String[] poptShader = QGetRenderContext().optCurrent().GetStringOption( "searchpath", strSearchPathOption );
	            if ( poptShader != null )
	                SearchPath = poptShader[ 0 ];

	            //std::cout << "\t" << SearchPath.c_str() << std::endl;
	        }
	        super.Open( strFilename, SearchPath, mode );
	        // If the file was not found, then try the "resource" searchpath.
	        if( !IsValid() )
	        {
	            // if not found there, search in the specified option searchpath.
	            final String[] poptResource = QGetRenderContext().optCurrent().GetStringOption( "searchpath", "resource" );
	            if ( poptResource != null )
	            {
	                SearchPath = poptResource[ 0 ];
	                super.Open( strFilename, SearchPath, mode );
	            }
	        }
	    }
}
