// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/**
 * 
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp interface CqPolygonBase {

//	public CqPolygonBase();
//	{
//	        STATS_INC( GPR_poly );
//	}
	public void destruct();
//	    {}

	//public CqBound	Bound()
	public CqBound	PBBound();//dp邽߂ɖOύXĂ܂
	//public int	Split( STLVector<CqBasicSurface> aSplits );
	public int	PBSplit( STLVector<CqBasicSurface> aSplits );//dp邽߂ɖOύXĂ܂

	/** Get a reference to the surface this polygon is associated with.
	 */
	public CqSurface Surface();
	    /** Get a reference to the surface this polygon is associated with.
	     */
    //public CqSurface&	Surface() const;

	    /** Get a reference to the polygon point at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public 	CqVector4D PolyP( int i );
	    /** Get a reference to the polygon normal at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public	CqVector3D PolyN( int i );
	    /** Get a reference to the polygon vertex color at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public CqColor PolyCs( int i );
	    /** Get a reference to the polygon vertex opacity at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public CqColor PolyOs( int i );
	    /** Get a reference to the polygon texture s coordinate at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public p_float Polys( int i );
	    /** Get a reference to the polygon texture t coordinate at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public p_float Polyt( int i );
	    /** Get a reference to the polygon surface u coordinate at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public 	p_float Polyu( int i );
	    /** Get a reference to the polygon surface v coordinate at the specified index.
	     * \param i Integer index in of the vertex in question.
	     */
	public 	p_float Polyv( int i );
	    /** Get the real index into the points list translated from the polygon vertex index.
	     * \param i Integer index in of the vertex in question.
	     */
	public 	int PolyIndex( int i );

	    /** Determine if the polygon has the given indexed primitive variable.
	     * \param index Integer index of the variable in the range EnvVars_Cs<=index<EnvVars_Last.
	     */
	public	boolean bHasVar( int index );
	    /** Get the real index into the points list translated from the polygon vertex index for facevarying variables.
	     * \param i Integer index in of the vertex in question.
	     */
    public 	int FaceVaryingIndex( int i );

	    /** Get the number of vertices in this polygon.
	     */
    public	int	NumVertices();

	    /** Get a pointer to the attributes state associated with this polygon.
	     */
    public IqAttributes	pAttributes();
	    /** Get a pointer to the transfrom associated with this polygon.
	     */
	public IqTransform pTransform();

	    /** Get the index of this polygon if it is a member of a polygon mesh
	     */
	public int MeshIndex();
//	pŎĂ
//	    {
//	        return ( 0 );
//	    }

	    /** Get a bit vector representing the standard shader variables this polygon needs.
	     */
	public int	PolyUses();
//	pŎĂ
//	    {
//	        return ( Surface().Uses() );
//	    }

	public void CreatePhantomData(CqParameter pParam);
}
