// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import static net.cellcomputing.himawari.library.EqEnvVars.*;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * 
 * CqMicroPolyGridPoints
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqMicroPolyGridPoints extends CqMicroPolyGrid {
	
    public CqMicroPolyGridPoints()
    {
    	super();
    }
    
    public CqMicroPolyGridPoints( int cu, int cv, final CqSurface pSurface )
    {
    	super( cu, cv, pSurface );
    }

    public	void Split( CqImageBuffer pImage, long xmin, long xmax, long ymin, long ymax )
    {
        if ( null == pVar(EnvVars_P) )
            return ;

        int cu = uGridRes();	// Only need cu, as we know cv is 1.

        this.AddRef();

        CqMatrix matCameraToObject0 = QGetRenderContext() .matSpaceToSpace( "camera", "object", new CqMatrix(), pSurface().pTransform().matObjectToWorld(pSurface().pTransform().Time(0)), pSurface().pTransform().Time(0) );
//        CqMatrix matObjectToCamera = QGetRenderContext() .matSpaceToSpace( "object", "camera", new CqMatrix(), pSurface().pTransform().matObjectToWorld(pSurface().pTransform().Time(0)), pSurface().pTransform().Time(0) );
        CqMatrix matCameraToRaster = QGetRenderContext() .matSpaceToSpace( "camera", "raster", new CqMatrix(), new CqMatrix(), pSurface().pTransform().Time(0) );

//        CqVector3D vecdefOriginRaster = matCameraToRaster .multiply( new CqVector3D( 0.0f,0.0f,0.0f ) );

        // Get a pointer to the surface, so that we can interrogate the "width" parameters.
        CqPoints pPoints = (CqPoints)( pSurface() );

        final CqParameterTypedConstant<p_float, p_float> pConstantWidthParam = pPoints.constantwidth( );

        QGetRenderContext() .Stats().MakeProject().Start();
        // Transform the whole grid to hybrid camera/raster space

        //nttdata 
//        STLVector<CqVector3D> pP = new STLVector<CqVector3D>(CqVector3D.class);
//        pVar(EnvVars_P) .GetPointPtr( pP );
        
        //STLVector<CqVector3D> pP ;
        STLArray<CqVector3D> pP ;
        pP = pVar(EnvVars_P) .GetPointPtr_2( );
        
        QGetRenderContext() .Stats().MakeProject().Stop();

        int iu;
        int iTime, tTime = pSurface().pTransform().cTimes();

        if( tTime > 1 )
        {
            // Get an array of P's for all time positions.
        	STLVector< STLVector<CqVector3D> > aaPtimes = new STLVector<STLVector<CqVector3D>>( 2, CqVector3D.class );
            aaPtimes.resize( pSurface().pTransform().cTimes() );

            // Array of cached object to camera matrices for each time slot.
            STLVector<CqMatrix>	amatObjectToCameraT = new  STLVector<CqMatrix>(CqMatrix.class);
            amatObjectToCameraT.resize( pSurface().pTransform().cTimes() );
            STLVector<CqMatrix>	amatNObjectToCameraT = new  STLVector<CqMatrix>(CqMatrix.class);
            amatNObjectToCameraT.resize( pSurface().pTransform().cTimes() );

//            CqMatrix matObjectToCameraT = new CqMatrix();
            int i;
            int gsmin1;
            gsmin1 = GridSize() - 1;


            for( iTime = 0; iTime < tTime; iTime++ )
            {
//                CqMatrix matCameraToObjectT = QGetRenderContext() .matSpaceToSpace( "camera", "object", new CqMatrix(), pSurface().pTransform().matObjectToWorld( pSurface().pTransform().Time( iTime ) ), pSurface().pTransform().Time( iTime ) );
                amatObjectToCameraT.get( iTime ).assignment( QGetRenderContext() .matSpaceToSpace( "object", "camera", new CqMatrix(), pSurface().pTransform().matObjectToWorld( pSurface().pTransform().Time( iTime ) ),  pSurface().pTransform().Time( iTime ) ) );
                amatNObjectToCameraT.get( iTime ).assignment( QGetRenderContext() .matNSpaceToSpace( "object", "camera", new CqMatrix(), pSurface().pTransform().matObjectToWorld( pSurface().pTransform().Time( iTime ) ), pSurface().pTransform().Time( iTime ) ) );

                aaPtimes.get( iTime ).resize( gsmin1 + 1 );

                for ( i = gsmin1; i >= 0; i-- )
                {
                    // This makes sure all our points are in object space.
                    aaPtimes.get( iTime ).get( i ).assignment( matCameraToObject0 .multiply( pP.get( i ) ) );
                }
            }

            for ( iu = 0; iu < cu; iu++ )
            {
                CqMicroPolygonMotionPoints pNew = new CqMicroPolygonMotionPoints();
                pNew.SetGrid( this );
                pNew.SetIndex( iu );

                float radius;
                float i_radius = 1.0f;
                if( null != pConstantWidthParam )
                	i_radius = ((p_float)pConstantWidthParam.pValue_get( 0 , 0 )).value;
                // Find out if the "width" parameter was specified.
                CqParameterTypedVarying<p_float, p_float> pWidthParam = pPoints.width( 0 );

                if( null != pWidthParam )
                    i_radius = ((p_float)pWidthParam.pValue_get( pPoints.KDTree().aLeaves().get( iu ) , 0 )).value;

                for( iTime = 0; iTime < tTime; iTime++ )
                {
                    radius = i_radius;
                    // Get point in camera space.
                    CqVector3D Point	= new CqVector3D( amatObjectToCameraT.get( iTime ) .multiply( aaPtimes.get( iTime ).get( iu ) ) );
                    CqVector3D pt		= new CqVector3D( amatObjectToCameraT.get( iTime ) .multiply( aaPtimes.get( iTime ).get( iu ) ) );
                    CqVector3D vecCamP	= new CqVector3D( amatObjectToCameraT.get( iTime ) .multiply( aaPtimes.get( iTime ).get( iu ) ) );
                    
                    // Ensure z is retained in camera space when we convert to raster.
                    float ztemp = Point.z;
                    Point.assignment( matCameraToRaster .multiply( Point ) );
                    Point.z( ztemp );
                    pP.get( iu ).assignment( Point );

                    // first, create a horizontal vector in object space which is
                    //  the length of the current width.
                    CqVector3D horiz = new CqVector3D( 1, 0, 0 );
                    horiz = amatNObjectToCameraT.get( iTime ) .multiply( horiz );
                    horiz.assignMul( radius / horiz.Magnitude() );

                    // Get the current point in object space.
                    CqVector3D pt_delta = pt .add( horiz );
                    pt = amatObjectToCameraT.get( iTime ).multiply( pt );
                    pt_delta = amatObjectToCameraT.get( iTime ).multiply( pt_delta );

                    // finally, find the difference between the two points in
                    //  the new space - this is the transformed width
                    CqVector3D widthVector = pt_delta .sub( pt );
                    radius = widthVector.Magnitude();

                    CqVector3D vecCamP2 = vecCamP .add( new CqVector3D( radius, 0.0f, 0.0f ) );
                    ztemp = vecCamP2.z;
                    CqVector3D vecRasP2 = matCameraToRaster .multiply( vecCamP2 );
                    vecRasP2.z( ztemp );
                    float ras_radius = ( vecRasP2 .sub( Point ) ).Magnitude();
                    radius = ras_radius * 0.5f;

                    pNew.AppendKey( Point, radius, pSurface().pTransform().Time( iTime ) );
                }
                pNew.GetTotalBound( true ); 
                pImage.AddMPG( pNew );
            }
        }
        else
        {
            iTime = 0;
//            CqMatrix matWorldToObjectT = QGetRenderContext() .matSpaceToSpace( "world", "object", new CqMatrix(), pSurface().pTransform().matObjectToWorld( pSurface().pTransform().Time( iTime ) ), pSurface().pTransform().Time( iTime ) );
            CqMatrix matObjectToCameraT = QGetRenderContext() .matSpaceToSpace( "object", "camera", new CqMatrix(), pSurface().pTransform().matObjectToWorld( pSurface().pTransform().Time( iTime ) ), pSurface().pTransform().Time( iTime ) );
            CqMatrix matNObjectToCameraT = QGetRenderContext() .matNSpaceToSpace( "object", "camera", new CqMatrix(), pSurface().pTransform().matObjectToWorld( pSurface().pTransform().Time( iTime ) ), pSurface().pTransform().Time( iTime ) );

            for ( iu = 0; iu < cu; iu++ )
            {
                // Get point in camera space.
                CqVector3D Point	= new CqVector3D( pP.get( iu ) );
                CqVector3D pt		= new CqVector3D( pP.get( iu ) );
                CqVector3D vecCamP	= new CqVector3D( pP.get( iu ) );
                // Ensure z is retained in camera space when we convert to raster.
                float ztemp = Point.z;
                Point = matCameraToRaster .multiply( Point );
                Point.z( ztemp );
                pP.get( iu ).assignment( Point );

                float radius = 1.0f;
                if( null != pConstantWidthParam )
                    radius = ((p_float)pConstantWidthParam.pValue_get( 0 , 0 )).value;
                // Find out if the "width" parameter was specified.
                CqParameterTypedVarying<p_float, p_float> pWidthParam = pPoints.width( 0 );

                if( null != pWidthParam )
                    radius = ((p_float)pWidthParam.pValue_get( pPoints.KDTree().aLeaves().get( iu ) , 0 )).value;

                // first, create a horizontal vector in camera space which is
                //  the length of the current width in current space
                CqVector3D horiz = new CqVector3D( 1, 0, 0 );
                horiz = matNObjectToCameraT .multiply( horiz );
                horiz.assignMul( radius / horiz.Magnitude() );

                // Get the current point in object space.
                CqVector3D pt_delta = pt .add( horiz );
                pt = matObjectToCameraT .multiply( pt );
                pt_delta = matObjectToCameraT .multiply( pt_delta ); 

                // finally, find the difference between the two points in
                //  the new space - this is the transformed width
                CqVector3D widthVector = pt_delta .sub( pt );
                radius = widthVector.Magnitude();

                CqVector3D vecCamP2 = vecCamP .add( new CqVector3D( radius, 0.0f, 0.0f ) );
                ztemp = vecCamP2.z;
                CqVector3D vecRasP2 = matCameraToRaster .multiply( vecCamP2 );
                vecRasP2.z( ztemp );
                float ras_radius = ( vecRasP2 .sub( Point ) ).Magnitude();
                radius = ras_radius * 0.5f;

                CqMicroPolygonPoints pNew = new CqMicroPolygonPoints();
                pNew.SetGrid( this );
                pNew.SetIndex( iu );
                pNew.Initialise( radius );
                //pNew.GetTotalBound();

                pImage.AddMPG( pNew );
            }
        }

        this.Release();

    }

    public	int GridSize()
    {
        assert( m_pShaderExecEnv!=null );
        return ( m_pShaderExecEnv.uGridRes() );
    }

}
