// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;

/**
 * 
 * Templatised class containing a series of motion stages of a specific surface type for motion blurring.<br>
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqDeformingPointsSurface extends CqDeformingSurface {

	
	public CqDeformingPointsSurface( final CqBasicSurface a )
	{
		super( a );
	}
	
	public CqDeformingPointsSurface( final CqDeformingPointsSurface From )
	{
		super( From );
	}

	/** 
	 * Dice this GPrim, creating a CqMotionMicroPolyGrid with all times in.
	 */
	public	CqMicroPolyGridBase Dice()
	{
		CqMotionMicroPolyGridPoints pGrid = new CqMotionMicroPolyGridPoints();
		int i;
		for ( i = 0; i < iTimes(); i++ )
		{
			CqMicroPolyGridBase pGrid2 = GetMotionObject( Time( i ) ).Dice();
			pGrid.AddTimeSlot( Time( i ), pGrid2 );
			//yzaqsis1.01ǉ********************
			//ADDREF( pGrid2); ܂񂪈ꉞBB
			//****************************************
		}
		return ( pGrid );
	}
	
	/** 
	 * Split this GPrim, creating a series of CqDeformingSurface with all times in.
	 */
	public	int	Split( STLVector<CqBasicSurface> aSplits )
	{
		STLVector< STLVector<CqBasicSurface> > aaMotionSplits = new STLVector<STLVector<CqBasicSurface>>( 2, CqBasicSurface.class );
		aaMotionSplits.resize( iTimes() );
		int cSplits = 0;
		int i;
		cSplits = GetMotionObject( Time( 0 ) ).Split( aaMotionSplits.get( 0 ) );
		CqPoints pFrom1 = (CqPoints)( aaMotionSplits.get( 0 ).get( 0 ) );
		CqPoints pFrom2 = (CqPoints)( aaMotionSplits.get( 0 ).get( 1 ) );
		
		// Now we have the appropriate split information, use this to make sure the rest
		// of the keyframes split at the same point.
		for ( i = 1; i < iTimes(); i++ )
			cSplits = ( (CqPoints)( GetMotionObject( Time( i ) ) ) ).CopySplit( aaMotionSplits.get( i ), pFrom1, pFrom2 );
		
		// Now build motion surfaces from the splits and pass them back.
		for ( i = 0; i < cSplits; i++ )
		{
			CqDeformingPointsSurface pNewMotion = new CqDeformingPointsSurface( (CqBasicSurface)null );
			pNewMotion.m_fDiceable = true;
			pNewMotion.m_EyeSplitCount = m_EyeSplitCount;
			int j;
			for ( j = 0; j < iTimes(); j++ )
				pNewMotion.AddTimeSlot( Time( j ), aaMotionSplits.get( j ).get( i ) );
			aSplits.add( pNewMotion );
		}
		return ( cSplits );
	}
	
	public void RenderComplete()
	{
		int i;
		for ( i = 0; i < iTimes(); i++ )
		{
			CqPoints Points = (CqPoints)( GetMotionObject( Time( i ) ) );
			Points.ClearKDTree();
		}
		super.RenderComplete();
	}

	
}
