// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;

/**
 * 
 * Base class for a group of curves.
 * 
 * @author NTT DATA Corporation
 */
public abstract strictfp class CqCurvesGroup extends CqCurve {

	protected int m_ncurves;      				 ///< Number of curves in the group.
	protected STLVector<Integer> m_nvertices;  ///< Number of vertices in each curve.
	protected boolean m_periodic;      		///< true if the curves specified are periodic
	protected int m_nTotalVerts;   			///< total number of vertices
	
	/**
	 * CqCurvesGroup constructor.
	 */
	public CqCurvesGroup()
	{
		 super();
		 m_ncurves		= 0;
		 m_periodic		= false;
	     m_nTotalVerts	= 0;
	     
	     m_nvertices = new STLVector<Integer>(Integer.class);
	}
	
	/**
	 * CqCurvesGroup copy constructor.
	 */
	public CqCurvesGroup( final CqCurvesGroup from )
	{
		super();
		this.assignment( from ); 
	}

	/**
	 * Assignment operator.
	 *
	 * @param from  CqCurvesGroup to set this one equal to.
	 */
	public CqCurvesGroup assignment( final CqCurvesGroup from )
	{
	    // base class assignment
		super.assignment( (CqCurve)from );

	    // copy members
	    m_ncurves = from.m_ncurves;
	    m_periodic = from.m_periodic;
//	    m_nvertices = from.m_nvertices;
	    m_nvertices = new STLVector<Integer>(Integer.class,from.m_nvertices);

	    return ( this );
	}	
}
