// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;

/**
 * 
 * CqBounds̃Xgw肷NXB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqBoundList {
	
	private STLVector<CqBound> m_Bounds	= new STLVector<CqBound>(CqBound.class);
	private STLVector<p_float> m_Times		= new STLVector<p_float>(p_float.class);


	/**
	 *  Clear the list
	 */
	public void Clear()
	{
		//for ( std::vector<CqBound*>::iterator i = m_Bounds.begin(); i != m_Bounds.end(); i++ )
		//	delete ( *i );
		m_Bounds.clear();
		m_Times.clear();
	}

	public void SetSize( int size )
	{
		m_Bounds.resize( size );
		m_Times.resize( size );
	}
	
	/** 
	 * Add a bound to the current list
	 * @param index The index to set in the list.
	 * @param bound The CqBound to add
	 * @param time The shutter time that this bound becomes valid at. The bound
	 *               is valid until the time of the next bound or until 1.0 if there are no more bounds.
	 */
	public void Set( int index, CqBound bound, float time )
	{
		assert( index < Size() );
		m_Bounds.get( index ).assignment( bound );
		m_Times.get( index ).value = time;
	}
	
	public int Size()
	{
		return m_Bounds.size();
	}

	public CqBound GetBound( int i )
	{
		return new CqBound( m_Bounds.get( i ) );
	}
	
	public float GetTime( int i )
	{
		return m_Times.get( i ).value;
	}

}
