// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqModeBlock.*;

/**
 *  Define the context that exists between calls to RiAttributeBegin/RiAttributeEnd.<br>
 *  RiAttributeBegin/RiAttributeEndĂ΂ĂԂɑ݂AReLXg`B
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqAttributeModeBlock extends CqModeBlock
{
	
	/**
	 * RXgN^B@lݒB
	 * @param	pconParent	ÕReLXgB
	 */
	public CqAttributeModeBlock( final CqModeBlock pconParent )
	{
		super(pconParent, Attribute);
		
	    // Create new Attributes as they must be pushed/popped by the state change.
		// Ԃ̕ωŕςAgr[gV쐬B
	    m_pattrCurrent = new CqAttributes( pconParent.m_pattrCurrent );
	    m_pattrCurrent.AddRef();
		m_ptransCurrent = new CqTransform(pconParent.m_ptransCurrent ) ;
	}

	/** 
	 * fXgN^B<br>@
	 * QƂ̏B@(QƃJE^fNgB)
	 * @see net.cellcomputing.himawari.library.CqModeBlock#destruct()
	 */
	@Override
	public void destruct()
	{
		m_pattrCurrent.Release();
	}

    /** 
     * Create a main context.<br>
     *  C̃ReLXg쐬B
     *  
     * @warning	Agr[gReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
	@Override
	public	CqModeBlock	BeginMainModeBlock()
    {
        return  null;	// Error
    }	
	
    /** 
     * Create a frame context.<br>
	 *  t[̃ReLXg쐬B
	 *  
     * @warning Agr[gReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
	@Override
	public	CqModeBlock	BeginFrameModeBlock()
    {
        return 	null;	// Error
    }	
	
    /** 
     * Create a world context.<br>
@@	 * 	[h̃ReLXg쐬B<br>
     * 
     * @warning Agr[gReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
	@Override
	public	CqModeBlock	BeginWorldModeBlock()
    {
        return 	null;	// Error
    }	

    /** 
     * Delete the attribute context.<br>
     * 	Agr[gReLXg̏B
     * 
     * @attention ̃\bĥ݁AAgr[g̃ReLXg邱ƂłB
     */
	@Override
	public	void	EndAttributeModeBlock()
    {
		destruct();
    }

    /** 
     * Get a reference to the options at the parent context, <br>
     * 	as attribute context doesn't store options.<br>
	 *  ẽReLXg̃IvṼQb^B<br>@
     *  ([hReLXg̓IvVĂȂ)
     *  
     * @return	IvV̎QƁB
     */
	@Override
	public CqOptions optCurrent()
    {
        return ( pconParent().optCurrent() );
    }

}
