/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * @author NTT DATA Corporation
 *
 */
public strictfp class ZFrameBufferRequest extends DisplayRequest {

	/**
	 * _O摜\Window
	 */
	private FrameBuffer frameBuffer;

	/**
	 * RXgN^
	 * @param name O
	 * @param type fBXvC^Cv(FrameBuffer)
	 * @param mode J[[h
	 * @param modeID
	 * @param dataOffset
	 * @param dataSize
	 * @param imageData 摜f[^ǗNX
	 */
	public ZFrameBufferRequest(String name, final String type,final String mode,
			int modeID, int dataOffset, int dataSize ,ImageData imageData){
		super(name,type,mode,modeID,dataOffset,dataSize,imageData);

	}
	/**
	 * DisplayBucketĂяoOɕKĂ΂郁\bhB
	 * Window쐬A\B
	 */
	public void openRequest() {

		try{
			frameBuffer = new FrameBuffer(((ZFileImage)imageData).getZImage(),name);
		}catch(ClassCastException cle){
			HimawariLogger.getLogger().error("Can't open framebuffer");
			return;
		}
		frameBuffer.init();
		frameBuffer.setVisible(true);

	}

	/**
	 * ĕ`̖߂windowɑ΂sB
	 */
	public void display() {
		frameBuffer.repaint();

	}

	/**
	 * ő[xAFo
	 * 
	 */
	public void closeRequest() {
		if(frameBuffer == null || !frameBuffer.isVisible())
			return;
		float max_depth;
		float min_depth;
		ZFileImage zImageData = (ZFileImage)imageData;
		float[][] depthData = (float[][])imageData.getImage(); 
		max_depth = zImageData.getMaxDepth();
		min_depth = zImageData.getMinDepth();
		float[] temp_depth = new float[3];
		for(int j = 0; j < imageData.height;j++){
			for(int i=0; i< imageData.width;i++){
				if(depthData[j][i]== RiGlobal.RI_FLOATMAX){
					temp_depth[zImageData.Z_COLOR] = 0;
					temp_depth[0] = 0;
					temp_depth[1] = 0;
					imageData.raster.setPixel(i,j,temp_depth);
					continue;
				}
				
				temp_depth[zImageData.Z_COLOR]= 255;
				temp_depth[0] = 255 -(depthData[j][i]-min_depth)*255/(max_depth-min_depth);
				temp_depth[1] = temp_depth[0];
				
				imageData.raster.setPixel(i,j,temp_depth);
			}
		}

		if(frameBuffer !=null)
			frameBuffer.repaint();
		imageData = null;
	}

}
