/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import static net.cellcomputing.himawari.library.EqSampleIndices.Sample_Alpha;
import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;

import java.awt.image.BufferedImage;

import net.cellcomputing.himawari.library.CqImageBuffer;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.types.CqColor;

/**
 * @author NTT DATA Corporation
 * RGBABufferedImageNXB
 * RGBA`̉摜ǗB
 */
public strictfp class RGBAImageData extends ImageData<BufferedImage> {
	/**
	 * 1pixelɊi[f[^̃TCY
	 */
	private static final int DATA_SIZE = 4;
	
	/**
	 * RXgN^
	 * f[^
	 */
	protected RGBAImageData(int offset){
		super(offset);			// 2006/11/10 offsetpύX
		this.dataSize = DATA_SIZE;								//pixel̃f[^TCY擾
		pixelData = new float[DATA_SIZE];	
	}
	

	/**
	 * pixelf[^Ƃ
	 * C[Wւ̕`sB
	 * @param pBucket `f[^
	 */
	public void setBucket(IqBucket pBucket) {

		
		if( (pBucket.Width() == 0) || (pBucket.Height() == 0) )
			return;
		
		int	xmin = pBucket.XOrigin();
		int	ymin = pBucket.YOrigin();
		int	xmaxplus1 = xmin + pBucket.Width();
		int	ymaxplus1 = ymin + pBucket.Height();
		
//nttdata 
//		// If completely outside the crop rectangle, don't bother sending.
//		//ʂ̃G[
//		if( xmaxplus1 <= QGetRenderContext().pImage().CropWindowXMin() ||
//			ymaxplus1 <= QGetRenderContext().pImage().CropWindowYMin() ||
//			xmin > QGetRenderContext().pImage().CropWindowXMax() ||
//			ymin > QGetRenderContext().pImage().CropWindowYMax() )
//			return;
//		//--܂
//		for ( int y = ymin; y < ymaxplus1; y++ )
//		{
//			for ( int x = xmin; x < xmaxplus1; x++ )
//			{
//				//`͈͂ǂ̃`FbNs
//				//ʂ̃G[
//				if(x < QGetRenderContext().pImage().CropWindowXMin() || y < QGetRenderContext().pImage().CropWindowYMin() ||
//					x >= QGetRenderContext().pImage().CropWindowXMax() || y >= QGetRenderContext().pImage().CropWindowYMax())
//					continue;
//				//--܂
//				CqColor col = pBucket.Color(x,y);
//				pixelData[0] = col.fRed();
//				pixelData[1] = col.fGreen();
//				pixelData[2] = col.fBlue();
//				pixelData[3] =  pBucket.Data(x,y).valueAt(Sample_Alpha);
//				raster.setPixel( x - QGetRenderContext().pImage().CropWindowXMin() , y - QGetRenderContext().pImage().CropWindowYMin(), pixelData);
//				
//			}
//		}

//		ʂ̃G[
		CqImageBuffer img = QGetRenderContext().pImage();
		if( xmaxplus1 <= img.CropWindowXMin() ||
			ymaxplus1 <= img.CropWindowYMin() ||
			xmin > img.CropWindowXMax() ||
			ymin > img.CropWindowYMax() )
			return;
		//--܂
		for ( int y = ymin; y < ymaxplus1; y++ )
		{
			for ( int x = xmin; x < xmaxplus1; x++ )
			{
				//`͈͂ǂ̃`FbNs
				//ʂ̃G[
				if(x < img.CropWindowXMin() || y < img.CropWindowYMin() ||
					x >= img.CropWindowXMax() || y >= img.CropWindowYMax())
					continue;
				//--܂
				CqColor col = pBucket.Color(x,y);
				pixelData[0] = col.fRed();
				pixelData[1] = col.fGreen();
				pixelData[2] = col.fBlue();
				pixelData[3] =  pBucket.Data(x,y).valueAt(Sample_Alpha);
				raster.setPixel( x - img.CropWindowXMin() , y - img.CropWindowYMin(), pixelData);
				
			}
		}

	}

	/**
	 * 摜f[^łBufferedImage擾
	 * @return `悵BufferedImage
	 */
	public BufferedImage getImage() {

		return imageData;
	}

	/**
	 * B
	 * OŎw肳ꂽl摜̕A肵A
	 * BufferedImage쐬ĂB
	 */
	public void init() {
		super.init();
		imageData = new BufferedImage(width,height,BufferedImage.TYPE_INT_ARGB);				//image쐬
		raster = imageData.getRaster();	
	}

}
