/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.util.HimawariLogger;
/**
 * @author NTT DATA Corporation
 * HDR`̖߂ǗNXB
 * 摜C[WAt@CB
 * 
 */
public strictfp class HDRRequest extends DisplayRequest {
	/**
	 * 摜f[^̕
	 */
	private int imageWidth;
	/**
	 * 摜f[^̍
	 */
	private int imageHeight;
	/**
	 * RXgN^
	 * Request
	 * @param name t@C̖O
	 * @param type ۑ`
	 * @param mode RGB,RGBAȂǂ̃J[񂪂͂
	 * @param modeID modehash
	 * @param dataOffset 
	 * @param dataSize
	 * @param imageData RequestǗImageData (BufferedImage)
	 */
	public HDRRequest(String name, final String type,final String mode,
			int modeID, int dataOffset, int dataSize ,ImageData imageData){
		super(name,type,mode,modeID,dataOffset,dataSize,imageData);
	}

	/**
	 * t@Cۑ邽߂̏ݒ肷
	 */
	public void openRequest() {
		imageWidth = QGetRenderContext() .optCurrent().GetIntegerOption( "System", "Resolution" ) [ 0 ];		//image̕擾
		imageHeight = QGetRenderContext() .optCurrent().GetIntegerOption( "System", "Resolution" ) [ 1 ];	//image̍擾
//		int xmin = (int)( PublicFunctions.CLAMP((float) Math.ceil( imageWidth * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 0 ] ), 0, imageWidth ) );
//		int xmax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( imageWidth * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 1 ] ), 0, imageWidth ) );
//		int ymin = (int)( PublicFunctions.CLAMP( (float)Math.ceil( imageHeight * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 2 ] ), 0, imageHeight ) );
//		int ymax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( imageHeight * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 3 ] ), 0, imageHeight ) );
		int xmin = (int)( PublicFunctions.CLAMP((float) Math.ceil( imageWidth * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 0 ).value ), 0, imageWidth ) );
		int xmax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( imageWidth * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 1 ).value ), 0, imageWidth ) );
		int ymin = (int)( PublicFunctions.CLAMP( (float)Math.ceil( imageHeight * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 2 ).value ), 0, imageHeight ) );
		int ymax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( imageHeight * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 3 ).value ), 0, imageHeight ) );

		imageWidth = xmax -xmin;
		imageHeight = ymax - ymin;

	}
	
	/**
	 * Ȃ
	 */
	public void display() {
		
	}
	
	/**
	 * 摜f[^HDR`̃t@C
	 * oB
	 */
	public void closeRequest() {
		RandomAccessFile file = null;
		CqColor[][] bucketList = (CqColor[][])imageData.getImage();
		
		try {
			file = new RandomAccessFile(name,"rw");
			file.write("#?RGBE\n".getBytes());
			file.write("FORMAT=32-bit_rle_rgbe\n\n".getBytes());
			file.write(("-Y "+ imageHeight +" +X "+ imageWidth + "\n").getBytes());
			
			byte[] rgbe = new byte[4];
			
			for(int y = 0; y < bucketList.length ; y++){
				for(int x = 0; x < bucketList[0].length;x++){
					//F񂪓Ă邩`FbN
					if(bucketList[y][x] == null)
						continue;
					
					//2006.11.28 f[^TCY`FbN
					switch( dataSize ){
					case 1:
						//P`l̏R`lɁB
						float2rgbe(rgbe,bucketList[y][x].fRed(),bucketList[y][x].fRed(),bucketList[y][x].fRed());
						break;
					case 3:
					case 4:
					default:
						//FRGBEɕϊ
						float2rgbe(rgbe,bucketList[y][x].fRed(),bucketList[y][x].fGreen(),bucketList[y][x].fBlue());
					}					

					//RGBEf[^t@Cɏo
					file.write(rgbe);
				}
			}
			//SĂBucketÎŃt@CB
			file.close();
			
		} catch (FileNotFoundException e) {
			HimawariLogger.outputException(e);
			HimawariLogger.getLogger().error( "Cannot open output image file: " + name + "\n");
			
		} catch (IOException e) {
			HimawariLogger.outputException(e);
			HimawariLogger.getLogger().error( "Cannot open output image file: " + name + "\n");
		}
		imageData = null;
	}
	
	
	/**
	 * 0`1floatŕ\ꂽRGB
	 * RGBE`̃f[^ɕϊB
	 * 
	 * @param rgbe RGBE`̏
	 * @param red Ԃ̐F(0`1)
	 * @param green ΂̐F(0`1)
	 * @param blue ̐F(0`1)
	 */
	public void float2rgbe(byte[] rgbe, float red, float green, float blue)
	{
		float v;
		p_int e = new p_int();

			
		v = red;
		if (green > v) v = green;
		if (blue > v) v = blue;
		if (v < 1e-32) {
			rgbe[0] = rgbe[1] = rgbe[2] = rgbe[3] = 0;
		}
		else {
			v = (float)(frexp(v,e) * 256.0/v);
			rgbe[0] = (byte) (red * v);
			rgbe[1] = (byte) (green * v);
			rgbe[2] = (byte) (blue * v);
			rgbe[3] = (byte) (e.value + 128);
		}
	}
	
	/**
	 * C++frexpƓl̓֐B
	 * 1ŗ^ꂽwAɕB
	 * v = 2^e + return
	 * Ƃ藧悤ɕϊ
	 * 
	 * @param v ΏۂƂȂ镂
	 * @param e w
	 * @return 
	 */
	public  float frexp(float v,p_int e) {
		int i = 0;
		if (v != 0.0) {
			int sign = 1;
			if (v < 0) {
				sign = -1;
				v = -v;
			}
			// slow...
			while (v < 0.5) {
				v = v*2.0f;
				i = i-1;
			}
			while (v >= 1.0) {
				v = v*0.5f;
				i = i+1;
			}
			v = v*sign;
		}
		float ret  = v;
		e.value = i;
		return ret;
	}
	
}
