/* Simple argument-parsing class
 * Copyright (C) 2001 Patrick E. Pelletier <ppelleti@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.argparse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.cellcomputing.himawari.accessory.Pair;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.accessory.primitive.p_double;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.exception.XqException;

/**
 * ̉͂sNX
 * @author NTT DATA Corporation
 */
public strictfp class ArgParse {

	/**
	 * IvVȏ゠邱ƂB
	 */
	public static int SEP_NONE = -1;//(F"--foo@one --foo two") 
	/**
	 * IvVɑ΂p[^Kvł邱ƂB
	 */
	public static int SEP_ARGV = -2;//(FA"--foo one two")

//			ASCIIgpꍇAargv(Stringz)PvfgpB
//			ŕ邱Ƃɂ蕡̗vfɂ܂B (:"--foo one,two")


	
	/**
	 * RXgN^
	 */
	public ArgParse()
	{
		d = new ArgParseInternalData();
		d.allowOneCharOptionsToBeCombined = false;
		d.allowUnrecognizedOptions = false;
	}
	
	/**
	 * fXgN^
	 */
	public void destruct()
	{
		d.options.clear();
		d.options = null;
	}
	
	/**
	 * IvVA͂Ă邩𔻒fB
	 */
	public void allowOneCharOptionsToBeCombined() // long but descriptive :)
	{
//		_unCtŎwB
//		Ã\bhĂ΂Ȃꍇ́A nCtVOł_ułӖɂȂB
//		F"--bar" Ƃ邱ƂŁA"-bar"  "-b -a -r"@ƂĈB(OFGCAX@\gpĂ邱)
		d.allowOneCharOptionsToBeCombined = true;
	}

	/**
	 * FĂȂIvVǂ𔻒fB 
	 */
	public void allowUnrecognizedOptions()
	{
//		Normally, parse() will return an error if there are any
//		unrecognized options.  But if you call this method before
//		calling parse(), then unrecognized options will go into
//		the leftovers, without causing an error.
//		IvV̏ꍇ́Aparse()̓G[JԂB
//		parse()̑OɁÅ֐ĂԂƁAFĂȂIvV́A
//		G[oleftover\bh
		 
		d.allowUnrecognizedOptions = true;
	}
	
//	ȉɐ錾Ă֐ɂ	
//	"--foo" will set *value to true.  If allow_negation is true,
//	then "--nofoo" will set *value to false.
//	"--option_name"@̂Ƃ́@value = true
//	allow_negation truełA"--nooption_name" ̂Ƃ value = false
	/**
	 *	IvV̒ǉB<br>
	 * @ĂяoF	IvV̏ڍ׃p[^boolean^̏ꍇɌĂ΂B
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param value	IvV̏ڍ׃p[^
	 */
	public void argFlag(String name, String usage, p_boolean value)
	{		
		argFlag(name, usage, value, true);
	}
		
	/**
	 * IvV̒ǉB<br>
	 * ĂяoF	allow_negationɏl^ĂꍇB<br>
	 *@				IvV̏ڍ׃p[^boolean^̏ꍇɌĂ΂B
	 * @param name	IvV	
	 * @param usage	p@bZ[W
	 * @param value	IvV̏ڍ׃p[^
	 * @param allow_negation	ے	
	 */
	public void argFlag(String name, String usage, p_boolean value, 
			boolean allow_negation)
	{		 
		d.addOption(name, new FlagHandler(usage, value, allow_negation));
	}
	
	/**
	 * IvV̒ǉB<br>
	 * ĂяoF	IvV̏ڍ׃p[^int^̏ꍇɌĂ΂B
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param value	IvV̏ڍ׃p[^
	 */
	public void argInt(String name, String usage, p_int value)
	{
		d.addOption(name, new IntHandler(usage, value));
	}
	
	/**
	 * IvV̒ǉB<br>
	 * ĂяoF	IvV̏ڍ׃p[^()int^̏ꍇɌĂ΂B
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 */
	public void argInts(String name, String usage, STLVector<Integer> values)
	{
		argInts(name, usage, values, SEP_NONE, -1);
	}
	/**
	 * IvV̒ǉB<br>
	 *@ĂяoF	separatoȑl^ĂꍇB<br>
	 * 				IvV̏ڍ׃p[^()int^̏ꍇɌĂ΂B
	 * @param name	IvV	
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 * @param separator	IvV͏
	 */
	public void argInts(String name, String usage, STLVector<Integer> values, int separator)
	{
		argInts(name, usage, values, separator, -1);
	}
	/**
	 *@IvVǉB<br>
	 *@ĂяoF	separator, count̏l^ꂢꍇ<br>
	 *@				IvV̏ڍ׃p[^()int^̏ꍇɌĂ΂B
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 * @param separator	IvV͏
	 * @param count	ڍ׃p[^̐
	 */
	public void argInts(String name, String usage,
			STLVector<Integer> values, int separator, int count)
	{
		d.addOption(name, new IntsHandler(usage, values, separator, count));
	}
	
	/**
	 * IvVǉB<br>
	 * ĂяoF	IvV̏ڍ׃p[^float^̏ꍇɌĂ΂B
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param value	IvV̏ڍ׃p[^
	 */
	public void argFloat(String name, String usage, p_double value)
	{
		d.addOption(name, new FloatHandler(usage, value));
	}
	
	/**
	 * IvVǉB<br>
	 * ĂяoF	IvV̏ڍ׃p[^()float^̏ꍇɌĂ΂B
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 */
	public void argFloats(String name, String usage, STLVector<Double> values)
	{
		argFloats(name, usage, values, SEP_NONE, -1);
	}
	
	/**
	 * IvVǉB<br>
	 * ĂяoF	separatoȑl^ĂꍇB<br>
	 * 				IvV̏ڍ׃p[^()float^̏ꍇB
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 * @param separator	IvV͏
	 */
	public void argFloats(String name, String usage, STLVector<Double> values, int separator)
	{
		argFloats(name, usage, values, separator, -1);
	}
	/**
	 * IvVǉB<br>
	 * ĂяoF	saparator, count̏l^ĂꍇB <br>
	 * 				IvV̏ڍ׃p[^()float^̏ꍇB
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 * @param separator	IvV͏
	 * @param count	ڍ׃p[^̐
	 */
	public void argFloats(String name, String usage,
			STLVector<Double> values, int separator, int count)
	{
		d.addOption(name, new FloatsHandler(usage, values, separator, count));
	}
	
	/**
	 * IvVǉB<br>
	 * ĂяoF	IvV̏ڍ׃p[^String^̏ꍇ
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param value	IvV̏ڍ׃p[^
	 */
	public void argString(String name, String usage, p_String value)
	{
		d.addOption(name, new StringHandler(usage, value));
	}
	
	/**
	 *@IvVǉB <br>
	 * ĂяoF	IvV̏ڍ׃p[^()String^̏ꍇ
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 */
	public void argStrings(String name, String usage, STLVector<String> values)
	{
		argStrings(name, usage, values, SEP_NONE, -1);
	}
	
	/**
	 * IvVǉB<br>
	 *@ĂяoF	IvV̏ڍ׃p[^()String^̏ꍇ<br>
	 *				saparatoȑl^Ăꍇ 
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 * @param separator	IvV͏
	 */
	public void argStrings(String name, String usage, STLVector<String> values, int separator)
	{
		argStrings(name, usage, values, separator, -1);
	}
	
	/**
	 * IvVǉB<br>
	 *@ĂяoF	IvV̏ڍ׃p[^()String^̏ꍇ<br>
	 *				saparator, count̏l^Ăꍇ 
	 * @param name	IvV
	 * @param usage	p@bZ[W
	 * @param values	IvV̏ڍ׃p[^
	 * @param separator@IvV͏
	 * @param count	ڍ׃p[^̐
	 */
	public void argStrings(String name, String usage,
			STLVector<String> values, int separator, int count)
	{
		d.addOption(name, new StringsHandler(usage, values, separator, count));
	}
	
	/**
	 * IvVuB
	 * @param realname	ۂ̃IvV	
	 * @param aliasname	uIvV
	 */
	public void alias(String realname, String aliasname)
	{
//		Makes "aliasname" work just like "realname".  Note that
//		"realname" can be a negated flag name (if the flag allows
//		negation), so you can make "--fooless" mean "--nofoo", for
//		exanple.
		
//		=> "realname"Ȗ̂Ƃ͒ӁI
//		=> F"--nofoo"  "--fooless"@ƂӖɂłBB
		
		if(d.aliases.get(aliasname) == null)
		{
			d.aliases.put(aliasname, realname);
			OptionHandler e = d.options.get(realname);
			
			if(e != null){
				e.aliases.add(aliasname);
			}
		}
	}
	
	/**
	 * ̓eLXgÂ܂ܗp@bZ[WXg֑}B
	 * @param text	̓eLXg
	 */
	public void usageHeader(String text)
	{
//		 This inserts literal text into the usage message.  The order
//	     is significant with respect to calls to argFlag, argInt, etc.
//	     The most common use of this would be to add the
//	     "Usage: blech [options] files" at the top, but it can also be
//	     used to make different "sections" of options (give the --help
//	     option to GNU tar to see what I mean) or to make a footer at the
//	     end of the usage.  Your string can contain newlines, but it
//	     shouldn't end in a newline unless you want an extra blank line.
//	     The "indent" value specifies how to line up
//	     columns of individual usage messages in the follow section.
//	     (Again, refer to the GNU tar usage message to see what I mean.)
		
		usageHeader(text, 25);
	}
	
	/**
	 *@̓eLXgÂ܂ܗp@bZ[WXg֑}<br>
	 *@̓eLXg鏉l^Ăꍇ
	 * @param text	̓eLXg
	 * @param indent	̓eLXg鐔l 
	 */
	//JavaiKł͎gpĂȂ
	public void usageHeader(String text, int indent)
	{
		Pair<Integer, String> tmppair = new Pair<Integer, String>(indent, text);
		d.usage.add(tmppair);
	}
	
	/**
	 * IvVƂē͂ꂽ̉͂sB
	 * @param argc	̐
	 * @param argv	̕
	 * @return (d.errmsg.length()== 0); 
	 */
	public boolean parse(int argc, String[] argv)
	{
		OptionHandler argeater = null;	//͍ς݂̃IvVf[^
		OptionHandler oneshotargeater = null;	//p[^
		boolean endofoptions = false;
		String eatername = "";	//͍ς݂̃IvVf[^

//		These statments are to reset things so we can call
//		parse() more than once.  This probably isn't a very
//		useful feature, though, so maybe it should be taken
//		out to simplify things.
		
		//eIvV𖢉͂̏Ԃɂ
		d.leftovers.clear();
		Iterator<OptionHandler> e = d.options.values().iterator();
		while(e.hasNext()){
			OptionHandler value = e.next();
			value.reset();
		}	 
		d.errmsg = "";
		
		//IvV̉͂s
		try
		{
			for (int i = 0; i < argc; i++) 
			{
				if (d.errmsg.length() > 0){	//G[bZ[WꍇA^[
					break;
				}
				if (endofoptions) {	//IvV̉͂I
					d.leftovers.add(argv[i]);
					continue;
				}
				if (oneshotargeater != null) {
					d.errmsg = oneshotargeater.handleargsplit(argv[i], eatername);
					oneshotargeater = null;
					continue;
				}
				
//				The argv[i][1] == '\0' part below is so we treat "-"
//				by itself as a regular argument, not as an option,
//				since it's a common abbreviation for stdin, and isn't
//				really meaningful as an option.	@

//				IvṼp[^
				if (( argv[i].charAt(0) != '-' || argv[i].length() <= 1 ) && 
						( argeater == null || ( argeater.count > 0 || argeater.count == -1 ) ) ) 
				{
					if (argeater == null){	//ǂ̃IvVɂȂp[^ƂĔf
						d.leftovers.add(argv[i]);
					}
					else{	//̗L𒲂ׂ
						d.errmsg = argeater.handleargsplit(argv[i], eatername);
					}
					continue;
				}

//				argv[i]̈ꕶڂ'-'ł邱Ƃ͖炩()ȂߏȗBargv[]'-'Rs[
				argeater = null;
				String rest = argv[i].substring(1);
				
				int point = 0; //"-"̐JEg
				point = 0;
				
//				"-"2̏ꍇ"--foo" 
//				if (rest.charAt(point) == '-') {
				if( rest.startsWith("-") ){
					point++;
					
					//"--"̏ꍇ
					if (rest.length() <= point) { 
						endofoptions = true; //IvV͏ItO𗧂ĂB
						continue;
					}
				}
				
				int ndashes = point + 1;//"-"@̐
				int l = 0;
				while(l < rest.length() && rest.charAt(l) != ':' && rest.charAt(l) != '=')
					l++;	//IvV̕JEg
								
//				Do all the bundled options except the last one.
//				We will let the last one fall through to the regular
//				logic.  This is because the last option could take
//				an argument, but the others can't. 
				
//				"-"AIvVA͂Ăꍇ@(-a, -b, -c => -abc)
				if (d.allowOneCharOptionsToBeCombined && ndashes == 1 && l > 1)
				{
					for (int j = 0; j < l - 1; j++) 
					{
						String onechar = String.valueOf(rest.charAt(j));
						p_boolean no = new p_boolean();
						OptionHandler oh = d.findOption(onechar, no);
						
//						IvVf[^Ȃꍇ
						if (oh == null) {
							d.errmsg = argv[i] + ": '" + onechar + 
										"' is an unrecognized option";
							/* if only this was Shading Language and I could
							 * say "break 2"... */
							throw new XqException();
						}
//						IvṼp[^͂ĂȂꍇ
						if (oh.takesarg()) {
							d.errmsg = argv[i] + ": '" + onechar +	"' requires an argument";
							throw new XqException();
						}

						d.errmsg = oh.handleargsplit(no.value ? "no" : "", argv[i]);
//						IvVȏꍇ
						if (d.errmsg.length() > 0){
							throw new XqException();
						}
					}
					point += l - 1;
					l = 1;
				}

				p_boolean no = new p_boolean();
			    String option_name = rest.substring(point, (l+point > rest.length())?rest.length():l+point );
				OptionHandler oh = d.findOption(option_name, no);
				
				//IvVɑΉ(OptionHandlerIuWFNg)Ȃꍇ
				if (oh == null) {
					
					//See if there is an option which matches the first character and takes and
					//argument, if so, match it as an option/argument pair.
					String onechar = rest.substring(point, (1+point > rest.length()) ? rest.length():1+point);;
					p_boolean no2 = new p_boolean();
					oh = d.findOption(onechar, no2); 
					
					//GCAXĂ&&p[^Ȃ
					if( oh != null && oh.takesarg()) {
						l = 0;//Setup the lenght to point to the remainder.
					}
					else {
						//IvVFĂˈꎞۑ@AĂȂ˃G[
						if (d.allowUnrecognizedOptions) {
							d.leftovers.add(argv[i]);
							continue;
						}
						else {
							d.errmsg = argv[i] + ": unrecognized option";
							break;
						}
					}
				}
			
				//p[^IvV̏ꍇ
				if (oh.takesarg()){
					if (l < rest.length()) { 
						d.errmsg = oh.handleargsplit(rest.substring(point + l + 1), argv[i]);
					}
					else if (oh.separator != SEP_ARGV) {
						oneshotargeater = oh;
					}
					if (oh.separator == SEP_ARGV) {
						argeater = oh;
					}
					eatername = argv[i];
				} 
				else {
					if (l < rest.length()) {
						d.errmsg = argv[i] + ": doesn't take an argument";
					}
					else {
						d.errmsg = oh.handleargsplit (no.value ? "no" : "", argv[i]);
					}
				}
			}
		}catch( XqException err){
		}finally{	
			if (d.errmsg.length() == 0 && oneshotargeater != null){
				d.errmsg = "missing an argument at end of command line";
			}
		}
		return (d.errmsg.length() == 0);
	}
	
	
	// If parse() returns false, this method will give you an
	// error message that describes what's wrong.  Note that
	// although it's legal to call parse() more than once on the
	// same ArgParse object, only the most recent error message is
	// retained.
	/**
	 *@G[bZ[WԂB 
	 * @return@d.errmsg
	 */
	public String errmsg()
	{
		return d.errmsg;
	}
	
//	 Returns a usage string made up of the usage messages of
//	 the individual arguments, with things from usageHeader()
//	 interspersed at the appropriate places.  The string returned
//	 contains embedded newlines, and also a trailing newline.
//	̃bZ[ẂAߍ܂ẮAꂽ̂܂łB
	/** 
	 * wvbZ[W(eIvV̗p@bZ[W)ԂB
	 * @return@ret
	 */
	public String usagemsg()
	{
		String ret = new String();
		int indent = 25;
		
		Iterator<Pair<Integer, String>> ite = d.usage.iterator();
		while(ite.hasNext())
		{
			Pair<Integer, String> e = ite.next();
			if(e.first.intValue() >= 0)
			{
				indent = e.first;
				ret += e.second;
				ret += '\n';
			}
			else
			{
				OptionHandler foundoption = d.options.get(e.second);
				if(foundoption == null)
					continue;
				OptionHandler oh = foundoption; 
				ArrayList<String> names = oh.aliases;
				names.add(e.second);
				
				Collections.sort( names, new CompareByLength() );
				
				boolean first = true;
				String line = "  ";
				int it = names.size();
				
//				IvṼwvbZ[W쐬
				for(int k = 0; k < it ; k++) 
				{
					if(first){
						if(d.allowOneCharOptionsToBeCombined && it != 1)
							line += "    ";
					}
					else{
						line += ", ";
					}
					first = false;
					if(d.allowOneCharOptionsToBeCombined && it != 1)
						line += '-';
					line += '-';
					line += names.get(k);
				}
				
				int it2 = oh.usage.length();
				for (int k = 0; k < it2; k++) {
					if (oh.usage.charAt(k) == '\n') {
						ret += line;
						ret += '\n';
						line = "";
					}
					else if (oh.usage.charAt(k) == '\t' ) {
						int spaces = indent - line.length();
						if (spaces < 1) {
							/* break onto a new line if we're already past
							 * the indent */
							ret += line;
							ret += '\n';
							line = "";
							spaces = indent;
						}
						for(int n = 0; n < spaces; n++){
							line += " ";
						}
					} 
					else {
						line += oh.usage.charAt(k);
					}
				}
				ret += line;
				ret += '\n';
			}
		}
		return ret;
	}
	
	
	/**
	 * ǂ̃IvVɂȂp[^NX
	 * @return@d.leftovers
	 */
	public STLVector<String> leftovers()
	{
		return d.leftovers;
		
	}
	
	/**
	 * IvVɊւIuWFNg
	 */
	private ArgParseInternalData d;
}
