/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.accessory;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;

import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * 
 * C++STLvector邽߂̃NXB
 * 
 * @author NTT DATA Corporation
 */
@SuppressWarnings("unchecked")
public strictfp class STLVector<T> extends Vector<T> {
	
	private static final long serialVersionUID = 5325093071986534510L;
	
	private Class<? extends T> myClass;
	
	//lXgp
	private int nests = 1;
	
	/**
	 * 
	 * NX̓ɉAwNX̃CX^XŖ߂B
	 * 
	 * @param cls	xN^̒gƂȂNXBGenericsw̑B
	 * @param initialCapacity	Vectoȑe
	 * @param capacityIncrement	VectorӂꂽƂɑe 
	 * @see java.util.Vector#Vector(int, int)
	 */
	public STLVector( Class<? extends T> cls, int initialCapacity, int capacityIncrement ) {
		super(initialCapacity, capacityIncrement);
		this.myClass = cls;
		
		fillInstance(0, initialCapacity);
	}
	
	/**
	 * 
	 * NX̓ɉAwNX̃CX^XŖ߂B
	 * 
	 * @param cls	xN^̒gƂȂNXBGenericsw̑B
	 * @param initialCapacity	Vectoȑe
	 * @see java.util.Vector#Vector(int)
	 */
	public STLVector( Class<? extends T> cls, int initialCapacity ) {
		super(initialCapacity);
		this.myClass = cls;
		
		fillInstance(0, initialCapacity);
	}
	
	/**
	 * NXƓB
	 * 
	 * @param cls	xN^̒gƂȂNXBGenericsw̑B
	 * @see java.util.Vector#Vector()
	 */
	public STLVector( Class<? extends T> cls ) {
		super();
		this.myClass = cls;
	}

	
	/**
	 * NXƓB
	 * 
	 * @param cls	xN^̒gƂȂNXBGenericsw̑B
	 * @param c	vfVectorɔzuRNV 
	 * @see java.util.Vector#Vector(java.util.Collection)
	 */
	public STLVector( Class<? extends T> cls, Collection<? extends T> c ) {
		super(c);
		this.myClass = cls;
	}
	
	
	//-----------------------------
	// lXgpRXgN^S
	//-----------------------------
	public STLVector( int nests, Class cls, int initialCapacity, int capacityIncrement ) {
		super(initialCapacity, capacityIncrement);
		this.myClass = cls;
		
		fillInstance(0, initialCapacity);
	}
	public STLVector( int nests, Class cls, int initialCapacity ) {
		super(initialCapacity);
		this.myClass = cls;
		this.nests = nests;
		
		fillInstance(0, initialCapacity );
	}
	public STLVector( int nests, Class cls ) {
		super();
		this.myClass = cls;
		this.nests = nests;
	}
	
	/**
	 * 
	 * NX̓ɉA͎wNX̃CX^XŖ߂B
	 * 
	 * @param newSize	VTCY
	 * @see java.util.Vector#setSize(int)
	 */
	public void resize( int newSize ) {
		
		int oldSize = elementCount;
		
		if( newSize > oldSize ){
			fillInstance( oldSize, newSize );
		}
		
		super.setSize(newSize);
	}
	
	/**
	 * 
	 * Iresize()փtH[h邾̃\bhɕύXB
	 * 
	 * @param newSize	VTCY
	 * @see java.util.Vector#setSize(int)
	 */
	@Override
	public void setSize(int newSize) {
		this.resize(newSize);
	}
	
	/**
	 * 
	 * ׂ̂̂Ă̗vf𐳂ŕێzԂB<br>
	 * ̂ƂAGenericsŎw肳ꂽNXɃLXgĕԂB
	 * 
	 * @see java.util.Collection#toArray()
	 */
	@Override
	public T[] toArray() {
		
		T[] array;
		
		if( nests <= 1 ){
			array = (T[])Array.newInstance( myClass, elementCount );
			System.arraycopy(elementData, 0, array, 0, elementCount);
		}
		else{
			array = (T[])Array.newInstance( getClass(), elementCount );
			System.arraycopy(elementData, 0, array, 0, elementCount);
		}
		
		return array;
	}

	/**
	 * 
	 * ׂ̂̂Ă̗vf𐳂ŕێzԂB<br>
	 * ̂ƂAGenericsŎw肳ꂽNXɃLXgĕԂB
	 * 
	 * @see java.util.Collection#toArray()
	 */
	public T[] toArray(int StartPoint) {
		
		T[] array;
		
		if( nests <= 1 ){
			array = (T[])Array.newInstance( myClass, elementCount - StartPoint);
			System.arraycopy(elementData, StartPoint, array, 0, elementCount - StartPoint);
		}
		else{
			array = (T[])Array.newInstance( getClass(), elementCount - StartPoint);
			System.arraycopy(elementData, StartPoint, array, 0, elementCount - StartPoint);
		}
		
		return array;
	}
	
	/**
	 * 
	 * STLassign̓sB<br>
	 * ܂ł̒l͑SĔjAw萔̎wIuWFNgœ𖄂߂B<br>
	 * AlXgɂ͖ΉB 
	 * 
	 * @param num	߂IuWFNg̐
	 * @param val	߂IuWFNg
	 */
//	public void assign( int num, final T val ) {
//		
//		//܂ł͔̂̂j
//		//buti 
//		//clear();
//		
//		//wTCYɃTCYύXCX^XŖ߂
//		resize( num );
//		
//		try {
//			
//			//assignment\bhH
//			Method assignment = myClass.getMethod( "assignment", myClass );
//			
//			//Ăassinmentő
//			if( assignment != null ){
//				for( T ele : this ){
//					assignment.invoke( ele, val );
//				}
//				return;//I
//			}
//			
//		} catch (NoSuchMethodException e) {
//			
//			//ł́AvaluetB[hH
//			try {
//				Field value = myClass.getField("value");
//				
//				//Ăvalueɑ
//				if( value != null ){
//					for( T ele : this ){
//						Object valfield = value.get(val);
//						value.set( ele, valfield );
//					}
//					return;//I
//				}
//				
//			} catch (NoSuchFieldException e1) {
//				
//				//łȂΕʂ=ŁB
//				for( int i=0; i<elementCount; i++ ){
//					set( i, val );
//				}
//				return;//I
//				
//			//G[
//			} catch (Exception e1) {
//				HimawariLogger.outputException( e );
//			}
//			
//		//G[
//		} catch (Exception e) {
//			HimawariLogger.outputException( e );
//		}
//			
//	}
	
public void assign( int num, final T val ) {
		
		//܂ł͔̂̂j
		//buti  ʂȔjȂ
		//clear();
		
		//wTCYɃTCYύXCX^XŖ߂
		resize( num );
				
		if(myClass.equals(CqVector3D.class))
		{
				for( T ele : this ){
					((CqVector3D)ele).assignment( (CqVector3D)val );
				}
		}
		else if(myClass.equals(CqVector4D.class))
		{
				for( T ele : this ){
					((CqVector4D)ele).assignment( (CqVector4D)val );
				}
		}
		else if(myClass.equals(p_float.class))
		{
				for( T ele : this ){
					((p_float)ele).value = ((p_float)val).value;
				}
		}
		else if(myClass.equals(CqColor.class))
		{
				for( T ele : this ){
					((CqColor)ele).assignment( (CqColor)val );
				}
		}
		else if(myClass.equals(CqMatrix.class))
		{
			for( T ele : this ){
				((CqMatrix)ele).assignment( (CqMatrix)val );
			}
		}
		else if(myClass.equals(p_int.class))
		{
			for( T ele : this ){
				((p_int)ele).value = ((p_int)val).value;
			}
		}
		else if(myClass.equals(p_String.class))
		{
			for( T ele : this ){
				((p_String)ele).value = ((p_String)val).value;
			}
		}
		else
		{
			for( int i=0; i<elementCount; i++ ){
				set( i, val );
			}
		}
	}

	//
	// ̑̒u
	//
	//	[C++]			[Java]
	//
	//	empty()			isEmpty()
	//	size()			size()
	//	capacity()		capacity()
	//	
	//	insert(i,Obj)	add(i, Obj)
	//	clear()			clear()
	//	
	//	=				=
	//	==				equals()
	//	
	//	
	//	
	//	
	//	vec[1]=2.0		vec.set( 1, 2.0 );	or vec.set( 1, new p_float(2.0) )
	//	
	
	/**
	 * 
	 * ̃xN^̒gCX^XŖ߂B
	 * ȂRXgN^ŃCX^XłȂꍇ́AnullŖ߂B
	 * 
	 * @param start	߂͈͂̊Jnʒu
	 * @param end		߂͈͂̏Iʒu
	 */
	private void fillInstance( int start, int end ){
		
		for( int i=start; i<end; i++ ){
			
			try {
				
				if( nests > 1 ){
					this.add( i, newThisInstance() );
				}
				else{
					this.add( i, newInstance(myClass) );
				}
				
			} catch (Exception e) {
//				e.printStackTrace();
				this.add( null );
			}
			
		}//end of for
		
	}
	
	
	/**
	 * 
	 * wNX̃CX^X𐶐B
	 * 
	 * @param cls	CX^XNX
	 * @return	wNX̃CX^X
	 */
	private T newInstance( Class<? extends T> cls ){
		try {
			
			//v~eBũbpH
			Class superClass = cls.getSuperclass();
			if( superClass.equals( Number.class) ){
				
				//bpNXȂ炻̃v~eBu^Class擾
				Class primitiveClass = (Class)cls.getField("TYPE").get(cls);
				
				//v~eBuɎRXgN^擾	
				Constructor<? extends T> cnst = cls.getConstructor(primitiveClass);
				
				//̃RXgN^ŃCX^X
				return cnst.newInstance( (byte)0 );
			}
			//͂܂BooleanH
			else if( cls.equals( Boolean.class ) ){
				
				//RXgN^̎擾
				Constructor<? extends T> cnst = cls.getConstructor(boolean.class);
				
				//CX^X
				return cnst.newInstance( false );
			}
			
			//͕̑ʂɃCX^X
			return cls.newInstance();
			
		} catch (Exception e) {
			
			//C^[tF[X⒊ۃNXȊOExceptionꍇAG[e\B
			int mod = cls.getModifiers();
			if( !Modifier.isInterface(mod) && !Modifier.isAbstract(mod) ) HimawariLogger.outputException( e );
			
			//Ȃ񂩃G[null
			return null;
		}
	}
	/**
	 * 
	 * ̃NX̃CX^X𐶐B
	 * 
	 * @return	̃NX̃CX^X
	 */
	private T newThisInstance(){
		try {
			Class cls = this.getClass();
			
			//RXgN^擾	
			Constructor cnst = cls.getConstructor( int.class, Class.class );
			
			//̃RXgN^ŃCX^X
			return (T)cnst.newInstance( nests-1, myClass );
			
		} catch (Exception e) {

			//C^[tF[X⒊ۃNXȊOExceptionꍇAG[e\B
			int mod = myClass.getModifiers();
			if( !Modifier.isInterface(mod) && !Modifier.isAbstract(mod) ) HimawariLogger.outputException( e );
			
			//Ȃ񂩃G[null
			return null;
		}
	}
	
}

