/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.accessory;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;

import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * 
 * C++STLvector̂悤ɓ삷ArrayList邽߂̃NXB
 * 
 * @author NTT DATA Corporation
 */
@SuppressWarnings("unchecked")
public strictfp class STLArrayList<T> extends ArrayList<T> {
	
	private static final long serialVersionUID = -7542680781499126519L;

	private Class<? extends T> myClass;
	
	
	/**
	 * 
	 * NX̓ɉAwNX̃CX^XŖ߂B
	 * 
	 * @param cls	Xg̒gƂȂNXBGenericsw̑B
	 * @param initialCapacity	ArrayList̏e
	 * @see java.util.ArrayList#ArrayList(int)
	 */
	public STLArrayList( Class<? extends T> cls, int initialCapacity ) {
		super(initialCapacity);
		this.myClass = cls;
		
		fillInstance(0, initialCapacity);
	}
	
	/**
	 * NXƓB
	 * 
	 * @param cls	Xg̒gƂȂNXBGenericsw̑B
	 * @see java.util.ArrayList#ArrayList()
	 */
	public STLArrayList( Class<? extends T> cls ) {
		super();
		this.myClass = cls;
	}

	
	/**
	 * NXƓB
	 * 
	 * @param cls	xN^̒gƂȂNXBGenericsw̑B
	 * @param c	vfVectorɔzuRNV 
	 * @see java.util.ArrayList#ArrayList(java.util.Collection)
	 */
	public STLArrayList( Class<? extends T> cls, Collection<? extends T> c ) {
		super(c);
		this.myClass = cls;
	}
	
	
	/**
	 * 
	 * ̃Xg̒gCX^XŖ߂B
	 * ȂRXgN^ŃCX^XłȂꍇ́AnullŖ߂B
	 * 
	 * @param start	߂͈͂̊Jnʒu
	 * @param end		߂͈͂̏Iʒu
	 */
	private void fillInstance( int start, int end ){
		
		for( int i=start; i<end; i++ ){
			
			try {
				
				T t = newInstance(myClass); 
				this.add( i, t );
				
			} catch (Exception e) {
//				e.printStackTrace();
				this.add( null );
			}
			
		}//end of for
		
	}
	
	
	/**
	 * 
	 * wNX̃CX^X𐶐B
	 * 
	 * @param cls	CX^XNX
	 * @return	wNX̃CX^X
	 */
	private T newInstance( Class<? extends T> cls ){
		try {
			
			//v~eBũbpH
			Class superClass = cls.getSuperclass();
			if( superClass.equals( Number.class) ){
				
				//bpNXȂ炻̃v~eBu^Class擾
				Class primitiveClass = (Class)cls.getField("TYPE").get(cls);
				
				//v~eBuɎRXgN^擾	
				Constructor<? extends T> cnst = cls.getConstructor(primitiveClass);
				
				//̃RXgN^ŃCX^X
				return cnst.newInstance( (byte)0 );
			}
			//͂܂BooleanH
			else if( cls.equals( Boolean.class ) ){
				
				//RXgN^̎擾
				Constructor<? extends T> cnst = cls.getConstructor(boolean.class);
				
				//CX^X
				return cnst.newInstance( false );
			}
			
			//͕̑ʂɃCX^X
			return cls.newInstance();
			
		} catch (Exception e) {
			
			//C^[tF[X⒊ۃNXȊOExceptionꍇAG[e\B
			int mod = cls.getModifiers();
			if( !Modifier.isInterface(mod) && !Modifier.isAbstract(mod) ) HimawariLogger.outputException( e );
			
			//Ȃ񂩃G[null
			return null;
		}
	}

	public void resize( int newSize ) {
		
		int oldSize = size();
		
		if( newSize > oldSize ){
			fillInstance( oldSize, newSize );
		}
	}
}

