/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.shaderexecenv;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class BakingChannel {
    public final int batchsize = 10240;
    private int elsize;
    private int buffered;
    private float[] data;
    private String filename;

    public BakingChannel() {
        this.buffered = 0;
        this.data = null;
        this.filename = null;
    }

    public BakingChannel(String _filename, int _elsize) {
        this.init(_filename, _elsize);
    }

    public void init(String _filename, int _elsize) {
        this.elsize = _elsize + 2;
        this.buffered = 0;
        this.data = new float[this.elsize * 10240];
        this.filename = _filename;
    }

    public void destruct() {
        this.writedata();
    }

    public void moredata(float s, float t, float[] newdata) {
        if (this.buffered >= 10240) {
            this.writedata();
        }
        float[] f = this.data;
        int f_idx = this.elsize * this.buffered;
        f[f_idx + 0] = s;
        f[f_idx + 1] = t;
        int j = 2;
        while (j < this.elsize) {
            f[f_idx + j] = newdata[j - 2];
            ++j;
        }
        ++this.buffered;
    }

    private void writedata() {
        try {
            if (this.buffered > 0 && this.filename != null) {
                FileOutputStream fos = new FileOutputStream(this.filename, true);
                PrintWriter file = new PrintWriter(fos);
                float[] f = this.data;
                int f_idx = 0;
                int i = 0;
                while (i < this.buffered) {
                    int j = 0;
                    while (j < this.elsize) {
                        file.printf("%g ", Float.valueOf(f[f_idx + j]));
                        ++j;
                    }
                    file.printf("\n", new Object[0]);
                    ++i;
                    f_idx += this.elsize;
                }
                file.close();
                fos.close();
            }
            this.buffered = 0;
        }
        catch (IOException e) {
            HimawariLogger.outputException(e);
        }
    }
}

