/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector4D;

public strictfp class CqVector3D {
    private static final long serialVersionUID = 4782309621216697640L;
    public float x;
    public float y;
    public float z;

    public CqVector3D() {
    }

    public CqVector3D(CqVector3D From) {
        this.x = From.x;
        this.y = From.y;
        this.z = From.z;
    }

    public CqVector3D(CqVector2D From) {
        this.x = From.x;
        this.y = From.y;
        this.z = 0.0f;
    }

    public CqVector3D(CqColor From) {
        this.x = From.m_fRed;
        this.y = From.m_fGreen;
        this.z = From.m_fBlue;
    }

    public CqVector3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CqVector3D(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
    }

    public CqVector3D(CqVector4D From) {
        if ((double)From.w != 1.0) {
            this.x = From.x / From.w;
            this.y = From.y / From.w;
            this.z = From.z / From.w;
        } else {
            this.x = From.x;
            this.y = From.y;
            this.z = From.z;
        }
    }

    public CqVector3D(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public void z(float z) {
        this.z = z;
    }

    public float Magnitude2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float Magnitude() {
        float mag2 = this.Magnitude2();
        return mag2 <= 0.0f ? 0.0f : (float)Math.sqrt(mag2);
    }

    public CqVector3D Unit() {
        float Mag = this.Magnitude();
        if (Mag > 0.0f) {
            this.x /= Mag;
            this.y /= Mag;
            this.z /= Mag;
        }
        return this;
    }

    public float valueAt(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return this.z;
    }

    public CqVector3D assignment(float a_x, float a_y) {
        this.x = a_x;
        this.y = a_y;
        this.z = 0.0f;
        return this;
    }

    public CqVector3D assignment(float a_x, float a_y, float a_z) {
        this.x = a_x;
        this.y = a_y;
        this.z = a_z;
        return this;
    }

    public CqVector3D assignment(CqVector2D From) {
        this.x = From.x;
        this.y = From.y;
        this.z = 0.0f;
        return this;
    }

    public CqVector3D assignment(CqVector3D From) {
        this.x = From.x;
        this.y = From.y;
        this.z = From.z;
        return this;
    }

    public CqVector3D assignment(CqVector4D From) {
        if ((double)From.w != 1.0) {
            this.x = From.x / From.w;
            this.y = From.y / From.w;
            this.z = From.z / From.w;
        } else {
            this.x = From.x;
            this.y = From.y;
            this.z = From.z;
        }
        return this;
    }

    public CqVector3D assignment(CqColor From) {
        this.x = From.m_fRed;
        this.y = From.m_fGreen;
        this.z = From.m_fBlue;
        return this;
    }

    public CqVector3D assignAdd(CqVector3D From) {
        this.x += From.x;
        this.y += From.y;
        this.z += From.z;
        return this;
    }

    public CqVector3D assignAdd(float f) {
        this.x += f;
        this.y += f;
        this.z += f;
        return this;
    }

    public CqVector3D assignSub(CqVector3D From) {
        this.x -= From.x;
        this.y -= From.y;
        this.z -= From.z;
        return this;
    }

    public CqVector3D assignSub(float f) {
        this.x -= f;
        this.y -= f;
        this.z -= f;
        return this;
    }

    public CqVector3D assignMod(CqVector3D From) {
        CqVector3D vecTemp = new CqVector3D(this);
        this.x = vecTemp.y * From.z - vecTemp.z * From.y;
        this.y = vecTemp.z * From.x - vecTemp.x * From.z;
        this.z = vecTemp.x * From.y - vecTemp.y * From.x;
        return this;
    }

    public CqVector3D assignMul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public CqVector3D assignMul(CqVector3D Scale) {
        this.x *= Scale.x;
        this.y *= Scale.y;
        this.z *= Scale.z;
        return this;
    }

    public CqVector3D assignDiv(CqVector3D Scale) {
        this.x /= Scale.x;
        this.y /= Scale.y;
        this.z /= Scale.z;
        return this;
    }

    public CqVector3D assignDiv(float Scale) {
        this.x /= Scale;
        this.y /= Scale;
        this.z /= Scale;
        return this;
    }

    public boolean equals(CqVector3D Cmp) {
        return this.x == Cmp.x && this.y == Cmp.y && this.z == Cmp.z;
    }

    public boolean ge(CqVector3D Cmp) {
        return this.x >= Cmp.x && this.y >= Cmp.y && this.z >= Cmp.z;
    }

    public boolean le(CqVector3D Cmp) {
        return this.x <= Cmp.x && this.y <= Cmp.y && this.z <= Cmp.z;
    }

    public boolean gt(CqVector3D Cmp) {
        return this.x > Cmp.x && this.y > Cmp.y && this.z > Cmp.z;
    }

    public boolean lt(CqVector3D Cmp) {
        return this.x < Cmp.x && this.y < Cmp.y && this.z < Cmp.z;
    }

    public CqVector3D add(float f) {
        CqVector3D r = new CqVector3D(this.x, this.y, this.z);
        return r.assignAdd(f);
    }

    public CqVector3D sub(float f) {
        CqVector3D r = new CqVector3D(this.x, this.y, this.z);
        return r.assignSub(f);
    }

    public CqVector3D subInv(float f) {
        return new CqVector3D(f - this.x, f - this.y, f - this.z);
    }

    public CqVector3D mul(float f) {
        CqVector3D r = new CqVector3D(this.x, this.y, this.z);
        return r.assignMul(f);
    }

    public CqVector3D div(float f) {
        CqVector3D r = new CqVector3D(this.x, this.y, this.z);
        return r.assignDiv(f);
    }

    public CqVector3D divInv(float f) {
        return new CqVector3D(f / this.x, f / this.y, f / this.z);
    }

    public CqVector3D add(CqVector3D b) {
        CqVector3D r = new CqVector3D(this.x, this.y, this.z);
        return r.assignAdd(b);
    }

    public CqVector3D sub(CqVector3D b) {
        CqVector3D r = new CqVector3D(this.x, this.y, this.z);
        return r.assignSub(b);
    }

    public CqVector3D div(CqVector3D b) {
        CqVector3D r = new CqVector3D(this.x, this.y, this.z);
        return r.assignDiv(b);
    }

    public float mul(CqVector3D b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public CqVector3D mod(CqVector3D b) {
        return new CqVector3D(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public CqVector3D negative() {
        return new CqVector3D(-this.x, -this.y, -this.z);
    }

    public void exterior(CqVector3D r, CqVector3D v) {
        double x = r.y * v.z - r.z * v.y;
        double y = v.x * r.z - v.z * r.x;
        this.z = r.x * v.y - r.y * v.x;
        this.x = (float)x;
        this.y = (float)y;
    }
}

