/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

public strictfp class CqRandom {
    private static final int N = 624;
    private static final int M = 397;
    private static final long MATRIX_A = 2567483615L;
    private static final long UPPER_MASK = 0x80000000L;
    private static final long LOWER_MASK = Integer.MAX_VALUE;
    private static long[] mt = new long[624];
    private static int mti = 625;
    private static long[] mag01;

    static {
        long[] lArray = new long[2];
        lArray[1] = 2567483615L;
        mag01 = lArray;
    }

    public CqRandom() {
    }

    public CqRandom(int Seed) {
    }

    public long RandomInt() {
        return CqRandom.genrand_int32();
    }

    public long RandomInt(int Range) {
        double n = this.RandomFloat(Range);
        return Math.round(n);
    }

    public float RandomFloat() {
        return (float)CqRandom.genrand_real2();
    }

    public float RandomFloat(float Range) {
        return (float)CqRandom.genrand_real2() * Range;
    }

    public void Reseed(int Seek) {
        CqRandom.init_genrand(Seek);
    }

    private static void init_genrand(long s) {
        CqRandom.mt[0] = s & 0xFFFFFFFFL;
        mti = 1;
        while (mti < 624) {
            CqRandom.mt[CqRandom.mti] = 1812433253L * (mt[mti - 1] ^ mt[mti - 1] >> 30) + (long)mti;
            int n = mti++;
            mt[n] = mt[n] & 0xFFFFFFFFL;
        }
    }

    private static long genrand_int32() {
        long y;
        if (mti >= 624) {
            if (mti == 625) {
                CqRandom.init_genrand(5489L);
            }
            int kk = 0;
            while (kk < 227) {
                y = mt[kk] & 0x80000000L | mt[kk + 1] & Integer.MAX_VALUE;
                CqRandom.mt[kk] = mt[kk + 397] ^ y >> 1 ^ mag01[(int)(y & 1L)];
                ++kk;
            }
            while (kk < 623) {
                y = mt[kk] & 0x80000000L | mt[kk + 1] & Integer.MAX_VALUE;
                CqRandom.mt[kk] = mt[kk + -227] ^ y >> 1 ^ mag01[(int)(y & 1L)];
                ++kk;
            }
            y = mt[623] & 0x80000000L | mt[0] & Integer.MAX_VALUE;
            CqRandom.mt[623] = mt[396] ^ y >> 1 ^ mag01[(int)(y & 1L)];
            mti = 0;
        }
        y = mt[mti++];
        y ^= y >> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >> 18;
        return y;
    }

    private static double genrand_real2() {
        return (double)CqRandom.genrand_int32() * 2.3283064365386963E-10;
    }
}

