/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import net.cellcomputing.himawari.library.types.GlobFileFilter;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqFile {
    private RandomAccessFile m_pStream;
    private String m_strRealName;

    public CqFile() {
        this.m_pStream = null;
    }

    public CqFile(RandomAccessFile Stream2, String strRealName) {
        this.m_pStream = Stream2;
        this.m_strRealName = strRealName;
    }

    public CqFile(String strFilename, String strSearchPathOption) {
        this.m_pStream = null;
        this.Open(strFilename, strSearchPathOption);
    }

    public CqFile(String strFilename) {
        this.m_pStream = null;
        this.Open(strFilename, "");
    }

    public void Open(String strFilename, String strSearchPathOption, String mode) {
        this.m_strRealName = strFilename = this.FixupPath(strFilename);
        RandomAccessFile pFStream = null;
        try {
            this.m_pStream = pFStream = new RandomAccessFile(strFilename, mode);
            return;
        }
        catch (FileNotFoundException e) {
            if (!strSearchPathOption.equals("")) {
                int len = 0;
                int start = 0;
                String strPath = "";
                while (true) {
                    File file;
                    int index;
                    if ((index = strSearchPathOption.indexOf(58, start)) == -1) {
                        index = strSearchPathOption.length();
                    }
                    if ((len = index - start) == 1 && Character.isLetter(strSearchPathOption.charAt(start))) {
                        int separatePos = strSearchPathOption.indexOf(58, start + 2);
                        len = separatePos == -1 ? strSearchPathOption.length() - start : separatePos - start;
                    }
                    if ((strPath = strSearchPathOption.substring(start, start + len)).equals("")) break;
                    String strAlternativeFilename = strPath = this.FixupPath(strPath);
                    if (!strAlternativeFilename.endsWith(File.separator)) {
                        strAlternativeFilename = String.valueOf(strAlternativeFilename) + File.separator;
                    }
                    if ((file = new File(strAlternativeFilename = String.valueOf(strAlternativeFilename) + strFilename)).isFile()) {
                        try {
                            this.m_pStream = pFStream = new RandomAccessFile(file, "r");
                            this.m_strRealName = strAlternativeFilename;
                            return;
                        }
                        catch (FileNotFoundException e1) {
                            this.m_pStream = null;
                        }
                    }
                    if (start + len >= strSearchPathOption.length()) break;
                    start += len + 1;
                }
            }
            return;
        }
    }

    private String FixupPath(String strPath) {
        if (strPath.startsWith("//") && strPath.charAt(3) == '/') {
            String strNewPath = strPath.substring(2, 3);
            strNewPath = strNewPath.concat(":/");
            strNewPath = strNewPath.concat(strPath.substring(4));
            return strNewPath;
        }
        return strPath;
    }

    public void Open(String strFilename, String strSearchPathOption) {
        this.Open(strFilename, strSearchPathOption, "r");
    }

    public void Open(String strFilename) {
        this.Open(strFilename, "", "r");
    }

    public void Close() {
        if (this.m_pStream != null) {
            try {
                this.m_pStream.close();
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
        }
        this.m_pStream = null;
    }

    public boolean IsValid() {
        return this.m_pStream != null;
    }

    public final String strRealName() {
        return this.m_strRealName;
    }

    public long Position() {
        try {
            return this.m_pStream.getFilePointer();
        }
        catch (IOException e) {
            HimawariLogger.outputException(e);
            return -1L;
        }
    }

    public long Length() {
        if (this.m_pStream == null) {
            return -1L;
        }
        try {
            return this.m_pStream.length();
        }
        catch (IOException e) {
            HimawariLogger.outputException(e);
            return -1L;
        }
    }

    public static ArrayList<String> Glob(String strFileGlob) {
        String pt = strFileGlob.trim();
        ArrayList<String> result = new ArrayList<String>();
        int dp = pt.lastIndexOf(File.separator);
        if (dp == -1) {
            pt = "." + pt;
            dp = 1;
        } else {
            dp += File.separator.length();
        }
        File hFile = new File(pt.substring(0, dp));
        if (hFile.exists()) {
            String[] strFile;
            String[] stringArray = strFile = hFile.list(new GlobFileFilter(pt.substring(dp)));
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String str = stringArray[n];
                result.add(str);
                ++n;
            }
        }
        return result;
    }

    public RandomAccessFile ref() {
        return this.m_pStream;
    }

    public RandomAccessFile point() {
        return this.m_pStream;
    }

    public static String FixupPathIfNeed(String path) {
        CqFile file = new CqFile();
        return file.FixupPath(path);
    }
}

