/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.cache.RiCacheBase;

public strictfp class RiPatchMeshCache
extends RiCacheBase {
    private String m_type;
    private int m_nu;
    private String m_uwrap;
    private int m_nv;
    private String m_vwrap;

    public RiPatchMeshCache(String type, int nu, String uwrap, int nv, String vwrap, int count, String[] tokens, Object[] values) {
        int vstep;
        int ustep;
        this.m_type = new String(type);
        this.m_nu = nu;
        this.m_uwrap = new String(uwrap);
        this.m_nv = nv;
        this.m_vwrap = new String(vwrap);
        int constant_size = 1;
        int uniform_size = 1;
        int varying_size = 1;
        int vertex_size = 1;
        int facevarying_size = 1;
        if (type.compareTo("bilinear") == 0) {
            uniform_size = uwrap.compareTo("periodic") == 0 ? nu : nu - 1;
            uniform_size = vwrap.compareTo("periodic") == 0 ? (uniform_size *= nv) : (uniform_size *= nv - 1);
        } else {
            ustep = RiGlobal.QGetRenderContext().pattrCurrent().GetIntegerAttribute("System", "BasisStep")[0];
            vstep = RiGlobal.QGetRenderContext().pattrCurrent().GetIntegerAttribute("System", "BasisStep")[1];
            uniform_size = uwrap.compareTo("periodic") == 0 ? nu / ustep : (nu - 4) / ustep;
            uniform_size = vwrap.compareTo("periodic") == 0 ? (uniform_size *= nv / vstep) : (uniform_size *= (nv - 4) / vstep);
        }
        if (type.compareTo("bilinear") == 0) {
            varying_size = nu * nv;
        } else {
            ustep = RiGlobal.QGetRenderContext().pattrCurrent().GetIntegerAttribute("System", "BasisStep")[0];
            vstep = RiGlobal.QGetRenderContext().pattrCurrent().GetIntegerAttribute("System", "BasisStep")[1];
            varying_size = nu / ustep * (nv / vstep);
        }
        vertex_size = nu * nv;
        this.CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
    }

    public void destruct() {
        super.destruct();
    }

    public void ReCall() {
        RendermanInterface.RiPatchMeshV(this.m_type, this.m_nu, this.m_uwrap, this.m_nv, this.m_vwrap, this.m_count, this.m_tokens, this.m_values);
    }
}

