/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Vector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqDeformingSurface;
import net.cellcomputing.himawari.library.CqLath;
import net.cellcomputing.himawari.library.CqMicroPolyGrid;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqMicroPolyGridBaseMotionImple;
import net.cellcomputing.himawari.library.CqMotionMicroPolyGrid;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.CqPolygonPoints;
import net.cellcomputing.himawari.library.CqSubdivision2;
import net.cellcomputing.himawari.library.CqSurfacePatchBicubic;
import net.cellcomputing.himawari.library.EqSplitDir;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqAttributes;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.IqTransform;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfaceSubdivisionPatch
extends CqBasicSurface {
    private CqSubdivision2 m_pTopology;
    private CqLath m_pFace;
    private int m_Uses;
    private float m_Time;
    private int m_FaceIndex;
    private static int[] aDiceSizes;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        int[] nArray = new int[17];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 4;
        nArray[15] = 4;
        nArray[16] = 4;
        aDiceSizes = nArray;
    }

    public CqSurfaceSubdivisionPatch(CqSubdivision2 pTopology, CqLath pFace, int faceIndex) {
        this.m_pTopology = pTopology;
        this.m_pFace = pFace;
        this.m_Uses = this.Uses();
        this.m_Time = RiGlobal.QGetRenderContextI().Time();
        this.m_FaceIndex = faceIndex;
    }

    public CqSubdivision2 pTopology() {
        return this.m_pTopology;
    }

    public CqLath pFace() {
        return this.m_pFace;
    }

    @Override
    public IqAttributes pAttributes() {
        return this.pTopology().pPoints().pAttributes();
    }

    @Override
    public IqTransform pTransform() {
        return this.pTopology().pPoints().pTransform();
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime) {
    }

    @Override
    public int cUniform() {
        return 0;
    }

    @Override
    public int cVarying() {
        return 0;
    }

    @Override
    public int cVertex() {
        return 0;
    }

    @Override
    public int cFaceVarying() {
        return 0;
    }

    @Override
    public CqBound Bound() {
        Vector<CqLath> aQff;
        assert (this.pTopology() != null);
        assert (this.pTopology().pPoints() != null);
        assert (this.pFace() != null);
        CqBound B = new CqBound();
        if (this.pFace().pParentFacet() != null) {
            aQff = new Vector<CqLath>();
            Vector<CqLath> apSubFaces2 = new Vector<CqLath>();
            this.pFace().pParentFacet().Qff(aQff);
            for (CqLath iF : aQff) {
                CqLath face = iF;
                if (face.pFaceVertex() != null) continue;
                this.pTopology().SubdivideFace(face, apSubFaces2);
            }
        }
        aQff = new Vector();
        this.pFace().Qff(aQff);
        for (CqLath iFF : aQff) {
            Vector<CqLath> aQfv = new Vector<CqLath>();
            iFF.Qfv(aQfv);
            for (CqLath iQfv : aQfv) {
                int iTime = 0;
                while (iTime < this.pTopology().iTimes()) {
                    B.Encapsulate(new CqVector3D(this.pTopology().pPoints(iTime).P().pValue_get(iQfv.VertexIndex(), 0)));
                    ++iTime;
                }
            }
        }
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqMicroPolyGridBase Dice() {
        STLVector<CqMicroPolyGridBase> apGrids = new STLVector<CqMicroPolyGridBase>(CqMicroPolyGridBase.class);
        int iTime = 0;
        while (iTime < this.pTopology().iTimes()) {
            CqSubdivision2 pSurface = this.Extract(iTime);
            CqSurfaceSubdivisionPatch pPatch = new CqSurfaceSubdivisionPatch(pSurface, pSurface.pFacet(0), 0);
            pPatch.m_uDiceSize = this.m_uDiceSize;
            pPatch.m_vDiceSize = this.m_vDiceSize;
            CqMicroPolyGridBase pGrid = pPatch.DiceExtract();
            apGrids.add(pGrid);
            ++iTime;
        }
        if (apGrids.size() == 1) {
            return (CqMicroPolyGridBase)apGrids.get(0);
        }
        CqMotionMicroPolyGrid pGrid = new CqMotionMicroPolyGrid();
        int i = 0;
        while (i < this.pTopology().iTimes()) {
            pGrid.AddTimeSlot(this.pTopology().Time(i), (CqMicroPolyGridBase)apGrids.get(i));
            ++i;
        }
        return pGrid;
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        block21: {
            block19: {
                int iTime;
                STLVector<CqSurfacePatchBicubic> apSurfaces;
                block20: {
                    CqLath pPoint;
                    assert (this.pTopology() != null);
                    assert (this.pTopology().pPoints() != null);
                    assert (this.pFace() != null);
                    boolean canuse = this.pTopology().CanUsePatch(this.pFace());
                    if (!canuse) break block19;
                    CqLath pRow = pPoint = this.pFace().cv().cv().cf().cf();
                    Vector<Integer> aiVertices = new Vector<Integer>();
                    Vector<Integer> aiFVertices = new Vector<Integer>();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.ccf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.cv().ccf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.cv().ccf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pRow = pPoint = pRow.cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pRow = pPoint = pRow.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pRow.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    pPoint = pPoint.ccv().cf();
                    aiVertices.add(pPoint.VertexIndex());
                    aiFVertices.add(pPoint.FaceVertexIndex());
                    apSurfaces = new STLVector<CqSurfacePatchBicubic>(CqSurfacePatchBicubic.class);
                    iTime = 0;
                    while (iTime < this.pTopology().iTimes()) {
                        CqSurfacePatchBicubic pSurface = new CqSurfacePatchBicubic();
                        pSurface.SetSurfaceParameters(this.pTopology().pPoints(iTime));
                        for (CqParameter iUP : this.pTopology().pPoints(iTime).aUserParams()) {
                            int i;
                            CqParameter pNewUP;
                            if (iUP.Class().getValue() == 3) {
                                pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                                pNewUP.SetSize(pSurface.cVarying());
                                pNewUP.SetValue(iUP, 0, (Integer)aiVertices.get(5));
                                pNewUP.SetValue(iUP, 1, (Integer)aiVertices.get(6));
                                pNewUP.SetValue(iUP, 2, (Integer)aiVertices.get(9));
                                pNewUP.SetValue(iUP, 3, (Integer)aiVertices.get(10));
                                pSurface.AddPrimitiveVariable(pNewUP);
                                continue;
                            }
                            if (iUP.Class().getValue() == 4) {
                                pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                                pNewUP.SetSize(pSurface.cVertex());
                                i = 0;
                                while (i < pSurface.cVertex()) {
                                    pNewUP.SetValue(iUP, i, (Integer)aiVertices.get(i));
                                    ++i;
                                }
                                pSurface.AddPrimitiveVariable(pNewUP);
                                continue;
                            }
                            if (iUP.Class().getValue() == 5) {
                                pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                                pNewUP.SetSize(pSurface.cVertex());
                                i = 0;
                                while (i < pSurface.cVertex()) {
                                    pNewUP.SetValue(iUP, i, (Integer)aiFVertices.get(i));
                                    ++i;
                                }
                                pSurface.AddPrimitiveVariable(pNewUP);
                                continue;
                            }
                            if (iUP.Class().getValue() == 2) {
                                pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                                pNewUP.SetSize(pSurface.cUniform());
                                pNewUP.SetValue(iUP, 0, this.m_FaceIndex);
                                pSurface.AddPrimitiveVariable(pNewUP);
                                continue;
                            }
                            if (iUP.Class().getValue() != 1) continue;
                            pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                            pNewUP.SetSize(1);
                            pNewUP.SetValue(iUP, 0, 0);
                            pSurface.AddPrimitiveVariable(pNewUP);
                        }
                        int i = 0;
                        while (i < pSurface.cVertex()) {
                            pSurface.P().pValue_get(i, 0).assignment(new CqVector3D(pSurface.P().pValue_get(i, 0)));
                            ++i;
                        }
                        CqMatrix matuBasis = new CqMatrix(RendermanInterface.RiBSplineBasis);
                        CqMatrix matvBasis = new CqMatrix(RendermanInterface.RiBSplineBasis);
                        pSurface.ConvertToBezierBasis(matuBasis, matvBasis);
                        int iUses = this.Uses();
                        if (RiGlobal.USES(iUses, 14) || RiGlobal.USES(iUses, 15) || RiGlobal.USES(iUses, 12) || RiGlobal.USES(iUses, 13)) {
                            CqParameterTypedVarying<p_float, p_float> pNewUP;
                            if (RiGlobal.USES(iUses, 14) && !this.pTopology().pPoints().bHasVar(14)) {
                                pNewUP = new CqParameterTypedVarying<p_float, p_float>("s", new EqVariableType(1), p_float.class, p_float.class);
                                pNewUP.SetSize(pSurface.cVarying());
                                pNewUP.pValue_get((int)0, (int)0).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)1).value = 1.0f;
                                pNewUP.pValue_get((int)0, (int)2).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)3).value = 1.0f;
                                pSurface.AddPrimitiveVariable(pNewUP);
                            }
                            if (RiGlobal.USES(iUses, 15) && !this.pTopology().pPoints().bHasVar(15)) {
                                pNewUP = new CqParameterTypedVarying<p_float, p_float>("t", new EqVariableType(1), p_float.class, p_float.class);
                                pNewUP.SetSize(pSurface.cVarying());
                                pNewUP.pValue_get((int)0, (int)0).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)1).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)2).value = 1.0f;
                                pNewUP.pValue_get((int)0, (int)3).value = 1.0f;
                                pSurface.AddPrimitiveVariable(pNewUP);
                            }
                            if (RiGlobal.USES(iUses, 12) && !this.pTopology().pPoints().bHasVar(12)) {
                                pNewUP = new CqParameterTypedVarying<p_float, p_float>("u", new EqVariableType(1), p_float.class, p_float.class);
                                pNewUP.SetSize(pSurface.cVarying());
                                pNewUP.pValue_get((int)0, (int)0).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)1).value = 1.0f;
                                pNewUP.pValue_get((int)0, (int)2).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)3).value = 1.0f;
                                pSurface.AddPrimitiveVariable(pNewUP);
                            }
                            if (RiGlobal.USES(iUses, 13) && !this.pTopology().pPoints().bHasVar(13)) {
                                pNewUP = new CqParameterTypedVarying<p_float, p_float>("v", new EqVariableType(1), p_float.class, p_float.class);
                                pNewUP.SetSize(pSurface.cVarying());
                                pNewUP.pValue_get((int)0, (int)0).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)1).value = 0.0f;
                                pNewUP.pValue_get((int)0, (int)2).value = 1.0f;
                                pNewUP.pValue_get((int)0, (int)3).value = 1.0f;
                                pSurface.AddPrimitiveVariable(pNewUP);
                            }
                        }
                        apSurfaces.add(pSurface);
                        ++iTime;
                    }
                    if (apSurfaces.size() != 1) break block20;
                    aSplits.add((CqBasicSurface)apSurfaces.get(0));
                    break block21;
                }
                if (apSurfaces.size() <= 1) break block21;
                CqDeformingSurface pMotionSurface = new CqDeformingSurface(null);
                iTime = 0;
                while (iTime < this.pTopology().iTimes()) {
                    float time = this.pTopology().Time(iTime);
                    pMotionSurface.AddTimeSlot(time, (CqBasicSurface)apSurfaces.get(iTime));
                    ++iTime;
                }
                aSplits.add(pMotionSurface);
                break block21;
            }
            Vector<CqLath> apSubFaces = new Vector<CqLath>();
            this.pTopology().SubdivideFace(this.pFace(), apSubFaces);
            for (CqLath iSF : apSubFaces) {
                CqSurfaceSubdivisionPatch pNew = new CqSurfaceSubdivisionPatch(this.pTopology(), iSF, this.m_FaceIndex);
                aSplits.add(pNew);
            }
        }
        return aSplits.size();
    }

    @Override
    public boolean Diceable() {
        assert (this.pTopology() != null);
        assert (this.pTopology().pPoints() != null);
        assert (this.pFace() != null);
        if (!this.m_fDiceable) {
            return false;
        }
        if (this.pTopology().CanUsePatch(this.pFace())) {
            return false;
        }
        Vector<CqLath> aQfv = new Vector<CqLath>();
        this.pFace().Qfv(aQfv);
        if (aQfv.size() != 4) {
            return false;
        }
        CqMatrix matCtoR = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time());
        CqVector2D[] avecHull = new CqVector2D[4];
        int i = 0;
        while (i < 4) {
            avecHull[i] = new CqVector2D();
            ++i;
        }
        float ShadingRate = this.pAttributes().GetFloatAttribute("System", "ShadingRate")[0];
        i = 0;
        while (i < 4) {
            avecHull[i].assignment(matCtoR.multiply(new CqVector3D(this.pTopology().pPoints().P().pValue_get(0, aQfv.get(i).VertexIndex()))));
            ++i;
        }
        float uLen = 0.0f;
        float vLen = 0.0f;
        CqVector2D Vec1 = avecHull[1].sub(avecHull[0]);
        CqVector2D Vec2 = avecHull[2].sub(avecHull[3]);
        uLen = Vec1.Magnitude2() > Vec2.Magnitude2() ? Vec1.Magnitude2() : Vec2.Magnitude2();
        Vec1 = avecHull[3].sub(avecHull[0]);
        Vec2 = avecHull[2].sub(avecHull[1]);
        float f = vLen = Vec1.Magnitude2() > Vec2.Magnitude2() ? Vec1.Magnitude2() : Vec2.Magnitude2();
        if (ShadingRate > 0.0f) {
            uLen = (float)Math.sqrt(uLen / ShadingRate);
            vLen = (float)Math.sqrt(vLen / ShadingRate);
        } else {
            uLen = 0.0f;
            vLen = 0.0f;
        }
        this.m_SplitDir = uLen > vLen ? new EqSplitDir(0) : new EqSplitDir(1);
        uLen = Math.max(Math.round(uLen), 1);
        vLen = Math.max(Math.round(vLen), 1);
        this.m_uDiceSize = (int)uLen;
        this.m_vDiceSize = (int)vLen;
        if (uLen < 1.1920929E-7f || vLen < 1.1920929E-7f) {
            this.m_fDiscard = true;
            return false;
        }
        float gs = 8.0f;
        float[] poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("System", "SqrtGridSize");
        if (poptGridSize != null) {
            gs = poptGridSize[0] / 2.0f;
        }
        if ((float)this.m_uDiceSize > gs) {
            return false;
        }
        return !((float)this.m_vDiceSize > gs);
    }

    private static float BilinearEvaluate(float A, float B, float C, float D, float s, float t) {
        float CD;
        float AB;
        if ((double)s <= 0.0) {
            AB = A;
            CD = C;
        } else if ((double)s >= 1.0) {
            AB = B;
            CD = D;
        } else {
            AB = (B - A) * s + A;
            CD = (D - C) * s + C;
        }
        float R = (double)t <= 0.0 ? AB : ((double)t >= 1.0 ? CD : (CD - AB) * t + AB);
        return R;
    }

    public CqMicroPolyGridBase DiceExtract() {
        CqMicroPolyGridBase pGrid;
        assert (this.pTopology() != null);
        assert (this.pTopology().pPoints() != null);
        assert (this.pFace() != null);
        int dicesize = Math.min(Math.max(this.m_uDiceSize, this.m_vDiceSize), 16);
        int sdcount = aDiceSizes[dicesize];
        dicesize = 1 << sdcount;
        int lUses = this.Uses();
        STLVector<CqMicroPolyGrid> apGrids = new STLVector<CqMicroPolyGrid>(CqMicroPolyGrid.class);
        int iTime = 0;
        while (iTime < this.pTopology().iTimes()) {
            int igrid;
            float u;
            int iu;
            float v;
            int iv;
            CqLath pLath;
            int nr;
            pGrid = new CqMicroPolyGrid(dicesize, dicesize, this.pTopology().pPoints());
            CqPolygonPoints pMotionPoints = this.pTopology().pPoints(iTime);
            Vector<CqLath> apSubFace1 = new Vector<CqLath>();
            Vector<CqLath> apSubFace2 = new Vector<CqLath>();
            apSubFace1.add(this.pFace());
            int isd = 0;
            while (isd < sdcount) {
                apSubFace2.clear();
                for (CqLath iSF : apSubFace1) {
                    Vector<CqLath> apSubFaceTemp = new Vector<CqLath>();
                    this.pTopology().SubdivideFace(iSF, apSubFaceTemp);
                    apSubFace2.addAll(apSubFaceTemp);
                }
                Vector tmp = new Vector(apSubFace1);
                apSubFace1 = new Vector(apSubFace2);
                apSubFace2 = new Vector(tmp);
                tmp.clear();
                ++isd;
            }
            int nc = nr = dicesize;
            int r = 0;
            CqLath pTemp = pLath = (CqLath)apSubFace1.get(0);
            int ivA = pLath.VertexIndex();
            int iFVA = pLath.FaceVertexIndex();
            int indexA = 0;
            this.StoreDice((CqMicroPolyGrid)pGrid, pMotionPoints, ivA, iFVA, indexA);
            ++indexA;
            pLath = pLath.ccf();
            int c = 0;
            while (c < nc) {
                ivA = pLath.VertexIndex();
                iFVA = pLath.FaceVertexIndex();
                this.StoreDice((CqMicroPolyGrid)pGrid, pMotionPoints, ivA, iFVA, indexA);
                if (c < nc - 1) {
                    pLath = pLath.cv().ccf();
                }
                ++indexA;
                ++c;
            }
            ++r;
            while (r <= nr) {
                pLath = pTemp.cf();
                if (r < nr) {
                    pTemp = pLath.ccv();
                }
                ivA = pLath.VertexIndex();
                iFVA = pLath.FaceVertexIndex();
                indexA = r * (nc + 1);
                this.StoreDice((CqMicroPolyGrid)pGrid, pMotionPoints, ivA, iFVA, indexA);
                ++indexA;
                pLath = pLath.cf();
                c = 0;
                while (c < nc) {
                    ivA = pLath.VertexIndex();
                    iFVA = pLath.FaceVertexIndex();
                    this.StoreDice((CqMicroPolyGrid)pGrid, pMotionPoints, ivA, iFVA, indexA);
                    if (c < nc - 1) {
                        pLath = pLath.ccv().cf();
                    }
                    ++indexA;
                    ++c;
                }
                ++r;
            }
            if (RiGlobal.USES(lUses, 0) && !this.pTopology().pPoints().bHasVar(0)) {
                if (this.pAttributes().GetColorAttribute("System", "Color") != null) {
                    ((CqMicroPolyGrid)pGrid).pVar(0).SetColor(new CqColor(this.pAttributes().GetColorAttribute("System", "Color")[0]));
                } else {
                    ((CqMicroPolyGrid)pGrid).pVar(0).SetColor(new CqColor(1.0f, 1.0f, 1.0f));
                }
            }
            if (RiGlobal.USES(lUses, 1) && !this.pTopology().pPoints().bHasVar(1)) {
                if (this.pAttributes().GetColorAttribute("System", "Opacity") != null) {
                    ((CqMicroPolyGrid)pGrid).pVar(1).SetColor(new CqColor(this.pAttributes().GetColorAttribute("System", "Opacity")[0]));
                } else {
                    ((CqMicroPolyGrid)pGrid).pVar(1).SetColor(new CqColor(1.0f, 1.0f, 1.0f));
                }
            }
            apGrids.add(pGrid);
            if (RiGlobal.USES(lUses, 12) && !this.pTopology().pPoints().bHasVar(12)) {
                iv = 0;
                while (iv <= dicesize) {
                    v = 1.0f / (float)(dicesize + 1) * (float)iv;
                    iu = 0;
                    while (iu <= dicesize) {
                        u = 1.0f / (float)(dicesize + 1) * (float)iu;
                        igrid = iv * (dicesize + 1) + iu;
                        ((CqMicroPolyGrid)pGrid).pVar(12).SetFloat(CqSurfaceSubdivisionPatch.BilinearEvaluate(0.0f, 1.0f, 0.0f, 1.0f, u, v), igrid);
                        ++iu;
                    }
                    ++iv;
                }
            }
            if (RiGlobal.USES(lUses, 13) && !this.pTopology().pPoints().bHasVar(13)) {
                iv = 0;
                while (iv <= dicesize) {
                    v = 1.0f / (float)(dicesize + 1) * (float)iv;
                    iu = 0;
                    while (iu <= dicesize) {
                        u = 1.0f / (float)(dicesize + 1) * (float)iu;
                        igrid = iv * (dicesize + 1) + iu;
                        ((CqMicroPolyGrid)pGrid).pVar(13).SetFloat(CqSurfaceSubdivisionPatch.BilinearEvaluate(0.0f, 0.0f, 1.0f, 1.0f, u, v), igrid);
                        ++iu;
                    }
                    ++iv;
                }
            }
            if (RiGlobal.USES(lUses, 14) && !this.pTopology().pPoints().bHasVar(14)) {
                ((CqMicroPolyGrid)pGrid).pVar(14).SetValueFromVariable(((CqMicroPolyGrid)pGrid).pVar(12));
            }
            if (RiGlobal.USES(lUses, 15) && !this.pTopology().pPoints().bHasVar(15)) {
                ((CqMicroPolyGrid)pGrid).pVar(15).SetValueFromVariable(((CqMicroPolyGrid)pGrid).pVar(13));
            }
            ++iTime;
        }
        if (apGrids.size() == 1) {
            return (CqMicroPolyGridBase)apGrids.get(0);
        }
        pGrid = new CqMotionMicroPolyGrid();
        int i = 0;
        while (i < this.pTopology().iTimes()) {
            ((CqMicroPolyGridBaseMotionImple)pGrid).AddTimeSlot(this.pTopology().Time(i), (CqMicroPolyGridBase)apGrids.get(i));
            ++i;
        }
        return pGrid;
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    public void StoreDice(CqMicroPolyGrid pGrid, CqPolygonPoints pPoints, int iParam, int iFVParam, int iData) {
        CqParameter pParam;
        int lUses = this.m_Uses;
        int lDone = 0;
        if (RiGlobal.USES(lUses, 8)) {
            pGrid.pVar(8).SetPoint(new CqVector3D(pPoints.P().pValue_get(iParam, 0)), iData);
        }
        if ((pParam = pPoints.FindUserParam("st")) != null) {
            int index = iParam;
            if (pParam.Class().getValue() == 5) {
                index = iFVParam;
            }
            CqParameterTyped pSTParam = (CqParameterTyped)pParam;
            if (RiGlobal.USES(lUses, 14) && pGrid.pVar(14) != null) {
                pGrid.pVar(14).SetFloat(((p_float)pSTParam.pValue_get((int)index, (int)0)).value, iData);
            }
            if (RiGlobal.USES(lUses, 15) && pGrid.pVar(15) != null) {
                pGrid.pVar(15).SetFloat(((p_float)pSTParam.pValue_get((int)index, (int)1)).value, iData);
            }
            lDone |= 0x4000;
            lDone |= 0x8000;
        }
        if (RiGlobal.USES(lUses, 14) && pGrid.pVar(14) != null && pPoints.bHasVar(14) && !RiGlobal.isDONE(lDone, 14)) {
            if (pPoints.s().Class().getValue() == 3 || pPoints.s().Class().getValue() == 4) {
                pGrid.pVar(14).SetFloat(pPoints.s().pValue_get((int)iParam, (int)0).value, iData);
            } else if (pPoints.s().Class().getValue() == 5) {
                pGrid.pVar(14).SetFloat(pPoints.s().pValue_get((int)iFVParam, (int)0).value, iData);
            } else if (pPoints.s().Class().getValue() == 2) {
                pGrid.pVar(14).SetFloat(pPoints.s().pValue_get((int)0, (int)0).value, iData);
            }
        }
        if (RiGlobal.USES(lUses, 15) && pGrid.pVar(15) != null && pPoints.bHasVar(15) && !RiGlobal.isDONE(lDone, 15)) {
            if (pPoints.t().Class().getValue() == 3 || pPoints.t().Class().getValue() == 4) {
                pGrid.pVar(15).SetFloat(pPoints.t().pValue_get((int)iParam, (int)0).value, iData);
            } else if (pPoints.t().Class().getValue() == 5) {
                pGrid.pVar(15).SetFloat(pPoints.t().pValue_get((int)iFVParam, (int)0).value, iData);
            } else if (pPoints.t().Class().getValue() == 2) {
                pGrid.pVar(15).SetFloat(pPoints.t().pValue_get((int)0, (int)0).value, iData);
            }
        }
        if (RiGlobal.USES(lUses, 0) && pGrid.pVar(0) != null && pPoints.bHasVar(0)) {
            if (pPoints.Cs().Class().getValue() == 3 || pPoints.Cs().Class().getValue() == 4) {
                pGrid.pVar(0).SetColor(pPoints.Cs().pValue_get(iParam, 0), iData);
            } else if (pPoints.Cs().Class().getValue() == 5) {
                pGrid.pVar(0).SetColor(pPoints.Cs().pValue_get(iFVParam, 0), iData);
            } else if (pPoints.Cs().Class().getValue() == 2) {
                pGrid.pVar(0).SetColor(pPoints.Cs().pValue_get(0, 0), iData);
            }
        }
        if (RiGlobal.USES(lUses, 1) && pGrid.pVar(1) != null && pPoints.bHasVar(1)) {
            if (pPoints.Os().Class().getValue() == 3 || pPoints.Os().Class().getValue() == 4) {
                pGrid.pVar(1).SetColor(pPoints.Os().pValue_get(iParam, 0), iData);
            } else if (pPoints.Os().Class().getValue() == 5) {
                pGrid.pVar(1).SetColor(pPoints.Os().pValue_get(iFVParam, 0), iData);
            } else if (pPoints.Os().Class().getValue() == 2) {
                pGrid.pVar(1).SetColor(pPoints.Os().pValue_get(0, 0), iData);
            }
        }
        for (CqParameter iUP : pPoints.aUserParams()) {
            IqShader pShader = pGrid.pAttributes().pshadSurface(this.m_Time);
            if (pShader != null) {
                CqSurfaceSubdivisionPatch.StoreDiceAPVar(pShader, iUP, iParam, iFVParam, iData);
            }
            if ((pShader = pGrid.pAttributes().pshadDisplacement(this.m_Time)) != null) {
                CqSurfaceSubdivisionPatch.StoreDiceAPVar(pShader, iUP, iParam, iFVParam, iData);
            }
            if ((pShader = pGrid.pAttributes().pshadAtmosphere(this.m_Time)) == null) continue;
            CqSurfaceSubdivisionPatch.StoreDiceAPVar(pShader, iUP, iParam, iFVParam, iData);
        }
    }

    private static void StoreDiceAPVar(IqShader pShader, CqParameter pParam, int ivA, int ifvA, int indexA) {
        IqShaderData pArg = pShader.FindArgument(pParam.strName());
        if (pArg != null) {
            int index = ivA;
            if (pParam.Class().getValue() == 5) {
                index = ifvA;
            }
            switch (pParam.Type().getValue()) {
                case 1: {
                    CqParameterTyped pNParam = (CqParameterTyped)pParam;
                    pArg.SetValue(((p_float)pNParam.pValue_get((int)index, (int)0)).value, indexA);
                    break;
                }
                case 2: {
                    CqParameterTyped pNParam = (CqParameterTyped)pParam;
                    pArg.SetValue(((p_int)pNParam.pValue_get((int)index, (int)0)).value, indexA);
                    break;
                }
                case 3: 
                case 8: 
                case 9: {
                    CqParameterTyped pNParam = (CqParameterTyped)pParam;
                    pArg.SetValue((CqVector3D)pNParam.pValue_get(index, 0), indexA);
                    break;
                }
                case 7: {
                    CqParameterTyped pNParam = (CqParameterTyped)pParam;
                    pArg.SetValue(new CqVector3D((CqVector4D)pNParam.pValue_get(index, 0)), indexA);
                    break;
                }
                case 4: {
                    CqParameterTyped pNParam = (CqParameterTyped)pParam;
                    pArg.SetValue(((p_String)pNParam.pValue_get((int)index, (int)0)).value, indexA);
                    break;
                }
                case 5: {
                    CqParameterTyped pNParam = (CqParameterTyped)pParam;
                    pArg.SetValue((CqColor)pNParam.pValue_get(index, 0), indexA);
                    break;
                }
                case 11: {
                    CqParameterTyped pNParam = (CqParameterTyped)pParam;
                    pArg.SetValue((CqMatrix)pNParam.pValue_get(index, 0), indexA);
                    break;
                }
            }
        }
    }

    public CqSubdivision2 Extract(int iTime) {
        assert (this.pTopology() != null);
        assert (this.pTopology().pPoints() != null);
        assert (this.pFace() != null);
        HashMap<Integer, Integer> Vertices = new HashMap<Integer, Integer>();
        int cVerts = 0;
        Vector<Integer> FVertices = new Vector<Integer>();
        Vector<CqLath> aQff = new Vector<CqLath>();
        this.pFace().Qff(aQff);
        for (CqLath iF : aQff) {
            Vector<CqLath> aQfv = new Vector<CqLath>();
            iF.Qfv(aQfv);
            int idx = aQfv.size() - 1;
            while (idx >= 0) {
                CqLath iV = aQfv.get(idx);
                if (!Vertices.containsKey(iV.VertexIndex())) {
                    Vertices.put(iV.VertexIndex(), cVerts);
                    ++cVerts;
                }
                FVertices.add(iV.FaceVertexIndex());
                --idx;
            }
        }
        CqPolygonPoints pPointsClass = new CqPolygonPoints(cVerts, aQff.size(), FVertices.size());
        pPointsClass.SetSurfaceParameters(this.pTopology().pPoints(iTime));
        CqSubdivision2 pSurface = new CqSubdivision2(pPointsClass);
        pSurface.Prepare(cVerts);
        for (CqParameter iUP : this.pTopology().pPoints(iTime).aUserParams()) {
            if (iUP.Class().getValue() == 4 || iUP.Class().getValue() == 3) {
                CqParameter pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                pNewUP.SetSize(cVerts);
                for (Map.Entry i : Vertices.entrySet()) {
                    pNewUP.SetValue(iUP, (Integer)i.getValue(), (Integer)i.getKey());
                }
                pSurface.pPoints().AddPrimitiveVariable(pNewUP);
                continue;
            }
            if (iUP.Class().getValue() == 5) {
                CqParameter pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                pNewUP.SetSize(FVertices.size());
                int iv = 0;
                Iterator iterator = FVertices.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    pNewUP.SetValue(iUP, iv, i);
                    ++iv;
                }
                pSurface.pPoints().AddPrimitiveVariable(pNewUP);
                continue;
            }
            if (iUP.Class().getValue() == 2) {
                CqParameter pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                pNewUP.SetSize(pSurface.pPoints().cUniform());
                pNewUP.SetValue(iUP, 0, this.m_FaceIndex);
                pSurface.pPoints().AddPrimitiveVariable(pNewUP);
                continue;
            }
            if (iUP.Class().getValue() != 1) continue;
            CqParameter pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
            pNewUP.SetSize(1);
            pNewUP.SetValue(iUP, 0, 0);
            pSurface.pPoints().AddPrimitiveVariable(pNewUP);
        }
        int i = 0;
        while (i < cVerts) {
            pSurface.pPoints().P().pValue_get(i, 0).assignment(pSurface.pPoints().P().pValue_get(i, 0));
            ++i;
        }
        int iP = 0;
        for (CqLath iF : aQff) {
            Vector<Integer> vertices = new Vector<Integer>();
            Vector<CqLath> aQfv = new Vector<CqLath>();
            iF.Qfv(aQfv);
            int idx = aQfv.size() - 1;
            while (idx >= 0) {
                CqLath iV = aQfv.get(idx);
                vertices.add((Integer)Vertices.get(iV.VertexIndex()));
                --idx;
            }
            int[] verticesAry = new int[vertices.size()];
            int ii = 0;
            while (ii < verticesAry.length) {
                verticesAry[ii] = (Integer)vertices.get(ii);
                ++ii;
            }
            pSurface.AddFacet(vertices.size(), verticesAry, iP);
            iP += vertices.size();
        }
        pSurface.Finalise();
        return pSurface;
    }
}

