/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqPolygonPoints;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqSurfacePointsPolygon;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfacePointsPolygons
extends CqSurface {
    private int m_NumPolys;
    private CqPolygonPoints m_pPoints;
    private STLVector<p_int> m_PointCounts = new STLVector<p_int>(p_int.class);
    private STLVector<p_int> m_PointIndices = new STLVector<p_int>(p_int.class);
    static /* synthetic */ Class class$0;

    public CqSurfacePointsPolygons(CqPolygonPoints pPoints, int NumPolys, int[] nverts, int[] verts) {
        this.m_NumPolys = NumPolys;
        this.m_pPoints = pPoints;
        this.m_PointCounts.resize(NumPolys);
        int vindex = 0;
        int i = 0;
        while (i < NumPolys) {
            ((p_int)this.m_PointCounts.get((int)i)).value = nverts[i];
            int polyvertex = 0;
            while (polyvertex < nverts[i]) {
                this.m_PointIndices.add(new p_int(verts[vindex++]));
                ++polyvertex;
            }
            ++i;
        }
        CqStats.STATS_INC(8);
    }

    @Override
    public CqBound Bound() {
        CqBound B = new CqBound();
        if (this.m_pPoints != null && this.m_pPoints.P() != null) {
            int PointIndex = this.m_pPoints.P().Size() - 1;
            while (PointIndex >= 0) {
                B.Encapsulate(new CqVector3D(this.m_pPoints.P().pValue_get(0, PointIndex)));
                --PointIndex;
            }
        }
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqMicroPolyGridBase Dice() {
        return null;
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        int CreatedPolys = 0;
        int iP = 0;
        int poly = 0;
        while (poly < this.m_NumPolys) {
            CqSurfacePointsPolygon pSurface = new CqSurfacePointsPolygon(this.m_pPoints, poly, iP);
            boolean fValid = true;
            pSurface.aIndices().resize(((p_int)this.m_PointCounts.get((int)poly)).value);
            int i = 0;
            while ((long)i < (long)((p_int)this.m_PointCounts.get((int)poly)).value) {
                if ((long)((p_int)this.m_PointIndices.get((int)iP)).value >= (long)this.m_pPoints.P().Size()) {
                    fValid = false;
                    String objname = "unnamed";
                    String[] pattrName = pSurface.pAttributes().GetStringAttribute("identifier", "name");
                    if (pattrName != null) {
                        objname = pattrName[0];
                    }
                    this.logger.warning("Invalid PointsPolygon index in object \"" + objname + "\"" + "\n");
                    break;
                }
                ((p_int)pSurface.aIndices().get((int)i)).value = ((p_int)this.m_PointIndices.get((int)iP)).value;
                ++iP;
                ++i;
            }
            if (fValid) {
                aSplits.add(pSurface);
                ++CreatedPolys;
            }
            ++poly;
        }
        return CreatedPolys;
    }

    @Override
    public boolean Diceable() {
        return false;
    }

    @Override
    public final void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx) {
        this.Transform(matTx, matITTx, matRTx, 0);
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime) {
        assert (this.m_pPoints != null);
        this.m_pPoints.Transform(matTx, matITTx, matRTx, iTime);
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public int cUniform() {
        return this.m_NumPolys;
    }

    @Override
    public int cVarying() {
        assert (this.m_pPoints != null);
        return this.m_pPoints.cVarying();
    }

    @Override
    public int cVertex() {
        assert (this.m_pPoints != null);
        return this.m_pPoints.cVarying();
    }

    @Override
    public int cFaceVarying() {
        assert (this.m_pPoints != null);
        return this.m_pPoints.cFaceVarying();
    }
}

