/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqQuadric;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSphere
extends CqQuadric {
    private float m_Radius;
    private float m_PhiMin;
    private float m_PhiMax;
    private float m_ThetaMin;
    private float m_ThetaMax;
    static /* synthetic */ Class class$0;

    public CqSphere() {
        this(1.0f, -1.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqSphere(float radius) {
        this(radius, -1.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqSphere(float radius, float zmin) {
        this(radius, zmin, 1.0f, 0.0f, 360.0f);
    }

    public CqSphere(float radius, float zmin, float zmax) {
        this(radius, zmin, zmax, 0.0f, 360.0f);
    }

    public CqSphere(float radius, float zmin, float zmax, float thetamin) {
        this(radius, zmin, zmax, thetamin, 360.0f);
    }

    public CqSphere(float radius, float zmin, float zmax, float thetamin, float thetamax) {
        this.m_Radius = radius;
        this.m_ThetaMin = thetamin;
        this.m_ThetaMax = thetamax;
        float frad = StrictMath.abs(this.m_Radius);
        if (StrictMath.abs(zmin) > frad) {
            zmin = frad * (float)(zmin < 0.0f ? -1 : 1);
        }
        if (StrictMath.abs(zmin) > frad) {
            zmin = frad * (float)(zmin < 0.0f ? -1 : 1);
        }
        this.m_PhiMin = (float)StrictMath.asin(zmin / this.m_Radius);
        this.m_PhiMax = (float)StrictMath.asin(zmax / this.m_Radius);
    }

    public CqSphere(CqSphere From) {
        this.assginment(From);
    }

    @Override
    public void destruct() {
        super.destruct();
    }

    @Override
    public CqBound Bound() {
        STLVector<CqVector3D> curve = new STLVector<CqVector3D>(CqVector3D.class);
        CqVector3D vA = new CqVector3D(0.0f, 0.0f, 0.0f);
        CqVector3D vB = new CqVector3D(1.0f, 0.0f, 0.0f);
        CqVector3D vC = new CqVector3D(0.0f, 0.0f, 1.0f);
        this.Circle(vA, vB, vC, this.m_Radius, this.m_PhiMin, this.m_PhiMax, curve);
        CqMatrix matRot = new CqMatrix((float)StrictMath.toRadians(this.m_ThetaMin), vC);
        for (CqVector3D i : curve) {
            i.assignment(matRot.multiply(i));
        }
        CqBound B = new CqBound(this.RevolveForBound(curve, vA, vC, (float)StrictMath.toRadians(this.m_ThetaMax - this.m_ThetaMin)));
        B.Transform(this.m_matTx);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqVector3D DicePoint(int u, int v) {
        float phi = this.m_PhiMin + (float)v * (this.m_PhiMax - this.m_PhiMin) / (float)this.m_vDiceSize;
        float cosphi = (float)StrictMath.cos(phi);
        float theta = (float)StrictMath.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        return new CqVector3D((float)((double)this.m_Radius * StrictMath.cos(theta) * (double)cosphi), (float)((double)this.m_Radius * StrictMath.sin(theta) * (double)cosphi), (float)((double)this.m_Radius * StrictMath.sin(phi)));
    }

    @Override
    public CqVector3D DicePoint(int u, int v, CqVector3D Normal) {
        CqVector3D p = this.DicePoint(u, v);
        Normal.assignment(p);
        Normal.Unit();
        return p;
    }

    @Override
    public boolean CanGenerateNormals() {
        return true;
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        float phicent = (float)((double)(this.m_PhiMin + this.m_PhiMax) * 0.5);
        float arccent = (float)((double)(this.m_ThetaMin + this.m_ThetaMax) * 0.5);
        CqSphere pNew1 = new CqSphere(this);
        CqSphere pNew2 = new CqSphere(this);
        if (u) {
            pNew1.m_ThetaMax = arccent;
            pNew2.m_ThetaMin = arccent;
        } else {
            pNew1.m_PhiMax = phicent;
            pNew2.m_PhiMin = phicent;
        }
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        return 2;
    }

    public CqSphere assginment(CqSphere From) {
        super.assignment(From);
        this.m_Radius = From.m_Radius;
        this.m_PhiMin = From.m_PhiMin;
        this.m_PhiMax = From.m_PhiMax;
        this.m_ThetaMin = From.m_ThetaMin;
        this.m_ThetaMax = From.m_ThetaMax;
        return this;
    }
}

