/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqMicroPolyGrid;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.EqSplitDir;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.PublicFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class CqQuadric
extends CqSurface {
    public static float RI_PI = (float)Math.PI;
    public static int TOOLARGEQUADS = 10000;
    public static int ESTIMATEGRIDSIZE = 8;
    protected CqMatrix m_matTx = new CqMatrix();
    protected CqMatrix m_matITTx = new CqMatrix();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CqQuadric() {
        this.m_uDiceSize = 0;
        this.m_vDiceSize = 0;
        CqStats.STATS_INC(12);
    }

    @Override
    public void destruct() {
        super.destruct();
    }

    public CqBound MotionBound(CqBound B) {
        return null;
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx) {
        this.Transform(matTx, matITTx, matRTx, 0);
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime) {
        this.m_matTx = this.m_matTx.assignMul(matTx);
        this.m_matITTx.assignMul(matITTx);
    }

    @Override
    public int cUniform() {
        return 1;
    }

    @Override
    public int cVarying() {
        return 4;
    }

    @Override
    public int cVertex() {
        return 4;
    }

    @Override
    public int cFaceVarying() {
        return 1;
    }

    @Override
    public boolean Diceable() {
        if (!this.m_fDiceable) {
            return false;
        }
        int toomuch = (int)this.EstimateGridSize();
        this.m_SplitDir = this.m_uDiceSize > this.m_vDiceSize ? new EqSplitDir(0) : new EqSplitDir(1);
        float gs = 16.0f;
        float[] poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("System", "SqrtGridSize");
        if (poptGridSize != null) {
            gs = poptGridSize[0];
        }
        if (toomuch > TOOLARGEQUADS) {
            return false;
        }
        if ((float)this.m_uDiceSize > gs) {
            return false;
        }
        return !((float)this.m_vDiceSize > gs);
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    public long EstimateGridSize() {
        float maxvsize = 0.0f;
        float maxusize = 0.0f;
        CqMatrix matTx = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time()).multiply(this.m_matTx);
        this.m_uDiceSize = ESTIMATEGRIDSIZE;
        this.m_vDiceSize = ESTIMATEGRIDSIZE;
        CqVector3D p = new CqVector3D();
        CqVector3D pum1 = new CqVector3D();
        CqVector3D[] pvm1 = new CqVector3D[ESTIMATEGRIDSIZE];
        int i = 0;
        while (i < ESTIMATEGRIDSIZE) {
            pvm1[i] = new CqVector3D();
            ++i;
        }
        int v = 0;
        while (v <= ESTIMATEGRIDSIZE) {
            int u = 0;
            while (u <= ESTIMATEGRIDSIZE) {
                p = this.DicePoint(u, v);
                p.assignment(matTx.multiply(p));
                if (v >= 1 && u >= 1) {
                    float udist = (p.x - pum1.x) * (p.x - pum1.x) + (p.y - pum1.y) * (p.y - pum1.y);
                    float vdist = (pvm1[u - 1].x - pum1.x) * (pvm1[u - 1].x - pum1.x) + (pvm1[u - 1].y - pum1.y) * (pvm1[u - 1].y - pum1.y);
                    maxusize = StrictMath.max(maxusize, udist);
                    maxvsize = StrictMath.max(maxvsize, vdist);
                }
                if (u >= 1) {
                    pvm1[u - 1] = pum1;
                }
                pum1 = p;
                ++u;
            }
            ++v;
        }
        maxusize = (float)StrictMath.sqrt(maxusize);
        maxvsize = (float)StrictMath.sqrt(maxvsize);
        float ShadingRate = this.pAttributes().GetFloatAttribute("System", "ShadingRateSqrt")[0];
        if (ShadingRate > 0.0f) {
            this.m_uDiceSize = (int)StrictMath.ceil((float)ESTIMATEGRIDSIZE * maxusize / ShadingRate);
            this.m_vDiceSize = (int)StrictMath.ceil((float)ESTIMATEGRIDSIZE * maxvsize / ShadingRate);
        } else {
            this.m_uDiceSize = 1;
            this.m_vDiceSize = 1;
        }
        int[] binary = this.pAttributes().GetIntegerAttribute("dice", "binary");
        if (binary != null && binary[0] != 0) {
            this.m_uDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_uDiceSize);
            this.m_vDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_vDiceSize);
        }
        return (long)this.m_uDiceSize * (long)this.m_vDiceSize;
    }

    public void Circle(CqVector3D O, CqVector3D X, CqVector3D Y, float r, float as, float ae, STLVector<CqVector3D> points) {
        while (ae < as) {
            ae += 2.0f * RI_PI;
        }
        float theta = ae - as;
        int narcs = 4;
        float dtheta = theta / (float)narcs;
        int n = 2 * narcs + 1;
        CqVector3D PO = new CqVector3D();
        CqVector3D TO = new CqVector3D();
        CqVector3D P2 = new CqVector3D();
        CqVector3D T2 = new CqVector3D();
        CqVector3D P1 = new CqVector3D();
        PO.assignment(O.add(X.mul((float)((double)r * StrictMath.cos(as)))).add(Y.mul((float)((double)r * StrictMath.sin(as)))));
        TO.assignment(X.mul((float)(-StrictMath.sin(as))).add(Y.mul((float)StrictMath.cos(as))));
        points.resize(n);
        ((CqVector3D)points.get(0)).assignment(PO);
        int index = 0;
        float angle = as;
        int i = 1;
        while (i <= narcs) {
            P2.assignment(O.add(X.mul((float)((double)r * StrictMath.cos(angle += dtheta)))).add(Y.mul((float)((double)r * StrictMath.sin(angle)))));
            ((CqVector3D)points.get(index + 2)).assignment(P2);
            T2.assignment(X.mul((float)(-StrictMath.sin(angle))).add(Y.mul((float)StrictMath.cos(angle))));
            CqQuadric.IntersectLine(PO, TO, P2, T2, P1);
            ((CqVector3D)points.get(index + 1)).assignment(P1);
            index += 2;
            if (i < narcs) {
                PO.assignment(P2);
                TO.assignment(T2);
            }
            ++i;
        }
    }

    public CqBound RevolveForBound(STLVector<CqVector3D> profile, CqVector3D S, CqVector3D Tvec, float theta) {
        CqBound bound = new CqBound(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        if (StrictMath.abs(theta) > 2.0f * RI_PI) {
            theta = theta < 0.0f ? -(2.0f * RI_PI) : 2.0f * RI_PI;
        }
        int narcs = 4;
        float dtheta = theta / (float)narcs;
        STLVector<Float> cosines = new STLVector<Float>(Float.class, narcs + 1);
        STLVector<Float> sines = new STLVector<Float>(Float.class, narcs + 1);
        float angle = 0.0f;
        int i = 1;
        while (i <= narcs) {
            angle = dtheta * (float)i;
            cosines.set(i, Float.valueOf((float)StrictMath.cos(angle)));
            sines.set(i, Float.valueOf((float)StrictMath.sin(angle)));
            ++i;
        }
        CqVector3D P0 = new CqVector3D();
        CqVector3D T0 = new CqVector3D();
        CqVector3D P2 = new CqVector3D();
        CqVector3D T2 = new CqVector3D();
        CqVector3D P1 = new CqVector3D();
        int j = 0;
        while (j < profile.size()) {
            CqVector3D O = new CqVector3D();
            CqVector3D pj = new CqVector3D((CqVector3D)profile.get(j));
            CqQuadric.ProjectToLine(S, Tvec, pj, O);
            CqVector3D X = new CqVector3D();
            CqVector3D Y = new CqVector3D();
            X.assignment(pj.sub(O));
            float r = X.Magnitude();
            if ((double)r < 1.0E-7) {
                bound.Encapsulate(O);
            } else {
                X.Unit();
                Y.assignment(Tvec.mod(X));
                Y.Unit();
                P0.assignment((CqVector3D)profile.get(j));
                bound.Encapsulate(P0);
                T0.assignment(Y);
                i = 1;
                while (i <= narcs) {
                    angle = dtheta * (float)i;
                    P2.assignment(O.add(X.mul(r * ((Float)cosines.get(i)).floatValue())).add(Y.mul(r * ((Float)sines.get(i)).floatValue())));
                    bound.Encapsulate(P2);
                    T2.assignment(X.mul(-((Float)sines.get(i)).floatValue()).add(Y.mul(((Float)cosines.get(i)).floatValue())));
                    CqQuadric.IntersectLine(P0, T0, P2, T2, P1);
                    bound.Encapsulate(P1);
                    if (i < narcs) {
                        P0.assignment(P2);
                        T0.assignment(T2);
                    }
                    ++i;
                }
            }
            ++j;
        }
        return bound;
    }

    @Override
    public int DiceAll(CqMicroPolyGrid pGrid) {
        int lUses = this.Uses();
        int lDone = 0;
        CqVector3D P = new CqVector3D();
        CqVector3D N = new CqVector3D();
        CqParameterTyped<p_float, p_float> ps = this.s();
        CqParameterTyped<p_float, p_float> pt = this.t();
        CqParameterTyped<p_float, p_float> pu = this.u();
        CqParameterTyped<p_float, p_float> pv = this.v();
        CqParameterTyped pst = (CqParameterTyped)this.FindUserParam("st");
        p_float s0 = new p_float();
        p_float s1 = new p_float();
        p_float s2 = new p_float();
        p_float s3 = new p_float();
        if (RiGlobal.USES(lUses, 14) && pGrid.pVar(14) != null && this.bHasVar(14)) {
            if (pst != null) {
                s0.value = ((p_float)pst.pValue_get((int)0, (int)0)).value;
                s1.value = ((p_float)pst.pValue_get((int)1, (int)0)).value;
                s2.value = ((p_float)pst.pValue_get((int)2, (int)0)).value;
                s3.value = ((p_float)pst.pValue_get((int)3, (int)0)).value;
            } else if (ps != null) {
                s0.value = ps.pValue_get((int)0, (int)0).value;
                s1.value = ps.pValue_get((int)1, (int)0).value;
                s2.value = ps.pValue_get((int)2, (int)0).value;
                s3.value = ps.pValue_get((int)3, (int)0).value;
            }
            lDone |= 0x4000;
        }
        p_float t0 = new p_float();
        p_float t1 = new p_float();
        p_float t2 = new p_float();
        p_float t3 = new p_float();
        if (RiGlobal.USES(lUses, 15) && pGrid.pVar(15) != null && this.bHasVar(15)) {
            if (pst != null) {
                t0.value = ((p_float)pst.pValue_get((int)0, (int)1)).value;
                t1.value = ((p_float)pst.pValue_get((int)1, (int)1)).value;
                t2.value = ((p_float)pst.pValue_get((int)2, (int)1)).value;
                t3.value = ((p_float)pst.pValue_get((int)3, (int)1)).value;
            } else if (pt != null) {
                t0.value = pt.pValue_get((int)0, (int)0).value;
                t1.value = pt.pValue_get((int)1, (int)0).value;
                t2.value = pt.pValue_get((int)2, (int)0).value;
                t3.value = pt.pValue_get((int)3, (int)0).value;
            }
            lDone |= 0x8000;
        }
        p_float u0 = new p_float();
        p_float u1 = new p_float();
        p_float u2 = new p_float();
        p_float u3 = new p_float();
        if (RiGlobal.USES(lUses, 12) && pGrid.pVar(12) != null && this.bHasVar(12)) {
            u0.value = pu.pValue_get((int)0, (int)0).value;
            u1.value = pu.pValue_get((int)1, (int)0).value;
            u2.value = pu.pValue_get((int)2, (int)0).value;
            u3.value = pu.pValue_get((int)3, (int)0).value;
            lDone |= 0x1000;
        }
        p_float v0 = new p_float();
        p_float v1 = new p_float();
        p_float v2 = new p_float();
        p_float v3 = new p_float();
        if (RiGlobal.USES(lUses, 13) && pGrid.pVar(13) != null && this.bHasVar(13)) {
            v0.value = pv.pValue_get((int)0, (int)0).value;
            v1.value = pv.pValue_get((int)1, (int)0).value;
            v2.value = pv.pValue_get((int)2, (int)0).value;
            v3.value = pv.pValue_get((int)3, (int)0).value;
            lDone |= 0x2000;
        }
        float du = (float)(1.0 / (double)this.uDiceSize());
        float dv = (float)(1.0 / (double)this.vDiceSize());
        int v = 0;
        while (v <= this.vDiceSize()) {
            float vf = (float)v * dv;
            int u = 0;
            while (u <= this.uDiceSize()) {
                float uf = (float)u * du;
                int igrid = v * (this.uDiceSize() + 1) + u;
                if (RiGlobal.USES(lUses, 8) && pGrid.pVar(8) != null) {
                    if (RiGlobal.USES(lUses, 2) && pGrid.pVar(2) != null) {
                        P = this.DicePoint(u, v, N);
                        pGrid.pVar(8).SetPoint(this.m_matTx.multiply(P), igrid);
                        pGrid.pVar(2).SetNormal(this.m_matITTx.multiply(N), igrid);
                    } else {
                        P = this.DicePoint(u, v);
                        pGrid.pVar(8).SetPoint(this.m_matTx.multiply(P), igrid);
                    }
                }
                if (RiGlobal.USES(lUses, 14) && pGrid.pVar(14) != null && this.bHasVar(14)) {
                    p_float _s = RiGlobal.BilinearEvaluate(s0, s1, s2, s3, uf, vf, p_float.class);
                    pGrid.pVar(14).SetFloat(_s.value, igrid);
                }
                if (RiGlobal.USES(lUses, 15) && pGrid.pVar(15) != null && this.bHasVar(15)) {
                    p_float _t = RiGlobal.BilinearEvaluate(t0, t1, t2, t3, uf, vf, p_float.class);
                    pGrid.pVar(15).SetFloat(_t.value, igrid);
                }
                if (RiGlobal.USES(lUses, 12) && pGrid.pVar(12) != null && this.bHasVar(12)) {
                    p_float _u = RiGlobal.BilinearEvaluate(u0, u1, u2, u3, uf, vf, p_float.class);
                    pGrid.pVar(12).SetFloat(_u.value, igrid);
                }
                if (RiGlobal.USES(lUses, 13) && pGrid.pVar(13) != null && this.bHasVar(13)) {
                    p_float _v = RiGlobal.BilinearEvaluate(v0, v1, v2, v3, uf, vf, p_float.class);
                    pGrid.pVar(13).SetFloat(_v.value, igrid);
                }
                ++u;
            }
            ++v;
        }
        return lDone;
    }

    public abstract CqVector3D DicePoint(int var1, int var2);

    public abstract CqVector3D DicePoint(int var1, int var2, CqVector3D var3);

    public CqQuadric assignment(CqQuadric From) {
        super.assignment(From);
        this.m_matTx.assignment(From.m_matTx);
        this.m_matITTx.assignment(From.m_matITTx);
        this.m_uDiceSize = From.m_uDiceSize;
        this.m_vDiceSize = From.m_vDiceSize;
        return this;
    }

    @Override
    public void NaturalDice(CqParameter pParameter, int uDiceSize, int vDiceSize, IqShaderData pData) {
        int hash = pData.strName().hashCode();
        if ((long)hash == RIH_P) {
            CqVector3D P = new CqVector3D();
            int v = 0;
            while (v <= vDiceSize) {
                int u = 0;
                while (u <= uDiceSize) {
                    int igrid = v * (uDiceSize + 1) + u;
                    P.assignment(this.DicePoint(u, v));
                    pData.SetPoint(this.m_matTx.multiply(P), igrid);
                    ++u;
                }
                ++v;
            }
        } else {
            this.NaturalDice(pParameter, uDiceSize, vDiceSize, pData);
        }
    }

    @Override
    public void GenerateGeometricNormals(int uDiceSize, int vDiceSize, IqShaderData pNormals) {
        CqVector3D N = new CqVector3D();
        int v = 0;
        while (v <= vDiceSize) {
            int u = 0;
            while (u <= uDiceSize) {
                int igrid = v * (uDiceSize + 1) + u;
                this.DicePoint(u, v, N);
                boolean CSO = this.pTransform().GetHandedness(this.pTransform().Time(0));
                boolean O = this.pAttributes().GetIntegerAttribute("System", "Orientation")[0] != 0;
                N.assignment(O == CSO ? N : N.negative());
                pNormals.SetNormal(this.m_matITTx.multiply(N), igrid);
                ++u;
            }
            ++v;
        }
    }

    static boolean IntersectLine(CqVector3D P1, CqVector3D T1, CqVector3D P2, CqVector3D T2, CqVector3D P) {
        CqVector3D v = new CqVector3D();
        CqVector3D px = new CqVector3D();
        px.assignment(T1.mod(P1.sub(T2)));
        v.assignment(px.mod(T1));
        float t = P1.sub(P2).mul(v);
        float vw = v.mul(T2);
        if ((double)(vw * vw) < 1.0E-7) {
            return false;
        }
        t /= vw;
        P.assignment(P2.add(T2.mul(P1.sub(P2).mul(v) / vw)));
        return true;
    }

    static void ProjectToLine(CqVector3D S, CqVector3D Trj, CqVector3D pnt, CqVector3D p) {
        CqVector3D a = pnt.sub(S);
        float denom = Trj.Magnitude2();
        float fraction = denom == 0.0f ? 0.0f : Trj.mul(a) / denom;
        p.assignment(Trj.mul(fraction));
        p.assignAdd(S);
    }
}

