/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqPolygonGeneral2D {
    private STLArray<p_int> m_aiVertices = new STLArray<p_int>(p_int.class);
    private int m_Orientation;
    private int m_Axis;
    private CqSurface m_pVertices;
    private boolean m_Reverse;
    public static final int Axis_Unknown = 0;
    public static final int Axis_XY = 1;
    public static final int Axis_XZ = 2;
    public static final int Axis_YZ = 3;
    public static final int Orientation_Unknown = 0;
    public static final int Orientation_Clockwise = 1;
    public static final int Orientation_AntiClockwise = 2;
    static /* synthetic */ Class class$0;

    public CqPolygonGeneral2D() {
        this.m_Orientation = 0;
        this.m_Reverse = false;
        CqStats.STATS_INC(8);
    }

    public CqPolygonGeneral2D(CqPolygonGeneral2D From) {
        this.assignment(From);
    }

    public STLArray<p_int> aiVertices() {
        return this.m_aiVertices;
    }

    public int cVertices() {
        return this.m_aiVertices.size();
    }

    public int Orientation() {
        return this.m_Orientation;
    }

    public int Axis() {
        return this.m_Axis;
    }

    public void SetAxis(int axis) {
        this.m_Axis = axis;
    }

    public void SetpVertices(CqSurface pVertices) {
        this.m_pVertices = pVertices;
    }

    public void SwapDirection() {
        int vertices2 = this.cVertices() / 2;
        int vertices1 = this.cVertices() - 1;
        int iVertex = 0;
        while (iVertex < vertices2) {
            int which = vertices1 - iVertex;
            int tmp = this.m_aiVertices.get((int)iVertex).value;
            this.m_aiVertices.get((int)iVertex).value = this.m_aiVertices.get((int)which).value;
            this.m_aiVertices.get((int)which).value = tmp;
            ++iVertex;
        }
        this.CalcOrientation();
        this.m_Reverse = !this.m_Reverse;
    }

    public int CalcOrientation() {
        int vertices1 = this.cVertices() - 1;
        CqVector2D tmp1 = this.valueAt(vertices1);
        CqVector2D tmp2 = this.valueAt(0);
        float Area = tmp1.x * tmp2.y - tmp2.x * tmp1.y;
        int iVertex = 0;
        while (iVertex < vertices1) {
            tmp1 = this.valueAt(iVertex);
            tmp2 = this.valueAt(iVertex + 1);
            Area += tmp1.x * tmp2.y - tmp2.x * tmp1.y;
            ++iVertex;
        }
        this.m_Orientation = (double)Area >= 0.0 ? 2 : 1;
        return this.m_Orientation;
    }

    public int CalcDeterminant(int i1, int i2, int i3) {
        assert (i1 >= 0 && i1 <= this.cVertices());
        assert (i2 >= 0 && i2 <= this.cVertices());
        assert (i3 >= 0 && i3 <= this.cVertices());
        CqVector2D tmp1 = this.valueAt(i1);
        CqVector2D tmp2 = this.valueAt(i2);
        CqVector2D tmp3 = this.valueAt(i3);
        float Determ = (tmp2.x - tmp1.x) * (tmp3.y - tmp1.y) - (tmp3.x - tmp1.x) * (tmp2.y - tmp1.y);
        if ((double)Determ > 0.0) {
            return 2;
        }
        if ((double)Determ == 0.0) {
            return 0;
        }
        return 1;
    }

    public boolean NoneInside(int i1, int i2, int i3, STLArray<p_int> iList) {
        int size = iList.size();
        int iVertex = 0;
        while (iVertex < size) {
            int iN = iList.get((int)iVertex).value;
            if (iN != i1 && iN != i2 && iN != i3) {
                CqVector2D tmp;
                int __t1 = this.CalcDeterminant(i2, i1, iN);
                int __t2 = this.CalcDeterminant(i1, i3, iN);
                int __t3 = this.CalcDeterminant(i3, i2, iN);
                if (!(__t1 == this.m_Orientation || __t2 == this.m_Orientation || __t3 == this.m_Orientation || (tmp = this.valueAt(iN)).equals(this.valueAt(i1)) || tmp.equals(this.valueAt(i2)) || tmp.equals(this.valueAt(i3)))) {
                    return false;
                }
            }
            ++iVertex;
        }
        return true;
    }

    public void EliminateDuplicatePoints() {
    }

    public boolean Contains(CqPolygonGeneral2D polyCheck) {
        assert (polyCheck.cVertices() > 0 && this.cVertices() > 0);
        int vertices = polyCheck.cVertices();
        int iVertex = 0;
        while (iVertex < vertices) {
            boolean c = false;
            float x = polyCheck.valueAt((int)iVertex).x;
            float y = polyCheck.valueAt((int)iVertex).y;
            int i = 0;
            int j = vertices - 1;
            while (i < vertices) {
                if ((this.valueAt((int)i).y <= y && y < this.valueAt((int)j).y || this.valueAt((int)j).y <= y && y < this.valueAt((int)i).y) && x < (this.valueAt((int)j).x - this.valueAt((int)i).x) * (y - this.valueAt((int)i).y) / (this.valueAt((int)j).y - this.valueAt((int)i).y) + this.valueAt((int)i).x) {
                    c = !c;
                }
                j = i++;
            }
            if (!c) {
                return false;
            }
            ++iVertex;
        }
        return true;
    }

    public void Combine(CqPolygonGeneral2D polyFrom) {
        int iMinThis = 0;
        int iMinThat = 0;
        float MinDist = Float.MAX_VALUE;
        int vertices = this.cVertices();
        int polyvertices = polyFrom.cVertices();
        int i = 0;
        while (i < vertices) {
            int j = 0;
            while (j < polyvertices) {
                CqVector2D vecTemp = new CqVector2D(this.valueAt(i).sub(polyFrom.valueAt(j)));
                float CurrDist = (float)Math.sqrt(vecTemp.mul(vecTemp));
                if (CurrDist == MinDist) {
                    CqVector2D currToPrev = i > 0 ? this.valueAt(i - 1).sub(this.valueAt(i)) : this.valueAt(this.cVertices() - 1).sub(this.valueAt(i));
                    CqVector2D currToNext = i < this.cVertices() - 1 ? this.valueAt(i + 1).sub(this.valueAt(i)) : this.valueAt(0).sub(this.valueAt(i));
                    CqVector2D minToPrev = iMinThis > 0 ? this.valueAt(iMinThis - 1).sub(this.valueAt(iMinThis)) : this.valueAt(this.cVertices() - 1).sub(this.valueAt(iMinThis));
                    CqVector2D minToNext = iMinThis < this.cVertices() - 1 ? this.valueAt(iMinThis + 1).sub(this.valueAt(iMinThis)) : this.valueAt(0).sub(this.valueAt(iMinThis));
                    CqVector2D vecTest = polyFrom.valueAt(j).sub(this.valueAt(i));
                    currToPrev.Unit();
                    currToNext.Unit();
                    minToPrev.Unit();
                    minToNext.Unit();
                    vecTemp = currToPrev.sub(vecTest);
                    float distCP = (float)Math.sqrt(vecTemp.mul(vecTemp));
                    vecTemp = currToNext.sub(vecTest);
                    float distCN = (float)Math.sqrt(vecTemp.mul(vecTemp));
                    vecTemp = minToPrev.sub(vecTest);
                    float distMP = (float)Math.sqrt(vecTemp.mul(vecTemp));
                    vecTemp = minToNext.sub(vecTest);
                    float distMN = (float)Math.sqrt(vecTemp.mul(vecTemp));
                    if (distCP + distCN < distMP + distMN) {
                        MinDist = CurrDist;
                        iMinThis = i;
                        iMinThat = j;
                    }
                } else if (CurrDist < MinDist) {
                    MinDist = CurrDist;
                    iMinThis = i;
                    iMinThat = j;
                }
                ++j;
            }
            ++i;
        }
        STLVector<p_int> avecNew = new STLVector<p_int>(p_int.class);
        i = iMinThis;
        while (i < vertices) {
            avecNew.add(new p_int(this.m_aiVertices.get(i)));
            ++i;
        }
        i = 0;
        while (i <= iMinThis) {
            avecNew.add(new p_int(this.m_aiVertices.get(i)));
            ++i;
        }
        i = iMinThat;
        while (i < polyvertices) {
            avecNew.add(new p_int(polyFrom.m_aiVertices.get(i)));
            ++i;
        }
        i = 0;
        while (i <= iMinThat) {
            avecNew.add(new p_int(polyFrom.m_aiVertices.get(i)));
            ++i;
        }
        int size = avecNew.size();
        this.m_aiVertices.resize(size);
        int ivert = 0;
        while (ivert < size) {
            this.m_aiVertices.get((int)ivert).value = ((p_int)avecNew.get((int)ivert)).value;
            ++ivert;
        }
    }

    public void Triangulate(STLVector<p_int> aiList) {
        STLArray<p_int> iList = new STLArray<p_int>(p_int.class);
        int size = this.m_aiVertices.size();
        iList.resize(size);
        int iVertex = size;
        while (iVertex-- > 0) {
            iList.get((int)iVertex).value = iVertex;
        }
        int cVertex = size;
        while (cVertex > 3) {
            boolean fDone = false;
            int iPrev = cVertex - 1;
            int iCurr = 0;
            int iNext = 1;
            while (iCurr < cVertex && !fDone) {
                iPrev = iCurr - 1;
                iNext = iCurr + 1;
                if (iCurr == 0) {
                    iPrev = cVertex - 1;
                } else if (iCurr == cVertex - 1) {
                    iNext = 0;
                }
                int CurrDeterm = this.CalcDeterminant(iList.get((int)iPrev).value, iList.get((int)iCurr).value, iList.get((int)iNext).value);
                boolean CurrPos = this.NoneInside(iList.get((int)iPrev).value, iList.get((int)iCurr).value, iList.get((int)iNext).value, iList);
                if (CurrDeterm == this.Orientation() && CurrPos) {
                    fDone = true;
                    continue;
                }
                ++iCurr;
            }
            if (!fDone) {
                return;
            }
            if (this.m_Reverse) {
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)iNext).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)iCurr).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)iPrev).value)));
            } else {
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)iPrev).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)iCurr).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)iNext).value)));
            }
            --cVertex;
            iVertex = iCurr;
            while (iVertex < cVertex) {
                iList.get((int)iVertex).value = iList.get((int)(iVertex + 1)).value;
                ++iVertex;
            }
            iList.resize(cVertex);
        }
        if (cVertex == 3) {
            if (this.m_Reverse) {
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)2).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)1).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)0).value)));
            } else {
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)0).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)1).value)));
                aiList.add(new p_int(this.m_aiVertices.get(iList.get((int)2).value)));
            }
        }
    }

    public CqVector2D valueAt(int index) {
        switch (this.m_Axis) {
            case 1: {
                CqVector4D tmp = this.m_pVertices.P().pValue_get(this.m_aiVertices.get((int)index).value, 0);
                return new CqVector2D(tmp.x, tmp.y);
            }
            case 2: {
                CqVector4D tmp = this.m_pVertices.P().pValue_get(this.m_aiVertices.get((int)index).value, 0);
                return new CqVector2D(tmp.x, tmp.z);
            }
            case 3: {
                CqVector4D tmp = this.m_pVertices.P().pValue_get(this.m_aiVertices.get((int)index).value, 0);
                return new CqVector2D(tmp.y, tmp.z);
            }
        }
        return new CqVector2D(0.0f, 0.0f);
    }

    public CqPolygonGeneral2D assignment(CqPolygonGeneral2D From) {
        int iVertex = From.cVertices();
        this.m_aiVertices.resize(iVertex);
        while (iVertex-- > 0) {
            this.m_aiVertices.get((int)iVertex).value = From.m_aiVertices.get((int)iVertex).value;
        }
        this.m_Orientation = From.m_Orientation;
        this.m_Axis = From.m_Axis;
        this.m_Reverse = From.m_Reverse;
        this.m_pVertices = From.m_pVertices;
        return this;
    }
}

