/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqKDTree;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqMicroPolyGridPoints;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqParameterTypedConstant;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.CqPointsKDTreeData;
import net.cellcomputing.himawari.library.CqPolygonPoints;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqSurfaceMotionImple;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqPoints
extends CqSurfaceMotionImple {
    private int m_nVertices;
    private CqPointsKDTreeData m_KDTreeData;
    private CqKDTree<Integer> m_KDTree;
    private int m_widthParamIndex;
    private int m_constantwidthParamIndex;
    private float m_MaxWidth;
    static /* synthetic */ Class class$0;

    public CqPoints(int nvertices, CqPolygonPoints pPoints) {
        this.CqMotionSpec(pPoints);
        this.m_nVertices = nvertices;
        this.m_KDTreeData = new CqPointsKDTreeData(this);
        this.m_KDTree = new CqKDTree<Integer>(this.m_KDTreeData, Integer.class);
        this.m_MaxWidth = 0.0f;
        assert (nvertices > 0);
        this.m_widthParamIndex = -1;
        this.m_constantwidthParamIndex = -1;
        if (pPoints != null) {
            this.AddTimeSlot(0.0f, pPoints);
        }
        int index = 0;
        for (CqParameter iUP : pPoints.aUserParams()) {
            if (iUP.strName().compareTo("constantwidth") == 0 && iUP.Type().getValue() == 1 && iUP.Class().getValue() == 1) {
                this.m_constantwidthParamIndex = index;
            } else if (iUP.strName().compareTo("width") == 0 && iUP.Type().getValue() == 1 && iUP.Class().getValue() == 3) {
                this.m_widthParamIndex = index;
            }
            ++index;
        }
        CqStats.STATS_INC(11);
    }

    @Override
    public int cUniform() {
        return 1;
    }

    @Override
    public int cVarying() {
        return this.m_nVertices;
    }

    @Override
    public int cVertex() {
        return this.m_nVertices;
    }

    @Override
    public int cFaceVarying() {
        return this.m_nVertices;
    }

    @Override
    public CqMicroPolyGridBase Dice() {
        assert (this.pPoints() != null);
        CqMicroPolyGridPoints pGrid = new CqMicroPolyGridPoints(this.nVertices(), 1, this);
        int lUses = this.Uses();
        if (RiGlobal.USES(lUses, 0) && pGrid.pVar(0) != null) {
            if (this.pPoints().bHasVar(0)) {
                this.NaturalDice(this.pPoints().Cs(), this.nVertices(), 1, pGrid.pVar(0));
            } else if (this.pAttributes().GetColorAttribute("System", "Color") != null) {
                pGrid.pVar(0).SetColor(this.pAttributes().GetColorAttribute("System", "Color")[0]);
            } else {
                pGrid.pVar(0).SetColor(new CqColor(1.0f, 1.0f, 1.0f));
            }
        }
        if (RiGlobal.USES(lUses, 1) && pGrid.pVar(1) != null) {
            if (this.pPoints().bHasVar(1)) {
                this.NaturalDice(this.pPoints().Os(), this.nVertices(), 1, pGrid.pVar(1));
            } else if (this.pAttributes().GetColorAttribute("System", "Opacity") != null) {
                pGrid.pVar(1).SetColor(this.pAttributes().GetColorAttribute("System", "Opacity")[0]);
            } else {
                pGrid.pVar(1).SetColor(new CqColor(1.0f, 1.0f, 1.0f));
            }
        }
        if (RiGlobal.USES(lUses, 14) && pGrid.pVar(14) != null && this.pPoints().bHasVar(14)) {
            this.NaturalDice(this.pPoints().s(), this.nVertices(), 1, pGrid.pVar(14));
        }
        if (RiGlobal.USES(lUses, 15) && pGrid.pVar(15) != null && this.pPoints().bHasVar(15)) {
            this.NaturalDice(this.pPoints().t(), this.nVertices(), 1, pGrid.pVar(15));
        }
        if (RiGlobal.USES(lUses, 12) && pGrid.pVar(12) != null && this.pPoints().bHasVar(12)) {
            this.NaturalDice(this.pPoints().u(), this.nVertices(), 1, pGrid.pVar(12));
        }
        if (RiGlobal.USES(lUses, 13) && pGrid.pVar(13) != null && this.pPoints().bHasVar(13)) {
            this.NaturalDice(this.pPoints().v(), this.nVertices(), 1, pGrid.pVar(13));
        }
        if (pGrid.pVar(8) != null) {
            this.NaturalDice(this.pPoints(0).P(), this.nVertices(), 1, pGrid.pVar(8));
        }
        if (RiGlobal.USES(lUses, 11) && pGrid.pVar(11) != null && this.pPoints().bHasVar(11)) {
            this.NaturalDice(this.pPoints().N(), this.nVertices(), 1, pGrid.pVar(11));
            pGrid.SetbShadingNormals(true);
        }
        if (RiGlobal.USES(lUses, 2)) {
            CqVector3D N = new CqVector3D(0.0f, 0.0f, 1.0f);
            int u = 0;
            while (u <= this.nVertices()) {
                boolean CSO = this.pTransform().GetHandedness(this.pTransform().Time(0));
                boolean O = this.pAttributes().GetIntegerAttribute("System", "Orientation")[0] != 0;
                N = O == CSO ? N : N.negative();
                pGrid.pVar(2).SetNormal(N, u);
                ++u;
            }
            pGrid.SetbGeometricNormals(true);
        }
        for (CqParameter iUP : this.pPoints().aUserParams()) {
            IqShader pShader = pGrid.pAttributes().pshadSurface(RiGlobal.QGetRenderContext().Time());
            if (pShader != null) {
                pShader.SetArgument(iUP, this);
            }
            if ((pShader = pGrid.pAttributes().pshadDisplacement(RiGlobal.QGetRenderContext().Time())) != null) {
                pShader.SetArgument(iUP, this);
            }
            if ((pShader = pGrid.pAttributes().pshadAtmosphere(RiGlobal.QGetRenderContext().Time())) == null) continue;
            pShader.SetArgument(iUP, this);
        }
        return pGrid;
    }

    @Override
    public boolean Diceable() {
        int gridsize = 256;
        int[] poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "gridsize");
        if (poptGridSize != null) {
            gridsize = poptGridSize[0];
        }
        return this.nVertices() <= gridsize;
    }

    @Override
    public void RenderComplete() {
        this.ClearKDTree();
        super.RenderComplete();
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public CqBound Bound() {
        CqBound B = new CqBound();
        int t = 0;
        while (t < this.iTimes()) {
            CqPolygonPoints pTimePoints = this.pPoints(t);
            int i = 0;
            while (i < this.nVertices()) {
                B.Encapsulate(new CqVector3D(pTimePoints.P().pValue_get((Integer)this.m_KDTree.aLeaves().get(i), 0)));
                ++i;
            }
            ++t;
        }
        B.vecMax().assignAdd(new CqVector3D(this.m_MaxWidth, this.m_MaxWidth, this.m_MaxWidth));
        B.vecMin().assignSub(new CqVector3D(this.m_MaxWidth, this.m_MaxWidth, this.m_MaxWidth));
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        int median = this.nVertices() / 2;
        CqPoints pA = new CqPoints(this);
        CqPoints pB = new CqPoints(this);
        pA.m_nVertices = median;
        pB.m_nVertices = this.nVertices() - median;
        pA.SetSurfaceParameters(this);
        pB.SetSurfaceParameters(this);
        this.KDTree().Subdivide(pA.KDTree(), pB.KDTree());
        aSplits.add(pA);
        aSplits.add(pB);
        return 2;
    }

    public int nVertices() {
        return this.m_nVertices;
    }

    public CqPolygonPoints pPoints(int TimeIndex) {
        return this.GetMotionObject(this.Time(TimeIndex));
    }

    public final CqPolygonPoints pPoints() {
        return this.GetMotionObject(this.Time(0));
    }

    @Override
    public STLVector<CqParameter> aUserParams() {
        return this.pPoints().aUserParams();
    }

    public int CopySplit(STLVector<CqBasicSurface> aSplits, CqPoints pFrom1, CqPoints pFrom2) {
        CqPoints pA = new CqPoints(this);
        CqPoints pB = new CqPoints(this);
        pA.m_nVertices = pFrom1.m_nVertices;
        pB.m_nVertices = pFrom2.m_nVertices;
        pA.SetSurfaceParameters(this);
        pB.SetSurfaceParameters(this);
        pA.KDTree().assignment(pFrom1.KDTree());
        pB.KDTree().assignment(pFrom2.KDTree());
        aSplits.add(pA);
        aSplits.add(pB);
        return 2;
    }

    public CqParameterTypedConstant<p_float, p_float> constantwidth() {
        if (this.m_constantwidthParamIndex >= 0) {
            return (CqParameterTypedConstant)this.aUserParams().get(this.m_constantwidthParamIndex);
        }
        return null;
    }

    public CqParameterTypedVarying<p_float, p_float> width(int iTime) {
        if (this.m_widthParamIndex >= 0) {
            return (CqParameterTypedVarying)this.pPoints(iTime).aUserParams().get(this.m_widthParamIndex);
        }
        return null;
    }

    public CqKDTree<Integer> KDTree() {
        return this.m_KDTree;
    }

    public void ClearKDTree() {
        this.m_KDTreeData.FreePoints();
    }

    public void InitialiseKDTree() {
        this.m_KDTree.aLeaves().ensureCapacity(this.nVertices());
        int i = 0;
        while (i < this.nVertices()) {
            this.m_KDTree.aLeaves().add(i);
            ++i;
        }
    }

    public void InitialiseMaxWidth() {
        int cu = this.nVertices();
        CqMatrix matObjectToCamera = RiGlobal.QGetRenderContext().matSpaceToSpace("object", "camera", new CqMatrix(), this.pTransform().matObjectToWorld(this.pTransform().Time(0)), RiGlobal.QGetRenderContext().Time());
        CqParameterTypedConstant<p_float, p_float> pConstantWidthParam = this.constantwidth();
        CqVector3D Point0 = matObjectToCamera.multiply(new CqVector3D(0.0f, 0.0f, 0.0f));
        float i_radius = 1.0f;
        if (pConstantWidthParam != null) {
            i_radius = pConstantWidthParam.pValue_get((int)0, (int)0).value;
        }
        int iu = 0;
        while (iu < cu) {
            CqParameterTypedVarying<p_float, p_float> pWidthParam = this.width(0);
            if (pWidthParam != null) {
                i_radius = pWidthParam.pValue_get((int)((Integer)this.KDTree().aLeaves().get((int)iu)).intValue(), (int)0).value;
            }
            float radius = i_radius;
            CqVector3D Point1 = matObjectToCamera.multiply(new CqVector3D(radius, 0.0f, 0.0f));
            radius = Point1.sub(Point0).Magnitude();
            this.m_MaxWidth = Math.max(this.m_MaxWidth, radius);
            ++iu;
        }
    }

    @Override
    public void NaturalDice(CqParameter pParameter, int uDiceSize, int vDiceSize, IqShaderData pData) {
        switch (pParameter.Type().getValue()) {
            case 1: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(pTParam, pData);
                break;
            }
            case 2: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(pTParam, pData);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(pTParam, pData);
                break;
            }
            case 7: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(pTParam, pData);
                break;
            }
            case 5: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(pTParam, pData);
                break;
            }
            case 4: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(pTParam, pData);
                break;
            }
            case 11: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(pTParam, pData);
                break;
            }
        }
    }

    @Override
    public void ClearMotionObject(CqPolygonPoints A) {
    }

    @Override
    public CqPolygonPoints ConcatMotionObjects(CqPolygonPoints A, CqPolygonPoints B) {
        return A;
    }

    @Override
    public CqPolygonPoints LinearInterpolateMotionObjects(float Fraction, CqPolygonPoints A, CqPolygonPoints B) {
        return A;
    }

    protected <T, SLT> void TypedNaturalDice(CqParameterTyped<T, SLT> pParam, IqShaderData pData) {
        int i = 0;
        while (i < this.nVertices()) {
            pData.SetValue(pParam.pValue_get(0, (Integer)this.m_KDTree.aLeaves().get(i)), i, pParam.TClass);
            ++i;
        }
    }

    private CqPoints(CqPoints From) {
        this.CqMotionSpec(From.pPoints());
        this.m_KDTreeData = new CqPointsKDTreeData(this);
        this.m_KDTree = new CqKDTree<Integer>(this.m_KDTreeData, Integer.class);
        this.assignment(From);
    }

    private CqPoints assignment(CqPoints From) {
        this.assignment((CqSurface)From);
        this.m_nVertices = From.m_nVertices;
        this.m_KDTreeData.SetpPoints(this);
        int i = 0;
        while (i < From.iTimes()) {
            CqPolygonPoints pTimePoints = From.GetMotionObject(From.Time(i));
            this.AddTimeSlot(From.Time(i), pTimePoints);
            ++i;
        }
        this.m_widthParamIndex = From.m_widthParamIndex;
        this.m_constantwidthParamIndex = From.m_constantwidthParamIndex;
        this.m_MaxWidth = From.m_MaxWidth;
        return this;
    }
}

