/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.exception.XqException;
import net.cellcomputing.himawari.library.EqVariableClass;
import net.cellcomputing.himawari.library.EqVariableType;

public strictfp class CqInlineParse {
    public static long huniform = "uniform".hashCode();
    public static long hconstant = "constant".hashCode();
    public static long hvarying = "varying".hashCode();
    public static long hvertex = "vertex".hashCode();
    public static long hfacevarying = "facevarying".hashCode();
    public static long hfloat = "float".hashCode();
    public static long hpoint = "point".hashCode();
    public static long hhpoint = "hpoint".hashCode();
    public static long hvector = "vector".hashCode();
    public static long hnormal = "normal".hashCode();
    public static long hcolor = "color".hashCode();
    public static long hstring = "string".hashCode();
    public static long hmatrix = "matrix".hashCode();
    public static long hinteger = "integer".hashCode();
    public static long hint = "int".hashCode();
    public static long hleft = "[".hashCode();
    public static long hright = "]".hashCode();
    private int number_of_words;
    private String[] word = new String[7];
    private boolean inline_def;
    private EqVariableClass tc = new EqVariableClass(0);
    private EqVariableType tt = new EqVariableType(0);
    private int size;
    private String identifier = new String();

    private boolean is_class(String str) {
        long param = str.hashCode();
        return param == hconstant || param == huniform || param == hvarying || param == hvertex || param == hfacevarying;
    }

    private boolean is_type(String str) {
        long param = str.hashCode();
        return param == hfloat || param == hpoint || param == hvector || param == hnormal || param == hcolor || param == hstring || param == hmatrix || param == hhpoint || param == hinteger || param == hint;
    }

    private boolean is_int(String str) {
        int j;
        try {
            j = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return j > 0;
    }

    private EqVariableClass get_class(String str) {
        long param = str.hashCode();
        if (param == hconstant) {
            return new EqVariableClass(1);
        }
        if (param == huniform) {
            return new EqVariableClass(2);
        }
        if (param == hvarying) {
            return new EqVariableClass(3);
        }
        if (param == hvertex) {
            return new EqVariableClass(4);
        }
        if (param == hfacevarying) {
            return new EqVariableClass(5);
        }
        return new EqVariableClass(1);
    }

    private EqVariableType get_type(String str) {
        long param = str.hashCode();
        if (param == hfloat) {
            return new EqVariableType(1);
        }
        if (param == hpoint) {
            return new EqVariableType(3);
        }
        if (param == hvector) {
            return new EqVariableType(9);
        }
        if (param == hnormal) {
            return new EqVariableType(8);
        }
        if (param == hcolor) {
            return new EqVariableType(5);
        }
        if (param == hstring) {
            return new EqVariableType(4);
        }
        if (param == hmatrix) {
            return new EqVariableType(11);
        }
        if (param == hhpoint) {
            return new EqVariableType(7);
        }
        if (param == hinteger) {
            return new EqVariableType(2);
        }
        if (param == hint) {
            return new EqVariableType(2);
        }
        return new EqVariableType(1);
    }

    private void check_syntax() throws XqException {
        switch (this.number_of_words) {
            case 0: {
                throw new XqException("void parameter declaration");
            }
            case 4: 
            case 7: {
                throw new XqException("Bad inline declaration");
            }
            case 1: {
                this.inline_def = false;
                break;
            }
            case 2: {
                this.word[0] = this.word[0].toLowerCase();
                if (!this.is_type(this.word[0])) {
                    throw new XqException("Bad inline declaration");
                }
                this.inline_def = true;
                this.tc = new EqVariableClass(2);
                this.tt = this.get_type(this.word[0]);
                this.size = 1;
                this.identifier = this.word[1];
                break;
            }
            case 3: {
                this.word[0] = this.word[0].toLowerCase();
                this.word[1] = this.word[1].toLowerCase();
                if (!this.is_class(this.word[0]) || !this.is_type(this.word[1])) {
                    throw new XqException("Bad inline declaration");
                }
                this.inline_def = true;
                this.tc = this.get_class(this.word[0]);
                this.tt = this.get_type(this.word[1]);
                this.size = 1;
                this.identifier = this.word[2];
                break;
            }
            case 5: {
                this.word[0] = this.word[0].toLowerCase();
                if (!this.is_type(this.word[0]) || this.word[1].compareTo("[") != 0 || !this.is_int(this.word[2]) || this.word[3].compareTo("]") != 0) {
                    throw new XqException("Bad inline declaration");
                }
                this.inline_def = true;
                this.tc = new EqVariableClass(2);
                this.tt = this.get_type(this.word[0]);
                this.size = Integer.parseInt(this.word[2]);
                this.identifier = this.word[4];
                break;
            }
            case 6: {
                this.word[0] = this.word[0].toLowerCase();
                this.word[1] = this.word[1].toLowerCase();
                if (!(this.is_class(this.word[0]) && this.is_type(this.word[1]) && this.word[2].compareTo("[") == 0 && this.is_int(this.word[3]) && this.word[4].compareTo("]") == 0)) {
                    throw new XqException("Bad inline declaration");
                }
                this.inline_def = true;
                this.tc = this.get_class(this.word[0]);
                this.tt = this.get_type(this.word[1]);
                this.size = Integer.parseInt(this.word[3]);
                this.identifier = this.word[5];
            }
        }
    }

    public void destracts() {
    }

    public void parse(String str) throws XqException {
        int sp = 0;
        int sz = 1;
        int j = 0;
        boolean start_found = false;
        int i = 0;
        while (i < str.length() && j < 7) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    if (start_found) {
                        this.word[j] = str.substring(sp, sp + sz);
                        ++j;
                        sz = 1;
                    }
                    start_found = false;
                    break;
                }
                case '#': {
                    throw new XqException("'#' character not allowed in strings");
                }
                case '\"': {
                    throw new XqException("'\"' character not allowed in strings");
                }
                case '[': 
                case ']': {
                    if (start_found) {
                        this.word[j] = str.substring(sp, sp + sz);
                        ++j;
                        start_found = false;
                    }
                    sp = i;
                    sz = 1;
                    if (j > 6) break;
                    this.word[j] = str.substring(sp, sp + sz);
                    ++j;
                    break;
                }
                default: {
                    if (start_found) {
                        ++sz;
                        break;
                    }
                    start_found = true;
                    sp = i;
                    sz = 1;
                }
            }
            ++i;
        }
        if (start_found) {
            this.word[j] = str.substring(sp, sp + sz);
            ++j;
        }
        this.number_of_words = j;
        try {
            this.check_syntax();
        }
        catch (XqException e) {
            String strError = new String(e.strReason());
            strError = String.valueOf(strError) + " : ";
            strError = String.valueOf(strError) + str;
            throw new XqException(strError);
        }
    }

    public boolean isInline() {
        return this.inline_def;
    }

    public EqVariableClass GetClass() {
        return this.tc;
    }

    public EqVariableType getType() {
        return this.tt;
    }

    public int getQuantity() {
        return this.size;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

