/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.util.Collections;
import java.util.Iterator;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqCSGTreeNode;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqImageSample;
import net.cellcomputing.himawari.library.SqSampleData;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqRandom;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqImagePixel {
    private CqRandom random = new CqRandom(53);
    private int m_XSamples;
    private int m_YSamples;
    private STLVector<STLVector<SqImageSample>> m_aValues = new STLVector(2, SqImageSample.class);
    private STLVector<SqImageSample> m_OpaqueValues = new STLVector<SqImageSample>(SqImageSample.class);
    private STLVector<SqSampleData> m_Samples = new STLVector<SqSampleData>(SqSampleData.class);
    private STLVector<Integer> m_DofOffsetIndices = new STLVector<Integer>(Integer.class);
    private SqImageSample m_Data = new SqImageSample();
    private int m_OpaqueSampleCount;
    private boolean m_AnySampleUsesSampleList;
    private float m_MaxDepth;
    private float m_MinDepth;
    private int m_OcclusionBoxId;
    private boolean m_NeedsZUpdate;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CqImagePixel() {
        this.m_XSamples = 0;
        this.m_YSamples = 0;
        this.m_MaxDepth = Float.MAX_VALUE;
        this.m_MinDepth = Float.MAX_VALUE;
        this.m_OcclusionBoxId = -1;
        this.m_NeedsZUpdate = false;
    }

    public CqImagePixel(CqImagePixel ieFrom) {
        this.m_AnySampleUsesSampleList = ieFrom.m_AnySampleUsesSampleList;
        this.m_aValues = ieFrom.m_aValues;
        this.m_Data = ieFrom.m_Data;
        this.m_DofOffsetIndices = ieFrom.m_DofOffsetIndices;
        this.m_MaxDepth = ieFrom.m_MaxDepth;
        this.m_MinDepth = ieFrom.m_MinDepth;
        this.m_NeedsZUpdate = ieFrom.m_NeedsZUpdate;
        this.m_OcclusionBoxId = ieFrom.m_OcclusionBoxId;
        this.m_OpaqueSampleCount = ieFrom.m_OpaqueSampleCount;
        this.m_Samples = ieFrom.m_Samples;
        this.m_XSamples = ieFrom.m_XSamples;
        this.m_YSamples = ieFrom.m_YSamples;
        this.random = ieFrom.random;
    }

    public void destruct() {
    }

    public int XSamples() {
        return this.m_XSamples;
    }

    public int YSamples() {
        return this.m_YSamples;
    }

    public void AllocateSamples(int XSamples, int YSamples) {
        if (this.m_XSamples != XSamples || this.m_YSamples != YSamples) {
            this.m_XSamples = XSamples;
            this.m_YSamples = YSamples;
            int numSamples = this.m_XSamples * this.m_YSamples;
            if (XSamples > 0 && YSamples > 0) {
                this.m_aValues.resize(numSamples);
                int i = this.m_OpaqueValues.size();
                while (i < numSamples) {
                    this.m_OpaqueValues.add(new SqImageSample(RiGlobal.QGetRenderContext().GetOutputDataTotalSize()));
                    ++i;
                }
                this.m_Samples.setSize(numSamples);
                this.m_DofOffsetIndices.setSize(numSamples);
            }
        }
    }

    public void InitialiseSamples(STLVector<CqVector2D> vecSamples) {
        this.InitialiseSamples(vecSamples, true);
    }

    public void InitialiseSamples(STLVector<CqVector2D> vecSamples, boolean fJitter) {
        p_float opentime = new p_float(RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Shutter", (int)0).value);
        p_float closetime = new p_float(RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Shutter", (int)1).value);
        int numSamples = this.m_XSamples * this.m_YSamples;
        float subcell_width = 1.0f / (float)numSamples;
        int m = this.m_XSamples;
        int n = this.m_YSamples;
        vecSamples.setSize(numSamples);
        if (!fJitter) {
            float XInc = 1.0f / (float)this.m_XSamples / 2.0f;
            float YInc = 1.0f / (float)this.m_YSamples / 2.0f;
            int y = 0;
            while (y < this.m_YSamples) {
                float YSam = YInc + YInc * (float)y;
                int x = 0;
                while (x < this.m_XSamples) {
                    ((CqVector2D)vecSamples.get(y * this.m_XSamples + x)).assignment(new CqVector2D(XInc + XInc * (float)x, YSam));
                    ++x;
                }
                ++y;
            }
            float time = 0.0f;
            int nSamples = this.m_XSamples * this.m_YSamples;
            float dtime = 1.0f / (float)nSamples;
            int i = 0;
            while (i < nSamples) {
                ((SqSampleData)this.m_Samples.get((int)i)).m_SubCellIndex = 0;
                ((SqSampleData)this.m_Samples.get((int)i)).m_DetailLevel = ((SqSampleData)this.m_Samples.get((int)i)).m_Time = time;
                time += dtime;
                ++i;
            }
        } else {
            int i2;
            int i1;
            int k;
            int j;
            int i = 0;
            while (i < n) {
                j = 0;
                while (j < m) {
                    int which = i * m + j;
                    ((CqVector2D)vecSamples.get(which)).x(i);
                    ((CqVector2D)vecSamples.get(which)).y(j);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < n) {
                j = 0;
                while (j < m) {
                    k = (int)this.random.RandomInt(n - 1 - i) + i;
                    i1 = i * m + j;
                    i2 = k * m + j;
                    assert (i1 < vecSamples.size() && i2 < vecSamples.size());
                    float t = ((CqVector2D)vecSamples.get((int)i1)).y;
                    ((CqVector2D)vecSamples.get(i1)).y(((CqVector2D)vecSamples.get((int)i2)).y);
                    ((CqVector2D)vecSamples.get(i2)).y(t);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < m) {
                j = 0;
                while (j < n) {
                    k = (int)this.random.RandomInt(n - 1 - j) + j;
                    i1 = j * m + i;
                    i2 = k * m + i;
                    assert (i1 < vecSamples.size() && i2 < vecSamples.size());
                    float t = ((CqVector2D)vecSamples.get((int)i1)).x;
                    ((CqVector2D)vecSamples.get(i1)).x(((CqVector2D)vecSamples.get((int)i2)).x);
                    ((CqVector2D)vecSamples.get(i2)).x(t);
                    ++j;
                }
                ++i;
            }
            float subpixelheight = 1.0f / (float)this.m_YSamples;
            float subpixelwidth = 1.0f / (float)this.m_XSamples;
            int which = 0;
            i = 0;
            while (i < n) {
                float sy = (float)i * subpixelheight;
                j = 0;
                while (j < m) {
                    float sx = (float)j * subpixelwidth;
                    float xindex = ((CqVector2D)vecSamples.get((int)which)).x;
                    float yindex = ((CqVector2D)vecSamples.get((int)which)).y;
                    ((CqVector2D)vecSamples.get(which)).x(xindex * subcell_width + subcell_width * 0.5f + sx);
                    ((CqVector2D)vecSamples.get(which)).y(yindex * subcell_width + subcell_width * 0.5f + sy);
                    ((SqSampleData)this.m_Samples.get((int)which)).m_SubCellIndex = (int)(yindex * (float)this.m_YSamples + xindex);
                    ++which;
                    ++j;
                }
                ++i;
            }
            float time = 0.0f;
            float dtime = 1.0f / (float)numSamples;
            float randomTime = this.random.RandomFloat(dtime);
            float lod = 0.0f;
            float dlod = dtime;
            i = 0;
            while (i < numSamples) {
                float t = time + randomTime;
                ((SqSampleData)this.m_Samples.get((int)i)).m_Time = t = (closetime.value - opentime.value) * t + opentime.value;
                time += dtime;
                ((SqSampleData)this.m_Samples.get((int)i)).m_DetailLevel = lod + this.random.RandomFloat(dlod);
                lod += dlod;
                ++i;
            }
            float dx = 2.0f / (float)this.m_XSamples;
            float dy = 2.0f / (float)this.m_YSamples;
            float sx = this.random.RandomFloat(dx);
            float sy = this.random.RandomFloat(dy);
            float xOffset = -1.0f + sx;
            float yOffset = -1.0f + sy;
            which = 0;
            STLVector<CqVector2D> tmpDofOffsets = new STLVector<CqVector2D>(CqVector2D.class, numSamples);
            i = 0;
            while (i < this.m_YSamples) {
                j = 0;
                while (j < this.m_XSamples) {
                    ((CqVector2D)tmpDofOffsets.get(which)).x(xOffset);
                    ((CqVector2D)tmpDofOffsets.get(which)).y(yOffset);
                    CqImagePixel.ProjectToCircle((CqVector2D)tmpDofOffsets.get(which));
                    this.m_DofOffsetIndices.set(which, which);
                    xOffset += dx;
                    ++which;
                    ++j;
                }
                yOffset += dy;
                xOffset = -1.0f + sx;
                ++i;
            }
            Collections.shuffle(this.m_DofOffsetIndices, RiGlobal.rand);
            i = 0;
            while (i < numSamples) {
                ((SqSampleData)this.m_Samples.get((int)((Integer)this.m_DofOffsetIndices.get((int)i)).intValue())).m_DofOffset = (CqVector2D)tmpDofOffsets.get(i);
                ++i;
            }
        }
        this.m_Data.m_Data.resize(RiGlobal.QGetRenderContext().GetOutputDataTotalSize());
    }

    public void ShuffleSamples() {
        int numSamples = this.m_XSamples * this.m_YSamples;
        STLVector<CqVector2D> tmpDofOffsets = new STLVector<CqVector2D>(CqVector2D.class, numSamples);
        int i = 0;
        while (i < numSamples) {
            ((CqVector2D)tmpDofOffsets.get(i)).assignment(((SqSampleData)this.m_Samples.get((int)((Integer)this.m_DofOffsetIndices.get((int)i)).intValue())).m_DofOffset);
            this.m_DofOffsetIndices.set(i, i);
            ++i;
        }
        Collections.shuffle(this.m_DofOffsetIndices, RiGlobal.rand);
        i = 0;
        while (i < numSamples) {
            ((SqSampleData)this.m_Samples.get((int)((Integer)this.m_DofOffsetIndices.get((int)i)).intValue())).m_DofOffset.assignment((CqVector2D)tmpDofOffsets.get(i));
            ++i;
        }
    }

    public void OffsetSamples(CqVector2D vecPixel, STLVector<CqVector2D> vecSamples) {
        int numSamples = this.m_XSamples * this.m_YSamples;
        int i = 0;
        while (i < numSamples) {
            ((SqSampleData)this.m_Samples.get((int)i)).m_Position.assignment((CqVector2D)vecSamples.get(i));
            ((SqSampleData)this.m_Samples.get((int)i)).m_Position.assignAdd(vecPixel);
            ++i;
        }
    }

    public void OffsetSamples(CqVector2D vecPixel, CqVector2D[] vecSamples) {
        int numSamples = this.m_XSamples * this.m_YSamples;
        int i = 0;
        while (i < numSamples) {
            ((SqSampleData)this.m_Samples.get((int)i)).m_Position.assignment(vecSamples[i]);
            ((SqSampleData)this.m_Samples.get((int)i)).m_Position.assignAdd(vecPixel);
            ++i;
        }
    }

    public float Coverage() {
        return this.m_Data.Coverage();
    }

    public void SetCoverage(float c) {
        this.m_Data.SetCoverage(c);
    }

    public CqColor Color() {
        return this.m_Data.Cs();
    }

    public void SetColor(CqColor col) {
        this.m_Data.SetCs(col);
    }

    public CqColor Opacity() {
        return this.m_Data.Os();
    }

    public void SetOpacity(CqColor col) {
        this.m_Data.SetOs(col);
    }

    public float Depth() {
        return this.m_Data.Depth();
    }

    public void SetDepth(float d) {
        this.m_Data.SetDepth(d);
    }

    public float Alpha() {
        return this.m_Data.Alpha();
    }

    public void SetAlpha(float a) {
        this.m_Data.SetAlpha(a);
    }

    public Valarray Data() {
        return this.m_Data.m_Data;
    }

    public SqImageSample GetPixelSample() {
        return this.m_Data;
    }

    public int DataSize() {
        return this.m_Data.m_Data.size();
    }

    public float MaxDepth() {
        return this.m_MaxDepth;
    }

    public void SetMaxDepth(float d) {
        this.m_MaxDepth = d;
    }

    public float MinDepth() {
        return this.m_MinDepth;
    }

    public void SetMinDepth(float d) {
        this.m_MinDepth = d;
    }

    public int OcclusionBoxId() {
        return this.m_OcclusionBoxId;
    }

    public void SetOcclusionBoxId(int id) {
        this.m_OcclusionBoxId = id;
    }

    public void MarkForZUpdate() {
        this.m_NeedsZUpdate = true;
    }

    public boolean NeedsZUpdating() {
        return this.m_NeedsZUpdate;
    }

    public void UpdateZValues() {
        float currentMax = 0.0f;
        float currentMin = Float.MAX_VALUE;
        int sampleIndex = 0;
        int sy = 0;
        while (sy < this.m_YSamples) {
            int sx = 0;
            while (sx < this.m_XSamples) {
                SqImageSample opaqueSample = (SqImageSample)this.m_OpaqueValues.get(sampleIndex);
                if ((opaqueSample.m_flags & 4) != 0) {
                    if (opaqueSample.Depth() > currentMax) {
                        currentMax = opaqueSample.Depth();
                    }
                    if (opaqueSample.Depth() < currentMin) {
                        currentMin = opaqueSample.Depth();
                    }
                } else {
                    currentMax = Float.MAX_VALUE;
                }
                ++sampleIndex;
                ++sx;
            }
            ++sy;
        }
        this.m_MaxDepth = currentMax;
        this.m_MinDepth = currentMin;
    }

    public void Clear() {
        int i = this.m_XSamples * this.m_YSamples - 1;
        while (i >= 0) {
            if (!((STLVector)this.m_aValues.get(i)).isEmpty()) {
                ((STLVector)this.m_aValues.get(i)).clear();
            }
            ((SqImageSample)this.m_OpaqueValues.get((int)i)).m_flags = 0;
            --i;
        }
        this.m_OpaqueSampleCount = 0;
        this.m_AnySampleUsesSampleList = false;
        this.m_MaxDepth = Float.MAX_VALUE;
        this.m_MinDepth = Float.MAX_VALUE;
        this.m_OcclusionBoxId = -1;
        this.m_NeedsZUpdate = false;
    }

    public STLVector<SqImageSample> Values(int index) {
        assert (index < this.m_XSamples * this.m_YSamples);
        return (STLVector)this.m_aValues.get(index);
    }

    public SqImageSample OpaqueValues(int index) {
        assert (index < this.m_XSamples * this.m_YSamples);
        return (SqImageSample)this.m_OpaqueValues.get(index);
    }

    public void IncOpaqueSampleCount() {
        ++this.m_OpaqueSampleCount;
    }

    public void SetUsesSampleList() {
        this.m_AnySampleUsesSampleList = true;
    }

    public void Combine() {
        int depthfilter = 0;
        HimawariLogger logger = HimawariLogger.getLogger();
        String[] pstrDepthFilter = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("Hider", "depthfilter");
        CqColor[] pzThreshold = RiGlobal.QGetRenderContext().optCurrent().GetColorOption("limits", "zthreshold");
        CqColor zThreshold = new CqColor(1.0f, 1.0f, 1.0f);
        if (pzThreshold != null) {
            zThreshold = pzThreshold[0];
        }
        if (pstrDepthFilter != null) {
            if (pstrDepthFilter[0].compareTo("min") == 0) {
                depthfilter = 0;
            } else if (pstrDepthFilter[0].compareTo("midpoint") == 0) {
                depthfilter = 1;
            } else if (pstrDepthFilter[0].compareTo("max") == 0) {
                depthfilter = 2;
            } else if (pstrDepthFilter[0].compareTo("average") == 0) {
                depthfilter = 3;
            } else {
                logger.warning("Invalid depthfilter \"" + pstrDepthFilter[0] + "\", depthfilter set to \"min\"");
            }
        }
        int samplecount = 0;
        if (this.m_AnySampleUsesSampleList) {
            int sampleIndex = 0;
            for (STLVector sTLVector : this.m_aValues) {
                SqImageSample opaqueValue = (SqImageSample)this.m_OpaqueValues.get(sampleIndex);
                ++sampleIndex;
                if (!sTLVector.isEmpty()) {
                    boolean CqCSGRequired;
                    if ((opaqueValue.m_flags & 4) != 0) {
                        Iterator isi = sTLVector.iterator();
                        int index = 0;
                        while (isi.hasNext()) {
                            SqImageSample tmp = (SqImageSample)isi.next();
                            if (tmp.Depth() >= opaqueValue.Depth()) break;
                            ++index;
                        }
                        sTLVector.insertElementAt(opaqueValue, index);
                    }
                    if (CqCSGRequired = CqCSGTreeNode.IsRequired()) {
                        boolean bProcessed;
                        block2: do {
                            bProcessed = false;
                            for (SqImageSample isample : sTLVector) {
                                if (isample.m_pCSGNode == null) continue;
                                isample.m_pCSGNode.ProcessTree(sTLVector);
                                bProcessed = true;
                                continue block2;
                            }
                        } while (bProcessed);
                    }
                    CqColor samplecolor = new CqColor(RiGlobal.gColBlack);
                    CqColor sampleopacity = new CqColor(RiGlobal.gColBlack);
                    boolean samplehit = false;
                    float[] opaqueDepths = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                    float maxOpaqueDepth = Float.MAX_VALUE;
                    int Size = sTLVector.size();
                    int index = Size - 1;
                    while (index >= 0) {
                        SqImageSample sample = (SqImageSample)sTLVector.get(index);
                        if ((sample.m_flags & 2) != 0) {
                            if ((sample.m_flags & 1) != 0) {
                                samplecolor.assignment(RiGlobal.gColBlack);
                                sampleopacity.assignment(RiGlobal.gColBlack);
                            } else {
                                samplecolor.SetColorRGB(RiGlobal.LERP(sample.Os().fRed(), samplecolor.fRed(), 0.0f), RiGlobal.LERP(sample.Os().fGreen(), samplecolor.fGreen(), 0.0f), RiGlobal.LERP(sample.Os().fBlue(), samplecolor.fBlue(), 0.0f));
                                sampleopacity.SetColorRGB(RiGlobal.LERP(sample.Os().fRed(), sampleopacity.fRed(), 0.0f), RiGlobal.LERP(sample.Os().fGreen(), sampleopacity.fGreen(), 0.0f), RiGlobal.LERP(sample.Os().fBlue(), sampleopacity.fBlue(), 0.0f));
                            }
                        } else {
                            samplecolor.assignment(samplecolor.mul(RiGlobal.gColWhite.sub(sample.Os())).add(sample.Cs()));
                            sampleopacity.assignment(RiGlobal.gColWhite.sub(sampleopacity).mul(sample.Os()).add(sampleopacity));
                        }
                        if (sample.Os().fRed() >= zThreshold.fRed() || sample.Os().fGreen() >= zThreshold.fGreen() || sample.Os().fBlue() >= zThreshold.fBlue()) {
                            opaqueDepths[1] = opaqueDepths[0];
                            opaqueDepths[0] = sample.Depth();
                            if (!(maxOpaqueDepth < Float.MAX_VALUE)) {
                                maxOpaqueDepth = sample.Depth();
                            }
                        }
                        samplehit = true;
                        --index;
                    }
                    if (samplehit) {
                        ++samplecount;
                    }
                    if (sTLVector.isEmpty()) continue;
                    opaqueValue.SetCs(samplecolor);
                    opaqueValue.SetOs(sampleopacity);
                    opaqueValue.m_flags |= 4;
                    if (depthfilter != 0) {
                        if (depthfilter == 1) {
                            if (sTLVector.size() > 1) {
                                opaqueValue.SetDepth((opaqueDepths[0] + opaqueDepths[1]) * 0.5f);
                                continue;
                            }
                            opaqueValue.SetDepth(Float.MAX_VALUE);
                            continue;
                        }
                        if (depthfilter == 2) {
                            opaqueValue.SetDepth(maxOpaqueDepth);
                            continue;
                        }
                        if (depthfilter != 3) continue;
                        Iterator sample = sTLVector.iterator();
                        float totDepth = 0.0f;
                        int totCount = 0;
                        while (sample.hasNext()) {
                            SqImageSample tmp = (SqImageSample)sample.next();
                            if (!(tmp.Os().fRed() >= zThreshold.fRed()) && !(tmp.Os().fGreen() >= zThreshold.fGreen()) && !(tmp.Os().fBlue() >= zThreshold.fBlue())) continue;
                            totDepth += tmp.Depth();
                            ++totCount;
                        }
                        opaqueValue.SetDepth(totDepth /= (float)totCount);
                        continue;
                    }
                    opaqueValue.SetDepth(opaqueDepths[0]);
                    continue;
                }
                if ((opaqueValue.m_flags & 4) == 0) continue;
                ++samplecount;
            }
        } else {
            samplecount = this.m_OpaqueSampleCount;
        }
    }

    public final SqSampleData SampleData(int index) {
        if (index < this.m_XSamples * this.m_YSamples) {
            return (SqSampleData)this.m_Samples.get(index);
        }
        return new SqSampleData();
    }

    public int GetDofOffsetIndex(int i) {
        return (Integer)this.m_DofOffsetIndices.get(i);
    }

    public static void ProjectToCircle(CqVector2D pos) {
        float r = pos.Magnitude();
        if ((double)r == 0.0) {
            return;
        }
        float adj = Math.max(Math.abs(pos.x), Math.abs(pos.y)) / r;
        pos.x(pos.x * adj);
        pos.y(pos.y * adj);
    }

    public void setfColor(CqColor col) {
        this.m_Data.setFColor(col);
    }

    public CqColor getFColor() {
        return this.m_Data.getFColor();
    }
}

