/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqAttributes;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqCSGTreeNode;
import net.cellcomputing.himawari.library.CqMicroPolyGrid;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqModeBlock;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqTransform;
import net.cellcomputing.himawari.library.EqSplitDir;
import net.cellcomputing.himawari.library.IqAttributes;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.IqSurface;
import net.cellcomputing.himawari.library.IqTransform;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class CqBasicSurface
extends IqSurface {
    public boolean m_fDiceable;
    public boolean m_fDiscard;
    public int m_EyeSplitCount;
    protected CqAttributes m_pAttributes;
    protected CqTransform m_pTransform;
    protected int m_uDiceSize;
    protected int m_vDiceSize;
    protected EqSplitDir m_SplitDir;
    protected boolean m_CachedBound;
    protected CqBound m_Bound = new CqBound();
    protected CqCSGTreeNode m_pCSGNode;
    protected static float m_fGridSize = (float)StrictMath.sqrt(256.0);
    protected HimawariLogger logger = HimawariLogger.getLogger();

    public CqBasicSurface() {
        this.m_fDiceable = true;
        this.m_fDiscard = false;
        this.m_EyeSplitCount = 0;
        this.m_pAttributes = null;
        this.m_SplitDir = new EqSplitDir();
        this.m_SplitDir.setValue(0);
        this.m_pAttributes = RiGlobal.QGetRenderContext().pattrCurrent();
        this.m_pAttributes.AddRef();
        this.m_pTransform = RiGlobal.QGetRenderContext().ptransCurrent();
        this.m_CachedBound = false;
        if (RiGlobal.QGetRenderContext().pconCurrent().isSolid()) {
            CqModeBlock pSolid = RiGlobal.QGetRenderContext().pconCurrent();
            if (pSolid.pCSGNode().NodeType().getValue() == 0) {
                this.m_pCSGNode = pSolid.pCSGNode();
            } else {
                String objname = "unnamed";
                String[] pattrName = this.m_pAttributes.GetStringAttribute("identifier", "name");
                if (pattrName != null) {
                    objname = pattrName[0];
                }
                this.logger.warning("Primitive \"" + objname + "\" defined when not in 'Primitive' solid block \n");
            }
        }
        CqStats.STATS_INC(1);
        CqStats.STATS_INC(4);
        int cGprim = CqStats.STATS_GETI(4);
        int cPeak = CqStats.STATS_GETI(5);
        CqStats.STATS_SETI(5, cGprim > cPeak ? cGprim : cPeak);
    }

    public CqBasicSurface(CqBasicSurface From) {
        this.assignment(From);
        this.m_pAttributes = From.m_pAttributes;
        this.m_pAttributes.AddRef();
        this.m_pTransform = From.m_pTransform;
        this.m_CachedBound = From.m_CachedBound;
        this.m_Bound = From.m_Bound;
        CqStats.STATS_INC(1);
        CqStats.STATS_INC(4);
        int cGprim = CqStats.STATS_GETI(4);
        int cPeak = CqStats.STATS_GETI(5);
        CqStats.STATS_SETI(5, cGprim > cPeak ? cGprim : cPeak);
    }

    public void destruct() {
        if (this.m_pAttributes != null) {
            this.m_pAttributes.Release();
        }
        this.m_pAttributes = null;
        CqStats.STATS_DEC(4);
    }

    public abstract CqMicroPolyGridBase Dice();

    public abstract int Split(STLVector<CqBasicSurface> var1);

    public abstract boolean Diceable();

    public void Reset() {
    }

    public abstract boolean IsMotionBlurMatch(CqBasicSurface var1);

    @Override
    public String strName() {
        String[] pattrLightName = this.pAttributes().GetStringAttribute("identifier", "name");
        String strName = "not named";
        if (pattrLightName != null) {
            strName = pattrLightName[0];
        }
        return strName;
    }

    @Override
    public int Uses() {
        int Uses = 0x73964 | RiGlobal.QGetRenderContext().pDDmanager().Uses();
        IqShader pshadSurface = this.pAttributes().pshadSurface(RiGlobal.QGetRenderContextI().Time());
        IqShader pshadDisplacement = this.pAttributes().pshadDisplacement(RiGlobal.QGetRenderContextI().Time());
        IqShader pshadAtmosphere = this.pAttributes().pshadAtmosphere(RiGlobal.QGetRenderContextI().Time());
        if (pshadSurface != null && pshadDisplacement != null && pshadAtmosphere != null) {
            return 0;
        }
        if (pshadSurface != null) {
            Uses |= pshadSurface.Uses();
        }
        if (pshadDisplacement != null) {
            Uses |= pshadDisplacement.Uses();
        }
        if (pshadAtmosphere != null) {
            Uses |= pshadAtmosphere.Uses();
        }
        if (RiGlobal.USES(Uses, 9)) {
            Uses |= 8;
        }
        if (RiGlobal.USES(Uses, 10)) {
            Uses |= 0x10;
        }
        if (RiGlobal.USES(Uses, 3)) {
            Uses |= 0x1000;
        }
        if (RiGlobal.USES(Uses, 4)) {
            Uses |= 0x2000;
        }
        return Uses;
    }

    @Override
    public void PreDice(int uDiceSize, int vDiceSize) {
    }

    @Override
    public int DiceAll(CqMicroPolyGrid pGrid) {
        return 0;
    }

    @Override
    public void NaturalDice(CqParameter pParameter, int uDiceSize, int vDiceSize, IqShaderData pData) {
    }

    @Override
    public void PostDice(CqMicroPolyGrid pGrid) {
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        return 0;
    }

    @Override
    public void NaturalSubdivide(CqParameter pParam, CqParameter pParam1, CqParameter pParam2, boolean u) {
    }

    @Override
    public void PostSubdivide(STLVector<CqBasicSurface> aSplits) {
    }

    @Override
    public void RenderComplete() {
    }

    public void PrepareTrimCurve() {
    }

    public int uDiceSize() {
        return this.m_uDiceSize;
    }

    public int vDiceSize() {
        return this.m_vDiceSize;
    }

    public CqVector3D SurfaceParametersAtVertex(int index) {
        return new CqVector3D(0.0f, 0.0f, 0.0f);
    }

    @Override
    public IqAttributes pAttributes() {
        return this.m_pAttributes;
    }

    @Override
    public IqTransform pTransform() {
        return this.m_pTransform;
    }

    public void SetSurfaceParameters(CqBasicSurface From) {
        if (this.m_pAttributes != null) {
            this.m_pAttributes.Release();
        }
        this.m_pAttributes = From.m_pAttributes;
        this.m_pAttributes.AddRef();
        this.m_pTransform = From.m_pTransform;
        this.m_pCSGNode = From.m_pCSGNode;
    }

    public void ForceUndiceable() {
        this.m_fDiceable = false;
        ++this.m_EyeSplitCount;
    }

    public boolean IsUndiceable() {
        return !this.m_fDiceable;
    }

    public void Discard() {
        this.m_fDiscard = true;
    }

    public void CopySplitInfo(CqBasicSurface From) {
        this.m_uDiceSize = From.m_uDiceSize;
        this.m_vDiceSize = From.m_vDiceSize;
        this.m_SplitDir.setValue(From.m_SplitDir.getValue());
    }

    public boolean fDiscard() {
        return this.m_fDiscard;
    }

    public int EyeSplitCount() {
        return this.m_EyeSplitCount;
    }

    public void SetEyeSplitCount(int EyeSplitCount) {
        this.m_EyeSplitCount = EyeSplitCount;
    }

    public int SplitDir() {
        return this.m_SplitDir.getValue();
    }

    public void SetSplitDir(EqSplitDir SplitDir) {
        this.m_SplitDir.setValue(SplitDir.getValue());
    }

    public void CacheRasterBound(CqBound pBound) {
        this.m_Bound.assignment(pBound);
        this.m_CachedBound = true;
    }

    public CqBound GetCachedRasterBound() {
        if (!this.m_CachedBound && this.m_fDiceable) {
            this.logger.critical("No cached bound available");
        }
        return this.m_Bound;
    }

    public boolean fCachedBound() {
        return this.m_CachedBound;
    }

    public CqBound AdjustBoundForTransformationMotion(CqBound B) {
        CqBound Bm = new CqBound(B);
        if (this.pTransform().cTimes() > 1) {
            CqMatrix matCameraToObject0 = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "object", new CqMatrix(), this.pTransform().matObjectToWorld(this.pTransform().Time(0)), this.pTransform().Time(0));
            CqBound B0 = new CqBound(B);
            B0.Transform(matCameraToObject0);
            int i = 1;
            while (i < this.pTransform().cTimes()) {
                CqBound Btx = new CqBound(B0);
                CqMatrix matObjectToCameraT = RiGlobal.QGetRenderContext().matSpaceToSpace("object", "camera", new CqMatrix(), this.pTransform().matObjectToWorld(this.pTransform().Time(i)), this.pTransform().Time(i));
                Btx.Transform(matObjectToCameraT);
                Bm.Encapsulate(Btx);
                ++i;
            }
        }
        return Bm;
    }

    public CqBasicSurface assignment(CqBasicSurface From) {
        this.m_fDiceable = From.m_fDiceable;
        this.m_EyeSplitCount = From.m_EyeSplitCount;
        this.m_fDiscard = From.m_fDiscard;
        this.SetSurfaceParameters(From);
        return this;
    }

    public CqCSGTreeNode pCSGNode() {
        return this.m_pCSGNode;
    }
}

