/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import net.cellcomputing.himawari.display.DisplayRequest;
import net.cellcomputing.himawari.display.FrameBuffer;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.display.ZFileImage;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class ZFrameBufferRequest
extends DisplayRequest {
    private FrameBuffer frameBuffer;

    public ZFrameBufferRequest(String name, String type, String mode, int modeID, int dataOffset, int dataSize, ImageData imageData) {
        super(name, type, mode, modeID, dataOffset, dataSize, imageData);
    }

    public void openRequest() {
        try {
            this.frameBuffer = new FrameBuffer(((ZFileImage)this.imageData).getZImage(), this.name);
        }
        catch (ClassCastException cle) {
            HimawariLogger.getLogger().error("Can't open framebuffer");
            return;
        }
        this.frameBuffer.init();
        this.frameBuffer.setVisible(true);
    }

    public void display() {
        this.frameBuffer.repaint();
    }

    public void closeRequest() {
        if (this.frameBuffer == null || !this.frameBuffer.isVisible()) {
            return;
        }
        ZFileImage zImageData = (ZFileImage)this.imageData;
        float[][] depthData = (float[][])this.imageData.getImage();
        float max_depth = zImageData.getMaxDepth();
        float min_depth = zImageData.getMinDepth();
        float[] temp_depth = new float[3];
        int j = 0;
        while (j < this.imageData.height) {
            int i = 0;
            while (i < this.imageData.width) {
                if (depthData[j][i] == Float.MAX_VALUE) {
                    temp_depth[zImageData.Z_COLOR] = 0.0f;
                    temp_depth[0] = 0.0f;
                    temp_depth[1] = 0.0f;
                    this.imageData.raster.setPixel(i, j, temp_depth);
                } else {
                    temp_depth[zImageData.Z_COLOR] = 255.0f;
                    temp_depth[0] = 255.0f - (depthData[j][i] - min_depth) * 255.0f / (max_depth - min_depth);
                    temp_depth[1] = temp_depth[0];
                    this.imageData.raster.setPixel(i, j, temp_depth);
                }
                ++i;
            }
            ++j;
        }
        if (this.frameBuffer != null) {
            this.frameBuffer.repaint();
        }
        this.imageData = null;
    }
}

