/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.display.AOVSingleImageData;
import net.cellcomputing.himawari.display.AOVTripleImageData;
import net.cellcomputing.himawari.display.BMPRequest;
import net.cellcomputing.himawari.display.DisplayRequest;
import net.cellcomputing.himawari.display.FrameBufferRequest;
import net.cellcomputing.himawari.display.GrobalDDManager;
import net.cellcomputing.himawari.display.HDRImage;
import net.cellcomputing.himawari.display.HDRRequest;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.display.JPEG2000Request;
import net.cellcomputing.himawari.display.JPEGRequest;
import net.cellcomputing.himawari.display.PngRequest;
import net.cellcomputing.himawari.display.RGBAImageData;
import net.cellcomputing.himawari.display.RGBImageData;
import net.cellcomputing.himawari.display.TiffRequest;
import net.cellcomputing.himawari.display.ZFileImage;
import net.cellcomputing.himawari.display.ZFileRequest;
import net.cellcomputing.himawari.display.ZFrameBufferRequest;
import net.cellcomputing.himawari.exception.DisplayNotFoundException;
import net.cellcomputing.himawari.exception.XqException;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.IqDDManager;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqParameterDeclaration;
import net.cellcomputing.himawari.library.UserParameter;
import net.cellcomputing.himawari.shaderexecenv.GlobalShaderExecEnv;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DisplayManager
implements IqDDManager {
    private static final String DISPLAY_TIFF = "tiff";
    private static final String DISPLAY_PNG = "png";
    private static final String DISPLAY_BMP = "bmp";
    private static final String DISPLAY_JPG = "jpg";
    private static final String DISPLAY_JPEG2000 = "jpeg2000";
    private static final String DISPLAY_MODE_RGBA = "rgba";
    private static final String DISPLAY_MODE_RGB = "rgb";
    private static final String DISPLAY_MODE_Z = "z";
    private static final String DISPLAY_HDR = "hdr";
    private static final String DISPLAY_FILE = "file";
    private static final String DISPLAY_FRAMEBUFFER = "framebuffer";
    private static final String DISPLAY_ZFRAMEBUFFER = "zframebuffer";
    private static final String DISPLAY_ZFILE = "zfile";
    private static final String DISPLAY_SHADOW_FILE = "shadow";
    private STLVector<DisplayRequest> m_displayRequests = new STLVector<DisplayRequest>(DisplayRequest.class);
    private STLVector<ImageData> m_ImageData = new STLVector<ImageData>(ImageData.class);
    private LinkedList<String> m_displayList = new LinkedList();
    private static int rgb = "rgb".hashCode();
    private static int rgba = "rgba".hashCode();
    private static int Ci = "Cs".hashCode();
    private static int Oi = "Os".hashCode();
    private static DisplayManager me;
    private ArrayList<String> dispNames = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    @Override
    public int Initialise() {
        String[] writerNames = ImageIO.getWriterFormatNames();
        int i = 0;
        while (i < writerNames.length) {
            this.m_displayList.add(writerNames[i]);
            ++i;
        }
        this.addExtractDisplay();
        return 0;
    }

    private void addExtractDisplay() {
        this.m_displayList.add(DISPLAY_FRAMEBUFFER);
        this.m_displayList.add(DISPLAY_FILE);
        this.m_displayList.add(DISPLAY_HDR);
        this.m_displayList.add(DISPLAY_ZFILE);
        this.m_displayList.add(DISPLAY_SHADOW_FILE);
        this.m_displayList.add(DISPLAY_ZFRAMEBUFFER);
    }

    @Override
    public int Shutdown() {
        return 0;
    }

    @Override
    public int AddDisplay(String name, String type, String mode, int modeID, int dataOffset, int dataSize, HashMap<String, Object> mapOfArguments) throws DisplayNotFoundException {
        ImageData imageData = null;
        DisplayRequest request = null;
        if (!this.m_displayList.contains(type)) {
            throw new DisplayNotFoundException(type);
        }
        int outType = RiGlobal.QGetRenderContext().OutputDataType(mode);
        if (outType > 0) {
            switch (outType) {
                case 1: 
                case 2: {
                    type = DISPLAY_HDR;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 9: {
                    type = DISPLAY_HDR;
                }
            }
        }
        if (mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_FRAMEBUFFER)) {
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new FrameBufferRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_FRAMEBUFFER)) {
            imageData = ImageData.getInstance(RGBAImageData.class, dataOffset);
            request = new FrameBufferRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_TIFF)) {
            imageData = ImageData.getInstance(RGBAImageData.class, dataOffset);
            request = new TiffRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_TIFF)) {
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new TiffRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_PNG)) {
            imageData = ImageData.getInstance(RGBAImageData.class, dataOffset);
            request = new PngRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_PNG)) {
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new PngRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_BMP)) {
            HimawariLogger.getLogger().warning("[" + type + "]  \"" + mode + "\" is not supported. Convert \"" + mode + "\" into \"rgb\".\n");
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new BMPRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_BMP)) {
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new BMPRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_JPG)) {
            HimawariLogger.getLogger().warning("[" + type + "]  \"" + mode + "\" is not supported. Convert \"" + mode + "\" into \"rgb\".\n");
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new JPEGRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_JPG)) {
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new JPEGRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_HDR)) {
            HimawariLogger.getLogger().warning("[" + type + "]  \"" + mode + "\" is not supported. Convert \"" + mode + "\" into \"rgb\".\n");
            imageData = ImageData.getInstance(HDRImage.class, dataOffset);
            request = new HDRRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_HDR)) {
            imageData = ImageData.getInstance(HDRImage.class, dataOffset);
            request = new HDRRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_JPEG2000)) {
            imageData = ImageData.getInstance(RGBAImageData.class, dataOffset);
            request = new JPEG2000Request(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_JPEG2000)) {
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = new JPEG2000Request(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (type.equals(DISPLAY_FILE) && mode.equals(DISPLAY_MODE_RGBA)) {
            imageData = ImageData.getInstance(RGBAImageData.class, dataOffset);
            request = this.m_displayList.contains(DISPLAY_TIFF) ? new TiffRequest(name, type, mode, modeID, dataOffset, dataSize, imageData) : new PngRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (type.equals(DISPLAY_FILE) && mode.equals(DISPLAY_MODE_RGB)) {
            imageData = ImageData.getInstance(RGBImageData.class, dataOffset);
            request = this.m_displayList.contains(DISPLAY_TIFF) ? new TiffRequest(name, type, mode, modeID, dataOffset, dataSize, imageData) : new PngRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if ((type.equals(DISPLAY_SHADOW_FILE) || type.equals(DISPLAY_ZFILE)) && mode.equals(DISPLAY_MODE_Z)) {
            imageData = ImageData.getInstance(ZFileImage.class, dataOffset);
            request = new ZFileRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if (type.equals(DISPLAY_ZFRAMEBUFFER) && mode.equals(DISPLAY_MODE_Z)) {
            imageData = ImageData.getInstance(ZFileImage.class, dataOffset);
            request = new ZFrameBufferRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if ((outType == 1 || outType == 2) && type.equals(DISPLAY_HDR)) {
            imageData = ImageData.getInstance(AOVSingleImageData.class, dataOffset);
            request = new HDRRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else if ((outType == 3 || outType == 9 || outType == 8 || outType == 5) && type.equals(DISPLAY_HDR)) {
            imageData = ImageData.getInstance(AOVTripleImageData.class, dataOffset);
            request = new HDRRequest(name, type, mode, modeID, dataOffset, dataSize, imageData);
        } else {
            HimawariLogger.getLogger().error("[" + type + "]  \"" + mode + "\" is not supported.\n");
        }
        if (request != null) {
            this.m_displayRequests.add(request);
        }
        if (imageData != null && !this.m_ImageData.contains(imageData)) {
            this.m_ImageData.add(imageData);
        }
        this.PrepareCustomParameters(mapOfArguments, imageData);
        this.dispNames.add(name);
        return 0;
    }

    @Override
    public int ClearDisplays() {
        this.m_displayRequests.clear();
        this.m_ImageData.clear();
        return 0;
    }

    @Override
    public int OpenDisplays() {
        for (ImageData imageData : this.m_ImageData) {
            imageData.init();
        }
        for (DisplayRequest displayRequest : this.m_displayRequests) {
            displayRequest.openRequest();
        }
        return 0;
    }

    @Override
    public int CloseDisplays() {
        for (DisplayRequest i : this.m_displayRequests) {
            i.closeRequest();
        }
        return 0;
    }

    @Override
    public int DisplayBucket(IqBucket pBucket) {
        for (ImageData imageData : this.m_ImageData) {
            imageData.setBucket(pBucket);
        }
        for (DisplayRequest displayRequest : this.m_displayRequests) {
            displayRequest.display();
        }
        return 0;
    }

    @Override
    public boolean fDisplayNeeds(String var) {
        long htoken = var.hashCode();
        for (DisplayRequest i : this.m_displayRequests) {
            boolean usage;
            boolean bl = usage = i.m_modeHash == rgba || i.m_modeHash == rgb;
            if (htoken == (long)Ci && usage) {
                return true;
            }
            if (htoken == (long)Oi && usage) {
                return true;
            }
            if ((long)i.m_modeHash != htoken) continue;
            return true;
        }
        return true;
    }

    @Override
    public int Uses() {
        int Uses = 0;
        for (DisplayRequest i : this.m_displayRequests) {
            int ivar = 0;
            while (ivar < 25) {
                if ((long)i.m_modeHash == GlobalShaderExecEnv.gVariableTokens[ivar]) {
                    Uses |= 1 << ivar;
                }
                ++ivar;
            }
        }
        return Uses;
    }

    public DisplayManager() {
        me = this;
    }

    public static BufferedImage getImage() {
        if (me == null) {
            return null;
        }
        for (ImageData id : DisplayManager.me.m_ImageData) {
            if (id.getImage() instanceof BufferedImage) {
                BufferedImage image = (BufferedImage)id.getImage();
                return image;
            }
            if (!(id instanceof ZFileImage)) continue;
            ZFileImage zimage = (ZFileImage)id;
            return zimage.getZImage();
        }
        return null;
    }

    private void PrepareCustomParameters(HashMap<String, Object> mapParams, ImageData req) {
        for (Map.Entry<String, Object> param : mapParams.entrySet()) {
            SqParameterDeclaration Decl;
            p_float[] floats;
            if (param.getKey().equals("quantize")) {
                floats = (p_float[])param.getValue();
                req.m_QuantizeZeroVal = floats[0].value;
                req.m_QuantizeOneVal = floats[1].value;
                req.m_QuantizeMinVal = floats[2].value;
                req.m_QuantizeMaxVal = floats[3].value;
                continue;
            }
            if (param.getKey().equals("dither")) {
                floats = (p_float[])param.getValue();
                req.m_QuantizeDitherVal = floats[0].value;
                continue;
            }
            try {
                Decl = RiGlobal.QGetRenderContext().FindParameterDecl(param.getKey());
            }
            catch (XqException e) {
                HimawariLogger.getLogger().error(String.valueOf(e.strReason()) + "\n");
                return;
            }
            if (Decl.m_Class.getValue() != 2) {
                assert (false);
                continue;
            }
            UserParameter parameter = new UserParameter();
            parameter.name = null;
            parameter.value = 0;
            parameter.vtype = '\u0000';
            parameter.vcount = 0;
            parameter.nbytes = 0;
            parameter.name = Decl.m_strName;
            switch (Decl.m_Type.getValue()) {
                case 4: {
                    p_String[] strings = (p_String[])param.getValue();
                    GrobalDDManager.ConstructStringsParameter(Decl.m_strName, strings, Decl.m_Count, parameter);
                    break;
                }
                case 1: {
                    p_float[] floats2 = (p_float[])param.getValue();
                    GrobalDDManager.ConstructFloatsParameter(Decl.m_strName, floats2, Decl.m_Count, parameter);
                    break;
                }
                case 2: {
                    p_int[] ints = (p_int[])param.getValue();
                    GrobalDDManager.ConstructIntsParameter(Decl.m_strName, ints, Decl.m_Count, parameter);
                }
            }
            req.m_customParams.add(parameter);
        }
    }

    public static ArrayList<String> getDisplayNames() {
        if (me == null) {
            return null;
        }
        DisplayManager.me.dispNames.remove("ri.pic");
        int i = 0;
        while (i < DisplayManager.me.dispNames.size()) {
            File file = new File(DisplayManager.me.dispNames.get(i));
            DisplayManager.me.dispNames.set(i, file.getName());
            ++i;
        }
        return DisplayManager.me.dispNames;
    }
}

