/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.exception.XqException;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqCSGTreeNode;
import net.cellcomputing.himawari.library.CqCone;
import net.cellcomputing.himawari.library.CqCubicCurvesGroup;
import net.cellcomputing.himawari.library.CqCylinder;
import net.cellcomputing.himawari.library.CqDeformingPointsSurface;
import net.cellcomputing.himawari.library.CqDeformingSurface;
import net.cellcomputing.himawari.library.CqDisk;
import net.cellcomputing.himawari.library.CqHyperboloid;
import net.cellcomputing.himawari.library.CqLath;
import net.cellcomputing.himawari.library.CqLightsource;
import net.cellcomputing.himawari.library.CqLinearCurvesGroup;
import net.cellcomputing.himawari.library.CqLogRangeCheckCallback;
import net.cellcomputing.himawari.library.CqMotionModeBlock;
import net.cellcomputing.himawari.library.CqNamedParameterList;
import net.cellcomputing.himawari.library.CqObjectInstance;
import net.cellcomputing.himawari.library.CqParaboloid;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqParameterTypedUniform;
import net.cellcomputing.himawari.library.CqParameterTypedUniformArray;
import net.cellcomputing.himawari.library.CqParameterTypedVertex;
import net.cellcomputing.himawari.library.CqPoints;
import net.cellcomputing.himawari.library.CqPolygonGeneral2D;
import net.cellcomputing.himawari.library.CqPolygonPoints;
import net.cellcomputing.himawari.library.CqProcedural;
import net.cellcomputing.himawari.library.CqRenderer;
import net.cellcomputing.himawari.library.CqRiFile;
import net.cellcomputing.himawari.library.CqSphere;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSubdivision2;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqSurfaceNURBS;
import net.cellcomputing.himawari.library.CqSurfacePatchBicubic;
import net.cellcomputing.himawari.library.CqSurfacePatchBilinear;
import net.cellcomputing.himawari.library.CqSurfacePatchMeshBicubic;
import net.cellcomputing.himawari.library.CqSurfacePatchMeshBilinear;
import net.cellcomputing.himawari.library.CqSurfacePointsPolygons;
import net.cellcomputing.himawari.library.CqSurfacePolygon;
import net.cellcomputing.himawari.library.CqSurfaceSubdivisionMesh;
import net.cellcomputing.himawari.library.CqTeapot;
import net.cellcomputing.himawari.library.CqTextureMap;
import net.cellcomputing.himawari.library.CqTorus;
import net.cellcomputing.himawari.library.CqTransform;
import net.cellcomputing.himawari.library.CqTrimCurve;
import net.cellcomputing.himawari.library.CqTrimLoop;
import net.cellcomputing.himawari.library.EqShaderType;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqParameterDeclaration;
import net.cellcomputing.himawari.library.cache.RiAreaLightSourceCache;
import net.cellcomputing.himawari.library.cache.RiAtmosphereCache;
import net.cellcomputing.himawari.library.cache.RiAttributeBeginCache;
import net.cellcomputing.himawari.library.cache.RiAttributeCache;
import net.cellcomputing.himawari.library.cache.RiAttributeEndCache;
import net.cellcomputing.himawari.library.cache.RiBasisCache;
import net.cellcomputing.himawari.library.cache.RiBlobbyCache;
import net.cellcomputing.himawari.library.cache.RiBoundCache;
import net.cellcomputing.himawari.library.cache.RiClippingCache;
import net.cellcomputing.himawari.library.cache.RiColorCache;
import net.cellcomputing.himawari.library.cache.RiColorSamplesCache;
import net.cellcomputing.himawari.library.cache.RiConcatTransformCache;
import net.cellcomputing.himawari.library.cache.RiConeCache;
import net.cellcomputing.himawari.library.cache.RiCoordinateSystemCache;
import net.cellcomputing.himawari.library.cache.RiCropWindowCache;
import net.cellcomputing.himawari.library.cache.RiCurvesCache;
import net.cellcomputing.himawari.library.cache.RiCylinderCache;
import net.cellcomputing.himawari.library.cache.RiDeclareCache;
import net.cellcomputing.himawari.library.cache.RiDeformationCache;
import net.cellcomputing.himawari.library.cache.RiDepthOfFieldCache;
import net.cellcomputing.himawari.library.cache.RiDetailCache;
import net.cellcomputing.himawari.library.cache.RiDetailRangeCache;
import net.cellcomputing.himawari.library.cache.RiDiskCache;
import net.cellcomputing.himawari.library.cache.RiDisplacementCache;
import net.cellcomputing.himawari.library.cache.RiDisplayCache;
import net.cellcomputing.himawari.library.cache.RiErrorHandlerCache;
import net.cellcomputing.himawari.library.cache.RiExposureCache;
import net.cellcomputing.himawari.library.cache.RiExteriorCache;
import net.cellcomputing.himawari.library.cache.RiFormatCache;
import net.cellcomputing.himawari.library.cache.RiFrameAspectRatioCache;
import net.cellcomputing.himawari.library.cache.RiFrameBeginCache;
import net.cellcomputing.himawari.library.cache.RiFrameEndCache;
import net.cellcomputing.himawari.library.cache.RiGeneralPolygonCache;
import net.cellcomputing.himawari.library.cache.RiGeometricApproximationCache;
import net.cellcomputing.himawari.library.cache.RiGeometryCache;
import net.cellcomputing.himawari.library.cache.RiHiderCache;
import net.cellcomputing.himawari.library.cache.RiHyperboloidCache;
import net.cellcomputing.himawari.library.cache.RiIdentityCache;
import net.cellcomputing.himawari.library.cache.RiIlluminateCache;
import net.cellcomputing.himawari.library.cache.RiImagerCache;
import net.cellcomputing.himawari.library.cache.RiInteriorCache;
import net.cellcomputing.himawari.library.cache.RiLightSourceCache;
import net.cellcomputing.himawari.library.cache.RiMakeBumpCache;
import net.cellcomputing.himawari.library.cache.RiMakeCubeFaceEnvironmentCache;
import net.cellcomputing.himawari.library.cache.RiMakeLatLongEnvironmentCache;
import net.cellcomputing.himawari.library.cache.RiMakeOcclusionCache;
import net.cellcomputing.himawari.library.cache.RiMakeShadowCache;
import net.cellcomputing.himawari.library.cache.RiMakeTextureCache;
import net.cellcomputing.himawari.library.cache.RiMatteCache;
import net.cellcomputing.himawari.library.cache.RiMotionBeginVCache;
import net.cellcomputing.himawari.library.cache.RiMotionEndCache;
import net.cellcomputing.himawari.library.cache.RiNuPatchCache;
import net.cellcomputing.himawari.library.cache.RiObjectBeginCache;
import net.cellcomputing.himawari.library.cache.RiObjectEndCache;
import net.cellcomputing.himawari.library.cache.RiObjectInstanceCache;
import net.cellcomputing.himawari.library.cache.RiOpacityCache;
import net.cellcomputing.himawari.library.cache.RiOptionCache;
import net.cellcomputing.himawari.library.cache.RiOrientationCache;
import net.cellcomputing.himawari.library.cache.RiParaboloidCache;
import net.cellcomputing.himawari.library.cache.RiPatchCache;
import net.cellcomputing.himawari.library.cache.RiPatchMeshCache;
import net.cellcomputing.himawari.library.cache.RiPerspectiveCache;
import net.cellcomputing.himawari.library.cache.RiPixelFilterCache;
import net.cellcomputing.himawari.library.cache.RiPixelSamplesCache;
import net.cellcomputing.himawari.library.cache.RiPixelVarianceCache;
import net.cellcomputing.himawari.library.cache.RiPointsCache;
import net.cellcomputing.himawari.library.cache.RiPointsGeneralPolygonsCache;
import net.cellcomputing.himawari.library.cache.RiPointsPolygonsCache;
import net.cellcomputing.himawari.library.cache.RiPolygonCache;
import net.cellcomputing.himawari.library.cache.RiProceduralCache;
import net.cellcomputing.himawari.library.cache.RiProjectionCache;
import net.cellcomputing.himawari.library.cache.RiQuantizeCache;
import net.cellcomputing.himawari.library.cache.RiReadArchiveCache;
import net.cellcomputing.himawari.library.cache.RiRelativeDetailCache;
import net.cellcomputing.himawari.library.cache.RiReverseOrientationCache;
import net.cellcomputing.himawari.library.cache.RiRotateCache;
import net.cellcomputing.himawari.library.cache.RiScaleCache;
import net.cellcomputing.himawari.library.cache.RiScreenWindowCache;
import net.cellcomputing.himawari.library.cache.RiShadingInterpolationCache;
import net.cellcomputing.himawari.library.cache.RiShadingRateCache;
import net.cellcomputing.himawari.library.cache.RiShutterCache;
import net.cellcomputing.himawari.library.cache.RiSidesCache;
import net.cellcomputing.himawari.library.cache.RiSkewCache;
import net.cellcomputing.himawari.library.cache.RiSolidBeginCache;
import net.cellcomputing.himawari.library.cache.RiSolidEndCache;
import net.cellcomputing.himawari.library.cache.RiSphereCache;
import net.cellcomputing.himawari.library.cache.RiSubdivisionMeshCache;
import net.cellcomputing.himawari.library.cache.RiSurfaceCache;
import net.cellcomputing.himawari.library.cache.RiTextureCoordinatesCache;
import net.cellcomputing.himawari.library.cache.RiTorusCache;
import net.cellcomputing.himawari.library.cache.RiTransformBeginCache;
import net.cellcomputing.himawari.library.cache.RiTransformCache;
import net.cellcomputing.himawari.library.cache.RiTransformEndCache;
import net.cellcomputing.himawari.library.cache.RiTransformPointsCache;
import net.cellcomputing.himawari.library.cache.RiTranslateCache;
import net.cellcomputing.himawari.library.cache.RiTrimCurveCache;
import net.cellcomputing.himawari.library.cache.RiWorldBeginCache;
import net.cellcomputing.himawari.library.cache.RiWorldEndCache;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqRandom;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.parser.Parser;
import net.cellcomputing.himawari.parser.keywords.AbstractKeywordParser;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class RendermanInterface {
    static CqRandom worldrand = new CqRandom();
    static HimawariLogger logger = HimawariLogger.getLogger();
    public static final String RI_FRAMEBUFFER = "framebuffer";
    public static final String RI_FILE = "file";
    public static final String RI_RGB = "rgb";
    public static final String RI_RGBA = "rgba";
    public static final String RI_RGBZ = "rgbz";
    public static final String RI_RGBAZ = "rgbaz";
    public static final String RI_A = "a";
    public static final String RI_Z = "z";
    public static final String RI_AZ = "az";
    public static final String RI_MERGE = "merge";
    public static final String RI_ORIGIN = "origin";
    public static final String RI_PERSPECTIVE = "perspective";
    public static final String RI_ORTHOGRAPHIC = "orthographic";
    public static final String RI_HIDDEN = "hidden";
    public static final String RI_PAINT = "paint";
    public static final String RI_CONSTANT = "constant";
    public static final String RI_SMOOTH = "smooth";
    public static final String RI_FLATNESS = "flatness";
    public static final String RI_FOV = "fov";
    public static final String RI_AMBIENTLIGHT = "ambientlight";
    public static final String RI_POINTLIGHT = "pointlight";
    public static final String RI_DISTANTLIGHT = "distantlight";
    public static final String RI_SPOTLIGHT = "spotlight";
    public static final String RI_INTENSITY = "intensity";
    public static final String RI_LIGHTCOLOR = "lightcolor";
    public static final String RI_FROM = "from";
    public static final String RI_TO = "to";
    public static final String RI_CONEANGLE = "coneangle";
    public static final String RI_CONEDELTAANGLE = "conedeltaangle";
    public static final String RI_BEAMDISTRIBUTION = "beamdistribution";
    public static final String RI_MATTE = "matte";
    public static final String RI_METAL = "metal";
    public static final String RI_PLASTIC = "plastic";
    public static final String RI_PAINTEDPLASTIC = "paintedplastic";
    public static final String RI_KA = "ka";
    public static final String RI_KD = "kd";
    public static final String RI_KS = "ks";
    public static final String RI_ROUGHNESS = "roughness";
    public static final String RI_SPECULARCOLOR = "specularcolor";
    public static final String RI_DEPTHCUE = "depthcue";
    public static final String RI_FOG = "fog";
    public static final String RI_BUMPY = "bumpy";
    public static final String RI_MINDISTANCE = "mindistance";
    public static final String RI_MAXDISTANCE = "maxdistance";
    public static final String RI_BACKGROUND = "background";
    public static final String RI_DISTANCE = "distance";
    public static final String RI_RASTER = "raster";
    public static final String RI_SCREEN = "screen";
    public static final String RI_CAMERA = "camera";
    public static final String RI_WORLD = "world";
    public static final String RI_OBJECT = "object";
    public static final String RI_INSIDE = "inside";
    public static final String RI_OUTSIDE = "outside";
    public static final String RI_LH = "lh";
    public static final String RI_RH = "rh";
    public static final String RI_P = "P";
    public static final String RI_PZ = "Pz";
    public static final String RI_PW = "Pw";
    public static final String RI_N = "N";
    public static final String RI_NP = "Np";
    public static final String RI_CS = "Cs";
    public static final String RI_OS = "Os";
    public static final String RI_S = "s";
    public static final String RI_T = "t";
    public static final String RI_ST = "st";
    public static final String RI_BILINEAR = "bilinear";
    public static final String RI_BICUBIC = "bicubic";
    public static final String RI_CUBIC = "cubic";
    public static final String RI_LINEAR = "linear";
    public static final String RI_PRIMITIVE = "primitive";
    public static final String RI_INTERSECTION = "intersection";
    public static final String RI_UNION = "union";
    public static final String RI_DIFFERENCE = "difference";
    public static final String RI_WRAP = "wrap";
    public static final String RI_NOWRAP = "nowrap";
    public static final String RI_PERIODIC = "periodic";
    public static final String RI_NONPERIODIC = "nonperiodic";
    public static final String RI_CLAMP = "clamp";
    public static final String RI_BLACK = "black";
    public static final String RI_IGNORE = "ignore";
    public static final String RI_PRINT = "print";
    public static final String RI_ABORT = "abort";
    public static final String RI_HANDLER = "handler";
    public static final String RI_IDENTIFIER = "identifier";
    public static final String RI_NAME = "name";
    public static final String RI_CURRENT = "current";
    public static final String RI_SHADER = "shader";
    public static final String RI_EYE = "eye";
    public static final String RI_NDC = "ndc";
    public static final String RI_AMPLITUDE = "amplitude";
    public static final String RI_COMMENT = "comment";
    public static final String RI_CONSTANTWIDTH = "constantwidth";
    public static final String RI_KR = "kr";
    public static final String RI_SHINYMETAL = "shinymetal";
    public static final String RI_STRUCTURE = "structure";
    public static final String RI_TEXTURENAME = "texturename";
    public static final String RI_VERBATIM = "verbatim";
    public static final String RI_WIDTH = "width";
    public static final float[][] RiBezierBasis = new float[][]{{-1.0f, 3.0f, -3.0f, 1.0f}, {3.0f, -6.0f, 3.0f, 0.0f}, {-3.0f, 3.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f}};
    public static final float[][] RiBSplineBasis = new float[][]{{-0.16666667f, 0.5f, -0.5f, 0.16666667f}, {0.5f, -1.0f, 0.5f, 0.0f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.16666667f, 0.6666667f, 0.16666667f, 0.0f}};
    public static final float[][] RiCatmullRomBasis = new float[][]{{-0.5f, 1.5f, -1.5f, 0.5f}, {1.0f, -2.5f, 2.0f, -0.5f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}};
    public static final float[][] RiHermiteBasis = new float[][]{{2.0f, 1.0f, -2.0f, 1.0f}, {-3.0f, -2.0f, 3.0f, -1.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f}};
    public static final float[][] RiPowerBasis = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
    public static long RIH_S = "s".hashCode();
    public static long RIH_T = "t".hashCode();
    public static long RIH_ST = "st".hashCode();
    public static long RIH_CS = "Cs".hashCode();
    public static long RIH_OS = "Os".hashCode();
    public static long RIH_P = "P".hashCode();
    public static long RIH_PZ = "Pz".hashCode();
    public static long RIH_PW = "Pw".hashCode();
    public static long RIH_N = "N".hashCode();
    public static long RIH_NP = "Np".hashCode();
    public static long RIH_DEPTHFILTER = "depthfilter".hashCode();
    public static long RIH_JITTER = "jitter".hashCode();
    public static long RIH_RENDER = "render".hashCode();
    public static long RIH_INDIRECT = "indirect".hashCode();
    public static long RIH_LIGHT = "light".hashCode();
    public static long RIH_VISIBILITY = "visibility".hashCode();
    public static int RiLastError = 0;
    public static String[][] StandardParameters = new String[][]{{"Ka", "uniform float"}, {"Kd", "uniform float"}, {"Ks", "uniform float"}, {"Kr", "uniform float"}, {"roughness", "uniform float"}, {"texturename", "uniform string"}, {"specularcolor", "uniform color"}, {"intensity", "uniform float"}, {"lightcolor", "uniform color"}, {"from", "uniform point"}, {"to", "uniform point"}, {"coneangle", "uniform float"}, {"conedeltaangle", "uniform float"}, {"beamdistribution", "uniform float"}, {"mindistance", "uniform float"}, {"maxdistance", "uniform float"}, {"distance", "uniform float"}, {"background", "uniform color"}, {"fov", "uniform float"}, {"P", "vertex point"}, {"Pz", "vertex point"}, {"Pw", "vertex hpoint"}, {"N", "varying normal"}, {"Ng", "varying normal"}, {"Np", "uniform normal"}, {"Cs", "varying color"}, {"Os", "varying color"}, {"s", "varying float"}, {"t", "varying float"}, {"st", "varying float[2]"}, {"gridsize", "uniform integer"}, {"texturememory", "uniform integer"}, {"bucketsize", "uniform integer[2]"}, {"eyesplits", "uniform integer"}, {"shader", "uniform string"}, {"archive", "uniform string"}, {"texture", "uniform string"}, {"display", "uniform string"}, {"dsolibs", "uniform string"}, {"plugin", "uniform string"}, {"auto_shadows", "uniform string"}, {"endofframe", "uniform integer"}, {"offset", "uniform float"}, {"renderinfo", "uniform integer"}, {"sphere", "uniform float"}, {"coordinatesystem", "uniform string"}, {"shadows", "uniform string"}, {"shadowmapsize", "uniform integer[2]"}, {"shadowangle", "uniform float"}, {"shadowmapname", "uniform string"}, {"shadow_shadingrate", "uniform float"}, {"name", "uniform string"}, {"shadinggroup", "uniform string"}, {"sense", "uniform string"}, {"compression", "uniform string"}, {"quality", "uniform integer"}, {"bias0", "uniform float"}, {"bias1", "uniform float"}, {"bias", "uniform float"}, {"jitter", "uniform integer"}, {"depthfilter", "uniform string"}, {"width", "varying float"}, {"constantwidth", "constant float"}, {"binary", "uniform integer"}, {"procedural", "uniform string"}, {"quantize", "uniform float[4]"}, {"dither", "uniform float"}, {"interpolateboundary", "uniform integer"}, {"zthreshold", "uniform color"}, new String[2]};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public static int BuildParameterList(Object[] pArgs, STLVector<String> aTokens, STLVector<Object> aValues) {
        int count = 0;
        aTokens.clear();
        aValues.clear();
        if (pArgs != null) {
            while (count < pArgs.length / 2) {
                aTokens.add((String)pArgs[2 * count]);
                aValues.add(pArgs[2 * count + 1]);
                ++count;
            }
        }
        return count;
    }

    public static boolean ValidateState(int count, int ... STATE) {
        int currentState = 0;
        if (RiGlobal.QGetRenderContext() != null && RiGlobal.QGetRenderContext().pconCurrent() != null) {
            currentState = RiGlobal.QGetRenderContext().pconCurrent().Type().getValue();
        }
        int i = 0;
        while (i < count) {
            int state = STATE[i];
            if (currentState == state) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final String GetStateAsString() {
        int currentState = 0;
        if (RiGlobal.QGetRenderContext() != null && RiGlobal.QGetRenderContext().pconCurrent() != null) {
            currentState = RiGlobal.QGetRenderContext().pconCurrent().Type().getValue();
        }
        switch (currentState) {
            case 0: {
                return "Outside";
            }
            case 1: {
                return "BeginEnd";
            }
            case 2: {
                return "Frame";
            }
            case 3: {
                return "World";
            }
            case 4: {
                return "Attribute";
            }
            case 5: {
                return "Transform";
            }
            case 6: {
                return "Solid";
            }
            case 7: {
                return "Object";
            }
            case 8: {
                return "Motion";
            }
        }
        return "";
    }

    public static String RiDeclare(String name, String declaration) {
        if (name == null || declaration == null) {
            return null;
        }
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDeclareCache(name, declaration));
            return null;
        }
        if (!RendermanInterface.ValidateState(9, 0, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiDeclare [" + RendermanInterface.GetStateAsString() + "]\n");
            return null;
        }
        String strName = name;
        String strDecl = declaration;
        RiGlobal.QGetRenderContext().AddParameterDecl(strName, strDecl);
        return null;
    }

    public static void SetDefaultRiOptions() {
        String rootPath;
        File tmp = new File(".");
        String acPath = tmp.getAbsoluteFile().getParentFile().getPath();
        String g_shader_path = rootPath = acPath.substring(0, acPath.lastIndexOf("\\") + 1);
        String g_archive_path = rootPath;
        String g_texture_path = rootPath;
        String g_display_path = rootPath;
        String g_dso_path = rootPath;
        String g_procedural_path = rootPath;
        String g_plugin_path = rootPath;
        g_shader_path = g_shader_path.concat("shaders");
        g_archive_path = g_archive_path.concat("archives");
        g_texture_path = g_texture_path.concat("textures");
        g_display_path = g_display_path.concat("bin");
        g_dso_path = g_dso_path.concat("dsos");
        g_procedural_path = g_procedural_path.concat("procedures");
        g_plugin_path = g_plugin_path.concat("plugins");
        p_String[] popt = new p_String[]{new p_String()};
        String[] pOption = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", RI_SHADER);
        if (pOption == null) {
            popt[0].value = System.getenv("HIMAWARI_SHADER_PATH") != null ? System.getenv("HIMAWARI_SHADER_PATH") : g_shader_path;
            RendermanInterface.RiOption("searchpath", RI_SHADER, popt, null);
        }
        if ((pOption = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", "archive")) == null) {
            popt[0].value = System.getenv("HIMAWARI_ARCHIVE_PATH") != null ? System.getenv("HIMAWARI_ARCHIVE_PATH") : g_archive_path;
            RendermanInterface.RiOption("searchpath", "archive", popt, null);
        }
        if ((pOption = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", "texture")) == null) {
            popt[0].value = System.getenv("HIMAWARI_TEXTURE_PATH") != null ? System.getenv("HIMAWARI_TEXTURE_PATH") : g_texture_path;
            RendermanInterface.RiOption("searchpath", "texture", popt, null);
        }
        if ((pOption = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", "display")) == null) {
            popt[0].value = System.getenv("HIMAWARI_DISPLAY_PATH") != null ? System.getenv("HIMAWARI_DISPLAY_PATH") : g_display_path;
            RendermanInterface.RiOption("searchpath", "display", popt, null);
        }
        if ((pOption = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", "dsolibs")) == null) {
            popt[0].value = System.getenv("HIMAWARI_DSO_PATH") != null ? System.getenv("HIMAWARI_DSO_PATH") : g_dso_path;
            RendermanInterface.RiOption("searchpath", "dsolibs", popt, null);
        }
        if ((pOption = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", "procedural")) == null) {
            popt[0].value = System.getenv("HIMAWARI_PROCEDURAL_PATH") != null ? System.getenv("HIMAWARI_PROCEDURAL_PATH") : g_procedural_path;
            RendermanInterface.RiOption("searchpath", "procedural", popt, null);
        }
        if ((pOption = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", "plugin")) == null) {
            popt[0].value = System.getenv("HIMAWARI_PLUGIN_PATH") != null ? System.getenv("HIMAWARI_PLUGIN_PATH") : g_plugin_path;
            RendermanInterface.RiOption("searchpath", "plugin", popt, null);
        }
        RendermanInterface.RiDisplay("ri.pic", RI_FILE, RI_RGBA, new Object[]{null});
    }

    public static void RiBegin(String name) {
        if (!RendermanInterface.ValidateState(1, 0)) {
            logger.error("Invalid state for RiBegin [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QSetRenderContext(new CqRenderer());
        RiGlobal.QGetRenderContext().Initialise();
        RiGlobal.QGetRenderContext().BeginMainModeBlock();
        RiGlobal.QGetRenderContext().ptransSetTime(new CqMatrix());
        RiGlobal.QGetRenderContext().SetCameraTransform(RiGlobal.QGetRenderContext().ptransCurrent());
        RiGlobal.Lightsource_stack.clear();
        RiGlobal.QGetRenderContext().optCurrent().ClearOptions();
        int param = 0;
        while (StandardParameters[param][0] != null) {
            RendermanInterface.RiDeclare(StandardParameters[param][0], StandardParameters[param][1]);
            ++param;
        }
        RendermanInterface.SetDefaultRiOptions();
        IqShader pDefaultSurfaceShader = RiGlobal.QGetRenderContext().getDefaultSurfaceShader();
        RiGlobal.QGetRenderContext().pattrWriteCurrent().SetpshadSurface(pDefaultSurfaceShader, RiGlobal.QGetRenderContext().Time());
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Orientation")[0].value = 0;
    }

    public static void RiEnd() {
        if (!RendermanInterface.ValidateState(1, 1)) {
            logger.error("Invalid state for RiEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().EndMainModeBlock();
        CqTextureMap.FlushCache();
        RiGlobal.Lightsource_stack.clear();
        RiGlobal.QGetRenderContext().destruct();
        RiGlobal.QSetRenderContext(null);
    }

    public static void RiFrameBegin(int number) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiFrameBeginCache(number));
            return;
        }
        if (!RendermanInterface.ValidateState(1, 1)) {
            logger.error("Invalid state for RiFrameBegin [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().Stats().InitialiseFrame();
        RiGlobal.QGetRenderContext().Stats().StartFrameTimer();
        RiGlobal.QGetRenderContext().BeginFrameModeBlock();
        RiGlobal.QGetRenderContext().SetCurrentFrame(number);
        CqCSGTreeNode.SetRequired(false);
        worldrand.Reseed(545);
    }

    public static void RiFrameEnd() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiFrameEndCache());
            return;
        }
        if (!RendermanInterface.ValidateState(1, 2)) {
            logger.error("Invalid state for RiFrameEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().EndFrameModeBlock();
        RiGlobal.QGetRenderContext().ClearDisplayRequests();
    }

    public static void RiWorldBegin() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiWorldBeginCache());
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiWorldBegin [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (RiGlobal.QGetRenderContext().pPreWorldFunction() != null) {
            try {
                RiGlobal.QGetRenderContext().pPreWorldFunction().invoke(null, new Object[0]);
            }
            catch (Exception e) {
                HimawariLogger.outputException(e);
            }
        }
        RiGlobal.QGetRenderContext().Stats().StartFrameTimer();
        RiGlobal.QGetRenderContext().Stats().MakeParse().Start();
        if (!RiGlobal.QGetRenderContext().optCurrent().FrameAspectRatioCalled()) {
            float PAR = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"PixelAspectRatio", (int)0).value;
            float resH = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value;
            float resV = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value;
            RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"FrameAspectRatio", (int)0).value = resH * PAR / resV;
        }
        if (!RiGlobal.QGetRenderContext().optCurrent().ScreenWindowCalled()) {
            float fFAR = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value;
            if ((double)fFAR >= 1.0) {
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)0).value = -fFAR;
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)1).value = fFAR;
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)2).value = 1.0f;
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)3).value = -1.0f;
            } else {
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)0).value = -1.0f;
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)1).value = 1.0f;
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)2).value = (float)(1.0 / (double)fFAR);
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)3).value = (float)(-1.0 / (double)fFAR);
            }
        }
        CqTransform current = RiGlobal.QGetRenderContext().ptransCurrent();
        CqTransform camera = new CqTransform();
        RiGlobal.QGetRenderContext().SetCameraTransform(camera);
        RiGlobal.QGetRenderContext().GetCameraTransform().ResetTransform(current.matObjectToWorld(current.Time(0)), current.GetHandedness(RiGlobal.QGetRenderContext().Time()));
        RiGlobal.QGetRenderContext().BeginWorldModeBlock();
        if (current.cTimes() > 1) {
            CqMatrix matOpenShutterInverse = current.matObjectToWorld(current.Time(0));
            matOpenShutterInverse = matOpenShutterInverse.Inverse();
            current.SetCurrentTransform(current.Time(0), new CqMatrix());
            int i = 1;
            while (i < current.cTimes()) {
                current.SetCurrentTransform(current.Time(i), matOpenShutterInverse.multiply(current.matObjectToWorld(current.Time(i))));
                ++i;
            }
            RiGlobal.QGetRenderContext().pconCurrent().ptransSetCurrent(current);
            CqTransform newTrans = new CqTransform(current);
            RiGlobal.QGetRenderContext().SetDefObjTransform(newTrans);
        } else {
            RiGlobal.QGetRenderContext().ptransSetTime(new CqMatrix());
            CqTransform newTrans = new CqTransform();
            RiGlobal.QGetRenderContext().SetDefObjTransform(newTrans);
        }
        RiGlobal.QGetRenderContext().SetWorldBegin();
        RiGlobal.QGetRenderContext().optCurrent().InitialiseCamera();
        RiGlobal.QGetRenderContext().pImage().SetImage();
        worldrand.Reseed(545);
    }

    public static void RiWorldEnd() {
        int[] poptGridSize;
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiWorldEndCache());
            return;
        }
        if (!RendermanInterface.ValidateState(1, 3)) {
            logger.error("Invalid state for RiWorldEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        boolean fFailed = false;
        if (RiGlobal.QGetRenderContext().pPreRenderFunction() != null) {
            try {
                RiGlobal.QGetRenderContext().pPreRenderFunction().invoke(null, new Object[0]);
            }
            catch (Exception e) {
                HimawariLogger.outputException(e);
            }
        }
        RiGlobal.QGetRenderContext().Stats().MakeParse().Stop();
        int[] poptVerbose = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("statistics", "renderinfo");
        if (poptVerbose != null) {
            RiGlobal.QGetRenderContext().Stats().PrintInfo();
        }
        if ((poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "gridsize")) != null) {
            if (poptGridSize[0] <= 0) {
                HimawariLogger.getLogger().warning("WARNING: BucketSize under 0 cast to 256\n");
                poptGridSize[0] = 256;
            }
            RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"SqrtGridSize", (int)0).value = (float)Math.sqrt(poptGridSize[0]);
        }
        if (RiGlobal.QGetRenderContext().pRaytracer() != null) {
            RiGlobal.QGetRenderContext().pRaytracer().Finalise();
        }
        try {
            RiGlobal.QGetRenderContext().RenderWorld();
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            logger.error(e.toString());
            fFailed = true;
        }
        RiGlobal.QGetRenderContext().EndWorldModeBlock();
        RiGlobal.QGetRenderContext().Stats().StopFrameTimer();
        if (!fFailed) {
            int verbosity = 0;
            int[] poptEndofframe = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("statistics", "endofframe");
            if (poptEndofframe != null) {
                verbosity = poptEndofframe[0];
            }
            RiGlobal.QGetRenderContext().Stats().PrintStats(verbosity);
        }
        RiGlobal.QGetRenderContext().SetWorldBegin(false);
    }

    public static void RiFormat(int xresolution, int yresolution, float pixelaspectratio) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiFormatCache(xresolution, yresolution, pixelaspectratio));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiFormat [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"Resolution", (int)0).value = xresolution;
        RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"Resolution", (int)1).value = yresolution;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"PixelAspectRatio", (int)0).value = (float)((double)pixelaspectratio < 0.0 ? 1.0 : (double)pixelaspectratio);
        RiGlobal.QGetRenderContext().optCurrent().CallFormat();
    }

    public static void RiFrameAspectRatio(float frameratio) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiFrameAspectRatioCache(frameratio));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiFrameAspectRatio [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("frameratio");
        if (!RiGlobal.CheckMinMax(frameratio, 0.0f, Float.MAX_VALUE, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.error("RiFrameAspectRatio: Invalid RiFrameAspectRatio, aborting\n");
            return;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"FrameAspectRatio", (int)0).value = frameratio;
        RiGlobal.QGetRenderContext().optCurrent().CallFrameAspectRatio();
    }

    public static void RiScreenWindow(float left, float right, float bottom, float top) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiScreenWindowCache(left, right, bottom, top));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiScreenWindow [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)0).value = left;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)1).value = right;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)2).value = top;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"ScreenWindow", (int)3).value = bottom;
        RiGlobal.QGetRenderContext().optCurrent().CallScreenWindow();
    }

    public static void RiCropWindow(float left, float right, float top, float bottom) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiCropWindowCache(left, right, top, bottom));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiCropWindow [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("left");
        if (!RiGlobal.CheckMinMax(left, 0.0f, 1.0f, rc)) {
            valid = false;
        }
        rc.set("right");
        if (!RiGlobal.CheckMinMax(right, 0.0f, 1.0f, rc)) {
            valid = false;
        }
        rc.set("top");
        if (!RiGlobal.CheckMinMax(top, 0.0f, 1.0f, rc)) {
            valid = false;
        }
        rc.set("bottom");
        if (!RiGlobal.CheckMinMax(bottom, 0.0f, 1.0f, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.error("Invalid RiCropWindow, aborting \n");
            return;
        }
        if (left >= right) {
            logger.error("Invalid Value for left. Value exceeded upper right \n");
            left = 0.0f;
            right = 1.0f;
        }
        if (top >= bottom) {
            logger.error("Invalid Value for top. Value exceeded upper bottom \n");
            top = 0.0f;
            bottom = 1.0f;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"CropWindow", (int)0).value = left;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"CropWindow", (int)1).value = right;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"CropWindow", (int)2).value = top;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"CropWindow", (int)3).value = bottom;
    }

    public static void RiProjection(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiProjectionV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiProjectionV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiProjectionCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiProjection [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (name.compareTo(RI_PERSPECTIVE) == 0) {
            RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"Projection", (int)0).value = 1;
        } else if (name.compareTo(RI_ORTHOGRAPHIC) == 0) {
            RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"Projection", (int)0).value = 0;
        } else if (name != RiGlobal.RI_NULL) {
            logger.error("RiProjection: Invalid projection: \"" + name + "\"\n");
            return;
        }
        int i = 0;
        while (i < count) {
            String token = tokens[i];
            Object value = values[i];
            if (token.compareTo(RI_FOV) == 0) {
                RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"FOV", (int)0).value = ((p_float[])value)[0].value;
            }
            ++i;
        }
        RiGlobal.QGetRenderContext().ptransSetTime(new CqMatrix());
    }

    public static void RiClipping(float cnear, float cfar) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiClippingCache(cnear, cfar));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiClipping [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("near");
        if (!RiGlobal.CheckMinMax(cnear, 1.1920929E-7f, cfar, rc)) {
            valid = false;
        }
        rc.set("far");
        if (!RiGlobal.CheckMinMax(cfar, cnear, Float.MAX_VALUE, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.error("RiClipping: Invalid RiClipping, clipping planes set to RI_EPSILON, RI_INFINITY\n");
            cnear = 1.1920929E-7f;
            cfar = Float.MAX_VALUE;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"Clipping", (int)0).value = cnear;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"Clipping", (int)1).value = cfar;
    }

    public static void RiDepthOfField(float fstop, float focallength, float focaldistance) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDepthOfFieldCache(fstop, focallength, focaldistance));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiDepthOfField [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("fstop");
        if (!RiGlobal.CheckMinMax(fstop, 0.0f, Float.MAX_VALUE, rc)) {
            valid = false;
        }
        rc.set("focallength");
        if (!RiGlobal.CheckMinMax(focallength, 0.0f, Float.MAX_VALUE, rc)) {
            valid = false;
        }
        rc.set("focaldistance");
        if (!RiGlobal.CheckMinMax(focaldistance, 0.0f, Float.MAX_VALUE, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.warning("RiDepthOfField: Invalid DepthOfField, DepthOfField ignored\n");
            return;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"DepthOfField", (int)0).value = fstop;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"DepthOfField", (int)1).value = focallength;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"DepthOfField", (int)2).value = focaldistance;
        RiGlobal.QGetRenderContext().SetDepthOfFieldData(fstop, focallength, focaldistance);
    }

    public static void RiShutter(float opentime, float closetime) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiShutterCache(opentime, closetime));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiShutter [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"Shutter", (int)0).value = opentime;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"Shutter", (int)1).value = closetime;
    }

    public static void RiPixelVariance(float variance) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPixelVarianceCache(variance));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiPixelVariance [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("variance");
        if (!RiGlobal.CheckMinMax(variance, 0.0f, Float.MAX_VALUE, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.warning("RiPixelVariance: Invalid PixelVariance, PixelVariance set to 0\n");
            variance = 0.0f;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"PixelVariance", (int)0).value = variance;
    }

    public static void RiPixelSamples(float xsamples, float ysamples) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPixelSamplesCache(xsamples, ysamples));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiPixelSamples [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("xsamples");
        if (!RiGlobal.CheckMinMax(xsamples, 1.0f, 1000.0f, rc)) {
            valid = false;
        }
        rc.set("ysamples");
        if (!RiGlobal.CheckMinMax(ysamples, 1.0f, 1000.0f, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.warning("RiPixelSamples: Invalid PixelSamples, PixelSamples set to 1, 1\n");
            xsamples = 1.0f;
            ysamples = 1.0f;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"PixelSamples", (int)0).value = (int)xsamples;
        RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"PixelSamples", (int)1).value = (int)ysamples;
    }

    public static void RiPixelFilter(Method function, float xwidth, float ywidth) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPixelFilterCache(function, xwidth, ywidth));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiPixelFilter [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("xwidth");
        if (!RiGlobal.CheckMinMax(xwidth, 1.0f, 1000.0f, rc)) {
            valid = false;
        }
        rc.set("ywidth");
        if (!RiGlobal.CheckMinMax(ywidth, 1.0f, 1000.0f, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.warning("RiPixelFilter: Invalid RiPixelFilter, RiPixelFilter set to 1, 1\n");
            xwidth = 1.0f;
            ywidth = 1.0f;
        }
        RiGlobal.QGetRenderContext().optCurrent().SetfuncFilter(function);
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"FilterWidth", (int)0).value = xwidth;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"FilterWidth", (int)1).value = ywidth;
    }

    public static void RiExposure(float gain, float gamma) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiExposureCache(gain, gamma));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiExposure [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"Exposure", (int)0).value = gain;
        RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"Exposure", (int)1).value = gamma;
    }

    public static void RiImager(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiImagerV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiImagerV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiImagerCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiImager [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (name.length() != 0) {
            RiGlobal.QGetRenderContext().optCurrent().GetStringOptionWriteIndex((String)"System", (String)"Imager", (int)0).value = name;
            RiGlobal.QGetRenderContext().optCurrent().LoadImager(name);
            int i = 0;
            while (i < count) {
                String token = tokens[i];
                Object value = values[i];
                RiGlobal.QGetRenderContext().optCurrent().SetValueImager(token, value);
                ++i;
            }
        }
    }

    public static void RiQuantize(String type, int one, int min, int max, float ditheramplitude) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiQuantizeCache(type, one, min, max, ditheramplitude));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiQuantize [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (type.compareTo(RI_RGBA) == 0) {
            p_float[] pColorQuantize = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWrite("Quantize", "Color");
            pColorQuantize[0].value = one;
            pColorQuantize[1].value = min;
            pColorQuantize[2].value = max;
            pColorQuantize[3].value = ditheramplitude;
        } else if (type.compareTo(RI_Z) == 0) {
            p_float[] pDepthQuantize = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWrite("Quantize", "Depth");
            pDepthQuantize[0].value = one;
            pDepthQuantize[1].value = min;
            pDepthQuantize[2].value = max;
            pDepthQuantize[3].value = ditheramplitude;
        } else {
            CqNamedParameterList pOption = RiGlobal.QGetRenderContext().optCurrent().pOptionWrite("Quantize");
            if (pOption != null) {
                CqParameterTypedUniformArray<p_float, p_float> pQuant = new CqParameterTypedUniformArray<p_float, p_float>(type, 4, new EqVariableType(1), p_float.class, p_float.class);
                pQuant.pValue_get((int)0, (int)0).value = one;
                pQuant.pValue_get((int)0, (int)1).value = min;
                pQuant.pValue_get((int)0, (int)2).value = max;
                pQuant.pValue_get((int)0, (int)3).value = ditheramplitude;
                pOption.AddParameter(pQuant);
            }
        }
    }

    public static void RiDisplay(String name, String type, String mode, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiDisplayV(name, type, mode, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiDisplayV(String name, String type, String mode, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDisplayCache(name, type, mode, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiDisplay [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        String strName = name;
        String strType = type;
        RiGlobal.QGetRenderContext().optCurrent().GetStringOptionWriteIndex((String)"System", (String)"DisplayName", (int)0).value = strName;
        RiGlobal.QGetRenderContext().optCurrent().GetStringOptionWriteIndex((String)"System", (String)"DisplayType", (int)0).value = strType;
        int eValue = 0;
        int index = 0;
        int dataOffset = 0;
        int dataSize = 0;
        if (index < mode.length() && mode.startsWith(RI_RGB, index)) {
            eValue |= 1;
            dataSize += 3;
            index += RI_RGB.length();
        }
        if (index < mode.length() && mode.startsWith(RI_A, index)) {
            eValue |= 2;
            ++dataSize;
            index += RI_A.length();
        }
        if (index < mode.length() && mode.startsWith(RI_Z, index)) {
            eValue |= 4;
            ++dataSize;
            index += RI_Z.length();
        }
        if (eValue == 0) {
            try {
                dataOffset = RiGlobal.QGetRenderContext().RegisterOutputData(mode);
            }
            catch (XqException e) {
                HimawariLogger.outputException(e);
            }
            dataSize = RiGlobal.QGetRenderContext().OutputDataSamples(mode);
        }
        HashMap<String, Object> mapOfArguments = new HashMap<String, Object>();
        int i = 0;
        while (i < count) {
            mapOfArguments.put(tokens[i], values[i]);
            ++i;
        }
        if (!strName.matches("\\+?[A-Za-z0-9\\.\\-_ :\\/\\\\]+")) {
            HimawariLogger.getLogger().warning("Invalid Display name:\"" + strName + "\".\n");
            return;
        }
        if (strName.charAt(0) == '+') {
            int iMode;
            RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"DisplayMode", (int)0).value = iMode = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value | eValue;
            strName = strName.substring(1);
        } else {
            RiGlobal.QGetRenderContext().ClearDisplayRequests();
            RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionWriteIndex((String)"System", (String)"DisplayMode", (int)0).value = eValue;
        }
        RiGlobal.QGetRenderContext().AddDisplayRequest(strName, strType, mode, eValue, dataOffset, dataSize, mapOfArguments);
    }

    public static float RiGaussianFilter(float x, float y, float xwidth, float ywidth) {
        x = (float)((double)x * (2.0 / (double)xwidth));
        y = (float)((double)y * (2.0 / (double)ywidth));
        return (float)Math.exp(-2.0 * (double)(x * x + y * y));
    }

    public static float RiBoxFilter(float x, float y, float xwidth, float ywidth) {
        return (float)Math.min((double)Math.abs(x) <= (double)xwidth / 2.0 ? 1.0 : 0.0, (double)Math.abs(y) <= (double)ywidth / 2.0 ? 1.0 : 0.0);
    }

    public static float RiTriangleFilter(float x, float y, float xwidth, float ywidth) {
        float hxw = (float)((double)xwidth / 2.0);
        float hyw = (float)((double)ywidth / 2.0);
        float absx = Math.abs(x);
        float absy = Math.abs(y);
        return (float)Math.min(absx <= hxw ? (double)((hxw - absx) / hxw) : 0.0, absy <= hyw ? (double)((hyw - absy) / hyw) : 0.0);
    }

    public static float RiCatmullRomFilter(float x, float y, float xwidth, float ywidth) {
        float r2 = x * x + y * y;
        float r = (float)Math.sqrt(r2);
        return (float)((double)r >= 2.0 ? 0.0 : ((double)r < 1.0 ? 3.0 * (double)r * (double)r2 - 5.0 * (double)r2 + 2.0 : (double)(-r * r2) + 5.0 * (double)r2 - 8.0 * (double)r + 4.0));
    }

    public static float RiSincFilter(float x, float y, float xwidth, float ywidth) {
        if ((double)x != 0.0) {
            x *= (float)Math.PI;
            x = (float)(Math.cos(0.5 * (double)x / (double)xwidth) * Math.sin(x) / (double)x);
        } else {
            x = 1.0f;
        }
        if ((double)y != 0.0) {
            y *= (float)Math.PI;
            y = (float)(Math.cos(0.5 * (double)y / (double)ywidth) * Math.sin(y) / (double)y);
        } else {
            y = 1.0f;
        }
        return x * y;
    }

    public static float RiDiskFilter(float x, float y, float xwidth, float ywidth) {
        double xx = x * x;
        double yy = y * y;
        double d = xx / (double)((xwidth = (float)((double)xwidth * 0.5)) * xwidth) + yy / (double)((ywidth = (float)((double)ywidth * 0.5)) * ywidth);
        if (d < 1.0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float RiBesselFilter(float x, float y, float xwidth, float ywidth) {
        double xx = x * x;
        double yy = y * y;
        double w = xx / (double)((xwidth = (float)((double)xwidth * 0.5)) * xwidth) + yy / (double)((ywidth = (float)((double)ywidth * 0.5)) * ywidth);
        if (w < 1.0) {
            double d = Math.sqrt(xx + yy);
            if (d != 0.0) {
                w = Math.cos(1.5707963705062866 * Math.sqrt(w));
                return (float)(w * 2.0 * RendermanInterface.j1(3.1415927410125732 * d) / d);
            }
            return (float)Math.PI;
        }
        return 0.0f;
    }

    public static double j1(double x) {
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = x * (7.2362614232E10 + y * (-7.895059235E9 + y * (2.423968531E8 + y * (-2972611.439 + y * (15704.4826 + y * -30.16036606)))));
            double ans2 = 1.44725228442E11 + y * (2.300535178E9 + y * (1.858330474E7 + y * (99447.43394 + y * (376.9991397 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double xx = ax - 2.356194491;
        double y = z * z;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        double ans = Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
        if (x < 0.0) {
            ans = -ans;
        }
        return ans;
    }

    public static void RiHider(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiHiderV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiHiderV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiHiderCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiHider [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (name.compareTo(RI_HIDDEN) == 0 || name.compareTo("painter") == 0) {
            RiGlobal.QGetRenderContext().optCurrent().GetStringOptionWriteIndex((String)"System", (String)"Hider", (int)0).value = name;
        }
        int i = 0;
        while (i < count) {
            block9: {
                SqParameterDeclaration Decl;
                try {
                    Decl = RiGlobal.QGetRenderContext().FindParameterDecl(tokens[i]);
                }
                catch (XqException e) {
                    logger.error(e.strReason());
                    break block9;
                }
                long hash = Decl.m_strName.hashCode();
                if (hash == RIH_DEPTHFILTER) {
                    RendermanInterface.RiOption("Hider", "depthfilter", values[i], null);
                } else if (hash == RIH_JITTER) {
                    RendermanInterface.RiOption("Hider", "jitter", values[i], null);
                }
            }
            ++i;
        }
    }

    public static void RiColorSamples(int N, float[] nRGB, float[] RGBn) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiColorSamplesCache(N, nRGB, RGBn));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiColorSamples [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        logger.warning("RiColorSamples not supported\n");
    }

    public static void RiRelativeDetail(float relativedetail) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiRelativeDetailCache(relativedetail));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiRelativeDetail [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (relativedetail < 0.0f) {
            logger.error("RiRelativeDetail < 0.0\n");
        } else {
            RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"RelativeDetail", (int)0).value = relativedetail;
        }
    }

    public static void RiOption(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiOptionV(name, count, aTokens.toArray(), aValues.toArray());
    }

    /*
     * Unable to fully structure code
     */
    public static void RiOptionV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiOptionCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, new int[]{1, 2})) {
            RendermanInterface.logger.error("Invalid state for RiOption [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        pOpt = RiGlobal.QGetRenderContext().optCurrent().pOptionWrite(name);
        i = 0;
        while (i < count) {
            block48: {
                token = tokens[i];
                value = values[i];
                try {
                    Decl = RiGlobal.QGetRenderContext().FindParameterDecl(token);
                }
                catch (XqException e) {
                    RendermanInterface.logger.error(e.strReason());
                    break block48;
                }
                Type = Decl.m_Type.getValue();
                bArray = Decl.m_Count > 1;
                pParam = pOpt.pParameter(Decl.m_strName);
                if (pParam != null) ** GOTO lbl35
                if (!Decl.m_strName.equals("") && Decl.m_Class.getValue() == 2) {
                    try {
                        pParam = RendermanInterface.createParameter(Decl);
                    }
                    catch (Exception e) {
                        HimawariLogger.outputException(e);
                    }
                    pOpt.AddParameter(pParam);
                } else {
                    if (Decl.m_strName.equals("")) {
                        RendermanInterface.logger.warning("Unrecognised declaration : " + token + "\n");
                    } else {
                        RendermanInterface.logger.warning("Options can only be uniform [" + token + "]\n");
                    }
                    return;
lbl35:
                    // 1 sources

                    Type = pParam.Type().getValue();
                    bArray = pParam.Count() > 1;
                }
                switch (Type) {
                    case 1: {
                        pf = (Object[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count()) {
                                ((p_float)((CqParameterTypedUniformArray)pParam).pValue_get((int)0, (int)j)).value = pf[j] instanceof p_float != false ? ((p_float)pf[j]).value : (float)((p_int)pf[j]).value;
                                ++j;
                            }
                            break;
                        }
                        if (pf[0] instanceof p_float) {
                            ((p_float)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)0)).value = ((p_float)pf[0]).value;
                            break;
                        }
                        ((p_float)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)0)).value = ((p_int)pf[0]).value;
                        break;
                    }
                    case 2: {
                        pi = (Object[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count()) {
                                ((p_int)((CqParameterTypedUniformArray)pParam).pValue_get((int)0, (int)j)).value = pi[j] instanceof p_int != false ? ((p_int)pi[j]).value : (int)((p_float)pi[j]).value;
                                ++j;
                            }
                            break;
                        }
                        if (pi[0] instanceof p_int) {
                            ((p_int)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)0)).value = ((p_int)pi[0]).value;
                            break;
                        }
                        ((p_int)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)0)).value = (int)((p_float)pi[0]).value;
                        break;
                    }
                    case 4: {
                        ps = (p_String[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count()) {
                                str = "";
                                if (name.compareTo("searchpath") == 0) {
                                    str_old = (p_String)((CqParameterTypedUniformArray)pParam).pValue_get(0, j);
                                    strt = 0;
                                    len = 0;
                                    while ((len = ps[j].value.indexOf("&", strt)) < ps[j].value.length() - strt && len != -1) {
                                        str = String.valueOf(str) + ps[j].value.substring(strt, len);
                                        str = String.valueOf(str) + str_old;
                                        strt += len + 1;
                                    }
                                    str = String.valueOf(str) + ps[j].value.substring(strt);
                                } else {
                                    str = new String(ps[j].value);
                                }
                                ((p_String)((CqParameterTypedUniformArray)pParam).pValue_get((int)0, (int)j)).value = str;
                                ++j;
                            }
                            break;
                        }
                        str = "";
                        if (name.compareTo("searchpath") == 0) {
                            str_old = (p_String)((CqParameterTypedUniform)pParam).pValue_get(0, 0);
                            strt = 0;
                            len = 0;
                            while ((len = ps[0].value.indexOf("&", strt)) < ps[0].value.length() - strt && len != -1) {
                                str = String.valueOf(str) + ps[0].value.substring(strt, len);
                                str = String.valueOf(str) + str_old;
                                strt += len - strt + 1;
                            }
                            str = String.valueOf(str) + ps[0].value.substring(strt);
                        } else {
                            str = new String(ps[0].value);
                        }
                        ((p_String)((CqParameterTyped)pParam).pValue_get((int)0, (int)0)).value = str;
                        break;
                    }
                    case 5: {
                        pc = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count() * 3) {
                                ((CqColor)((CqParameterTypedUniformArray)pParam).pValue_get(0, j / 3)).assignment(new CqVector3D(pc[j].value, pc[j + 1].value, pc[j + 2].value));
                                j += 3;
                            }
                            break;
                        }
                        ((CqColor)((CqParameterTypedUniform)pParam).pValue_get(0, 0)).assignment(new CqVector3D(pc[0].value, pc[1].value, pc[2].value));
                        break;
                    }
                    case 3: {
                        pv = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count() * 3) {
                                ((CqVector3D)((CqParameterTypedUniformArray)pParam).pValue_get(0, j / 3)).assignment(new CqVector3D(pv[j].value, pv[j + 1].value, pv[j + 2].value));
                                j += 3;
                            }
                            break;
                        }
                        ((CqVector3D)((CqParameterTypedUniform)pParam).pValue_get(0, 0)).assignment(new CqVector3D(pv[0].value, pv[1].value, pv[2].value));
                        break;
                    }
                    case 8: {
                        pv = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count() * 3) {
                                ((CqVector3D)((CqParameterTypedUniformArray)pParam).pValue_get(0, j / 3)).assignment(new CqVector3D(pv[j].value, pv[j + 1].value, pv[j + 2].value));
                                j += 3;
                            }
                            break;
                        }
                        ((CqVector3D)((CqParameterTypedUniform)pParam).pValue_get(0, 0)).assignment(new CqVector3D(pv[0].value, pv[1].value, pv[2].value));
                        break;
                    }
                    case 9: {
                        pv = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count() * 3) {
                                ((CqVector3D)((CqParameterTypedUniformArray)pParam).pValue_get(0, j / 3)).assignment(new CqVector3D(pv[j].value, pv[j + 1].value, pv[j + 2].value));
                                j += 3;
                            }
                            break;
                        }
                        ((CqVector3D)((CqParameterTypedUniform)pParam).pValue_get(0, 0)).assignment(new CqVector3D(pv[0].value, pv[1].value, pv[2].value));
                        break;
                    }
                    case 7: {
                        pv = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count() * 4) {
                                ((CqVector4D)((CqParameterTypedUniformArray)pParam).pValue_get(0, j / 4)).assignment(new CqVector4D(pv[j].value, pv[j + 1].value, pv[j + 2].value, pv[j + 3].value));
                                j += 4;
                            }
                            break;
                        }
                        ((CqVector4D)((CqParameterTypedUniform)pParam).pValue_get(0, 0)).assignment(new CqVector4D(pv[0].value, pv[1].value, pv[2].value, pv[3].value));
                        break;
                    }
                    case 11: {
                        pm = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count() * 16) {
                                ((CqMatrix)((CqParameterTypedUniformArray)pParam).pValue_get(0, j / 16)).assignment(new CqMatrix(pm[j].value, pm[j + 1].value, pm[j + 2].value, pm[j + 3].value, pm[j + 4].value, pm[j + 5].value, pm[j + 6].value, pm[j + 7].value, pm[j + 8].value, pm[j + 9].value, pm[j + 10].value, pm[j + 11].value, pm[j + 12].value, pm[j + 13].value, pm[j + 14].value, pm[j + 15].value));
                                j += 16;
                            }
                            break;
                        }
                        ((CqMatrix)((CqParameterTypedUniform)pParam).pValue_get(0, 0)).assignment(new CqMatrix(pm[0].value, pm[1].value, pm[2].value, pm[3].value, pm[4].value, pm[5].value, pm[6].value, pm[7].value, pm[8].value, pm[9].value, pm[10].value, pm[11].value, pm[12].value, pm[13].value, pm[14].value, pm[15].value));
                    }
                }
            }
            ++i;
        }
    }

    public static void RiAttributeBegin() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiAttributeBeginCache());
            return;
        }
        if (!RendermanInterface.ValidateState(5, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiAttributeBegin [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().BeginAttributeModeBlock();
    }

    public static void RiAttributeEnd() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiAttributeEndCache());
            return;
        }
        if (!RendermanInterface.ValidateState(1, 4)) {
            logger.error("Invalid state for RiAttributeEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().EndAttributeModeBlock();
    }

    public static void RiColor(float[] Cq) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiColorCache(Cq));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiColor [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetColorAttributeWrite("System", "Color")[0].assignment(new CqColor(Cq));
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiOpacity(float[] Os) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiOpacityCache(Os));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiOpacity [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetColorAttributeWrite("System", "Opacity")[0].assignment(new CqColor(Os));
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiTextureCoordinates(float s1, float t1, float s2, float t2, float s3, float t3, float s4, float t4) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTextureCoordinatesCache(s1, t1, s2, t2, s3, t3, s4, t4));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiTextureCoordinates [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        p_float[] pTC = RiGlobal.QGetRenderContext().pattrWriteCurrent().GetFloatAttributeWrite("System", "TextureCoordinates");
        assert (pTC != null);
        pTC[0].value = s1;
        pTC[1].value = t1;
        pTC[2].value = s2;
        pTC[3].value = t2;
        pTC[4].value = s3;
        pTC[5].value = t3;
        pTC[6].value = s4;
        pTC[7].value = t4;
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    Object RiLightSource(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        return RendermanInterface.RiLightSourceV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static Object RiLightSourceV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiLightSourceCache(name, count, tokens, values));
            return null;
        }
        if (!RendermanInterface.ValidateState(7, 1, 2, 3, 4, 5, 6, 8)) {
            logger.error("Invalid state for RiLightSource [" + RendermanInterface.GetStateAsString() + "]\n");
            return null;
        }
        IqShader pShader = RiGlobal.QGetRenderContext().CreateShader(name, new EqShaderType(1));
        if (pShader == null) {
            return null;
        }
        pShader.matCurrent().assignment(RiGlobal.QGetRenderContext().ptransCurrent().matObjectToWorld(RiGlobal.QGetRenderContext().Time()));
        CqLightsource pNew = new CqLightsource(pShader, true);
        RiGlobal.Lightsource_stack.add(pNew);
        pShader.PrepareDefArgs();
        if (pNew != null) {
            int i = 0;
            while (i < count) {
                String token = tokens[i];
                Object value = values[i];
                RendermanInterface.SetShaderArgument(pShader, token, value);
                ++i;
            }
            RiGlobal.QGetRenderContext().pattrWriteCurrent().AddLightsource(pNew);
            RiGlobal.QGetRenderContext().pconCurrent().AddContextLightSource(pNew);
            return pNew;
        }
        return null;
    }

    Object RiAreaLightSource(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        return RendermanInterface.RiAreaLightSourceV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static Object RiAreaLightSourceV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiAreaLightSourceCache(name, count, tokens, values));
            return null;
        }
        if (!RendermanInterface.ValidateState(7, 1, 2, 3, 4, 5, 6, 8)) {
            logger.error("Invalid state for RiAreaLightSource [" + RendermanInterface.GetStateAsString() + "]\n");
            return null;
        }
        logger.warning("RiAreaLightSource not supported, will produce a point light\n");
        return RendermanInterface.RiLightSourceV(name, count, tokens, values);
    }

    public static void RiIlluminate(Object light, boolean onoff) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiIlluminateCache(light, onoff));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiIlluminate [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLightsource pL = (CqLightsource)light;
        if (light == null) {
            return;
        }
        if (onoff) {
            RiGlobal.QGetRenderContext().pattrWriteCurrent().AddLightsource(pL);
        } else {
            RiGlobal.QGetRenderContext().pattrWriteCurrent().RemoveLightsource(pL);
        }
    }

    public static void RiSurface(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiSurfaceV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiSurfaceV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiSurfaceCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiSurface [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        IqShader pshadSurface = RiGlobal.QGetRenderContext().CreateShader(name, new EqShaderType(0));
        if (pshadSurface != null) {
            float time = RiGlobal.QGetRenderContext().Time();
            pshadSurface.matCurrent().assignment(RiGlobal.QGetRenderContext().matCurrent(time));
            pshadSurface.PrepareDefArgs();
            int i = 0;
            while (i < count) {
                String token = tokens[i];
                Object value = values[i];
                RendermanInterface.SetShaderArgument(pshadSurface, token, value);
                ++i;
            }
            RiGlobal.QGetRenderContext().pattrWriteCurrent().SetpshadSurface(pshadSurface, RiGlobal.QGetRenderContext().Time());
        }
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiAtmosphere(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiAtmosphereV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiAtmosphereV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiAtmosphereCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiAtmosphere [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        IqShader pshadAtmosphere = RiGlobal.QGetRenderContext().CreateShader(name, new EqShaderType(2));
        if (pshadAtmosphere != null) {
            pshadAtmosphere.matCurrent().assignment(RiGlobal.QGetRenderContext().matCurrent(RiGlobal.QGetRenderContext().Time()));
            pshadAtmosphere.PrepareDefArgs();
            int i = 0;
            while (i < count) {
                String token = tokens[i];
                Object value = values[i];
                RendermanInterface.SetShaderArgument(pshadAtmosphere, token, value);
                ++i;
            }
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().SetpshadAtmosphere(pshadAtmosphere, RiGlobal.QGetRenderContext().Time());
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiInterior(String name, Object ... pArgs) {
        logger.warning("RiInterior not supported\n");
    }

    public static void RiInteriorV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiInteriorCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiInterior [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        logger.warning("RiInterior not supported\n");
    }

    public static void RiExterior(String name, Object ... pArgs) {
        logger.warning("RiExterior not supported\n");
    }

    public static void RiExteriorV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiExteriorCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiExterior [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        logger.warning("RiExterior not supported\n");
    }

    public static void RiShadingRate(float size) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiShadingRateCache(size));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiShadingRate [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        boolean valid = true;
        rc.set("size");
        if (!RiGlobal.CheckMinMax(size, 0.0f, Float.MAX_VALUE, rc)) {
            valid = false;
        }
        if (!valid) {
            logger.warning("Invalid ShadingRate, ShadingRate set to 1\n");
            size = 1.0f;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetFloatAttributeWrite((String)"System", (String)"ShadingRate")[0].value = size;
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetFloatAttributeWrite((String)"System", (String)"ShadingRateSqrt")[0].value = (float)Math.sqrt(size);
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiShadingInterpolation(String type) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiShadingInterpolationCache(type));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiShadingInterpolation [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (type.compareTo(RI_CONSTANT) == 0) {
            RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"ShadingInterpolation")[0].value = 0;
        } else if (type.compareTo(RI_SMOOTH) == 0) {
            RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"ShadingInterpolation")[0].value = 0;
        } else {
            logger.error("RiShadingInterpolation unrecognised value \"" + type + "\"\n");
        }
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiMatte(boolean onoff) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMatteCache(onoff));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiMatte [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Matte")[0].value = onoff ? 1 : 0;
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiBound(float[] bound) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiBoundCache(bound));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiBound [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiDetail(float[] bound) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDetailCache(bound));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiDetail [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqBound Bound = new CqBound(bound);
        Bound.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_RASTER, new CqMatrix(), RiGlobal.QGetRenderContext().matCurrent(RiGlobal.QGetRenderContext().Time()), RiGlobal.QGetRenderContext().Time()));
        float ruler = Math.abs(Math.max(Bound.vecMax().x - Bound.vecMin().x, Bound.vecMax().y - Bound.vecMin().y));
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetFloatAttributeWrite((String)"System", (String)"LevelOfDetailRulerSize")[0].value = ruler *= RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"RelativeDetail", (int)0).value;
    }

    public static void RiDetailRange(float offlow, float onlow, float onhigh, float offhigh) {
        float maxImportance;
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDetailRangeCache(offlow, onlow, onhigh, offhigh));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiDetail [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (offlow > onlow || onhigh > offhigh) {
            logger.error("RiDetailRange invalid range\n");
            return;
        }
        p_float ruler = RiGlobal.QGetRenderContext().pattrWriteCurrent().GetFloatAttributeWrite("System", "LevelOfDetailRulerSize")[0];
        float minImportance = onlow == offlow ? (ruler.value < onlow ? 1.0f : 0.0f) : PublicFunctions.CLAMP((onlow - ruler.value) / (onlow - offlow), 0.0f, 1.0f);
        if (minImportance >= (maxImportance = onhigh == offhigh ? (ruler.value < onhigh ? 1.0f : 0.0f) : PublicFunctions.CLAMP((offhigh - ruler.value) / (offhigh - onhigh), 0.0f, 1.0f))) {
            maxImportance = -1.0f;
            minImportance = -1.0f;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetFloatAttributeWrite((String)"System", (String)"LevelOfDetailBounds")[0].value = minImportance;
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetFloatAttributeWrite((String)"System", (String)"LevelOfDetailBounds")[1].value = maxImportance;
    }

    public static void RiGeometricApproximation(String type, float value) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiGeometricApproximationCache(type, value));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiGeometricApproximation [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        logger.warning("RiGeometricApproximation not supported\n");
    }

    public static void RiOrientation(String orientation) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiOrientationCache(orientation));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiOrientation [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (orientation != null) {
            if (orientation.indexOf(RI_RH) != -1 && orientation.substring(orientation.indexOf(RI_RH)) != null) {
                int n = RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Orientation")[0].value = RiGlobal.QGetRenderContext().ptransCurrent().GetHandedness(RiGlobal.QGetRenderContext().Time()) ? 0 : 1;
            }
            if (orientation.indexOf(RI_LH) != -1 && orientation.substring(orientation.indexOf(RI_LH)) != null) {
                int n = RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Orientation")[0].value = RiGlobal.QGetRenderContext().ptransCurrent().GetHandedness(RiGlobal.QGetRenderContext().Time()) ? 1 : 0;
            }
            if (orientation.indexOf(RI_INSIDE) != -1 && orientation.substring(orientation.indexOf(RI_INSIDE)) != null) {
                RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Orientation")[0].value = 1;
            }
            if (orientation.indexOf(RI_OUTSIDE) != -1 && orientation.substring(orientation.indexOf(RI_OUTSIDE)) != null) {
                RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Orientation")[0].value = 0;
            }
        }
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiReverseOrientation() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiReverseOrientationCache());
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiReverseOrientation [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().FlipeOrientation(RiGlobal.QGetRenderContext().Time());
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiSides(int nsides) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiSidesCache(nsides));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiSides [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Sides")[0].value = nsides;
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiIdentity() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiIdentityCache());
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiIdentity [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().ptransSetTime(new CqMatrix());
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiTransform(float[][] transform) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTransformCache(transform));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiTransform [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (RiGlobal.QGetRenderContext().IsWorldBegin()) {
            CqTransform newTrans = new CqTransform(RiGlobal.QGetRenderContext().GetDefObjTransform());
            RiGlobal.QGetRenderContext().pconCurrent().ptransSetCurrent(newTrans);
            RiGlobal.QGetRenderContext().ptransConcatCurrentTime(new CqMatrix(transform));
        } else {
            RiGlobal.QGetRenderContext().ptransSetCurrentTime(new CqMatrix(transform));
        }
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiConcatTransform(float[][] transform) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiConcatTransformCache(transform));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiConcatTransform [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().ptransConcatCurrentTime(new CqMatrix(transform));
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiPerspective(float fov) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPerspectiveCache(fov));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiPerspective [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (fov <= 0.0f) {
            logger.error("RiPerspective invalid FOV\n");
            return;
        }
        fov = (float)Math.tan(PublicFunctions.RAD(fov / 2.0f));
        CqMatrix matP = new CqMatrix(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, fov, fov, 0.0f, 0.0f, -fov, 0.0f);
        RiGlobal.QGetRenderContext().ptransConcatCurrentTime(matP);
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiTranslate(float dx, float dy, float dz) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTranslateCache(dx, dy, dz));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiTranslate [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqMatrix matTrans = new CqMatrix(new CqVector3D(dx, dy, dz));
        RiGlobal.QGetRenderContext().ptransConcatCurrentTime(matTrans);
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiRotate(float angle, float dx, float dy, float dz) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiRotateCache(angle, dx, dy, dz));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiRotate [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqMatrix matRot = new CqMatrix(PublicFunctions.RAD(angle), new CqVector3D(dx, dy, dz));
        RiGlobal.QGetRenderContext().ptransConcatCurrentTime(matRot);
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiScale(float sx, float sy, float sz) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiScaleCache(sx, sy, sz));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiScale [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqMatrix matScale = new CqMatrix(sx, sy, sz);
        RiGlobal.QGetRenderContext().ptransConcatCurrentTime(matScale);
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiSkew(float angle, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiSkewCache(angle, dx1, dy1, dz1, dx2, dy2, dz2));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiSkew [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqMatrix matSkew = new CqMatrix(PublicFunctions.RAD(angle), dx1, dy1, dz1, dx2, dy2, dz2);
        RiGlobal.QGetRenderContext().ptransConcatCurrentTime(matSkew);
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiDeformation(String name, Object ... pArgs) {
        logger.warning("RiDeformation not supported\n");
    }

    public static void RiDeformationV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDeformationCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiDeformation [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        logger.warning("RiDeformation not supported\n");
    }

    public static void RiDisplacement(String name, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiDisplacementV(name, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiDisplacementV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDisplacementCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiDisplacement [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        IqShader pshadDisplacement = RiGlobal.QGetRenderContext().CreateShader(name, new EqShaderType(3));
        if (pshadDisplacement != null) {
            pshadDisplacement.matCurrent().assignment(RiGlobal.QGetRenderContext().matCurrent(RiGlobal.QGetRenderContext().Time()));
            pshadDisplacement.PrepareDefArgs();
            int i = 0;
            while (i < count) {
                String token = tokens[i];
                Object value = values[i];
                RendermanInterface.SetShaderArgument(pshadDisplacement, token, value);
                ++i;
            }
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().SetpshadDisplacement(pshadDisplacement, RiGlobal.QGetRenderContext().Time());
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiCoordinateSystem(String space) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiCoordinateSystemCache(space));
            return;
        }
        if (!RendermanInterface.ValidateState(7, 1, 2, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiCoordinateSystem [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().SetCoordSystem(space, RiGlobal.QGetRenderContext().matCurrent(RiGlobal.QGetRenderContext().Time()));
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiCoordSysTransform(String space) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiCoordinateSystemCache(space));
            return;
        }
        if (!RendermanInterface.ValidateState(7, 1, 2, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiCoordinateSystem [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().ptransSetTime(RiGlobal.QGetRenderContext().matSpaceToSpace(space, RI_WORLD, new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time()));
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static Object RiTransformPoints(String fromspace, String tospace, int npoints, float[][] points) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTransformPointsCache(fromspace, tospace, npoints, points));
            return null;
        }
        if (!RendermanInterface.ValidateState(7, 1, 2, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiTransformPoints [" + RendermanInterface.GetStateAsString() + "]\n");
            return null;
        }
        logger.warning("RiTransformPoints not supported\n");
        return null;
    }

    public static void RiTransformBegin() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTransformBeginCache());
            return;
        }
        if (!RendermanInterface.ValidateState(7, 1, 2, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiTransformBegin [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().BeginTransformModeBlock();
    }

    public static void RiTransformEnd() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTransformEndCache());
            return;
        }
        if (!RendermanInterface.ValidateState(1, 5)) {
            logger.error("Invalid state for RiTransformEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().EndTransformModeBlock();
    }

    public static void RiAttribute(String name, Object ... pArgs) {
        long hash = name.hashCode();
        if (hash == RIH_RENDER) {
            return;
        }
        if (hash == RIH_INDIRECT) {
            return;
        }
        if (hash == RIH_LIGHT) {
            return;
        }
        if (hash == RIH_VISIBILITY) {
            return;
        }
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiAttributeV(name, count, aTokens.toArray(), aValues.toArray());
    }

    /*
     * Unable to fully structure code
     */
    public static void RiAttributeV(String name, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiAttributeCache(name, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(8, new int[]{1, 2, 3, 4, 5, 6, 7, 8})) {
            RendermanInterface.logger.error("Invalid state for RiAttribute [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        hash = name.hashCode();
        if (hash == RendermanInterface.RIH_RENDER) {
            return;
        }
        if (hash == RendermanInterface.RIH_INDIRECT) {
            return;
        }
        if (hash == RendermanInterface.RIH_LIGHT) {
            return;
        }
        if (hash == RendermanInterface.RIH_VISIBILITY) {
            return;
        }
        pAttr = RiGlobal.QGetRenderContext().pattrWriteCurrent().pAttributeWrite(name);
        i = 0;
        while (i < count) {
            block28: {
                token = tokens[i];
                value = values[i];
                pParam = pAttr.pParameter(token);
                if (pParam != null) ** GOTO lbl50
                try {
                    Decl = RiGlobal.QGetRenderContext().FindParameterDecl(token);
                }
                catch (XqException e) {
                    RendermanInterface.logger.error(e.strReason());
                    break block28;
                }
                if (!Decl.m_strName.equals("") && Decl.m_Class.getValue() == 2) {
                    try {
                        pParam = RendermanInterface.createParameter(Decl);
                    }
                    catch (IllegalArgumentException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (IllegalAccessException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (InvocationTargetException e) {
                        HimawariLogger.outputException(e);
                    }
                    Type = Decl.m_Type.getValue();
                    bArray = Decl.m_Count > 1;
                    pAttr.AddParameter(pParam);
                } else {
                    if (Decl.m_strName.equals("")) {
                        RendermanInterface.logger.warning("Unrecognised declaration \"" + token + "\"\n");
                    } else {
                        RendermanInterface.logger.warning("Attributes can only be uniform\n");
                    }
                    return;
lbl50:
                    // 1 sources

                    Type = pParam.Type().getValue();
                    bArray = pParam.Count() > 1;
                }
                switch (Type) {
                    case 1: {
                        pf = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count()) {
                                ((p_float)((CqParameterTypedUniformArray)pParam).pValue_get((int)0, (int)j)).value = pf[j].value;
                                ++j;
                            }
                            break;
                        }
                        ((p_float)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)0)).value = pf[0].value;
                        break;
                    }
                    case 2: {
                        pi = (p_float[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count()) {
                                ((p_int)((CqParameterTypedUniformArray)pParam).pValue_get((int)0, (int)j)).value = (int)pi[j].value;
                                ++j;
                            }
                            break;
                        }
                        ((p_int)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)0)).value = (int)pi[0].value;
                        break;
                    }
                    case 4: {
                        ps = (p_String[])value;
                        if (bArray) {
                            j = 0;
                            while (j < pParam.Count()) {
                                ((p_String)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)j)).value = str = ps[j].value;
                                ++j;
                            }
                            break;
                        }
                        ((p_String)((CqParameterTypedUniform)pParam).pValue_get((int)0, (int)0)).value = str = ps[0].value;
                        if (!name.equals("identifier")) break;
                        RendermanInterface.logger.info("Identifier: " + ps[0] + "\n");
                    }
                }
            }
            ++i;
        }
    }

    public static void RiPolygon(int nvertices, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiPolygonV(nvertices, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiPolygonV(int nvertices, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPolygonCache(nvertices, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiPolygon [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqSurfacePolygon pSurface = new CqSurfacePolygon(nvertices);
        if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
            if (!pSurface.CheckDegenerate()) {
                float time = RiGlobal.QGetRenderContext().Time();
                pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                RendermanInterface.CreateGPrim(pSurface);
            } else {
                logger.error("Found degenerate polygon\n");
            }
        }
    }

    public static void RiGeneralPolygon(int nloops, int[] nverts, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiGeneralPolygonV(nloops, nverts, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiGeneralPolygonV(int nloops, int[] nverts, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiGeneralPolygonCache(nloops, nverts, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiGeneralPolygon [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 0;
        int iloop = 0;
        while (iloop < nloops) {
            cVerts += nverts[iloop];
            if (nverts[iloop] < 3) {
                String objname = "unnamed";
                String[] pattrName = RiGlobal.QGetRenderContext().pattrCurrent().GetStringAttribute(RI_IDENTIFIER, RI_NAME);
                if (pattrName != null) {
                    objname = pattrName[0];
                }
                logger.warning("Degenerate loop in GeneralPolygon object \"" + objname + "\" \n");
                if (nverts[iloop] == 0) {
                    return;
                }
            }
            ++iloop;
        }
        int i = 0;
        while (i < count) {
            String param = tokens[i];
            int diff = cVerts * 3 - Array.getLength(values[i]);
            if (param.equals(RI_P) && diff > 0) {
                logger.error("Invalid \"P\" parameter length " + Array.getLength(values[i]) + " : \"P\" needs " + cVerts * 3 + " float values \n");
                p_float[] filledP = new p_float[cVerts * 3];
                System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                int j = Array.getLength(values[i]);
                while (j < filledP.length) {
                    filledP[j] = new p_float(0.0f);
                    ++j;
                }
                values[i] = filledP;
            }
            ++i;
        }
        CqPolygonPoints pPointsClass = new CqPolygonPoints(cVerts, 1, cVerts);
        if (RendermanInterface.ProcessPrimitiveVariables(pPointsClass, count, tokens, values)) {
            float MaxZ;
            float MaxY;
            float MaxX;
            pPointsClass.SetDefaultPrimitiveVariables(false);
            CqVector3D vecTemp = new CqVector3D(pPointsClass.P().pValue_get(0, 0));
            float MinX = MaxX = vecTemp.x;
            float MinY = MaxY = vecTemp.y;
            float MinZ = MaxZ = vecTemp.z;
            boolean O = RiGlobal.QGetRenderContext().pattrCurrent().GetIntegerAttribute("System", "Orientation")[0] != 0;
            int iVert = 1;
            while (iVert < pPointsClass.P().Size()) {
                vecTemp = new CqVector3D(pPointsClass.P().pValue_get(iVert, 0));
                MinX = MinX < vecTemp.x ? MinX : vecTemp.x;
                MinY = MinY < vecTemp.y ? MinY : vecTemp.y;
                MinZ = MinZ < vecTemp.z ? MinZ : vecTemp.z;
                MaxX = MaxX > vecTemp.x ? MaxX : vecTemp.x;
                MaxY = MaxY > vecTemp.y ? MaxY : vecTemp.y;
                MaxZ = MaxZ > vecTemp.z ? MaxZ : vecTemp.z;
                ++iVert;
            }
            float DiffX = MaxX - MinX;
            float DiffY = MaxY - MinY;
            float DiffZ = MaxZ - MinZ;
            int Axis = DiffX < DiffY && DiffX < DiffZ ? 3 : (DiffY < DiffX && DiffY < DiffZ ? 2 : 1);
            CqPolygonGeneral2D poly = new CqPolygonGeneral2D();
            int ipoint = 0;
            iloop = 0;
            while (iloop < nloops) {
                CqPolygonGeneral2D polya = new CqPolygonGeneral2D();
                polya.SetAxis(Axis);
                polya.SetpVertices(pPointsClass);
                int ivert = 0;
                while (ivert < nverts[iloop]) {
                    assert (ipoint < pPointsClass.P().Size());
                    polya.aiVertices().add(new p_int(ipoint++));
                    ++ivert;
                }
                if (iloop == 0) {
                    if (O) {
                        if (polya.CalcOrientation() != 2) {
                            RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Orientation")[0].value = 0;
                            polya.SwapDirection();
                        }
                    } else if (polya.CalcOrientation() != 1) {
                        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"Orientation")[0].value = 1;
                        polya.SwapDirection();
                    }
                    poly.assignment(polya);
                } else {
                    if (O) {
                        if (polya.CalcOrientation() != 1) {
                            polya.SwapDirection();
                        }
                    } else if (polya.CalcOrientation() != 2) {
                        polya.SwapDirection();
                    }
                    poly.Combine(polya);
                }
                ++iloop;
            }
            STLVector<p_int> aiTriangles = new STLVector<p_int>(p_int.class);
            poly.CalcOrientation();
            poly.Triangulate(aiTriangles);
            int ctris = aiTriangles.size() / 3;
            STLVector<p_int> _nverts = new STLVector<p_int>(p_int.class);
            int i2 = 0;
            while (i2 < ctris) {
                _nverts.add(new p_int(3));
                ++i2;
            }
            int[] _nverts_ary = new int[_nverts.size()];
            int i3 = 0;
            while (i3 < _nverts_ary.length) {
                _nverts_ary[i3] = ((p_int)_nverts.get((int)i3)).value;
                ++i3;
            }
            int[] aiTriangles_ary = new int[aiTriangles.size()];
            int i4 = 0;
            while (i4 < aiTriangles_ary.length) {
                aiTriangles_ary[i4] = ((p_int)aiTriangles.get((int)i4)).value;
                ++i4;
            }
            RendermanInterface.RiPointsPolygonsV(ctris, _nverts_ary, aiTriangles_ary, count, tokens, values);
        }
    }

    public static void RiBlobby(int nleaf, int ncodes, int[] codes, int nfloats, float[] floats, int nstrings, String[] strings, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiBlobbyV(nleaf, ncodes, codes, nfloats, floats, nstrings, strings, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiBlobbyV(int nleaf, int ncode, int[] code, int nflt, float[] flt, int nstr, String[] str, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiBlobbyCache(nleaf, ncode, code, nflt, flt, nstr, str, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiBlobby [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        logger.warning("RiBlobby not supported\n");
    }

    public static void RiPoints(int nvertices, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiPointsV(nvertices, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiPointsV(int npoints, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPointsCache(npoints, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiPoints [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqPolygonPoints pPointsClass = new CqPolygonPoints(npoints, 1, npoints);
        if (RendermanInterface.ProcessPrimitiveVariables(pPointsClass, count, tokens, values)) {
            pPointsClass.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(pPointsClass.pTransform().Time(0)), pPointsClass.pTransform().Time(0)), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(pPointsClass.pTransform().Time(0)), pPointsClass.pTransform().Time(0)), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(pPointsClass.pTransform().Time(0)), pPointsClass.pTransform().Time(0)));
            CqPoints pSurface = new CqPoints(npoints, pPointsClass);
            pSurface.InitialiseKDTree();
            pSurface.InitialiseMaxWidth();
            if (RiGlobal.QGetRenderContext().pattrCurrent().GetFloatAttribute("System", "LevelOfDetailBounds")[1] < 0.0f) {
                return;
            }
            if (RiGlobal.QGetRenderContext().pconCurrent().fMotionBlock()) {
                CqMotionModeBlock pMMB = (CqMotionModeBlock)RiGlobal.QGetRenderContext().pconCurrent();
                CqDeformingSurface pMS = pMMB.GetDeformingSurface();
                if (pMS == null) {
                    CqDeformingPointsSurface pNewMS = new CqDeformingPointsSurface(pSurface);
                    pNewMS.AddTimeSlot(RiGlobal.QGetRenderContext().Time(), pSurface);
                    pMMB.SetDeformingSurface(pNewMS);
                } else {
                    pMS.AddTimeSlot(RiGlobal.QGetRenderContext().Time(), pSurface);
                }
                RiGlobal.QGetRenderContext().AdvanceTime();
            } else {
                RiGlobal.QGetRenderContext().pImage().PostSurface(pSurface);
                CqStats.STATS_INC(2);
            }
        }
    }

    public static void RiCurves(String type, int ncurves, int[] nvertices, String wrap, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiCurvesV(type, ncurves, nvertices, wrap, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiCurvesV(String type, int ncurves, int[] nvertices, String wrap, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiCurvesCache(type, ncurves, nvertices, wrap, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiCurves [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        boolean periodic = false;
        if (wrap.equals(RI_PERIODIC)) {
            periodic = true;
        } else if (wrap.equals(RI_NONPERIODIC)) {
            periodic = false;
        } else {
            logger.error("RiCurves invalid wrap mode \"" + wrap + "\" \n");
        }
        if (ncurves < 1) {
            logger.error("Invalid parameter " + ncurves + " : ncurves > 0 \n");
            return;
        }
        int i = 0;
        int cVerts = 0;
        i = 0;
        while (i < nvertices.length) {
            cVerts += nvertices[i];
            ++i;
        }
        if (cVerts < 1) {
            logger.error("Invalid parameter " + cVerts + " : nvertex > 0 \n");
            return;
        }
        i = 0;
        while (i < count) {
            int diff = cVerts * 3 - Array.getLength(values[i]);
            if (tokens[i].equals(RI_P) && diff > 0) {
                logger.error("Invalid \"P\" parameter length " + Array.getLength(values[i]) + " : \"P\" needs " + cVerts * 3 + " float values \n");
                p_float[] filledP = new p_float[cVerts * 3];
                System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                int j = Array.getLength(values[i]);
                while (j < filledP.length) {
                    filledP[j] = new p_float(0.0f);
                    ++j;
                }
                values[i] = filledP;
            }
            ++i;
        }
        if (type.equals(RI_CUBIC)) {
            CqCubicCurvesGroup pSurface = new CqCubicCurvesGroup(ncurves, nvertices, periodic);
            if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
                pSurface.SetDefaultPrimitiveVariables();
                float time = RiGlobal.QGetRenderContext().Time();
                pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                STLVector<CqBasicSurface> aSplits = new STLVector<CqBasicSurface>(CqBasicSurface.class);
                pSurface.Split(aSplits);
                for (CqBasicSurface iSS : aSplits) {
                    RendermanInterface.CreateGPrim(iSS);
                }
            }
        } else if (type.equals(RI_LINEAR)) {
            CqLinearCurvesGroup pSurface = new CqLinearCurvesGroup(ncurves, nvertices, periodic);
            if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
                pSurface.SetDefaultPrimitiveVariables();
                float time = RiGlobal.QGetRenderContext().Time();
                pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                RendermanInterface.CreateGPrim(pSurface);
            }
        } else {
            logger.error("RiCurves invalid type \"" + type + "\"");
        }
    }

    public static void RiPointsPolygons(int npolys, int[] nverts, int[] verts, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiPointsPolygonsV(npolys, nverts, verts, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiPointsPolygonsV(int npolys, int[] nverts, int[] verts, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPointsPolygonsCache(npolys, nverts, verts, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiPointsPolygons [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 0;
        int pVerts = 0;
        int sumnVerts = 0;
        int poly = 0;
        while (poly < npolys) {
            sumnVerts += nverts[poly];
            if (verts.length < pVerts + nverts[poly]) {
                logger.error("Invalid parameter length " + verts.length + " : verts length = " + (pVerts + nverts[poly]) + " \n");
                return;
            }
            int v = 0;
            while (v < nverts[poly]) {
                cVerts = verts[pVerts] + 1 > cVerts ? verts[pVerts] + 1 : cVerts;
                ++pVerts;
                ++v;
            }
            ++poly;
        }
        int i = 0;
        while (i < count) {
            String param = tokens[i];
            int diff = cVerts * 3 - Array.getLength(values[i]);
            if (param.equals(RI_P) && diff > 0) {
                logger.error("Invalid \"P\" parameter length " + Array.getLength(values[i]) + " : \"P\" needs " + cVerts * 3 + " float values \n");
                p_float[] filledP = new p_float[cVerts * 3];
                System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                int j = Array.getLength(values[i]);
                while (j < filledP.length) {
                    filledP[j] = new p_float(0.0f);
                    ++j;
                }
                values[i] = filledP;
            }
            ++i;
        }
        CqPolygonPoints pPointsClass = new CqPolygonPoints(cVerts, npolys, sumnVerts);
        if (RendermanInterface.ProcessPrimitiveVariables(pPointsClass, count, tokens, values)) {
            CqSurfacePointsPolygons pPsPs = new CqSurfacePointsPolygons(pPointsClass, npolys, nverts, verts);
            float time = RiGlobal.QGetRenderContext().Time();
            pPointsClass.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(time), time));
            RendermanInterface.CreateGPrim(pPsPs);
        }
    }

    public static void RiPointsGeneralPolygons(int npolys, int[] nloops, int[] nverts, int[] verts, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiPointsGeneralPolygonsV(npolys, nloops, nverts, verts, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiPointsGeneralPolygonsV(int npolys, int[] nloops, int[] nverts, int[] verts, int count, String[] tokens, Object[] values) {
        int iloop;
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPointsGeneralPolygonsCache(npolys, nloops, nverts, verts, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiPointsGeneralPolygons [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int igloop = 0;
        int cVerts = 0;
        int igvert = 0;
        int sumnVerts = 0;
        int pVerts = 0;
        int ipoly = 0;
        while (ipoly < npolys) {
            if (nverts.length < igloop + nloops[ipoly]) {
                logger.error("Invalid parameter length " + nverts.length + " : nverts length = " + (igloop + nloops[ipoly]) + " \n");
                return;
            }
            iloop = 0;
            while (iloop < nloops[ipoly]) {
                sumnVerts += nverts[igloop];
                if (nverts[igloop] < 3) {
                    String objname = "unnamed";
                    String[] pattrName = RiGlobal.QGetRenderContext().pattrCurrent().GetStringAttribute(RI_IDENTIFIER, RI_NAME);
                    if (pattrName != null) {
                        objname = pattrName[0];
                    }
                    logger.warning("Degenerate loop in PointsGeneralPolygons object \"" + objname + "\"" + " \n");
                    if (nverts[igloop] == 0) {
                        return;
                    }
                }
                if (verts.length < pVerts + nverts[igloop]) {
                    logger.error("Invalid parameter length " + verts.length + " : verts length = " + (pVerts + nverts[igloop]) + " \n");
                    return;
                }
                int v = 0;
                while (v < nverts[igloop]) {
                    cVerts = verts[pVerts] + 1 > cVerts ? verts[pVerts] + 1 : cVerts;
                    ++pVerts;
                    ++v;
                }
                ++iloop;
                ++igloop;
            }
            ++ipoly;
        }
        int i = 0;
        while (i < count) {
            String param = tokens[i];
            int diff = cVerts * 3 - Array.getLength(values[i]);
            if (param.equals(RI_P) && diff > 0) {
                logger.error("Invalid \"P\" parameter length " + Array.getLength(values[i]) + " : \"P\" needs " + cVerts * 3 + " float values \n");
                p_float[] filledP = new p_float[cVerts * 3];
                System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                int j = Array.getLength(values[i]);
                while (j < filledP.length) {
                    filledP[j] = new p_float(0.0f);
                    ++j;
                }
                values[i] = filledP;
            }
            ++i;
        }
        boolean O = RiGlobal.QGetRenderContext().pattrCurrent().GetIntegerAttribute("System", "Orientation")[0] != 0;
        CqPolygonPoints pPointsClass = new CqPolygonPoints(cVerts, npolys, sumnVerts);
        if (RendermanInterface.ProcessPrimitiveVariables(pPointsClass, count, tokens, values)) {
            pPointsClass.SetDefaultPrimitiveVariables(false);
            igloop = 0;
            int ctris = 0;
            STLVector<p_int> aiTriangles = new STLVector<p_int>(p_int.class);
            STLVector<p_int> aFVList = new STLVector<p_int>(p_int.class);
            STLVector<p_int> aUVList = new STLVector<p_int>(p_int.class);
            ipoly = 0;
            while (ipoly < npolys) {
                int initial_index = igvert;
                CqPolygonGeneral2D poly = new CqPolygonGeneral2D();
                int ipoint = 0;
                int imaxindex = cVerts;
                int iminindex = 0;
                iloop = 0;
                while (iloop < nloops[ipoly]) {
                    float MaxZ;
                    float MaxY;
                    float MaxX;
                    iminindex = iminindex < verts[igvert] ? iminindex : verts[igvert];
                    imaxindex = imaxindex > verts[igvert] ? imaxindex : verts[igvert];
                    CqVector3D vecTemp = new CqVector3D(pPointsClass.P().pValue_get(verts[igvert], 0));
                    float MinX = MaxX = vecTemp.x;
                    float MinY = MaxY = vecTemp.y;
                    float MinZ = MaxZ = vecTemp.z;
                    CqPolygonGeneral2D polya = new CqPolygonGeneral2D();
                    polya.SetpVertices(pPointsClass);
                    int ivert = 0;
                    while (ivert < nverts[igloop]) {
                        ipoint = verts[igvert];
                        assert (ipoint < pPointsClass.P().Size());
                        polya.aiVertices().add(new p_int(ipoint));
                        vecTemp = new CqVector3D(pPointsClass.P().pValue_get(verts[igvert], 0));
                        MinX = MinX < vecTemp.x ? MinX : vecTemp.x;
                        MinY = MinY < vecTemp.y ? MinY : vecTemp.y;
                        MinZ = MinZ < vecTemp.z ? MinZ : vecTemp.z;
                        MaxX = MaxX > vecTemp.x ? MaxX : vecTemp.x;
                        MaxY = MaxY > vecTemp.y ? MaxY : vecTemp.y;
                        MaxZ = MaxZ > vecTemp.z ? MaxZ : vecTemp.z;
                        ++ivert;
                        ++igvert;
                    }
                    float DiffX = MaxX - MinX;
                    float DiffY = MaxY - MinY;
                    float DiffZ = MaxZ - MinZ;
                    int Axis = DiffX < DiffY && DiffX < DiffZ ? 3 : (DiffY < DiffX && DiffY < DiffZ ? 2 : 1);
                    polya.SetAxis(Axis);
                    if (iloop == 0) {
                        if (!O) {
                            if (polya.CalcOrientation() != 1) {
                                polya.SwapDirection();
                            }
                        } else if (polya.CalcOrientation() != 2) {
                            polya.SwapDirection();
                        }
                        poly.assignment(polya);
                    } else {
                        if (!O) {
                            if (polya.CalcOrientation() != 2) {
                                polya.SwapDirection();
                            }
                        } else if (polya.CalcOrientation() != 1) {
                            polya.SwapDirection();
                        }
                        poly.Combine(polya);
                    }
                    ++iloop;
                    ++igloop;
                }
                poly.CalcOrientation();
                int iStartTri = aiTriangles.size();
                poly.Triangulate(aiTriangles);
                int iEndTri = aiTriangles.size();
                int ifv = iStartTri;
                while (ifv < iEndTri) {
                    int ivaryingindex = ((p_int)aiTriangles.get((int)ifv)).value;
                    boolean found = false;
                    int iv = initial_index;
                    while (iv != igvert) {
                        if (verts[iv] == ivaryingindex) {
                            aFVList.add(new p_int(iv));
                            found = true;
                        }
                        ++iv;
                    }
                    assert (found);
                    ++ifv;
                }
                aUVList.add(new p_int((iEndTri - iStartTri) / 3));
                ++ipoly;
            }
            ctris = aiTriangles.size() / 3;
            STLVector<p_int> _nverts = new STLVector<p_int>(p_int.class);
            int i2 = 0;
            while (i2 < ctris) {
                _nverts.add(new p_int(3));
                ++i2;
            }
            int fvcount = ctris * 3;
            assert (aFVList.size() == fvcount);
            Vector<p_float[]> aNewParams = new Vector<p_float[]>();
            int iUserParam = 0;
            while (iUserParam < count) {
                block54: {
                    SqParameterDeclaration Decl;
                    try {
                        Decl = RiGlobal.QGetRenderContext().FindParameterDecl(tokens[iUserParam]);
                    }
                    catch (XqException e) {
                        logger.error(e.strReason());
                        break block54;
                    }
                    int elem_size = 0;
                    switch (Decl.m_Type.getValue()) {
                        case 1: {
                            elem_size = 4;
                            break;
                        }
                        case 2: {
                            elem_size = 4;
                            break;
                        }
                        case 3: 
                        case 8: 
                        case 9: {
                            elem_size = 12;
                            break;
                        }
                        case 5: {
                            elem_size = 12;
                            break;
                        }
                        case 11: {
                            elem_size = 64;
                        }
                    }
                    int array_size = Decl.m_Count;
                    if (Decl.m_Class.getValue() == 5) {
                        p_float[] pNew = new p_float[(elem_size /= 4) * fvcount * array_size];
                        int idx = 0;
                        int iElem = 0;
                        while (iElem < fvcount) {
                            int i3 = 0;
                            while (i3 < elem_size * array_size) {
                                p_float pval = (p_float)Array.get(values[iUserParam], ((p_int)aFVList.get((int)iElem)).value * elem_size * array_size + i3);
                                pNew[idx++] = new p_float(pval.value);
                                ++i3;
                            }
                            ++iElem;
                        }
                        aNewParams.add(pNew);
                        values[iUserParam] = aNewParams.lastElement();
                    } else if (Decl.m_Class.getValue() == 2) {
                        p_float[] pNew = new p_float[(elem_size /= 4) * ctris * array_size];
                        int idx = 0;
                        int iElem = 0;
                        while (iElem < npolys) {
                            int dup_count = ((p_int)aUVList.get((int)iElem)).value;
                            int dup = 0;
                            while (dup < dup_count) {
                                int i4 = 0;
                                while (i4 < elem_size) {
                                    p_float pval = (p_float)Array.get(values[iUserParam], iElem * array_size + i4);
                                    pNew[idx++] = new p_float(pval.value);
                                    ++i4;
                                }
                                ++dup;
                            }
                            ++iElem;
                        }
                        aNewParams.add(pNew);
                        values[iUserParam] = aNewParams.lastElement();
                    }
                }
                ++iUserParam;
            }
            int[] _nverts_ary = new int[_nverts.size()];
            int[] aiTriangles_ary = new int[aiTriangles.size()];
            int i5 = 0;
            while (i5 < _nverts_ary.length) {
                _nverts_ary[i5] = ((p_int)_nverts.get((int)i5)).value;
                ++i5;
            }
            i5 = 0;
            while (i5 < aiTriangles_ary.length) {
                aiTriangles_ary[i5] = ((p_int)aiTriangles.get((int)i5)).value;
                ++i5;
            }
            RendermanInterface.RiPointsPolygonsV(ctris, _nverts_ary, aiTriangles_ary, count, tokens, values);
        }
    }

    public static void RiBasis(float[][] ubasis, int ustep, float[][] vbasis, int vstep) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiBasisCache(ubasis, ustep, vbasis, vstep));
            return;
        }
        if (!RendermanInterface.ValidateState(8, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiBasis [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (ustep < 1) {
            logger.error("Invalid parameter " + ustep + " : ustep > 0 \n");
            return;
        }
        if (vstep < 1) {
            logger.error("Invalid parameter " + vstep + " : vstep > 0 \n");
            return;
        }
        CqMatrix u = new CqMatrix();
        CqMatrix v = new CqMatrix();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                u.m_aaElement[i][j] = ubasis[i][j];
                v.m_aaElement[i][j] = vbasis[i][j];
                ++j;
            }
            ++i;
        }
        u.SetfIdentity(false);
        v.SetfIdentity(false);
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetMatrixAttributeWrite("System", "Basis")[0].assignment(u);
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetMatrixAttributeWrite("System", "Basis")[1].assignment(v);
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"BasisStep")[0].value = ustep;
        RiGlobal.QGetRenderContext().pattrWriteCurrent().GetIntegerAttributeWrite((String)"System", (String)"BasisStep")[1].value = vstep;
        RiGlobal.QGetRenderContext().AdvanceTime();
    }

    public static void RiPatch(String type, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiPatchV(type, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiPatchV(String type, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPatchCache(type, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiPatch [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 0;
        if (type.equals(RI_BICUBIC)) {
            cVerts = 16;
        } else if (type.equals(RI_BILINEAR)) {
            cVerts = 4;
        }
        int i = 0;
        while (i < count) {
            block21: {
                block19: {
                    block20: {
                        block18: {
                            if (!tokens[i].equals(RI_P)) break block18;
                            cVerts *= 3;
                            break block19;
                        }
                        if (!tokens[i].equals(RI_PW)) break block20;
                        cVerts *= 4;
                        break block19;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block21;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    logger.error("Invalid \"" + tokens[i] + "\" parameter length " + Array.getLength(values[i]) + " : \"" + tokens[i] + "\" needs " + cVerts * 3 + " float values \n");
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        if (type.compareTo(RI_BICUBIC) == 0) {
            CqSurfacePatchBicubic pSurface = new CqSurfacePatchBicubic();
            if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
                pSurface.SetDefaultPrimitiveVariables();
                CqMatrix matuBasis = pSurface.pAttributes().GetMatrixAttribute("System", "Basis")[0];
                CqMatrix matvBasis = pSurface.pAttributes().GetMatrixAttribute("System", "Basis")[1];
                pSurface.ConvertToBezierBasis(matuBasis, matvBasis);
                float time = RiGlobal.QGetRenderContext().Time();
                pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                RendermanInterface.CreateGPrim(pSurface);
            }
        } else if (type.compareTo(RI_BILINEAR) == 0) {
            CqSurfacePatchBilinear pSurface = new CqSurfacePatchBilinear();
            if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
                pSurface.SetDefaultPrimitiveVariables();
                float time = RiGlobal.QGetRenderContext().Time();
                pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                RendermanInterface.CreateGPrim(pSurface);
            }
        } else {
            logger.error("RiPatch invalid patch type \"" + type + "\"");
        }
    }

    public static void RiPatchMesh(String type, int nu, String uwrap, int nv, String vwrap, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiPatchMeshV(type, nu, uwrap, nv, vwrap, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiPatchMeshV(String type, int nu, String uwrap, int nv, String vwrap, int count, String[] tokens, Object[] values) {
        CqSurface pSurface;
        boolean vPeriodic;
        boolean uPeriodic;
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiPatchMeshCache(type, nu, uwrap, nv, vwrap, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiPatchMesh [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (nu < 1) {
            logger.error("Invalid parameter " + nu + " : nu > 0 \n");
            return;
        }
        if (nv < 1) {
            logger.error("Invalid parameter " + nv + " : nv > 0 \n");
            return;
        }
        if (uwrap.compareTo(RI_PERIODIC) != 0 && uwrap.compareTo(RI_NONPERIODIC) != 0) {
            logger.error("RiPatchMesh invalid u-wrap type: \"" + uwrap + "\"\n");
        }
        if (vwrap.compareTo(RI_PERIODIC) != 0 && vwrap.compareTo(RI_NONPERIODIC) != 0) {
            logger.error("RiPatchMesh invalid v-wrap type: \"" + vwrap + "\"\n");
        }
        int cVerts = nu * nv;
        int i = 0;
        while (i < count) {
            block23: {
                block21: {
                    block22: {
                        block20: {
                            if (!tokens[i].equals(RI_P)) break block20;
                            cVerts *= 3;
                            break block21;
                        }
                        if (!tokens[i].equals(RI_PW)) break block22;
                        cVerts *= 4;
                        break block21;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block23;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    logger.error("Invalid \"" + tokens[i] + "\" parameter length " + Array.getLength(values[i]) + " : \"" + tokens[i] + "\" needs " + cVerts * 3 + " float values \n");
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        if (type.compareTo(RI_BICUBIC) == 0) {
            uPeriodic = uwrap.compareTo(RI_PERIODIC) == 0;
            pSurface = new CqSurfacePatchMeshBicubic(nu, nv, uPeriodic, vPeriodic = vwrap.compareTo(RI_PERIODIC) == 0);
            if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
                pSurface.SetDefaultPrimitiveVariables();
                STLVector<CqBasicSurface> aSplits = new STLVector<CqBasicSurface>(CqBasicSurface.class);
                ((CqSurfacePatchMeshBicubic)pSurface).Split(aSplits);
                for (CqBasicSurface iSS : aSplits) {
                    CqMatrix matuBasis = pSurface.pAttributes().GetMatrixAttribute("System", "Basis")[0];
                    CqMatrix matvBasis = pSurface.pAttributes().GetMatrixAttribute("System", "Basis")[1];
                    ((CqSurfacePatchBicubic)iSS).ConvertToBezierBasis(matuBasis, matvBasis);
                    float time = RiGlobal.QGetRenderContext().Time();
                    iSS.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                    RendermanInterface.CreateGPrim(iSS);
                }
            }
        } else if (type.compareTo(RI_BILINEAR) == 0) {
            uPeriodic = uwrap.compareTo(RI_PERIODIC) == 0;
            pSurface = new CqSurfacePatchMeshBilinear(nu, nv, uPeriodic, vPeriodic = vwrap.compareTo(RI_PERIODIC) == 0);
            if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
                pSurface.SetDefaultPrimitiveVariables();
                float time = RiGlobal.QGetRenderContext().Time();
                pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                RendermanInterface.CreateGPrim(pSurface);
            }
        } else {
            logger.error("RiPatchMesh invalid type \"" + type + "\"");
        }
    }

    public static void RiNuPatch(int nu, int uorder, float[] uknot, float umin, float umax, int nv, int vorder, float[] vknot, float vmin, float vmax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiNuPatchV(nu, uorder, uknot, umin, umax, nv, vorder, vknot, vmin, vmax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiNuPatchV(int nu, int uorder, float[] uknot, float umin, float umax, int nv, int vorder, float[] vknot, float vmin, float vmax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiNuPatchCache(nu, uorder, uknot, umin, umax, nv, vorder, vknot, vmin, vmax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiNuPatch [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (uorder < 1) {
            logger.error("Invalid parameter " + uorder + " : " + "uorder" + " > 0 \n");
            return;
        }
        if (vorder < 1) {
            logger.error("Invalid parameter " + vorder + " : " + "vorder" + " > 0 \n");
            return;
        }
        if (nu < uorder) {
            logger.error("Invalid parameter " + nu + " : " + "nu" + " > uorder = " + uorder + "\n");
            return;
        }
        if (nv < vorder) {
            logger.error("Invalid parameter " + nv + " : " + "nv" + " > vorder = " + vorder + "\n");
            return;
        }
        if (nu + uorder != uknot.length) {
            logger.error("Invalid \"uknot\" parameter length " + uknot.length + " : \"uknot\" needs " + (nu + uorder) + " float values \n");
            return;
        }
        if (nv + vorder != vknot.length) {
            logger.error("Invalid \"vknot\" parameter length " + vknot.length + " : \"vknot\" needs " + (nv + vorder) + " float values \n");
            return;
        }
        int cVerts = nu * nv;
        int i = 0;
        while (i < count) {
            block19: {
                block18: {
                    block17: {
                        if (!tokens[i].equals(RI_P)) break block17;
                        cVerts *= 3;
                        break block18;
                    }
                    if (!tokens[i].equals(RI_PW)) break block19;
                    cVerts *= 4;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    logger.error("Invalid \"" + tokens[i] + "\" parameter length " + Array.getLength(values[i]) + " : \"" + tokens[i] + "\" needs " + cVerts * 3 + " float values \n");
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqSurfaceNURBS pSurface = new CqSurfaceNURBS();
        pSurface.SetfPatchMesh();
        pSurface.Init(uorder, vorder, nu, nv);
        pSurface.Setumin(umin);
        pSurface.Setumax(umax);
        pSurface.Setvmin(vmin);
        pSurface.Setvmax(vmax);
        int i2 = 0;
        while (i2 < nu + uorder) {
            pSurface.auKnots().get((int)i2).value = uknot[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < nv + vorder) {
            pSurface.avKnots().get((int)i2).value = vknot[i2];
            ++i2;
        }
        if (RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values)) {
            pSurface.SetDefaultPrimitiveVariables();
            pSurface.Clamp();
            float time = RiGlobal.QGetRenderContext().Time();
            pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
            RendermanInterface.CreateGPrim(pSurface);
        }
    }

    public static void RiTrimCurve(int nloops, int[] ncurves, int[] order, float[] knot, float[] min, float[] max, int[] n, float[] u, float[] v, float[] w) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTrimCurveCache(nloops, ncurves, order, knot, min, max, n, u, v, w));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiTrimCurve [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int i = 0;
        while (i < nloops) {
            if (ncurves[i] < 0) {
                logger.error("Invalid parameter " + ncurves[i] + " at ncurves[" + i + "] : all ncurves > 0 \n");
                return;
            }
            ++i;
        }
        if (order.length != n.length) {
            logger.error("Invalid \"order\" parameter length and \"n\" parameter length \n");
            return;
        }
        i = 0;
        while (i < order.length) {
            if (order[i] < 1) {
                logger.error("Invalid parameter " + order[i] + " at order[" + i + "] : all order > 0 \n");
                return;
            }
            if (n[i] < 1) {
                logger.error("Invalid parameter " + n[i] + " at n[" + i + "] : all n > 0 \n");
                return;
            }
            ++i;
        }
        RiGlobal.QGetRenderContext().pattrWriteCurrent().TrimLoops().Clear();
        int in = 0;
        int iorder = 0;
        int iknot = 0;
        int ivert = 0;
        int iloop = 0;
        while (iloop < nloops) {
            CqTrimLoop Loop = new CqTrimLoop();
            int icurve = 0;
            while (icurve < ncurves[iloop]) {
                CqTrimCurve Curve = new CqTrimCurve();
                int o = order[iorder++];
                int cverts = n[in++];
                Curve.Init(o, cverts);
                boolean out = false;
                int i2 = 0;
                while (i2 < o + cverts) {
                    if (i2 >= knot.length) {
                        ((p_float)Curve.aKnots().get((int)i2)).value = 0.0f;
                        out = true;
                    } else {
                        ((p_float)Curve.aKnots().get((int)i2)).value = knot[iknot++];
                    }
                    ++i2;
                }
                if (out) {
                    logger.error("Invalid \"knot\" parameter length " + knot.length + " : \"knot\" needs " + (o + cverts) + " float values \n");
                }
                CqVector3D vec = new CqVector3D(0.0f, 0.0f, 1.0f);
                i2 = 0;
                while (i2 < cverts) {
                    vec.x(u[ivert]);
                    vec.y(v[ivert]);
                    vec.z(w[ivert++]);
                    Curve.CP(i2).assignment(vec);
                    ++i2;
                }
                Loop.aCurves().add(Curve);
                ++icurve;
            }
            RiGlobal.QGetRenderContext().pattrWriteCurrent().TrimLoops().aLoops().add(Loop);
            ++iloop;
        }
    }

    public static void RiSphere(float radius, float zmin, float zmax, float thetamax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiSphereV(radius, zmin, zmax, thetamax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiSphereV(float radius, float zmin, float zmax, float thetamax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiSphereCache(radius, zmin, zmax, thetamax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiSphere [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 4;
        int i = 0;
        while (i < count) {
            block11: {
                block9: {
                    block10: {
                        block8: {
                            if (!tokens[i].equals(RI_P)) break block8;
                            cVerts *= 3;
                            break block9;
                        }
                        if (!tokens[i].equals(RI_PW)) break block10;
                        cVerts *= 4;
                        break block9;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block11;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqLogRangeCheckCallback rc = new CqLogRangeCheckCallback();
        rc.set("sphere zmin");
        RiGlobal.CheckMinMax(zmin, Math.min(-radius, radius), Math.max(-radius, radius), rc);
        rc.set("sphere zmax");
        RiGlobal.CheckMinMax(zmax, Math.min(-radius, radius), Math.max(-radius, radius), rc);
        CqSphere pSurface = new CqSphere(radius, zmin, zmax, 0.0f, thetamax);
        RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
        pSurface.SetDefaultPrimitiveVariables();
        float time = RiGlobal.QGetRenderContext().Time();
        pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pSurface);
    }

    public static void RiCone(float height, float radius, float thetamax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiConeV(height, radius, thetamax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiConeV(float height, float radius, float thetamax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiConeCache(height, radius, thetamax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiCone [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (thetamax == 0.0f) {
            return;
        }
        int cVerts = 4;
        int i = 0;
        while (i < count) {
            block12: {
                block10: {
                    block11: {
                        block9: {
                            if (!tokens[i].equals(RI_P)) break block9;
                            cVerts *= 3;
                            break block10;
                        }
                        if (!tokens[i].equals(RI_PW)) break block11;
                        cVerts *= 4;
                        break block10;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block12;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqCone pSurface = new CqCone(height, radius, 0.0f, thetamax, 0.0f, 1.0f);
        RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
        pSurface.SetDefaultPrimitiveVariables();
        float time = RiGlobal.QGetRenderContext().Time();
        pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pSurface);
    }

    public static void RiCylinder(float radius, float zmin, float zmax, float thetamax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiCylinderV(radius, zmin, zmax, thetamax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiCylinderV(float radius, float zmin, float zmax, float thetamax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiCylinderCache(radius, zmin, zmax, thetamax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiCylinder [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 4;
        int i = 0;
        while (i < count) {
            block11: {
                block9: {
                    block10: {
                        block8: {
                            if (!tokens[i].equals(RI_P)) break block8;
                            cVerts *= 3;
                            break block9;
                        }
                        if (!tokens[i].equals(RI_PW)) break block10;
                        cVerts *= 4;
                        break block9;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block11;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqCylinder pSurface = new CqCylinder(radius, zmin, zmax, 0.0f, thetamax);
        RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
        pSurface.SetDefaultPrimitiveVariables();
        float time = RiGlobal.QGetRenderContext().Time();
        pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pSurface);
    }

    public static void RiHyperboloid(float[] point1, float[] point2, float thetamax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiHyperboloidV(point1, point2, thetamax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiHyperboloidV(float[] point1, float[] point2, float thetamax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiHyperboloidCache(point1, point2, thetamax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiHyperboloid [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 4;
        int i = 0;
        while (i < count) {
            block11: {
                block9: {
                    block10: {
                        block8: {
                            if (!tokens[i].equals(RI_P)) break block8;
                            cVerts *= 3;
                            break block9;
                        }
                        if (!tokens[i].equals(RI_PW)) break block10;
                        cVerts *= 4;
                        break block9;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block11;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqVector3D v0 = new CqVector3D(point1[0], point1[1], point1[2]);
        CqVector3D v1 = new CqVector3D(point2[0], point2[1], point2[2]);
        CqHyperboloid pSurface = new CqHyperboloid(v0, v1, 0.0f, thetamax);
        RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
        pSurface.SetDefaultPrimitiveVariables();
        float time = RiGlobal.QGetRenderContext().Time();
        pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pSurface);
    }

    public static void RiParaboloid(float rmax, float zmin, float zmax, float thetamax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiParaboloidV(rmax, zmin, zmax, thetamax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiParaboloidV(float rmax, float zmin, float zmax, float thetamax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiParaboloidCache(rmax, zmin, zmax, thetamax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiParaboloid [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (zmin < 0.0f) {
            logger.error("Invalid parameter " + zmin + " : zmin > 0 \n");
            return;
        }
        if (zmax < zmin) {
            logger.error("Invalid parameter " + zmax + " : zmax > zmin = " + zmin + "\n");
            return;
        }
        int cVerts = 4;
        int i = 0;
        while (i < count) {
            block13: {
                block11: {
                    block12: {
                        block10: {
                            if (!tokens[i].equals(RI_P)) break block10;
                            cVerts *= 3;
                            break block11;
                        }
                        if (!tokens[i].equals(RI_PW)) break block12;
                        cVerts *= 4;
                        break block11;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block13;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqParaboloid pSurface = new CqParaboloid(rmax, zmin, zmax, 0.0f, thetamax);
        RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
        pSurface.SetDefaultPrimitiveVariables();
        float time = RiGlobal.QGetRenderContext().Time();
        pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pSurface);
    }

    public static void RiDisk(float height, float radius, float thetamax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiDiskV(height, radius, thetamax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiDiskV(float height, float radius, float thetamax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiDiskCache(height, radius, thetamax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiDisk [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 4;
        int i = 0;
        while (i < count) {
            block11: {
                block9: {
                    block10: {
                        block8: {
                            if (!tokens[i].equals(RI_P)) break block8;
                            cVerts *= 3;
                            break block9;
                        }
                        if (!tokens[i].equals(RI_PW)) break block10;
                        cVerts *= 4;
                        break block9;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block11;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqDisk pSurface = new CqDisk(height, 0.0f, radius, 0.0f, thetamax);
        RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
        pSurface.SetDefaultPrimitiveVariables();
        float time = RiGlobal.QGetRenderContext().Time();
        pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pSurface);
    }

    public static void RiTorus(float majorrad, float minorrad, float phimin, float phimax, float thetamax, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiTorusV(majorrad, minorrad, phimin, phimax, thetamax, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiTorusV(float majorrad, float minorrad, float phimin, float phimax, float thetamax, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiTorusCache(majorrad, minorrad, phimin, phimax, thetamax, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiTorus [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 4;
        int i = 0;
        while (i < count) {
            block11: {
                block9: {
                    block10: {
                        block8: {
                            if (!tokens[i].equals(RI_P)) break block8;
                            cVerts *= 3;
                            break block9;
                        }
                        if (!tokens[i].equals(RI_PW)) break block10;
                        cVerts *= 4;
                        break block9;
                    }
                    if (!tokens[i].equals(RI_PZ)) break block11;
                    cVerts *= cVerts;
                }
                int diff = cVerts - Array.getLength(values[i]);
                if (diff > 0) {
                    p_float[] filledP = new p_float[cVerts];
                    System.arraycopy(values[i], 0, filledP, 0, Array.getLength(values[i]));
                    int j = Array.getLength(values[i]);
                    while (j < filledP.length) {
                        filledP[j] = new p_float(0.0f);
                        ++j;
                    }
                    values[i] = filledP;
                }
            }
            ++i;
        }
        CqTorus pSurface = new CqTorus(majorrad, minorrad, phimin, phimax, 0.0f, thetamax);
        RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
        pSurface.SetDefaultPrimitiveVariables();
        float time = RiGlobal.QGetRenderContext().Time();
        pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pSurface);
    }

    public static void RiProcedural(Object[] data, float[] bound, Method refineproc, Method freeproc) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiProceduralCache(data, bound, refineproc, freeproc));
            return;
        }
        if (!RendermanInterface.ValidateState(5, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiProcedural [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        CqBound B = new CqBound(bound);
        CqProcedural pProc = new CqProcedural(data, B, refineproc, freeproc);
        float time = RiGlobal.QGetRenderContext().Time();
        pProc.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pProc.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pProc.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pProc.pTransform().matObjectToWorld(time), time));
        RendermanInterface.CreateGPrim(pProc);
    }

    public static void RiProcRunProgram(Object[] data, float detail) {
        String progName = ((p_String[])data[0])[0].value;
        String strParam = ((p_String[])data[0])[1].value;
        if (!progName.contains(".")) {
            progName = String.valueOf(progName) + ".exe";
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(progName);
            BufferedInputStream bis = new BufferedInputStream(process.getInputStream());
            BufferedOutputStream bos = new BufferedOutputStream(process.getOutputStream());
            bos.write((String.valueOf(detail) + " " + strParam).getBytes());
            bos.flush();
            bos.close();
            Parser parser = new Parser();
            parser.parse(progName, bis);
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            logger.error("RiProcRunProgram: CreateProcess failed \n");
        }
    }

    public static void RiProcDelayedReadArchive(Object[] data, float detail) {
        RendermanInterface.RiReadArchive(((p_String[])data[0])[0].value, null, new Object[0]);
        CqStats.STATS_INC(22);
    }

    public static void RiProcDynamicLoad(Object[] data, float detail) {
        logger.warning("RiProcDynamicLoad not supported\n");
    }

    public static void RiProcFree(Object[] data) {
    }

    public static void RiGeometry(String type, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiGeometryV(type, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiGeometryV(String type, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiGeometryCache(type, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(5, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiGeometry [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (type.compareTo("teapot") == 0) {
            CqTeapot pSurface = new CqTeapot(true);
            pSurface.SetSurfaceParameters(pSurface);
            RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
            pSurface.SetDefaultPrimitiveVariables();
            int i = 0;
            while (i < pSurface.cNbrPatchMeshBicubic) {
                CqSurface pMesh = pSurface.pPatchMeshBicubic[i];
                float time = RiGlobal.QGetRenderContext().Time();
                pMesh.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
                RendermanInterface.CreateGPrim(pMesh);
                ++i;
            }
        } else if (type.compareTo("sphere") == 0) {
            CqSphere pSurface = new CqSphere(1.0f, -1.0f, 1.0f, 0.0f, 360.0f);
            RendermanInterface.ProcessPrimitiveVariables(pSurface, count, tokens, values);
            pSurface.SetDefaultPrimitiveVariables();
            float time = RiGlobal.QGetRenderContext().Time();
            pSurface.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pSurface.pTransform().matObjectToWorld(time), time));
            RendermanInterface.CreateGPrim(pSurface);
        } else {
            logger.warning("RiGeometry unrecognised type \"" + type + "\"" + "\n");
        }
    }

    public static void RiSolidBegin(String type) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiSolidBeginCache(type));
            return;
        }
        if (!RendermanInterface.ValidateState(5, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiSolidBegin [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        String strType = type;
        if (!(type.equals(RI_PRIMITIVE) || type.equals(RI_UNION) || type.equals(RI_INTERSECTION) || type.equals(RI_DIFFERENCE))) {
            logger.error("Invalid Parameter \"" + type + "\" : Solid Type is ( \"primitive\", \"union\", \"intersection\", \"difference\" ) \n");
            return;
        }
        RiGlobal.QGetRenderContext().BeginSolidModeBlock(strType);
    }

    public static void RiSolidEnd() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiSolidEndCache());
            return;
        }
        if (!RendermanInterface.ValidateState(1, 6)) {
            logger.error("Invalid state for RiSolidEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().EndSolidModeBlock();
    }

    public static Object RiObjectBegin() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiObjectBeginCache());
            return null;
        }
        if (!RendermanInterface.ValidateState(6, 1, 2, 3, 4, 5, 6)) {
            logger.error("Invalid state for RiObjectBegin [" + RendermanInterface.GetStateAsString() + "]\n");
            return null;
        }
        RiGlobal.QGetRenderContext().BeginObjectModeBlock();
        CqObjectInstance ObjectHandle = RiGlobal.QGetRenderContext().OpenNewObjectInstance();
        return ObjectHandle;
    }

    public static void RiObjectEnd() {
        if (!RendermanInterface.ValidateState(1, 7)) {
            logger.error("Invalid state for RiObjectEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().EndObjectModeBlock();
        RiGlobal.QGetRenderContext().CloseObjectInstance();
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiObjectEndCache());
            return;
        }
    }

    public static void RiObjectInstance(Object handle) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiObjectInstanceCache(handle));
            return;
        }
        if (!RendermanInterface.ValidateState(5, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiObjectInstance [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().InstantiateObject((CqObjectInstance)handle);
    }

    public static void RiMotionBegin(int N, Object ... pArgs) {
        float[] times = new float[N];
        int i = 0;
        while (i < N) {
            times[i] = ((p_float)pArgs[i]).value;
            ++i;
        }
        RendermanInterface.RiMotionBeginV(N, times);
        times = null;
    }

    public static void RiMotionBeginV(int N, float[] times) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMotionBeginVCache(N, times));
            return;
        }
        if (!RendermanInterface.ValidateState(7, 1, 2, 3, 4, 5, 6, 7)) {
            logger.error("Invalid state for RiMotionBeginV [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().BeginMotionModeBlock(N, times);
    }

    public static void RiMotionEnd() {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMotionEndCache());
            return;
        }
        if (!RendermanInterface.ValidateState(1, 8)) {
            logger.error("Invalid state for RiMotionEnd [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().EndMotionModeBlock();
    }

    public static void RiMakeTexture(String pic, String tex, String swrap, String twrap, Method filterfunc, float swidth, float twidth, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiMakeTextureV(pic, tex, swrap, twrap, filterfunc, swidth, twidth, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiMakeTextureV(String imagefile, String texturefile, String swrap, String twrap, Method filterfunc, float swidth, float twidth, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMakeTextureCache(imagefile, texturefile, swrap, twrap, filterfunc, swidth, twidth, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiMakeTexture [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        assert (imagefile != null && texturefile != null && swrap != null && twrap != null && filterfunc != null);
        if (imagefile.equals(texturefile)) {
            HimawariLogger.getLogger().error("ImageFile and TextureMapFile are the same names. \"" + imagefile + "\"\n");
            return;
        }
        RiGlobal.QGetRenderContext().Stats().MakeTextureTimer().Start();
        String modes = String.valueOf(swrap) + " " + twrap + " " + "box" + " " + swidth + " " + twidth;
        if (filterfunc.getName().equals("RiGaussianFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "gaussian" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiBoxFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "box" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiTriangleFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "triangle" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiCatmullRomFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "catmull-rom" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiSincFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "sinc" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiDiskFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "disk" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiBesselFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "bessel" + " " + swidth + " " + twidth;
        }
        CqTextureMap Source = new CqTextureMap(imagefile);
        Source.Open();
        p_int comp = new p_int();
        p_int qual = new p_int();
        RendermanInterface.ProcessCompression(comp, qual, count, tokens, values);
        Source.SetCompression(comp.value);
        Source.SetQuality(qual.value);
        if (Source.IsValid() && Source.Format().getValue() == 0) {
            Source.Interpreted(modes);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(new File(texturefile));
                    ImageIO.write((RenderedImage)Source.m_pImage, "png", fos);
                    fos.write(modes.getBytes());
                }
                catch (FileNotFoundException e) {
                    HimawariLogger.getLogger().error("Cannot open texture file \"" + texturefile + "\"\n");
                    HimawariLogger.outputException(e);
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
        }
        Source.Close();
        RiGlobal.QGetRenderContext().Stats().MakeTextureTimer().Stop();
    }

    public static void RiMakeBump(String imagefile, String bumpfile, String swrap, String twrap, Method filterfunc, float swidth, float twidth, Object ... pArgs) {
        logger.warning("RiMakeBump not supported\n");
    }

    public static void RiMakeBumpV(String imagefile, String bumpfile, String swrap, String twrap, Method filterfunc, float swidth, float twidth, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMakeBumpCache(imagefile, bumpfile, swrap, twrap, filterfunc, swidth, twidth, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiMakeBump [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        logger.warning("RiMakeBump not supported\n");
    }

    public static void RiMakeLatLongEnvironment(String imagefile, String reflfile, Method filterfunc, float swidth, float twidth, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiMakeLatLongEnvironmentV(imagefile, reflfile, filterfunc, swidth, twidth, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiMakeLatLongEnvironmentV(String imagefile, String reflfile, Method filterfunc, float swidth, float twidth, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMakeLatLongEnvironmentCache(imagefile, reflfile, filterfunc, swidth, twidth, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiMakeLatLongEnvironment [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (imagefile.equals(reflfile)) {
            HimawariLogger.getLogger().error("ImageFile and LatLongMapFile are the same names. \"" + imagefile + "\"\n");
            return;
        }
        String swrap = RI_PERIODIC;
        String twrap = RI_CLAMP;
        assert (imagefile != null && reflfile != null && swrap != null && twrap != null && filterfunc != null);
        RiGlobal.QGetRenderContext().Stats().MakeEnvTimer().Start();
        String modes = String.valueOf(swrap) + " " + twrap + " " + "box" + " " + swidth + " " + twidth;
        if (filterfunc.getName().equals("RiGaussianFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "gaussian" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiBoxFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "box" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiTriangleFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "triangle" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiCatmullRomFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "catmull-rom" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiSincFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "sinc" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiDiskFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "disk" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiBesselFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "bessel" + " " + swidth + " " + twidth;
        }
        CqTextureMap Source = new CqTextureMap(imagefile);
        Source.Open();
        p_int comp = new p_int();
        p_int qual = new p_int();
        RendermanInterface.ProcessCompression(comp, qual, count, tokens, values);
        Source.SetCompression(comp.value);
        Source.SetQuality(qual.value);
        if (Source.IsValid() && Source.Format().getValue() == 0) {
            Source.Interpreted(modes);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(new File(reflfile));
                    ImageIO.write((RenderedImage)Source.m_pImage, "png", fos);
                    fos.write(modes.getBytes());
                }
                catch (FileNotFoundException e) {
                    HimawariLogger.getLogger().error("Cannot open texture file \"" + reflfile + "\"\n");
                    HimawariLogger.outputException(e);
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
        }
        Source.Close();
        RiGlobal.QGetRenderContext().Stats().MakeEnvTimer().Stop();
    }

    public static void RiMakeCubeFaceEnvironment(String px, String nx, String py, String ny, String pz, String nz, String reflfile, float fov, Method filterfunc, float swidth, float twidth, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiMakeCubeFaceEnvironmentV(px, nx, py, ny, pz, nz, reflfile, fov, filterfunc, swidth, twidth, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiMakeCubeFaceEnvironmentV(String px, String nx, String py, String ny, String pz, String nz, String reflfile, float fov, Method filterfunc, float swidth, float twidth, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMakeCubeFaceEnvironmentCache(px, nx, py, ny, pz, nz, reflfile, fov, filterfunc, swidth, twidth, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiMakeCubeFaceEnvironment [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        String swrap = RI_BLACK;
        String twrap = RI_BLACK;
        RiGlobal.QGetRenderContext().Stats().MakeEnvTimer().Start();
        assert (px != null && nx != null && py != null && ny != null && pz != null && nz != null && reflfile != null && filterfunc != null);
        String modes = String.valueOf(swrap) + " " + twrap + " " + "box" + " " + swidth + " " + twidth;
        if (filterfunc.getName().equals("RiGaussianFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "gaussian" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiBoxFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "box" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiTriangleFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "triangle" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiCatmullRomFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "catmull-rom" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiSincFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "sinc" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiDiskFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "disk" + " " + swidth + " " + twidth;
        }
        if (filterfunc.getName().equals("RiBesselFilter")) {
            modes = String.valueOf(swrap) + " " + twrap + " " + "bessel" + " " + swidth + " " + twidth;
        }
        CqTextureMap tpx = new CqTextureMap(px);
        CqTextureMap tnx = new CqTextureMap(nx);
        CqTextureMap tpy = new CqTextureMap(py);
        CqTextureMap tny = new CqTextureMap(ny);
        CqTextureMap tpz = new CqTextureMap(pz);
        CqTextureMap tnz = new CqTextureMap(nz);
        tpx.Open();
        tnx.Open();
        tpy.Open();
        tny.Open();
        tpz.Open();
        tnz.Open();
        if (tpx.IsValid() && tnx.IsValid() && tpy.IsValid() && tny.IsValid() && tpz.IsValid() && tnz.IsValid()) {
            boolean fValid = false;
            if (tpx.XRes() == tnx.XRes() && tpx.XRes() == tpy.XRes() && tpx.XRes() == tny.XRes() && tpx.XRes() == tpz.XRes() && tpx.XRes() == tnz.XRes() && tpx.XRes() == tnx.XRes() && tpx.XRes() == tpy.XRes() && tpx.XRes() == tny.XRes() && tpx.XRes() == tpz.XRes() && tpx.XRes() == tnz.XRes()) {
                fValid = true;
            }
            if (!fValid) {
                logger.error("RiMakeCubeFaceEnvironment all images must be the same size\n");
                return;
            }
            CqTextureMap[] Images = new CqTextureMap[]{tpz, tpx, tpy, tnx, tny, tnz};
            int xRes = (int)tpx.XRes();
            int yRes = (int)tpx.YRes();
            FileOutputStream fos = null;
            try {
                try {
                    int width = xRes * 3;
                    int height = yRes * 2;
                    BufferedImage image = new BufferedImage(width, height, 1);
                    Graphics g = image.getGraphics();
                    g.drawImage(Images[0].m_pImage, 0, 0, null);
                    g.drawImage(Images[1].m_pImage, xRes, 0, null);
                    g.drawImage(Images[2].m_pImage, xRes * 2, 0, null);
                    g.drawImage(Images[3].m_pImage, 0, yRes, null);
                    g.drawImage(Images[4].m_pImage, xRes, yRes, null);
                    g.drawImage(Images[5].m_pImage, xRes * 2, yRes, null);
                    fos = new FileOutputStream(new File(reflfile));
                    ImageIO.write((RenderedImage)image, "png", fos);
                    g.dispose();
                    image = null;
                    fos.write(modes.getBytes());
                }
                catch (FileNotFoundException e) {
                    HimawariLogger.getLogger().error("Cannot open texture file \"" + reflfile + "\"\n");
                    HimawariLogger.outputException(e);
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
        }
        RiGlobal.QGetRenderContext().Stats().MakeEnvTimer().Stop();
    }

    public static void RiMakeShadow(String picfile, String shadowfile, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiMakeShadowV(picfile, shadowfile, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiMakeShadowV(String picfile, String shadowfile, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMakeShadowCache(picfile, shadowfile, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(2, 1, 2)) {
            logger.error("Invalid state for RiMakeShadow [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        if (picfile.equals(shadowfile)) {
            return;
        }
        RiGlobal.QGetRenderContext().Stats().MakeShadowTimer().Start();
        File src = new File(picfile);
        File dest = new File(shadowfile);
        FileInputStream in = null;
        FileOutputStream out = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                bis = new BufferedInputStream(in);
                bos = new BufferedOutputStream(out);
                byte[] buf = new byte[4096];
                while (bis.read(buf) != -1) {
                    bos.write(buf);
                }
            }
            catch (FileNotFoundException e) {
                if (in == null) {
                    HimawariLogger.getLogger().error("Cannot open texture file \"" + src + "\"\n");
                } else {
                    HimawariLogger.getLogger().error("Cannot open texture file \"" + dest + "\"\n");
                }
                HimawariLogger.outputException(e);
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
        }
        RiGlobal.QGetRenderContext().Stats().MakeShadowTimer().Stop();
    }

    public static void RiMakeOcclusion(int npics, String[] picfiles, String shadowfile, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiMakeOcclusionV(npics, picfiles, shadowfile, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiMakeOcclusionV(int npics, String[] picfiles, String shadowfile, int count, String[] tokens, Object[] values) {
        block22: {
            if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
                RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiMakeOcclusionCache(npics, picfiles, shadowfile, count, tokens, values));
                return;
            }
            if (!RendermanInterface.ValidateState(2, 1, 2)) {
                logger.error("Invalid state for RiMakeOcclusion [" + RendermanInterface.GetStateAsString() + "]\n");
                return;
            }
            RiGlobal.QGetRenderContext().Stats().MakeShadowTimer().Start();
            FileOutputStream out = null;
            FilterOutputStream bos = null;
            FileInputStream in = null;
            BufferedInputStream bis = null;
            File dest = null;
            File src = null;
            try {
                try {
                    dest = new File(shadowfile);
                    out = new FileOutputStream(dest);
                    bos = new BufferedOutputStream(out);
                    int index = 0;
                    while (index < npics) {
                        src = new File(picfiles[index]);
                        RandomAccessFile rfile = new RandomAccessFile(src, "r");
                        String str = rfile.readLine();
                        if (str == null || !str.equals("START_SHADOW_HEADER")) {
                            HimawariLogger.getLogger().error("invalid image file \"" + picfiles[index] + "\"\n");
                            rfile.close();
                        } else {
                            if (rfile != null) {
                                rfile.close();
                            }
                            in = new FileInputStream(src);
                            bis = new BufferedInputStream(in);
                            byte[] buf = new byte[4096];
                            while (bis.read(buf) != -1) {
                                bos.write(buf);
                            }
                        }
                        ++index;
                    }
                }
                catch (FileNotFoundException e) {
                    if (in == null) {
                        HimawariLogger.getLogger().error("Cannot open texture file \"" + src + "\"\n");
                        break block22;
                    }
                    HimawariLogger.getLogger().error("Cannot open texture file \"" + dest + "\"\n");
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    HimawariLogger.outputException(e);
                }
            }
        }
        RiGlobal.QGetRenderContext().Stats().MakeShadowTimer().Stop();
    }

    public static void RiErrorHandler(Method handler) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiErrorHandlerCache(handler));
            return;
        }
        if (!RendermanInterface.ValidateState(9, 0, 1, 2, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiErrorHandler [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        RiGlobal.QGetRenderContext().SetpErrorHandler(handler);
    }

    public static void RiErrorIgnore(int code, int severity, String message) {
    }

    public static void RiErrorPrint(int code, int severity, String message) {
        System.err.println("RiError: " + code + " : " + severity + " : " + message);
    }

    public static void RiErrorAbort(int code, int severity, String message) {
    }

    public static void RiSubdivisionMesh(String scheme, int nfaces, int[] nvertices, int[] vertices, int ntags, String[] tags, int[] nargs, int[] intargs, float[] floatargs, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiSubdivisionMeshV(scheme, nfaces, nvertices, vertices, ntags, tags, nargs, intargs, floatargs, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiSubdivisionMeshV(String scheme, int nfaces, int[] nvertices, int[] vertices, int ntags, String[] tags, int[] nargs, int[] intargs, float[] floatargs, int count, String[] tokens, Object[] values) {
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiSubdivisionMeshCache(scheme, nfaces, nvertices, vertices, ntags, tags, nargs, intargs, floatargs, count, tokens, values));
            return;
        }
        if (!RendermanInterface.ValidateState(6, 3, 4, 5, 6, 7, 8)) {
            logger.error("Invalid state for RiSubdivisionMesh [" + RendermanInterface.GetStateAsString() + "]\n");
            return;
        }
        int cVerts = 0;
        int[] pVerts = vertices;
        int pVertsIdx = 0;
        int sumnVerts = 0;
        int face = 0;
        while (face < nfaces) {
            sumnVerts += nvertices[face];
            int v = 0;
            while (v < nvertices[face]) {
                cVerts = Math.max(pVerts[pVertsIdx] + 1, cVerts);
                ++pVertsIdx;
                ++v;
            }
            ++face;
        }
        CqPolygonPoints pPointsClass = new CqPolygonPoints(cVerts, nfaces, sumnVerts);
        if (RendermanInterface.ProcessPrimitiveVariables(pPointsClass, count, tokens, values)) {
            if (scheme.compareTo("catmull-clark") == 0) {
                pPointsClass.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(pPointsClass.pTransform().Time(0)), pPointsClass.pTransform().Time(0)), RiGlobal.QGetRenderContext().matNSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(pPointsClass.pTransform().Time(0)), pPointsClass.pTransform().Time(0)), RiGlobal.QGetRenderContext().matVSpaceToSpace(RI_OBJECT, RI_CAMERA, new CqMatrix(), pPointsClass.pTransform().matObjectToWorld(pPointsClass.pTransform().Time(0)), pPointsClass.pTransform().Time(0)));
                CqSubdivision2 pSubd2 = new CqSubdivision2(pPointsClass);
                pSubd2.Prepare(cVerts);
                int iP = 0;
                face = 0;
                while (face < nfaces) {
                    int[] verticesSubAry = new int[vertices.length - iP];
                    System.arraycopy(vertices, iP, verticesSubAry, 0, verticesSubAry.length);
                    pSubd2.AddFacet(nvertices[face], verticesSubAry, iP);
                    iP += nvertices[face];
                    ++face;
                }
                if (pSubd2.Finalise()) {
                    int argcIndex = 0;
                    int floatargIndex = 0;
                    int intargIndex = 0;
                    int i = 0;
                    while (i < ntags) {
                        if (tags[i].compareTo("interpolateboundary") == 0) {
                            pSubd2.SetInterpolateBoundary(true);
                        } else if (tags[i].compareTo("crease") == 0) {
                            float creaseSharpness = floatargs[floatargIndex];
                            if (creaseSharpness > 5.0f) {
                                creaseSharpness = 5.0f;
                            }
                            creaseSharpness /= 5.0f;
                            creaseSharpness = (float)Math.pow(creaseSharpness, 0.2f);
                            int iEdge = 0;
                            while (iEdge < nargs[argcIndex] - 1) {
                                if (intargs[iEdge + intargIndex] < pSubd2.cVertices() && intargs[iEdge + intargIndex + 1] < pSubd2.cVertices()) {
                                    CqLath pEdge = pSubd2.pVertex(intargs[iEdge + intargIndex]);
                                    STLVector<CqLath> aQve = new STLVector<CqLath>(CqLath.class);
                                    pEdge.Qve(aQve);
                                    for (CqLath iOpp : aQve) {
                                        if (iOpp.ec() == null || iOpp.ec().VertexIndex() != intargs[iEdge + intargIndex + 1]) continue;
                                        pSubd2.AddSharpEdge(iOpp, creaseSharpness);
                                        pSubd2.AddSharpEdge(iOpp.ec(), creaseSharpness);
                                        break;
                                    }
                                }
                                ++iEdge;
                            }
                        } else if (tags[i].compareTo("corner") == 0) {
                            int iVertex = 0;
                            while (iVertex < nargs[argcIndex]) {
                                if (intargs[iVertex + intargIndex] < pSubd2.cVertices()) {
                                    CqLath pVertex = pSubd2.pVertex(intargs[iVertex + intargIndex]);
                                    pSubd2.AddSharpCorner(pVertex, Float.MAX_VALUE);
                                }
                                ++iVertex;
                            }
                        } else if (tags[i].compareTo("hole") == 0) {
                            int iFace = 0;
                            while (iFace < nargs[argcIndex]) {
                                pSubd2.SetHoleFace(intargs[iFace + intargIndex]);
                                ++iFace;
                            }
                        }
                        intargIndex += nargs[argcIndex++];
                        floatargIndex += nargs[argcIndex++];
                        ++i;
                    }
                    CqSurfaceSubdivisionMesh pMesh = new CqSurfaceSubdivisionMesh(pSubd2, nfaces);
                    RendermanInterface.CreateGPrim(pMesh);
                } else {
                    logger.error("RiSubdivisionMesh contains non-manifold data");
                }
            } else {
                logger.error("RiSubdivisionMesh invalid scheme \"" + scheme + "\"");
            }
        }
    }

    public static void RiReadArchive(String name, Method callback, Object ... pArgs) {
        STLVector<String> aTokens = new STLVector<String>(String.class);
        STLVector<Object> aValues = new STLVector<Object>(Object.class);
        int count = RendermanInterface.BuildParameterList(pArgs, aTokens, aValues);
        RendermanInterface.RiReadArchiveV(name, callback, count, aTokens.toArray(), aValues.toArray());
    }

    public static void RiReadArchiveV(String name, Method callback, int count, String[] tokens, Object[] values) {
        Parser parser = new Parser();
        if (RiGlobal.QGetRenderContext().pCurrentObject() != null) {
            RiGlobal.QGetRenderContext().pCurrentObject().AddCacheCommand(new RiReadArchiveCache(name, callback, count, tokens, values));
            return;
        }
        CqRiFile fileArchive = new CqRiFile(name, "archive");
        if (fileArchive.IsValid()) {
            String strRealName = fileArchive.strRealName();
            fileArchive.Close();
            try {
                parser.parse(strRealName);
                logger.info("RiReadArchive: Reading archive \"" + strRealName + "\"\n");
            }
            catch (Exception e) {
                HimawariLogger.outputException(e);
            }
        } else {
            logger.error("Archive \"" + name + "\" not found\n");
        }
    }

    public static void RiArchiveRecord(String type, String val, Object ... pArgs) {
    }

    Object RiGetContext() {
        return null;
    }

    public static void RiContext(Object object) {
    }

    public static void RiClippingPlane(float a, float b, float c, float d, float e, float f) {
        logger.warning("RiClippingPlane not supported\n");
    }

    static boolean ProcessPrimitiveVariables(CqSurface pSurface, int count, String[] tokens, Object[] values) {
        SqParameterDeclaration Decl;
        long start = System.currentTimeMillis();
        STLVector<p_int> aUserParams = new STLVector<p_int>(p_int.class);
        int fP = -1;
        p_float[] pPoints = null;
        int i = 0;
        while (i < count) {
            String token = tokens[i];
            Object value = values[i];
            Decl = new SqParameterDeclaration();
            try {
                Decl = RiGlobal.QGetRenderContext().FindParameterDecl(token);
            }
            catch (XqException e) {
                HimawariLogger.outputException(e);
            }
            long hash = Decl.m_strName.hashCode();
            if (hash == RIH_P && Decl.m_Class.getValue() == 4) {
                fP = 0;
                pPoints = (p_float[])value;
            } else if (hash == RIH_PZ && Decl.m_Class.getValue() == 4) {
                fP = 1;
                pPoints = (p_float[])value;
            } else if (hash == RIH_PW && Decl.m_Class.getValue() == 4) {
                fP = 2;
                pPoints = (p_float[])value;
            } else {
                aUserParams.add(new p_int(i));
            }
            ++i;
        }
        if (fP != -1) {
            pSurface.AddPrimitiveVariable(new CqParameterTypedVertex<CqVector4D, CqVector3D>(RI_P, 1, new EqVariableType(7), CqVector4D.class, CqVector3D.class));
            pSurface.P().SetSize(pSurface.cVertex());
            switch (fP) {
                case 0: {
                    int cvert = pSurface.cVertex();
                    int j = 0;
                    while (j < cvert) {
                        pSurface.P().pValue_get(j, 0).assignment(pPoints[j * 3].value, pPoints[j * 3 + 1].value, pPoints[j * 3 + 2].value);
                        ++j;
                    }
                    break;
                }
                case 1: {
                    int j = 0;
                    while (j < pSurface.cVertex()) {
                        CqVector3D vecP = pSurface.SurfaceParametersAtVertex(j);
                        vecP.z(pPoints[j].value);
                        pSurface.P().pValue_get(j, 0).assignment(vecP);
                        ++j;
                    }
                    break;
                }
                case 2: {
                    int j = 0;
                    while (j < pSurface.cVertex()) {
                        pSurface.P().pValue_get(j, 0).assignment(new CqVector4D(pPoints[j * 4].value, pPoints[j * 4 + 1].value, pPoints[j * 4 + 2].value, pPoints[j * 4 + 3].value));
                        ++j;
                    }
                    break;
                }
            }
        }
        long end = System.currentTimeMillis();
        if (aUserParams.size() > 0) {
            for (p_int iUserParam : aUserParams) {
                try {
                    Decl = RiGlobal.QGetRenderContext().FindParameterDecl(tokens[iUserParam.value]);
                }
                catch (XqException e) {
                    logger.error(e.strReason());
                    continue;
                }
                Class<?> valCls = values[iUserParam.value].getClass();
                if (!(Decl.m_Type.getValue() == 1 && valCls.equals(p_float[].class) || Decl.m_Type.getValue() == 2 && valCls.equals(p_float[].class) || Decl.m_Type.getValue() == 3 && valCls.equals(p_float[].class) || Decl.m_Type.getValue() == 8 && valCls.equals(p_float[].class) || Decl.m_Type.getValue() == 9 && valCls.equals(p_float[].class) || Decl.m_Type.getValue() == 4 && valCls.equals(p_String[].class) || Decl.m_Type.getValue() == 5 && valCls.equals(p_float[].class) || Decl.m_Type.getValue() == 7 && valCls.equals(p_float[].class) || Decl.m_Type.getValue() == 11 && valCls.equals(p_float[].class))) {
                    logger.error("Undeclared! " + AbstractKeywordParser.paramToString(valCls) + " Parameter[" + tokens[iUserParam.value] + "]\n");
                    continue;
                }
                CqParameter pNewParam = null;
                try {
                    pNewParam = RendermanInterface.createParameter(Decl);
                }
                catch (Exception e) {
                    HimawariLogger.outputException(e);
                    continue;
                }
                int cValues = 1;
                switch (Decl.m_Class.getValue()) {
                    case 2: {
                        cValues = pSurface.cUniform();
                        break;
                    }
                    case 3: {
                        cValues = pSurface.cVarying();
                        break;
                    }
                    case 4: {
                        cValues = pSurface.cVertex();
                        break;
                    }
                    case 5: {
                        cValues = pSurface.cFaceVarying();
                    }
                }
                pNewParam.SetSize(cValues);
                end = System.currentTimeMillis();
                switch (Decl.m_Type.getValue()) {
                    case 1: {
                        int iArrayIndex;
                        CqParameterTyped pFloatParam = (CqParameterTyped)pNewParam;
                        Object[] pValue = (p_float[])values[iUserParam.value];
                        int j = 0;
                        int iValIndex = 0;
                        while (iValIndex < cValues) {
                            iArrayIndex = 0;
                            while (iArrayIndex < Decl.m_Count) {
                                ((p_float)pFloatParam.pValue_get((int)iValIndex, (int)iArrayIndex)).value = pValue.length > j ? ((p_float)pValue[j]).value : 0.0f;
                                ++iArrayIndex;
                                ++j;
                            }
                            ++iValIndex;
                        }
                        break;
                    }
                    case 2: {
                        int iArrayIndex;
                        int iValIndex;
                        int j;
                        Object[] pValue;
                        CqParameterTyped pIntParam = (CqParameterTyped)pNewParam;
                        if (values[iUserParam.value] instanceof p_int[]) {
                            pValue = (p_int[])values[iUserParam.value];
                            j = 0;
                            iValIndex = 0;
                            while (iValIndex < cValues) {
                                iArrayIndex = 0;
                                while (iArrayIndex < Decl.m_Count) {
                                    ((p_int)pIntParam.pValue_get((int)iValIndex, (int)iArrayIndex)).value = pValue.length > j ? ((p_int)pValue[j]).value : 0;
                                    ++iArrayIndex;
                                    ++j;
                                }
                                ++iValIndex;
                            }
                        } else {
                            if (!(values[iUserParam.value] instanceof p_float[])) break;
                            pValue = (p_float[])values[iUserParam.value];
                            j = 0;
                            iValIndex = 0;
                            while (iValIndex < cValues) {
                                iArrayIndex = 0;
                                while (iArrayIndex < Decl.m_Count) {
                                    ((p_int)pIntParam.pValue_get((int)iValIndex, (int)iArrayIndex)).value = pValue.length > j ? (int)((p_float)pValue[j]).value : 0;
                                    ++iArrayIndex;
                                    ++j;
                                }
                                ++iValIndex;
                            }
                        }
                        break;
                    }
                    case 3: 
                    case 8: 
                    case 9: {
                        int temp;
                        float[] tempArray;
                        int iArrayIndex;
                        CqParameterTyped pVectorParam = (CqParameterTyped)pNewParam;
                        Object[] pValue = (p_float[])values[iUserParam.value];
                        int j = 0;
                        int iValIndex = 0;
                        while (iValIndex < cValues) {
                            iArrayIndex = 0;
                            while (iArrayIndex < Decl.m_Count) {
                                if (pValue.length > j * 3 + 2) {
                                    ((CqVector3D)pVectorParam.pValue_get(iValIndex, iArrayIndex)).assignment(((p_float)pValue[j * 3]).value, ((p_float)pValue[j * 3 + 1]).value, ((p_float)pValue[j * 3 + 2]).value);
                                } else if (j * 3 < pValue.length) {
                                    tempArray = new float[]{0.0f, 0.0f, 0.0f};
                                    temp = 0;
                                    while (j * 3 + temp < pValue.length) {
                                        tempArray[temp] = ((p_float)pValue[j * 3 + temp]).value;
                                        ++temp;
                                    }
                                    ((CqVector3D)pVectorParam.pValue_get(iValIndex, iArrayIndex)).assignment(tempArray[0], tempArray[1], tempArray[2]);
                                } else {
                                    ((CqVector3D)pVectorParam.pValue_get(iValIndex, iArrayIndex)).assignment(0.0f, 0.0f, 0.0f);
                                }
                                ++iArrayIndex;
                                ++j;
                            }
                            ++iValIndex;
                        }
                        break;
                    }
                    case 4: {
                        int iArrayIndex;
                        CqParameterTyped pStringParam = (CqParameterTyped)pNewParam;
                        Object[] pValue = (p_String[])values[iUserParam.value];
                        int j = 0;
                        int iValIndex = 0;
                        while (iValIndex < cValues) {
                            iArrayIndex = 0;
                            while (iArrayIndex < Decl.m_Count) {
                                ((p_String)pStringParam.pValue_get((int)iValIndex, (int)iArrayIndex)).value = pValue.length > j ? ((p_String)pValue[j]).value : "";
                                ++iArrayIndex;
                                ++j;
                            }
                            ++iValIndex;
                        }
                        break;
                    }
                    case 5: {
                        int temp;
                        float[] tempArray;
                        int iArrayIndex;
                        CqParameterTyped pColorParam = (CqParameterTyped)pNewParam;
                        Object[] pValue = (p_float[])values[iUserParam.value];
                        int j = 0;
                        int iValIndex = 0;
                        while (iValIndex < cValues) {
                            iArrayIndex = 0;
                            while (iArrayIndex < Decl.m_Count) {
                                if (pValue.length > j * 3 + 2) {
                                    ((CqColor)pColorParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqColor(((p_float)pValue[j * 3]).value, ((p_float)pValue[j * 3 + 1]).value, ((p_float)pValue[j * 3 + 2]).value));
                                } else if (j * 3 < pValue.length) {
                                    tempArray = new float[]{0.0f, 0.0f, 0.0f};
                                    temp = 0;
                                    while (j * 3 + temp < pValue.length) {
                                        tempArray[temp] = ((p_float)pValue[j * 3 + temp]).value;
                                        ++temp;
                                    }
                                    ((CqColor)pColorParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqColor(tempArray[0], tempArray[1], tempArray[2]));
                                } else {
                                    ((CqColor)pColorParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqColor(0.0f, 0.0f, 0.0f));
                                }
                                ++iArrayIndex;
                                ++j;
                            }
                            ++iValIndex;
                        }
                        break;
                    }
                    case 7: {
                        int temp;
                        float[] tempArray;
                        int iArrayIndex;
                        CqParameterTyped pVectorParam = (CqParameterTyped)pNewParam;
                        Object[] pValue = (p_float[])values[iUserParam.value];
                        int j = 0;
                        int iValIndex = 0;
                        while (iValIndex < cValues) {
                            iArrayIndex = 0;
                            while (iArrayIndex < Decl.m_Count) {
                                if (pValue.length > j * 4 + 3) {
                                    ((CqVector4D)pVectorParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqVector4D(((p_float)pValue[j * 4]).value, ((p_float)pValue[j * 4 + 1]).value, ((p_float)pValue[j * 4 + 2]).value, ((p_float)pValue[j * 4 + 3]).value));
                                } else if (j * 4 < pValue.length) {
                                    tempArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                                    temp = 0;
                                    while (j * 4 + temp < pValue.length) {
                                        tempArray[temp] = ((p_float)pValue[j * 4 + temp]).value;
                                        ++temp;
                                    }
                                    ((CqVector4D)pVectorParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqVector4D(tempArray[0], tempArray[1], tempArray[2], tempArray[3]));
                                } else {
                                    ((CqVector4D)pVectorParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqVector4D(0.0f, 0.0f, 0.0f, 0.0f));
                                }
                                ++iArrayIndex;
                                ++j;
                            }
                            ++iValIndex;
                        }
                        break;
                    }
                    case 11: {
                        int temp;
                        float[] tempArray;
                        int iArrayIndex;
                        CqParameterTyped pMatrixParam = (CqParameterTyped)pNewParam;
                        Object[] pValue = (p_float[])values[iUserParam.value];
                        int j = 0;
                        int iValIndex = 0;
                        while (iValIndex < cValues) {
                            iArrayIndex = 0;
                            while (iArrayIndex < Decl.m_Count) {
                                if (pValue.length > j * 16 + 15) {
                                    ((CqMatrix)pMatrixParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqMatrix(((p_float)pValue[j * 16]).value, ((p_float)pValue[j * 16 + 1]).value, ((p_float)pValue[j * 16 + 2]).value, ((p_float)pValue[j * 16 + 3]).value, ((p_float)pValue[j * 16 + 4]).value, ((p_float)pValue[j * 16 + 5]).value, ((p_float)pValue[j * 16 + 6]).value, ((p_float)pValue[j * 16 + 7]).value, ((p_float)pValue[j * 16 + 8]).value, ((p_float)pValue[j * 16 + 9]).value, ((p_float)pValue[j * 16 + 10]).value, ((p_float)pValue[j * 16 + 11]).value, ((p_float)pValue[j * 16 + 12]).value, ((p_float)pValue[j * 16 + 13]).value, ((p_float)pValue[j * 16 + 14]).value, ((p_float)pValue[j * 16 + 15]).value));
                                } else if (j * 16 < pValue.length) {
                                    tempArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                                    temp = 0;
                                    while (j * 16 + temp < pValue.length) {
                                        tempArray[temp] = ((p_float)pValue[j * 16 + temp]).value;
                                        ++temp;
                                    }
                                    ((CqMatrix)pMatrixParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqMatrix(tempArray));
                                } else {
                                    ((CqMatrix)pMatrixParam.pValue_get(iValIndex, iArrayIndex)).assignment(new CqMatrix(0.0f));
                                }
                                ++iArrayIndex;
                                ++j;
                            }
                            ++iValIndex;
                        }
                        break;
                    }
                }
                end = System.currentTimeMillis();
                pSurface.AddPrimitiveVariable(pNewParam);
            }
        }
        end = System.currentTimeMillis();
        return pSurface.P() != null;
    }

    public static void CreateGPrim(CqBasicSurface pSurface) {
        if (RiGlobal.QGetRenderContext().pattrCurrent().GetFloatAttribute("System", "LevelOfDetailBounds")[1] < 0.0f) {
            return;
        }
        if (RiGlobal.QGetRenderContext().pconCurrent().fMotionBlock()) {
            pSurface.PrepareTrimCurve();
            CqMotionModeBlock pMMB = (CqMotionModeBlock)RiGlobal.QGetRenderContext().pconCurrent();
            CqDeformingSurface pMS = pMMB.GetDeformingSurface();
            if (pMS == null) {
                CqDeformingSurface pNewMS = new CqDeformingSurface(pSurface);
                pNewMS.AddTimeSlot(RiGlobal.QGetRenderContext().Time(), pSurface);
                pMMB.SetDeformingSurface(pNewMS);
            } else {
                pMS.AddTimeSlot(RiGlobal.QGetRenderContext().Time(), pSurface);
            }
            RiGlobal.QGetRenderContext().AdvanceTime();
        } else {
            pSurface.PrepareTrimCurve();
            RiGlobal.QGetRenderContext().pImage().PostSurface(pSurface);
            CqStats.STATS_INC(2);
            if (RiGlobal.QGetRenderContext().pRaytracer() != null) {
                RiGlobal.QGetRenderContext().pRaytracer().AddPrimitive(pSurface);
            }
        }
    }

    public static boolean BasisFromName(float[][] b, String strName) {
        float[][] pVals = null;
        if (strName.equals("bezier")) {
            pVals = RiBezierBasis;
        } else if (strName.equals("bspline") || strName.equals("b-spline")) {
            pVals = RiBSplineBasis;
        } else if (strName.equals("catmull-rom")) {
            pVals = RiCatmullRomBasis;
        } else if (strName.equals("hermite")) {
            pVals = RiHermiteBasis;
        } else if (strName.equals("power")) {
            pVals = RiPowerBasis;
        }
        if (pVals != null) {
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 4) {
                    b[i][j] = pVals[i][j];
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static void RiProgressHandler(Method handler) {
        RiGlobal.QGetRenderContext().SetpProgressHandler(handler);
    }

    public static Method RiPreRenderFunction(Method function) {
        Method pOldPreRenderFunction = RiGlobal.QGetRenderContext().pPreRenderFunction();
        RiGlobal.QGetRenderContext().SetpPreRenderFunction(function);
        return pOldPreRenderFunction;
    }

    public static Method RiPreWorldFunction(Method function) {
        Method pOldPreWorldFunction = RiGlobal.QGetRenderContext().pPreWorldFunction();
        RiGlobal.QGetRenderContext().SetpPreWorldFunction(function);
        return pOldPreWorldFunction;
    }

    public static void SetShaderArgument(IqShader pShader, String name, Object val) {
        SqParameterDeclaration Decl = new SqParameterDeclaration();
        try {
            Decl = RiGlobal.QGetRenderContext().FindParameterDecl(name);
        }
        catch (XqException e) {
            logger.error(e.strReason());
            return;
        }
        pShader.SetArgument(Decl.m_strName, Decl.m_Type, Decl.m_strSpace, val);
    }

    static void ProcessCompression(p_int compression, p_int quality, int count, String[] tokens, Object[] values) {
    }

    private static CqParameter createParameter(SqParameterDeclaration Decl) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        CqParameter pParam = null;
        if (Decl == null) {
            return null;
        }
        switch (Decl.m_Type.getValue()) {
            case 0: {
                break;
            }
            case 1: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, p_float.class, p_float.class);
                break;
            }
            case 2: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, p_int.class, p_float.class);
                break;
            }
            case 3: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, CqVector3D.class, CqVector3D.class);
                break;
            }
            case 4: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, p_String.class, p_String.class);
                break;
            }
            case 5: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, CqColor.class, CqColor.class);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, CqVector4D.class, CqVector4D.class);
                break;
            }
            case 8: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, CqVector3D.class, CqVector3D.class);
                break;
            }
            case 9: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, CqVector3D.class, CqVector3D.class);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                pParam = (CqParameter)Decl.m_pCreate.invoke(null, Decl.m_strName, Decl.m_Count, Decl.m_Type, CqMatrix.class, CqMatrix.class);
                break;
            }
        }
        return pParam;
    }
}

