/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.util.Collection;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqTrimCurve;
import net.cellcomputing.himawari.library.types.CqVector2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqTrimLoop {
    private STLVector<CqTrimCurve> m_aCurves = new STLVector<CqTrimCurve>(CqTrimCurve.class);
    private STLVector<CqVector2D> m_aCurvePoints = new STLVector<CqVector2D>(CqVector2D.class);
    private int Maxindex = 1000;
    private STLArray<p_int>[] m_aCurvePointsIndex = new STLArray[this.Maxindex];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CqTrimLoop() {
        int i = 0;
        while (i < this.Maxindex) {
            this.m_aCurvePointsIndex[i] = new STLArray<p_int>(p_int.class);
            ++i;
        }
    }

    public CqTrimLoop(CqTrimLoop From) {
        int i = 0;
        while (i < this.Maxindex) {
            this.m_aCurvePointsIndex[i] = new STLArray<p_int>(p_int.class);
            this.m_aCurvePointsIndex[i].addAll((Collection<p_int>)From.m_aCurvePointsIndex[i]);
            ++i;
        }
        this.m_aCurves.addAll(From.m_aCurves);
    }

    public void destract() {
    }

    public STLVector<CqTrimCurve> aCurves() {
        return this.m_aCurves;
    }

    public void Prepare(CqSurface pSurface) {
        for (CqTrimCurve iCurve : this.m_aCurves) {
            int cPoints = pSurface.TrimDecimation(iCurve);
            iCurve.Clamp();
            float range = ((p_float)iCurve.aKnots().get((int)(iCurve.cKnots() - 1))).value - ((p_float)iCurve.aKnots().get((int)0)).value;
            float u = ((p_float)iCurve.aKnots().get((int)0)).value;
            float du = range / (float)cPoints;
            int iPoint = 0;
            while (iPoint < cPoints) {
                CqVector2D tmp = iCurve.Evaluate(u);
                this.m_aCurvePoints.add(tmp);
                int lastindex = this.m_aCurvePoints.size() - 1;
                if (lastindex != 0) {
                    int j;
                    int B;
                    int A = (int)Math.floor(tmp.y * (float)this.Maxindex % (float)this.Maxindex);
                    if (A == (B = (int)Math.floor(((CqVector2D)this.m_aCurvePoints.get((int)(lastindex - 1))).y * (float)this.Maxindex % (float)this.Maxindex))) {
                        this.m_aCurvePointsIndex[A].add(new p_int(lastindex));
                    } else if (A < B) {
                        if (A != 0) {
                            j = A;
                            while (j <= B) {
                                this.m_aCurvePointsIndex[j].add(new p_int(lastindex));
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j <= A) {
                                this.m_aCurvePointsIndex[j].add(new p_int(lastindex));
                                ++j;
                            }
                            j = B;
                            while (j <= this.Maxindex - 1) {
                                this.m_aCurvePointsIndex[j].add(new p_int(lastindex));
                                ++j;
                            }
                        }
                    } else if (B < A) {
                        if (B != 0) {
                            j = B;
                            while (j <= A) {
                                this.m_aCurvePointsIndex[j].add(new p_int(lastindex));
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j <= B) {
                                this.m_aCurvePointsIndex[j].add(new p_int(lastindex));
                                ++j;
                            }
                            j = A;
                            while (j <= this.Maxindex - 1) {
                                this.m_aCurvePointsIndex[j].add(new p_int(lastindex));
                                ++j;
                            }
                        }
                    }
                }
                u += du;
                ++iPoint;
            }
        }
    }

    public boolean TrimPoint(CqVector2D v) {
        float x = v.x;
        float y = v.y;
        boolean oddNodes = false;
        int index = (int)Math.floor(v.y * (float)this.Maxindex % (float)this.Maxindex);
        int size = this.m_aCurvePointsIndex[index].size();
        int MaxSize = this.m_aCurvePoints.size() - 1;
        int i = 0;
        while (i < size) {
            int front_index = this.m_aCurvePointsIndex[index].get((int)i).value;
            int back_index = front_index == 0 ? MaxSize : front_index - 1;
            float ax = ((CqVector2D)this.m_aCurvePoints.get((int)front_index)).x;
            float ay = ((CqVector2D)this.m_aCurvePoints.get((int)front_index)).y;
            float bx = ((CqVector2D)this.m_aCurvePoints.get((int)back_index)).x;
            float by = ((CqVector2D)this.m_aCurvePoints.get((int)back_index)).y;
            if ((ay < y && by >= y || by < y && ay >= y) && ax + (y - ay) / (by - ay) * (bx - ax) < x) {
                oddNodes = !oddNodes;
            }
            ++i;
        }
        return oddNodes;
    }

    public boolean LineIntersects(CqVector2D v1, CqVector2D v2) {
        float x1 = v1.x;
        float y1 = v1.y;
        float x2 = v2.x;
        float y2 = v2.y;
        int size = this.m_aCurvePoints.size();
        int i = 0;
        int j = size - 1;
        while (i < size) {
            float y4 = ((CqVector2D)this.m_aCurvePoints.get((int)j)).y;
            float y3 = ((CqVector2D)this.m_aCurvePoints.get((int)i)).y;
            float x4 = ((CqVector2D)this.m_aCurvePoints.get((int)j)).x;
            float x3 = ((CqVector2D)this.m_aCurvePoints.get((int)i)).x;
            float d = (x2 - x1) * (y4 - y3) - (y2 - y1) * (x4 - x3);
            if (d != 0.0f) {
                float r = ((y1 - y3) * (x4 - x3) - (x1 - x3) * (y4 - y3)) / d;
                float s = ((y1 - y3) * (x2 - x1) - (x1 - x3) * (y2 - y1)) / d;
                if (r >= 0.0f && s >= 0.0f && r <= 1.0f && s <= 1.0f) {
                    return true;
                }
            }
            j = i++;
        }
        return false;
    }
}

