/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqSubdivision2;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqSurfaceSubdivisionPatch;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfaceSubdivisionMesh
extends CqSurface {
    private int m_NumFaces;
    private CqSubdivision2 m_pTopology;

    public CqSurfaceSubdivisionMesh(CqSubdivision2 pTopology, int NumFaces) {
        this.m_NumFaces = NumFaces;
        this.m_pTopology = pTopology;
    }

    @Override
    public CqBound Bound() {
        CqBound B = new CqBound();
        if (this.m_pTopology != null && this.m_pTopology.pPoints() != null && this.m_pTopology.pPoints().P() != null) {
            int PointIndex = this.m_pTopology.pPoints().P().Size() - 1;
            while (PointIndex >= 0) {
                B.Encapsulate(new CqVector3D(this.m_pTopology.pPoints().P().pValue_get(0, PointIndex)));
                --PointIndex;
            }
        }
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqMicroPolyGridBase Dice() {
        return null;
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        int CreatedPolys = 0;
        int face = 0;
        while (face < this.m_NumFaces) {
            if (!(this.m_pTopology.pFacet(face).isBoundaryFacet() && !this.m_pTopology.isInterpolateBoundary() || this.m_pTopology.isHoleFace(face))) {
                CqSurfaceSubdivisionPatch pNew = new CqSurfaceSubdivisionPatch(this.m_pTopology, this.m_pTopology.pFacet(face), face);
                aSplits.add(pNew);
                ++CreatedPolys;
            }
            ++face;
        }
        return CreatedPolys;
    }

    @Override
    public boolean Diceable() {
        return false;
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime) {
        assert (this.m_pTopology != null);
        this.m_pTopology.pPoints().Transform(matTx, matITTx, matRTx, iTime);
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public int cUniform() {
        return this.m_NumFaces;
    }

    @Override
    public int cVarying() {
        assert (this.m_pTopology != null);
        assert (this.m_pTopology.pPoints() != null);
        return this.m_pTopology.pPoints().cVarying();
    }

    @Override
    public int cVertex() {
        assert (this.m_pTopology != null);
        assert (this.m_pTopology.pPoints() != null);
        return this.m_pTopology.pPoints().cVertex();
    }

    @Override
    public int cFaceVarying() {
        assert (this.m_pTopology != null);
        assert (this.m_pTopology.pPoints() != null);
        return this.m_pTopology.pPoints().cFaceVarying();
    }
}

