/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqAttributes;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqTrimCurve;
import net.cellcomputing.himawari.library.CqTrimLoop;
import net.cellcomputing.himawari.library.CqTrimLoopArray;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.library.types.PublicFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfaceNURBS
extends CqSurface {
    public static final int NURBS_H_INCLUDED = 1;
    protected STLArray<p_float> m_auKnots = new STLArray<p_float>(p_float.class);
    protected STLArray<p_float> m_avKnots = new STLArray<p_float>(p_float.class);
    protected int m_uOrder;
    protected int m_vOrder;
    protected int m_cuVerts;
    protected int m_cvVerts;
    protected float m_umin;
    protected float m_umax;
    protected float m_vmin;
    protected float m_vmax;
    protected boolean m_fPatchMesh;
    protected CqTrimLoopArray m_TrimLoops = new CqTrimLoopArray();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CqSurfaceNURBS() {
        this.m_uOrder = 0;
        this.m_vOrder = 0;
        this.m_cuVerts = 0;
        this.m_cvVerts = 0;
        this.m_umin = 0.0f;
        this.m_umax = 1.0f;
        this.m_vmin = 0.0f;
        this.m_vmax = 1.0f;
        this.m_fPatchMesh = false;
        this.m_TrimLoops.aLoops().clear();
        for (CqTrimLoop tmp : ((CqAttributes)this.pAttributes()).TrimLoops().aLoops()) {
            this.m_TrimLoops.aLoops().add(new CqTrimLoop(tmp));
        }
        CqStats.STATS_INC(7);
    }

    public CqSurfaceNURBS(CqSurfaceNURBS From) {
        this.assignment(From);
        CqStats.STATS_INC(7);
    }

    @Override
    public void destruct() {
    }

    public void Torus() {
    }

    public int uOrder() {
        return this.m_uOrder;
    }

    public int vOrder() {
        return this.m_vOrder;
    }

    public int uDegree() {
        return this.m_uOrder - 1;
    }

    public int vDegree() {
        return this.m_vOrder - 1;
    }

    public int cuVerts() {
        return this.m_cuVerts;
    }

    public int cvVerts() {
        return this.m_cvVerts;
    }

    public int cuKnots() {
        return this.m_cuVerts + this.m_uOrder;
    }

    public int cvKnots() {
        return this.m_cvVerts + this.m_vOrder;
    }

    public float umin() {
        return this.m_umin;
    }

    public void Setumin(float umin) {
        this.m_umin = umin;
    }

    public float vmin() {
        return this.m_vmin;
    }

    public void Setvmin(float vmin) {
        this.m_vmin = vmin;
    }

    public float umax() {
        return this.m_umax;
    }

    public void Setumax(float umax) {
        this.m_umax = umax;
    }

    public float vmax() {
        return this.m_vmax;
    }

    public void Setvmax(float vmax) {
        this.m_vmax = vmax;
    }

    public STLArray<p_float> auKnots() {
        return this.m_auKnots;
    }

    public STLArray<p_float> avKnots() {
        return this.m_avKnots;
    }

    public int cuSegments() {
        return 1 + this.m_cuVerts - this.m_uOrder;
    }

    public int cvSegments() {
        return 1 + this.m_cvVerts - this.m_vOrder;
    }

    public boolean fPatchMesh() {
        return this.m_fPatchMesh;
    }

    public void SetfPatchMesh() {
        this.SetfPatchMesh(true);
    }

    public void SetfPatchMesh(boolean fPatchMesh) {
        this.m_fPatchMesh = fPatchMesh;
    }

    public void assignment(CqSurfaceNURBS From) {
        super.assignment(From);
        this.Init(From.m_uOrder, From.m_vOrder, From.m_cuVerts, From.m_cvVerts);
        this.m_umin = From.m_umin;
        this.m_umax = From.m_umax;
        this.m_vmin = From.m_vmin;
        this.m_vmax = From.m_vmax;
        this.m_fPatchMesh = From.m_fPatchMesh;
        int i = From.m_auKnots.size() - 1;
        while (i >= 0) {
            this.m_auKnots.get((int)i).value = From.m_auKnots.get((int)i).value;
            --i;
        }
        i = From.m_avKnots.size() - 1;
        while (i >= 0) {
            this.m_avKnots.get((int)i).value = From.m_avKnots.get((int)i).value;
            --i;
        }
        this.m_TrimLoops.aLoops().clear();
        this.m_TrimLoops.aLoops().addAll(((CqAttributes)this.pAttributes()).TrimLoops().aLoops());
    }

    public int compareTo(CqSurfaceNURBS from) {
        if (from.m_cuVerts != this.m_cuVerts || from.m_cvVerts != this.m_cvVerts) {
            return 0;
        }
        if (from.m_uOrder != this.m_uOrder || from.m_vOrder != this.m_vOrder) {
            return 0;
        }
        int i = this.P().Size() - 1;
        while (i >= 0) {
            if (!this.P().pValue_get(i, 0).equals(from.P().pValue_get(i, 0))) {
                return 0;
            }
            --i;
        }
        i = this.m_auKnots.size() - 1;
        while (i >= 0) {
            if (this.m_auKnots.get((int)i).value != from.m_auKnots.get((int)i).value) {
                return 0;
            }
            --i;
        }
        i = this.m_avKnots.size() - 1;
        while (i >= 0) {
            if (this.m_avKnots.get((int)i).value != from.m_avKnots.get((int)i).value) {
                return 0;
            }
            --i;
        }
        return 1;
    }

    public final CqVector4D CP(int u, int v) {
        return this.P().pValue_get(v * this.m_cuVerts + u, 0);
    }

    public void Init(int uOrder, int vOrder, int cuVerts, int cvVerts) {
        int uKnots = cuVerts + uOrder;
        int vKnots = cvVerts + vOrder;
        this.m_auKnots.resize(uKnots);
        this.m_avKnots.resize(vKnots);
        this.m_uOrder = uOrder;
        this.m_vOrder = vOrder;
        this.m_cuVerts = cuVerts;
        this.m_cvVerts = cvVerts;
    }

    public int FindSpanU(float u) {
        if (u >= this.m_auKnots.get((int)this.m_cuVerts).value) {
            return this.m_cuVerts - 1;
        }
        if (u <= this.m_auKnots.get((int)this.uDegree()).value) {
            return this.uDegree();
        }
        int low = 0;
        int high = this.m_cuVerts + 1;
        int mid = (low + high) / 2;
        while (u < this.m_auKnots.get((int)mid).value || u >= this.m_auKnots.get((int)(mid + 1)).value) {
            if (u < this.m_auKnots.get((int)mid).value) {
                high = mid;
            } else {
                low = mid;
            }
            mid = (low + high) / 2;
        }
        return mid;
    }

    public int FindSpanV(float v) {
        if (v >= this.m_avKnots.get((int)this.m_cvVerts).value) {
            return this.m_cvVerts - 1;
        }
        if (v <= this.m_avKnots.get((int)this.vDegree()).value) {
            return this.vDegree();
        }
        int low = 0;
        int high = this.m_cvVerts + 1;
        int mid = (low + high) / 2;
        while (v < this.m_avKnots.get((int)mid).value || v >= this.m_avKnots.get((int)(mid + 1)).value) {
            if (v < this.m_avKnots.get((int)mid).value) {
                high = mid;
            } else {
                low = mid;
            }
            mid = (low + high) / 2;
        }
        return mid;
    }

    public void BasisFunctions(float u, int i, STLArray<p_float> U, int k, STLArray<p_float> N) {
        float[] left = new float[k];
        float[] right = new float[k];
        N.get((int)0).value = 1.0f;
        int j = 1;
        while (j <= k - 1) {
            left[j] = u - U.get((int)(i + 1 - j)).value;
            right[j] = U.get((int)(i + j)).value - u;
            float saved = 0.0f;
            int r = 0;
            while (r < j) {
                float temp = N.get((int)r).value / (right[r + 1] + left[j - r]);
                N.get((int)r).value = saved + right[r + 1] * temp;
                saved = left[j - r] * temp;
                ++r;
            }
            N.get((int)j).value = saved;
            ++j;
        }
    }

    public void DersBasisFunctions(float u, int i, STLArray<p_float> U, int k, int n, STLVector<STLVector<p_float>> ders) {
        int r;
        float[] left = new float[k];
        float[] right = new float[k];
        STLVector ndu = new STLVector(2, p_float.class, k);
        STLVector a = new STLVector(2, p_float.class, 2);
        int j = 0;
        while (j < k) {
            ((STLVector)ndu.get(j)).resize(k);
            ++j;
        }
        ders.resize(n + 1);
        j = 0;
        while (j < n + 1) {
            ((STLVector)ders.get(j)).resize(k);
            ++j;
        }
        ((STLVector)a.get(0)).resize(k);
        ((STLVector)a.get(1)).resize(k);
        int p = k - 1;
        ((p_float)((STLVector)ndu.get((int)0)).get((int)0)).value = 1.0f;
        j = 1;
        while (j <= p) {
            left[j] = u - U.get((int)(i + 1 - j)).value;
            right[j] = U.get((int)(i + j)).value - u;
            float saved = 0.0f;
            r = 0;
            while (r < j) {
                ((p_float)((STLVector)ndu.get((int)j)).get((int)r)).value = right[r + 1] + left[j - r];
                float temp = ((p_float)((STLVector)ndu.get((int)r)).get((int)(j - 1))).value / ((p_float)((STLVector)ndu.get((int)j)).get((int)r)).value;
                ((p_float)((STLVector)ndu.get((int)r)).get((int)j)).value = saved + right[r + 1] * temp;
                saved = left[j - r] * temp;
                ++r;
            }
            ((p_float)((STLVector)ndu.get((int)j)).get((int)j)).value = saved;
            ++j;
        }
        j = 0;
        while (j <= p) {
            ((p_float)((STLVector)ders.get((int)0)).get((int)j)).value = ((p_float)((STLVector)ndu.get((int)j)).get((int)p)).value;
            ++j;
        }
        r = 0;
        while (r <= p) {
            int s1 = 0;
            int s2 = 1;
            ((p_float)((STLVector)a.get((int)0)).get((int)0)).value = 1.0f;
            k = 1;
            while (k <= n) {
                float d = 0.0f;
                int rk = r - k;
                int pk = p - k;
                if (r >= k) {
                    ((p_float)((STLVector)a.get((int)s2)).get((int)0)).value = ((p_float)((STLVector)a.get((int)s1)).get((int)0)).value / ((p_float)((STLVector)ndu.get((int)(pk + 1))).get((int)rk)).value;
                    d = ((p_float)((STLVector)a.get((int)s2)).get((int)0)).value * ((p_float)((STLVector)ndu.get((int)rk)).get((int)pk)).value;
                }
                int j1 = rk >= -1 ? 1 : -rk;
                int j2 = r - 1 <= pk ? k - 1 : p - r;
                j = j1;
                while (j <= j2) {
                    ((p_float)((STLVector)a.get((int)s2)).get((int)j)).value = (((p_float)((STLVector)a.get((int)s1)).get((int)j)).value - ((p_float)((STLVector)a.get((int)s1)).get((int)(j - 1))).value) / ((p_float)((STLVector)ndu.get((int)(pk + 1))).get((int)(rk + j))).value;
                    d += ((p_float)((STLVector)a.get((int)s2)).get((int)j)).value * ((p_float)((STLVector)ndu.get((int)(rk + j))).get((int)pk)).value;
                    ++j;
                }
                if (r <= pk) {
                    ((p_float)((STLVector)a.get((int)s2)).get((int)k)).value = -((p_float)((STLVector)a.get((int)s1)).get((int)(k - 1))).value / ((p_float)((STLVector)ndu.get((int)(pk + 1))).get((int)r)).value;
                    d += ((p_float)((STLVector)a.get((int)s2)).get((int)k)).value * ((p_float)((STLVector)ndu.get((int)r)).get((int)pk)).value;
                }
                ((p_float)((STLVector)ders.get((int)k)).get((int)r)).value = d;
                j = s1;
                s1 = s2;
                s2 = j;
                ++k;
            }
            ++r;
        }
        r = p;
        k = 1;
        while (k <= n) {
            j = 0;
            while (j <= p) {
                ((p_float)((STLVector)ders.get((int)k)).get((int)j)).value *= (float)r;
                ++j;
            }
            r *= p - k;
            ++k;
        }
    }

    public <T, SLT> T Evaluate(float u, float v, CqParameterTyped<T, SLT> pParam) {
        Object S;
        block15: {
            int uind;
            int vspan;
            block20: {
                STLArray<p_float> Nv;
                STLArray<p_float> Nu;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block14: {
                                    Nu = new STLArray<p_float>(p_float.class, this.m_uOrder);
                                    Nv = new STLArray<p_float>(p_float.class, this.m_vOrder);
                                    int uspan = this.FindSpanU(u);
                                    this.BasisFunctions(u, uspan, this.m_auKnots, this.m_uOrder, Nu);
                                    vspan = this.FindSpanV(v);
                                    this.BasisFunctions(v, vspan, this.m_avKnots, this.m_vOrder, Nv);
                                    uind = uspan - this.uDegree();
                                    S = pParam.pValue_get(0, 0);
                                    if (!(S instanceof p_float)) break block14;
                                    S = new p_float();
                                    float temp = 0.0f;
                                    int l = 0;
                                    while (l <= this.vDegree()) {
                                        int vind = vspan - this.vDegree() + l;
                                        int k = 0;
                                        while (k <= this.uDegree()) {
                                            temp += Nu.get((int)k).value * ((p_float)pParam.pValue_get((int)(vind * this.m_cuVerts + uind + k), (int)0)).value;
                                            ++k;
                                        }
                                        ((p_float)S).value += Nv.get((int)0).value * temp;
                                        ++l;
                                    }
                                    break block15;
                                }
                                if (!(S instanceof p_int)) break block16;
                                S = new p_int();
                                int l = 0;
                                while (l <= this.vDegree()) {
                                    int temp = 0;
                                    int vind = vspan - this.vDegree() + l;
                                    int k = 0;
                                    while (k <= this.uDegree()) {
                                        temp += (int)Nu.get((int)k).value * ((p_int)pParam.pValue_get((int)(vind * this.m_cuVerts + uind + k), (int)0)).value;
                                        ++k;
                                    }
                                    ((p_int)S).value += (int)Nv.get((int)l).value * temp;
                                    ++l;
                                }
                                break block15;
                            }
                            if (!(S instanceof CqVector3D)) break block17;
                            S = new CqVector3D();
                            int l = 0;
                            while (l <= this.vDegree()) {
                                CqVector3D temp = new CqVector3D();
                                int vind = vspan - this.vDegree() + l;
                                int k = 0;
                                while (k <= this.uDegree()) {
                                    temp.assignment(temp.add(((CqVector3D)pParam.pValue_get(vind * this.m_cuVerts + uind + k, 0)).mul(Nu.get((int)k).value)));
                                    ++k;
                                }
                                ((CqVector3D)S).assignment(((CqVector3D)S).add(temp.mul(Nv.get((int)l).value)));
                                ++l;
                            }
                            break block15;
                        }
                        if (!(S instanceof CqVector4D)) break block18;
                        S = new CqVector4D();
                        int l = 0;
                        while (l <= this.vDegree()) {
                            CqVector4D temp = new CqVector4D();
                            int vind = vspan - this.vDegree() + l;
                            CqVector4D temp2 = new CqVector4D();
                            int k = 0;
                            while (k <= this.uDegree()) {
                                temp2.assignment((CqVector4D)pParam.pValue_get(vind * this.m_cuVerts + uind + k, 0));
                                temp.assignAdd(temp2.assignMul(Nu.get((int)k).value));
                                ++k;
                            }
                            ((CqVector4D)S).assignAdd(temp.assignMul(Nv.get((int)l).value));
                            ++l;
                        }
                        break block15;
                    }
                    if (!(S instanceof CqColor)) break block19;
                    S = new CqColor();
                    int l = 0;
                    while (l <= this.vDegree()) {
                        CqColor temp = new CqColor();
                        int vind = vspan - this.vDegree() + l;
                        int k = 0;
                        while (k <= this.uDegree()) {
                            temp.assignment(temp.add(((CqColor)pParam.pValue_get(vind * this.m_cuVerts + uind + k, 0)).mul(Nu.get((int)k).value)));
                            ++k;
                        }
                        ((CqColor)S).assignment(((CqColor)S).add(temp.mul(Nv.get((int)l).value)));
                        ++l;
                    }
                    break block15;
                }
                if (!(S instanceof CqMatrix)) break block20;
                S = new CqMatrix();
                int l = 0;
                while (l <= this.vDegree()) {
                    CqMatrix temp = new CqMatrix();
                    int vind = vspan - this.vDegree() + l;
                    int k = 0;
                    while (k <= this.uDegree()) {
                        temp.assignment(temp.add(((CqMatrix)pParam.pValue_get(vind * this.m_cuVerts + uind + k, 0)).mulInv(Nu.get((int)k).value)));
                        ++k;
                    }
                    ((CqMatrix)S).assignment(((CqMatrix)S).add(temp.mulInv(Nv.get((int)l).value)));
                    ++l;
                }
                break block15;
            }
            if (!(S instanceof p_String)) break block15;
            S = new p_String();
            int l = 0;
            while (l <= this.vDegree()) {
                p_String temp = new p_String();
                int vind = vspan - this.vDegree() + l;
                int k = 0;
                while (k <= this.uDegree()) {
                    temp.value = String.valueOf(temp.value) + ((p_String)pParam.pValue_get((int)(vind * this.m_cuVerts + uind + k), (int)0)).value;
                    ++k;
                }
                ((p_String)S).value = String.valueOf(((p_String)S).value) + temp.value;
                ++l;
            }
        }
        return S;
    }

    public CqVector4D EvaluateWithNormal(float u, float v, CqVector4D P) {
        int l;
        int d = 1;
        int p = this.uDegree();
        int q = this.vDegree();
        STLVector SKL = new STLVector(2, CqVector4D.class, d + 1);
        int k = 0;
        while (k <= d) {
            ((STLVector)SKL.get(k)).resize(d + 1);
            ++k;
        }
        STLVector<STLVector<p_float>> Nu = new STLVector<STLVector<p_float>>(2, p_float.class);
        STLVector<STLVector<p_float>> Nv = new STLVector<STLVector<p_float>>(2, p_float.class);
        STLVector<CqVector4D> temp = new STLVector<CqVector4D>(CqVector4D.class, q + 1);
        int du = Math.min(d, p);
        k = p + 1;
        while (k <= d) {
            l = 0;
            while (l <= d - k) {
                ((STLVector)SKL.get(k)).set(l, new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f));
                ++l;
            }
            ++k;
        }
        int dv = Math.min(d, q);
        l = q + 1;
        while (l <= d) {
            k = 0;
            while (k <= d - l) {
                ((STLVector)SKL.get(k)).set(l, new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f));
                ++k;
            }
            ++l;
        }
        int uspan = this.FindSpanU(u);
        this.DersBasisFunctions(u, uspan, this.m_auKnots, this.m_uOrder, du, Nu);
        int vspan = this.FindSpanV(v);
        this.DersBasisFunctions(v, vspan, this.m_avKnots, this.m_vOrder, dv, Nv);
        k = 0;
        while (k <= du) {
            int s = 0;
            while (s <= q) {
                int r = 0;
                while (r <= p) {
                    ((CqVector4D)temp.get(s)).assignment(((CqVector4D)temp.get(s)).add(this.CP(uspan - p + r, vspan - q + s).mul(((p_float)((STLVector)Nu.get((int)k)).get((int)r)).value)));
                    ++r;
                }
                ++s;
            }
            int dd = Math.min(d - k, dv);
            l = 0;
            while (l <= dd) {
                s = 0;
                while (s <= q) {
                    ((CqVector4D)((STLVector)SKL.get(k)).get(l)).assignment(((CqVector4D)((STLVector)SKL.get(k)).get(l)).add(((CqVector4D)temp.get(s)).mul(((p_float)((STLVector)Nv.get((int)l)).get((int)s)).value)));
                    ++s;
                }
                ++l;
            }
            ++k;
        }
        CqVector4D N = ((CqVector4D)((STLVector)SKL.get(1)).get(0)).mod((CqVector4D)((STLVector)SKL.get(0)).get(1));
        N.Unit();
        P.assignment((CqVector4D)((STLVector)SKL.get(0)).get(0));
        return N;
    }

    public void SplitNURBS(CqSurfaceNURBS nrbA, CqSurfaceNURBS nrbB, boolean dirflag) {
        int j;
        int SplitPoint;
        STLArray<p_float> aKnots = dirflag ? this.m_auKnots : this.m_avKnots;
        int Order = dirflag ? this.m_uOrder : this.m_vOrder;
        int extra = 0;
        int last = dirflag ? this.m_cuVerts + this.m_uOrder - 1 : this.m_cvVerts + this.m_vOrder - 1;
        float midVal = (aKnots.get((int)0).value + aKnots.get((int)last).value) / 2.0f;
        int middex = dirflag ? this.FindSpanU(midVal) : this.FindSpanV(midVal);
        int i = 0;
        int same = 0;
        if (aKnots.get((int)middex).value == midVal) {
            i = middex + 1;
            same = 1;
            while (i < last && aKnots.get((int)i).value == midVal) {
                ++i;
                ++same;
            }
            i = middex - 1;
            while ((long)i > 0L && aKnots.get((int)i).value == midVal) {
                --i;
                --middex;
                ++same;
            }
        }
        if (i <= 0) {
            midVal = (aKnots.get((int)0).value + aKnots.get((int)last).value) / 2.0f;
            middex = 0;
            while (aKnots.get((int)(middex + 1)).value < midVal) {
                ++middex;
            }
            same = 0;
        }
        extra = Order - same;
        STLArray<p_float> anewKnots = new STLArray<p_float>(p_float.class, extra);
        if (same < Order) {
            i = 0;
            while (i < extra) {
                anewKnots.get((int)i).value = midVal;
                ++i;
            }
        }
        int n = SplitPoint = extra < Order ? middex - 1 : middex;
        if (dirflag) {
            this.RefineKnotU(anewKnots);
        } else {
            this.RefineKnotV(anewKnots);
        }
        nrbA.Init(this.m_uOrder, this.m_vOrder, dirflag ? SplitPoint + 1 : this.m_cuVerts, dirflag ? this.m_cvVerts : SplitPoint + 1);
        for (CqParameter iUP : this.m_aUserParams) {
            if (iUP.Class().getValue() != 4) continue;
            CqParameter pNewA = iUP.CloneType(iUP.strName(), iUP.Count());
            pNewA.SetSize(nrbA.cuVerts() * nrbA.cvVerts());
            i = 0;
            while (i < nrbA.m_cvVerts) {
                j = 0;
                while (j < nrbA.m_cuVerts) {
                    pNewA.SetValue(iUP, i * nrbA.cuVerts() + j, i * this.m_cuVerts + j);
                    ++j;
                }
                ++i;
            }
            nrbA.AddPrimitiveVariable(pNewA);
        }
        i = 0;
        while (i < nrbA.m_uOrder + nrbA.m_cuVerts) {
            nrbA.m_auKnots.get((int)i).value = this.m_auKnots.get((int)i).value;
            ++i;
        }
        i = 0;
        while (i < nrbA.m_vOrder + nrbA.m_cvVerts) {
            nrbA.m_avKnots.get((int)i).value = this.m_avKnots.get((int)i).value;
            ++i;
        }
        nrbB.Init(this.m_uOrder, this.m_vOrder, dirflag ? this.m_cuVerts - ++SplitPoint : this.m_cuVerts, dirflag ? this.m_cvVerts : this.m_cvVerts - SplitPoint);
        for (CqParameter iUP : this.m_aUserParams) {
            if (iUP.Class().getValue() != 4) continue;
            CqParameter pNewB = iUP.CloneType(iUP.strName(), iUP.Count());
            pNewB.SetSize(nrbB.cuVerts() * nrbB.cvVerts());
            i = 0;
            while (i < nrbB.m_cvVerts) {
                j = 0;
                while (j < nrbB.m_cuVerts) {
                    int iSrc = dirflag ? i : i + SplitPoint;
                    iSrc *= this.m_cuVerts;
                    pNewB.SetValue(iUP, i * nrbB.cuVerts() + j, iSrc += dirflag ? j + SplitPoint : j);
                    ++j;
                }
                ++i;
            }
            nrbB.AddPrimitiveVariable(pNewB);
        }
        i = 0;
        while (i < nrbB.m_uOrder + nrbB.m_cuVerts) {
            nrbB.m_auKnots.get((int)i).value = this.m_auKnots.get((int)(dirflag ? i + SplitPoint : i)).value;
            ++i;
        }
        i = 0;
        while (i < nrbB.m_vOrder + nrbB.m_cvVerts) {
            nrbB.m_avKnots.get((int)i).value = this.m_avKnots.get((int)(dirflag ? i : i + SplitPoint)).value;
            ++i;
        }
    }

    public void SubdivideSegments(STLArray<CqSurfaceNURBS> S) {
        STLArray<p_float> anewKnots;
        int same;
        int i;
        int middex;
        float midVal;
        int last;
        int extra;
        int uSplits = this.cuSegments();
        int vSplits = this.cvSegments();
        S.resize(uSplits * vSplits);
        int[] uSplitPoint = new int[uSplits + 1];
        int[] vSplitPoint = new int[vSplits + 1];
        uSplitPoint[0] = 0;
        vSplitPoint[0] = 0;
        int iu = 1;
        while (iu < uSplits) {
            float su = (float)iu / (float)uSplits * (this.m_auKnots.get((int)this.m_cuVerts).value - this.m_auKnots.get((int)(this.m_uOrder - 1)).value) + this.m_auKnots.get((int)(this.m_uOrder - 1)).value;
            extra = 0;
            last = this.m_cuVerts + this.m_uOrder - 1;
            midVal = su;
            middex = this.FindSpanU(midVal);
            i = 0;
            same = 0;
            if (this.auKnots().get((int)middex).value == midVal) {
                i = middex + 1;
                same = 1;
                while (i < last && this.auKnots().get((int)i).value == midVal) {
                    ++i;
                    ++same;
                }
                i = middex - 1;
                while ((long)i > 0L && this.auKnots().get((int)i).value == midVal) {
                    --i;
                    --middex;
                    ++same;
                }
            }
            if ((long)i <= 0L) {
                middex = 0;
                while (this.auKnots().get((int)(middex + 1)).value < midVal) {
                    ++middex;
                }
                same = 0;
            }
            extra = this.m_uOrder - same;
            anewKnots = new STLArray<p_float>(p_float.class, extra);
            if (same < this.m_uOrder) {
                i = 0;
                while (i < extra) {
                    anewKnots.get((int)i).value = midVal;
                    ++i;
                }
            }
            uSplitPoint[iu] = extra < this.m_uOrder ? middex - 1 : middex;
            this.RefineKnotU(anewKnots);
            ++iu;
        }
        int iv = 1;
        while (iv < vSplits) {
            float sv = (float)iv / (float)vSplits * (this.m_avKnots.get((int)this.m_cvVerts).value - this.m_avKnots.get((int)(this.m_vOrder - 1)).value) + this.m_avKnots.get((int)(this.m_vOrder - 1)).value;
            extra = 0;
            last = this.m_cvVerts + this.m_vOrder - 1;
            midVal = sv;
            middex = this.FindSpanV(midVal);
            i = 0;
            same = 0;
            if (this.avKnots().get((int)middex).value == midVal) {
                i = middex + 1;
                same = 1;
                while (i < last && this.avKnots().get((int)i).value == midVal) {
                    ++i;
                    ++same;
                }
                i = middex - 1;
                while (i > 0 && this.avKnots().get((int)i).value == midVal) {
                    --i;
                    --middex;
                    ++same;
                }
            }
            if ((long)i <= 0L) {
                middex = 0;
                while (this.avKnots().get((int)(middex + 1)).value < midVal) {
                    ++middex;
                }
                same = 0;
            }
            extra = this.m_vOrder - same;
            anewKnots = new STLArray<p_float>(p_float.class, extra);
            if (same < this.m_vOrder) {
                i = 0;
                while (i < extra) {
                    anewKnots.get((int)i).value = midVal;
                    ++i;
                }
            }
            vSplitPoint[iv] = extra < this.m_vOrder ? middex - 1 : middex;
            this.RefineKnotV(anewKnots);
            ++iv;
        }
        uSplitPoint[uSplits] = this.m_cuVerts - 1;
        vSplitPoint[vSplits] = this.m_cvVerts - 1;
        int vOffset = 0;
        int vPatch = 0;
        while (vPatch < vSplits) {
            int uOffset = 0;
            int vEnd = vSplitPoint[vPatch + 1];
            int uPatch = 0;
            while (uPatch < uSplits) {
                int uEnd = uSplitPoint[uPatch + 1];
                int iS = vPatch * uSplits + uPatch;
                S.set(iS, new CqSurfaceNURBS());
                S.get(iS).SetfPatchMesh(false);
                S.get(iS).Init(this.m_uOrder, this.m_vOrder, uEnd + 1 - uOffset, vEnd + 1 - vOffset);
                for (CqParameter iUP : this.aUserParams()) {
                    if (iUP.Class().getValue() != 4) continue;
                    CqParameter pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                    pNewUP.SetSize(S.get(iS).cVertex());
                    int iPv = 0;
                    while (iPv <= vEnd - vOffset) {
                        int iPIndex = (vOffset + iPv) * this.m_cuVerts + uOffset;
                        int iPu = 0;
                        while (iPu <= uEnd - uOffset) {
                            int iSP = iPv * S.get(iS).cuVerts() + iPu;
                            pNewUP.SetValue(iUP, iSP, iPIndex++);
                            ++iPu;
                        }
                        ++iPv;
                    }
                    S.get(iS).AddPrimitiveVariable(pNewUP);
                }
                int iuK = 0;
                while (iuK < S.get(iS).uOrder() + S.get(iS).cuVerts()) {
                    S.get((int)iS).auKnots().get((int)iuK).value = this.auKnots().get((int)(uOffset + iuK)).value;
                    ++iuK;
                }
                int ivK = 0;
                while (ivK < S.get(iS).vOrder() + S.get(iS).cvVerts()) {
                    S.get((int)iS).avKnots().get((int)ivK).value = this.avKnots().get((int)(vOffset + ivK)).value;
                    ++ivK;
                }
                uOffset = uEnd + 1;
                ++uPatch;
            }
            vOffset = vEnd + 1;
            ++vPatch;
        }
        int nuSegs = uSplits;
        int nvSegs = vSplits;
        int icol = 0;
        while (icol < nvSegs) {
            int irow = 0;
            while (irow < nuSegs) {
                int iPatch = icol * nuSegs + irow;
                int iA = icol * (nuSegs + 1) + irow;
                int iB = icol * (nuSegs + 1) + irow + 1;
                int iC = (icol + 1) * (nuSegs + 1) + irow;
                int iD = (icol + 1) * (nuSegs + 1) + irow + 1;
                for (CqParameter iUP : this.aUserParams()) {
                    CqParameter pNewUP;
                    if (iUP.Class().getValue() == 3) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(4);
                        pNewUP.SetValue(iUP, 0, iA);
                        pNewUP.SetValue(iUP, 1, iB);
                        pNewUP.SetValue(iUP, 2, iC);
                        pNewUP.SetValue(iUP, 3, iD);
                        S.get(iPatch).AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() == 2) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(1);
                        pNewUP.SetValue(iUP, 0, iPatch);
                        S.get(iPatch).AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() != 1) continue;
                    pNewUP = iUP.Clone();
                    S.get(iPatch).AddPrimitiveVariable(pNewUP);
                }
                ++irow;
            }
            ++icol;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void RefineKnotU(STLArray<p_float> X) {
        if (X.size() <= 0) {
            return;
        }
        n = this.m_cuVerts - 1;
        p = this.uDegree();
        m = n + p + 1;
        r = X.size() - 1;
        a = this.FindSpanU(X.get((int)0).value);
        b = this.FindSpanU(X.get((int)r).value);
        i = ++b + p - 1;
        k = b + p + r;
        this.m_cuVerts = r + 1 + n + 1;
        auHold = new STLArray<p_float>(p_float.class, this.m_auKnots.size());
        j = 0;
        while (j < this.m_auKnots.size()) {
            auHold.get((int)j).value = this.m_auKnots.get((int)j).value;
            ++j;
        }
        this.m_auKnots.resize(this.m_cuVerts + this.m_uOrder);
        j = 0;
        while (j <= a) {
            this.m_auKnots.get((int)j).value = auHold.get((int)j).value;
            ++j;
        }
        j = b + p;
        while (j <= m) {
            this.m_auKnots.get((int)(j + r + 1)).value = auHold.get((int)j).value;
            ++j;
        }
        j = r;
        ** GOTO lbl36
        {
            this.m_auKnots.get((int)k--).value = auHold.get((int)i--).value;
            do {
                if (X.get((int)j).value <= this.m_auKnots.get((int)i).value && i > a) continue block12;
                this.m_auKnots.get((int)k--).value = X.get((int)j).value;
                --j;
lbl36:
                // 2 sources

            } while (j >= 0);
        }
        i = b + p - 1;
        k = b + p + r;
        for (CqParameter iUP : this.m_aUserParams) {
            if (iUP.Class().getValue() != 4) continue;
            i = b + p - 1;
            k = b + p + r;
            pHold = iUP.Clone();
            iUP.SetSize(this.m_cuVerts * this.m_cvVerts);
            row = 0;
            while (row < this.m_cvVerts) {
                rowoff = row * this.m_cuVerts;
                j = 0;
                while (j <= a - p) {
                    iUP.SetValue(pHold, rowoff + j, row * (n + 1) + j);
                    ++j;
                }
                j = b - 1;
                while (j <= n) {
                    iUP.SetValue(pHold, rowoff + j + r + 1, row * (n + 1) + j);
                    ++j;
                }
                ++row;
            }
            j = r;
            ** GOTO lbl157
            {
                row = 0;
                while (row < this.m_cvVerts) {
                    iUP.SetValue(pHold, row * this.m_cuVerts + k - p - 1, row * (n + 1) + i - p - 1);
                    ++row;
                }
                --k;
                --i;
                do {
                    if (X.get((int)j).value <= this.m_auKnots.get((int)i).value && i > a) continue block18;
                    row = 0;
                    while (row < this.m_cvVerts) {
                        iUP.SetValue(iUP, row * this.m_cuVerts + k - p - 1, row * this.m_cuVerts + k - p);
                        ++row;
                    }
                    l = 1;
                    while (l <= p) {
                        block33: {
                            block32: {
                                ind = k - p + l;
                                alpha = this.m_auKnots.get((int)(k + l)).value - X.get((int)j).value;
                                if (alpha != 0.0f) break block32;
                                row = 0;
                                if (true) ** GOTO lbl151
                            }
                            alpha /= this.m_auKnots.get((int)(k + l)).value - auHold.get((int)(i - p + l)).value;
                            switch (iUP.Type().getValue()) {
                                case 1: {
                                    pTParam = (CqParameterTyped)iUP;
                                    row = 0;
                                    while (row < this.m_cvVerts) {
                                        ((p_float)pTParam.pValue_get((int)(row * this.m_cuVerts + ind - 1), (int)0)).value = alpha * ((p_float)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind - 1))).value + (1.0f - alpha) * ((p_float)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind))).value;
                                        ++row;
                                    }
                                    break block33;
                                }
                                case 2: {
                                    pTParam = (CqParameterTyped)iUP;
                                    row = 0;
                                    while (row < this.m_cvVerts) {
                                        ((p_int)pTParam.pValue_get((int)(row * this.m_cuVerts + ind - 1), (int)0)).value = (int)(alpha * (float)((p_int)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind - 1))).value + (1.0f - alpha) * (float)((p_int)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind))).value);
                                        ++row;
                                    }
                                    break block33;
                                }
                                case 3: 
                                case 8: 
                                case 9: {
                                    pTParam = (CqParameterTyped)iUP;
                                    row = 0;
                                    while (row < this.m_cvVerts) {
                                        ((CqVector3D)pTParam.pValue_get(row * this.m_cuVerts + ind - 1, 0)).assignment(((CqVector3D)pTParam.pValue_get(0, row * this.m_cuVerts + ind - 1)).mul(alpha).add(((CqVector3D)pTParam.pValue_get(0, row * this.m_cuVerts + ind)).mul(1.0f - alpha)));
                                        ++row;
                                    }
                                    break block33;
                                }
                                case 7: {
                                    pTParam = (CqParameterTyped)iUP;
                                    row = 0;
                                    while (row < this.m_cvVerts) {
                                        cp = new CqVector4D(alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind - 1))).x + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind))).x, alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind - 1))).y + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind))).y, alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind - 1))).z + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind))).z, alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind - 1))).w + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind))).w);
                                        ((CqVector4D)pTParam.pValue_get(row * this.m_cuVerts + ind - 1, 0)).assignment(cp);
                                        ++row;
                                    }
                                    break block33;
                                }
                                case 5: {
                                    pTParam = (CqParameterTyped)iUP;
                                    row = 0;
                                    while (row < this.m_cvVerts) {
                                        ((CqColor)pTParam.pValue_get(row * this.m_cuVerts + ind - 1, 0)).assignment(((CqColor)pTParam.pValue_get(0, row * this.m_cuVerts + ind - 1)).mul(alpha).add(((CqColor)pTParam.pValue_get(0, row * this.m_cuVerts + ind)).mul(1.0f - alpha)));
                                        ++row;
                                    }
                                    break block33;
                                }
                                case 4: {
                                    pTParam = (CqParameterTyped)iUP;
                                    row = 0;
                                    while (row < this.m_cvVerts) {
                                        ((p_String)pTParam.pValue_get((int)(row * this.m_cuVerts + ind - 1), (int)0)).value = String.valueOf(((p_String)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind - 1))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(row * this.m_cuVerts + ind))).value;
                                        ++row;
                                    }
                                    break block33;
                                }
                                case 11: {
                                    pTParam = (CqParameterTyped)iUP;
                                    row = 0;
                                    while (row < this.m_cvVerts) {
                                        ((CqMatrix)pTParam.pValue_get(row * this.m_cuVerts + ind - 1, 0)).assignment(((CqMatrix)pTParam.pValue_get(0, row * this.m_cuVerts + ind - 1)).mulInv(alpha).add(((CqMatrix)pTParam.pValue_get(0, row * this.m_cuVerts + ind)).mulInv(1.0f - alpha)));
                                        ++row;
                                    }
                                    break block33;
                                }
                            }
                            break block33;
                            do {
                                iUP.SetValue(iUP, row * this.m_cuVerts + ind - 1, row * this.m_cuVerts + ind);
                                ++row;
lbl151:
                                // 2 sources

                            } while (row < this.m_cvVerts);
                        }
                        ++l;
                    }
                    --k;
                    --j;
lbl157:
                    // 2 sources

                } while (j >= 0);
            }
            pHold = null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void RefineKnotV(STLArray<p_float> X) {
        if (X.size() <= 0) {
            return;
        }
        n = this.m_cvVerts - 1;
        p = this.vDegree();
        m = n + p + 1;
        r = X.size() - 1;
        a = this.FindSpanV(X.get((int)0).value);
        b = this.FindSpanV(X.get((int)r).value);
        i = ++b + p - 1;
        k = b + p + r;
        this.m_cvVerts = r + 1 + n + 1;
        avHold = new STLArray<p_float>(p_float.class, this.m_avKnots.size());
        j = 0;
        while (j < this.m_avKnots.size()) {
            avHold.get((int)j).value = this.m_avKnots.get((int)j).value;
            ++j;
        }
        this.m_avKnots.resize(this.m_cvVerts + this.m_vOrder);
        j = 0;
        while (j <= a) {
            this.m_avKnots.get((int)j).value = avHold.get((int)j).value;
            ++j;
        }
        j = b + p;
        while (j <= m) {
            this.m_avKnots.get((int)(j + r + 1)).value = avHold.get((int)j).value;
            ++j;
        }
        j = r;
        ** GOTO lbl36
        {
            this.m_avKnots.get((int)k--).value = avHold.get((int)i--).value;
            do {
                if (X.get((int)j).value <= this.m_avKnots.get((int)i).value && i > a) continue block12;
                this.m_avKnots.get((int)k--).value = X.get((int)j).value;
                --j;
lbl36:
                // 2 sources

            } while (j >= 0);
        }
        i = b + p - 1;
        k = b + p + r;
        for (CqParameter iUP : this.m_aUserParams) {
            if (iUP.Class().getValue() != 4) continue;
            i = b + p - 1;
            k = b + p + r;
            pHold = iUP.Clone();
            iUP.SetSize(this.m_cuVerts * this.m_cvVerts);
            col = 0;
            while (col < this.m_cuVerts) {
                j = 0;
                while (j <= a - p) {
                    iUP.SetValue(pHold, j * this.m_cuVerts + col, j * this.m_cuVerts + col);
                    ++j;
                }
                j = b - 1;
                while (j <= n) {
                    iUP.SetValue(pHold, (j + r + 1) * this.m_cuVerts + col, j * this.m_cuVerts + col);
                    ++j;
                }
                ++col;
            }
            j = r;
            ** GOTO lbl156
            {
                col = 0;
                while (col < this.m_cuVerts) {
                    iUP.SetValue(pHold, (k - p - 1) * this.m_cuVerts + col, (i - p - 1) * this.m_cuVerts + col);
                    ++col;
                }
                --k;
                --i;
                do {
                    if (X.get((int)j).value <= this.m_avKnots.get((int)i).value && i > a) continue block18;
                    col = 0;
                    while (col < this.m_cuVerts) {
                        iUP.SetValue(iUP, (k - p - 1) * this.m_cuVerts + col, (k - p) * this.m_cuVerts + col);
                        ++col;
                    }
                    l = 1;
                    while (l <= p) {
                        block33: {
                            block32: {
                                ind = k - p + l;
                                alpha = this.m_avKnots.get((int)(k + l)).value - X.get((int)j).value;
                                if (alpha != 0.0f) break block32;
                                col = 0;
                                if (true) ** GOTO lbl150
                            }
                            alpha /= this.m_avKnots.get((int)(k + l)).value - avHold.get((int)(i - p + l)).value;
                            switch (iUP.Type().getValue()) {
                                case 1: {
                                    pTParam = (CqParameterTyped)iUP;
                                    col = 0;
                                    while (col < this.m_cuVerts) {
                                        ((p_float)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).value = alpha * ((p_float)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).value + (1.0f - alpha) * ((p_float)pTParam.pValue_get((int)0, (int)(ind * this.m_cuVerts + col))).value;
                                        ++col;
                                    }
                                    break block33;
                                }
                                case 2: {
                                    pTParam = (CqParameterTyped)iUP;
                                    col = 0;
                                    while (col < this.m_cuVerts) {
                                        ((p_int)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).value = (int)(alpha * (float)((p_int)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).value + (1.0f - alpha) * (float)((p_int)pTParam.pValue_get((int)0, (int)(ind * this.m_cuVerts + col))).value);
                                        ++col;
                                    }
                                    break block33;
                                }
                                case 3: 
                                case 8: 
                                case 9: {
                                    pTParam = (CqParameterTyped)iUP;
                                    col = 0;
                                    while (col < this.m_cuVerts) {
                                        ((CqVector3D)pTParam.pValue_get(0, (ind - 1) * this.m_cuVerts + col)).assignment(((CqVector3D)pTParam.pValue_get(0, (ind - 1) * this.m_cuVerts + col)).mul(alpha).add(((CqVector3D)pTParam.pValue_get(0, ind * this.m_cuVerts + col)).mul(1.0f - alpha)));
                                        ++col;
                                    }
                                    break block33;
                                }
                                case 7: {
                                    pTParam = (CqParameterTyped)iUP;
                                    col = 0;
                                    while (col < this.m_cuVerts) {
                                        cp = new CqVector4D(alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).x + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(ind * this.m_cuVerts + col))).x, alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).y + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(ind * this.m_cuVerts + col))).y, alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).z + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(ind * this.m_cuVerts + col))).z, alpha * ((CqVector4D)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).w + (1.0f - alpha) * ((CqVector4D)pTParam.pValue_get((int)0, (int)(ind * this.m_cuVerts + col))).w);
                                        ((CqVector4D)pTParam.pValue_get(0, (ind - 1) * this.m_cuVerts + col)).assignment(cp);
                                        ++col;
                                    }
                                    break block33;
                                }
                                case 5: {
                                    pTParam = (CqParameterTyped)iUP;
                                    col = 0;
                                    while (col < this.m_cuVerts) {
                                        ((CqColor)pTParam.pValue_get(0, (ind - 1) * this.m_cuVerts + col)).assignment(((CqColor)pTParam.pValue_get(0, (ind - 1) * this.m_cuVerts + col)).mul(alpha).add(((CqColor)pTParam.pValue_get(0, ind * this.m_cuVerts + col)).mul(1.0f - alpha)));
                                        ++col;
                                    }
                                    break block33;
                                }
                                case 4: {
                                    pTParam = (CqParameterTyped)iUP;
                                    col = 0;
                                    while (col < this.m_cuVerts) {
                                        ((p_String)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).value = String.valueOf(((p_String)pTParam.pValue_get((int)0, (int)((ind - 1) * this.m_cuVerts + col))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(ind * this.m_cuVerts + col))).value;
                                        ++col;
                                    }
                                    break block33;
                                }
                                case 11: {
                                    pTParam = (CqParameterTyped)iUP;
                                    col = 0;
                                    while (col < this.m_cuVerts) {
                                        ((CqMatrix)pTParam.pValue_get(0, (ind - 1) * this.m_cuVerts + col)).assignment(((CqMatrix)pTParam.pValue_get(0, (ind - 1) * this.m_cuVerts + col)).mulInv(alpha).add(((CqMatrix)pTParam.pValue_get(0, ind * this.m_cuVerts + col)).mulInv(1.0f - alpha)));
                                        ++col;
                                    }
                                    break block33;
                                }
                            }
                            break block33;
                            do {
                                iUP.SetValue(iUP, (ind - 1) * this.m_cuVerts + col, ind * this.m_cuVerts + col);
                                ++col;
lbl150:
                                // 2 sources

                            } while (col < this.m_cuVerts);
                        }
                        ++l;
                    }
                    --k;
                    --j;
lbl156:
                    // 2 sources

                } while (j >= 0);
            }
            pHold = null;
        }
    }

    public int InsertKnotU(float u, int r) {
        int n = this.m_cuVerts;
        int k = this.m_auKnots.size() - 1;
        int s = 0;
        int p = this.uDegree();
        if (u < this.m_auKnots.get((int)this.uDegree()).value || u > this.m_auKnots.get((int)this.m_cuVerts).value) {
            return 0;
        }
        int i = 0;
        while (i < this.m_auKnots.size()) {
            if (this.m_auKnots.get((int)i).value > u) {
                k = i - 1;
                break;
            }
            ++i;
        }
        if (u <= this.m_auKnots.get((int)k).value) {
            s = 1;
            i = k;
            while (i > this.uDegree()) {
                if (this.m_auKnots.get((int)i).value <= this.m_auKnots.get((int)(i - 1)).value) {
                    ++s;
                    --i;
                    continue;
                }
                break;
            }
        } else {
            s = 0;
        }
        if (r + s > p + 1) {
            r = p + 1 - s;
        }
        if (r <= 0) {
            return 0;
        }
        this.m_cuVerts += r;
        this.m_auKnots.resize(this.m_cuVerts + this.m_uOrder);
        STLArray<p_float> auHold = new STLArray<p_float>(p_float.class, this.m_auKnots.size());
        i = 0;
        while (i < this.m_auKnots.size()) {
            auHold.get((int)i).value = this.m_auKnots.get((int)i).value;
            ++i;
        }
        i = 0;
        while (i <= k) {
            this.m_auKnots.get((int)i).value = auHold.get((int)i).value;
            ++i;
        }
        i = 1;
        while (i <= r) {
            this.m_auKnots.get((int)(k + i)).value = u;
            ++i;
        }
        i = k + 1;
        while (i + r < this.m_auKnots.size()) {
            this.m_auKnots.get((int)(i + r)).value = auHold.get((int)i).value;
            ++i;
        }
        for (CqParameter iUP : this.m_aUserParams) {
            if (iUP.Class().getValue() != 4) continue;
            CqParameter pHold = iUP.Clone();
            iUP.SetSize(this.m_cuVerts * this.m_cvVerts);
            CqParameter R = iUP.CloneType("R");
            R.SetSize(p + 1);
            int row = 0;
            while (row < this.m_cvVerts) {
                i = 0;
                while (i <= k - p) {
                    iUP.SetValue(pHold, row * this.m_cuVerts + i, row * n + i);
                    ++i;
                }
                i = k - s;
                while (i < this.m_cuVerts - r) {
                    iUP.SetValue(pHold, row * this.m_cuVerts + i + r, row * n + i);
                    ++i;
                }
                i = 0;
                while (i <= p - s) {
                    R.SetValue(pHold, i, row * n + k - p + i);
                    ++i;
                }
                int L = 0;
                int j = 1;
                while (j <= r) {
                    L = k - p + j;
                    i = 0;
                    while (i <= p - j - s) {
                        float alpha = (u - auHold.get((int)(L + i)).value) / (auHold.get((int)(i + k + 1)).value - auHold.get((int)(L + i)).value);
                        switch (iUP.Type().getValue()) {
                            case 1: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((p_float)pTR.pValue_get((int)i, (int)0)).value = alpha * ((p_float)pTR.pValue_get((int)(i + 1), (int)0)).value + (1.0f - alpha) * ((p_float)pTR.pValue_get((int)i, (int)0)).value;
                                break;
                            }
                            case 2: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((p_int)pTR.pValue_get((int)i, (int)0)).value = (int)((double)(alpha * (float)((p_int)pTR.pValue_get((int)(i + 1), (int)0)).value) + (1.0 - (double)alpha) * (double)((p_int)pTR.pValue_get((int)i, (int)0)).value);
                                break;
                            }
                            case 3: 
                            case 8: 
                            case 9: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((CqVector3D)pTR.pValue_get(i, 0)).assignment(((CqVector3D)pTR.pValue_get(i + 1, 0)).mul(alpha).add(((CqVector3D)pTR.pValue_get(i, 0)).mul(1.0f - alpha)));
                                break;
                            }
                            case 7: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                CqVector4D cp = new CqVector4D(alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).x + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).x, alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).y + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).y, alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).z + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).z, alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).w + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).w);
                                ((CqVector4D)pTR.pValue_get(i, 0)).assignment(cp);
                                break;
                            }
                            case 5: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((CqColor)pTR.pValue_get(i, 0)).assignment(((CqColor)pTR.pValue_get(i + 1, 0)).mul(alpha).add(((CqColor)pTR.pValue_get(i, 0)).mul(1.0f - alpha)));
                                break;
                            }
                            case 11: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((CqMatrix)pTR.pValue_get(i, 0)).assignment(((CqMatrix)pTR.pValue_get(i + 1, 0)).mulInv(alpha).add(((CqMatrix)pTR.pValue_get(i, 0)).mulInv(1.0f - alpha)));
                                break;
                            }
                        }
                        ++i;
                    }
                    iUP.SetValue(R, row * this.m_cuVerts + L, 0);
                    if (p - j - s > 0) {
                        iUP.SetValue(R, row * this.m_cuVerts + k + r - j - s, p - j - s);
                    }
                    ++j;
                }
                i = L + 1;
                while (i < k - s) {
                    iUP.SetValue(R, row * this.m_cuVerts + i, i - L);
                    ++i;
                }
                ++row;
            }
            R = null;
            pHold = null;
        }
        return r;
    }

    public int InsertKnotV(float v, int r) {
        int m = this.m_cvVerts;
        int k = this.m_avKnots.size() - 1;
        int s = 0;
        int p = this.vDegree();
        if (v < this.m_avKnots.get((int)this.vDegree()).value || v > this.m_avKnots.get((int)this.m_cvVerts).value) {
            return 0;
        }
        int size = this.m_avKnots.size();
        int i = 0;
        while (i < size) {
            if (this.m_avKnots.get((int)i).value > v) {
                k = i - 1;
                break;
            }
            ++i;
        }
        if (v <= this.m_avKnots.get((int)k).value) {
            s = 1;
            i = k;
            while (i > this.vDegree()) {
                if (this.m_avKnots.get((int)i).value <= this.m_avKnots.get((int)(i - 1)).value) {
                    ++s;
                    --i;
                    continue;
                }
                break;
            }
        } else {
            s = 0;
        }
        if (r + s > p + 1) {
            r = p + 1 - s;
        }
        if (r <= 0) {
            return 0;
        }
        this.m_cvVerts += r;
        this.m_avKnots.resize(this.m_cvVerts + this.m_vOrder);
        STLArray<p_float> avHold = new STLArray<p_float>(p_float.class, this.m_avKnots.size());
        i = 0;
        while (i < this.m_avKnots.size()) {
            avHold.get((int)i).value = this.m_avKnots.get((int)i).value;
            ++i;
        }
        i = 0;
        while (i <= k) {
            this.m_avKnots.get((int)i).value = avHold.get((int)i).value;
            ++i;
        }
        i = 1;
        while (i <= r) {
            this.m_avKnots.get((int)(k + i)).value = v;
            ++i;
        }
        size = this.m_avKnots.size();
        i = k + 1;
        while (i + r < size) {
            this.m_avKnots.get((int)(i + r)).value = avHold.get((int)i).value;
            ++i;
        }
        for (CqParameter iUP : this.m_aUserParams) {
            if (iUP.Class().getValue() != 4) continue;
            CqParameter pHold = iUP.Clone();
            iUP.SetSize(this.m_cuVerts * this.m_cvVerts);
            CqParameter R = iUP.CloneType("R");
            R.SetSize(p + 1);
            int col = 0;
            while (col < this.m_cuVerts) {
                i = 0;
                while (i <= k - p) {
                    iUP.SetValue(pHold, i * this.m_cuVerts + col, i * this.m_cuVerts + col);
                    ++i;
                }
                i = k - s;
                while (i < m) {
                    iUP.SetValue(pHold, (i + r) * this.m_cuVerts + col, i * this.m_cuVerts + col);
                    ++i;
                }
                i = 0;
                while (i <= p - s) {
                    R.SetValue(pHold, i, (k - p + i) * this.m_cuVerts + col);
                    ++i;
                }
                int L = 0;
                int j = 1;
                while (j <= r) {
                    L = k - p + j;
                    i = 0;
                    while (i <= p - j - s) {
                        float alpha = (v - avHold.get((int)(L + i)).value) / (avHold.get((int)(i + k + 1)).value - avHold.get((int)(L + i)).value);
                        switch (iUP.Type().getValue()) {
                            case 1: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((p_float)pTR.pValue_get((int)i, (int)0)).value = alpha * ((p_float)pTR.pValue_get((int)(i + 1), (int)0)).value + (1.0f - alpha) * ((p_float)pTR.pValue_get((int)i, (int)0)).value;
                                break;
                            }
                            case 2: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((p_int)pTR.pValue_get((int)i, (int)0)).value = (int)(alpha * (float)((p_int)pTR.pValue_get((int)(i + 1), (int)0)).value + (1.0f - alpha) * (float)((p_int)pTR.pValue_get((int)i, (int)0)).value);
                                break;
                            }
                            case 3: 
                            case 8: 
                            case 9: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((CqVector3D)pTR.pValue_get(i, 0)).assignment(((CqVector3D)pTR.pValue_get(i + 1, 0)).mul(alpha).add(((CqVector3D)pTR.pValue_get(i, 0)).mul(1.0f - alpha)));
                                break;
                            }
                            case 7: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                CqVector4D cp = new CqVector4D(alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).x + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).x, alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).y + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).y, alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).z + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).z, alpha * ((CqVector4D)pTR.pValue_get((int)(i + 1), (int)0)).w + (1.0f - alpha) * ((CqVector4D)pTR.pValue_get((int)i, (int)0)).w);
                                ((CqVector4D)pTR.pValue_get(i, 0)).assignment(cp);
                                break;
                            }
                            case 5: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((CqColor)pTR.pValue_get(i, 0)).assignment(((CqColor)pTR.pValue_get(i + 1, 0)).mul(alpha).add(((CqColor)pTR.pValue_get(i, 0)).mul(1.0f - alpha)));
                                break;
                            }
                            case 11: {
                                CqParameterTyped pTR = (CqParameterTyped)R;
                                ((CqMatrix)pTR.pValue_get(i, 0)).assignment(((CqMatrix)pTR.pValue_get(i + 1, 0)).mulInv(alpha).add(((CqMatrix)pTR.pValue_get(i, 0)).mulInv(1.0f - alpha)));
                                break;
                            }
                        }
                        ++i;
                    }
                    iUP.SetValue(R, L * this.m_cuVerts + col, 0);
                    if (p - j - s > 0) {
                        iUP.SetValue(R, (k + r - j - s) * this.m_cuVerts + col, p - j - s);
                    }
                    ++j;
                }
                i = L + 1;
                while (i < k - s) {
                    iUP.SetValue(R, i * this.m_cuVerts + col, i - L);
                    ++i;
                }
                ++col;
            }
            R = null;
            pHold = null;
        }
        return r;
    }

    public void ClampU() {
        float u1 = this.m_auKnots.get((int)this.uDegree()).value;
        float u2 = this.m_auKnots.get((int)this.m_cuVerts).value;
        int n1 = this.InsertKnotU(u1, this.uDegree());
        int n2 = this.InsertKnotU(u2, this.uDegree());
        int i = 0;
        if (n1 != 0 || n2 != 0) {
            STLArray<p_float> auHold = new STLArray<p_float>(p_float.class, this.m_auKnots.size());
            i = 0;
            while (i < this.m_auKnots.size()) {
                auHold.get((int)i).value = this.m_auKnots.get((int)i).value;
                ++i;
            }
            this.m_auKnots.resize(this.m_auKnots.size() - n1 - n2);
            i = n1;
            while (i < auHold.size() - n2) {
                this.m_auKnots.get((int)(i - n1)).value = auHold.get((int)i).value;
                ++i;
            }
            int n = this.m_cuVerts;
            this.m_cuVerts -= n1 + n2;
            for (CqParameter iUP : this.m_aUserParams) {
                if (iUP.Class().getValue() != 4) continue;
                CqParameter pHold = iUP.Clone();
                iUP.SetSize(this.m_cuVerts * this.m_cvVerts);
                int row = 0;
                while (row < this.m_cvVerts) {
                    i = n1;
                    while (i < n - n2) {
                        iUP.SetValue(pHold, row * this.m_cuVerts + i - n1, row * n + i);
                        ++i;
                    }
                    ++row;
                }
                pHold = null;
            }
        }
    }

    public void ClampV() {
        float v1 = this.m_avKnots.get((int)this.vDegree()).value;
        float v2 = this.m_avKnots.get((int)this.m_cvVerts).value;
        int n1 = this.InsertKnotV(v1, this.vDegree());
        int n2 = this.InsertKnotV(v2, this.vDegree());
        int i = 0;
        if (n1 != 0 || n2 != 0) {
            STLArray<p_float> avHold = new STLArray<p_float>(p_float.class, this.m_avKnots.size());
            i = 0;
            while (i < this.m_avKnots.size()) {
                avHold.get((int)i).value = this.m_avKnots.get((int)i).value;
                ++i;
            }
            this.m_avKnots.resize(this.m_avKnots.size() - n1 - n2);
            i = n1;
            while (i < avHold.size() - n2) {
                this.m_avKnots.get((int)(i - n1)).value = avHold.get((int)i).value;
                ++i;
            }
            int n = this.m_cvVerts;
            this.m_cvVerts -= n1 + n2;
            for (CqParameter iUP : this.m_aUserParams) {
                if (iUP.Class().getValue() != 4) continue;
                CqParameter pHold = iUP.Clone();
                iUP.SetSize(this.m_cvVerts * this.m_cuVerts);
                int col = 0;
                while (col < this.m_cuVerts) {
                    i = n1;
                    while (i < n - n2) {
                        iUP.SetValue(pHold, (i - n1) * this.m_cuVerts + col, i * this.m_cuVerts + col);
                        ++i;
                    }
                    ++col;
                }
                pHold = null;
            }
        }
    }

    public void Clamp() {
        this.ClampU();
        this.ClampV();
    }

    public void OutputMesh() {
        int Granularity = 30;
        STLArray<CqSurfaceNURBS> S = new STLArray<CqSurfaceNURBS>(CqSurfaceNURBS.class);
        S.add(this);
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("NURBS.RAW")));
            int s = 0;
            while (s < S.size()) {
                bw.write("Surface_" + s + "\n");
                STLVector aaPoints = new STLVector(2, CqVector3D.class, Granularity + 1);
                int p = 0;
                while (p <= Granularity) {
                    ((STLVector)aaPoints.get(p)).resize(Granularity + 1);
                    ++p;
                }
                int i = 0;
                while (i <= Granularity) {
                    float v = (float)i / (float)Granularity * (S.get((int)s).m_avKnots.get((int)S.get((int)s).m_cvVerts).value - S.get((int)s).m_avKnots.get((int)(S.get((int)s).m_vOrder - 1)).value) + S.get((int)s).m_avKnots.get((int)(S.get((int)s).m_vOrder - 1)).value;
                    int j = 0;
                    while (j <= Granularity) {
                        float u = (float)j / (float)Granularity * (S.get((int)s).m_auKnots.get((int)S.get((int)s).m_cuVerts).value - S.get((int)s).m_auKnots.get((int)(S.get((int)s).m_uOrder - 1)).value) + S.get((int)s).m_auKnots.get((int)(S.get((int)s).m_uOrder - 1)).value;
                        ((CqVector3D)((STLVector)aaPoints.get(i)).get(j)).assignment(S.get(s).Evaluate(u, v, this.P()));
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < Granularity) {
                    int j = 0;
                    while (j < Granularity) {
                        bw.write(String.valueOf(((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).x) + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).z + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).z + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)j)).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)j)).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)j)).z + "\n");
                        bw.write(String.valueOf(((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).x) + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).z + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)(j + 1))).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)(j + 1))).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)(j + 1))).z + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).z + "\n");
                        ++j;
                    }
                    ++i;
                }
                ++s;
            }
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void AppendMesh(String name, int index) {
        int Granularity = 10;
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name, true)));
            bw.write("Surface_" + index + "\n");
            STLVector aaPoints = new STLVector(2, CqVector3D.class, Granularity + 1);
            int p = 0;
            while (p <= Granularity) {
                ((STLVector)aaPoints.get(p)).resize(Granularity + 1);
                ++p;
            }
            int i = 0;
            while (i <= Granularity) {
                float v = (float)i / (float)Granularity * (this.m_avKnots.get((int)this.m_cvVerts).value - this.m_avKnots.get((int)(this.m_vOrder - 1)).value) + this.m_avKnots.get((int)(this.m_vOrder - 1)).value;
                int j = 0;
                while (j <= Granularity) {
                    float u = (float)j / (float)Granularity * (this.m_auKnots.get((int)this.m_cuVerts).value - this.m_auKnots.get((int)(this.m_uOrder - 1)).value) + this.m_auKnots.get((int)(this.m_uOrder - 1)).value;
                    ((CqVector3D)((STLVector)aaPoints.get(i)).get(j)).assignment(this.Evaluate(u, v, this.P()));
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < Granularity) {
                int j = 0;
                while (j < Granularity) {
                    bw.write(String.valueOf(((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).x) + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).z + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).z + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)j)).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)j)).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)j)).z + "\n");
                    bw.write(String.valueOf(((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).x) + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)j)).z + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)(j + 1))).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)(j + 1))).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)i)).get((int)(j + 1))).z + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).x + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).y + " " + ((CqVector3D)((STLVector)aaPoints.get((int)(i + 1))).get((int)(j + 1))).z + "\n");
                    ++j;
                }
                ++i;
            }
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void Output(String name) {
        try {
            BufferedWriter bos = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
            bos.write("NuPatch " + this.m_cuVerts + " " + this.m_uOrder + "[\n");
            int i = 0;
            while (i < this.m_auKnots.size()) {
                bos.write(String.valueOf(this.m_auKnots.get((int)i).value) + " \n");
                ++i;
            }
            bos.write("0.0 1.0 " + this.m_cvVerts + " " + this.m_vOrder + "[\n");
            i = 0;
            while (i < this.m_avKnots.size()) {
                bos.write(String.valueOf(this.m_avKnots.get((int)i).value) + " \n");
                ++i;
            }
            bos.write("]\n0.0 1.0 \"Pw\" [\n");
            i = 0;
            while (i < this.P().Size()) {
                bos.write(this.P().pValue_get(i, 0).toString());
                ++i;
            }
            bos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public CqTrimLoopArray TrimLoops() {
        return this.m_TrimLoops;
    }

    public void uSubdivide(CqSurfaceNURBS pnrbA, CqSurfaceNURBS pnrbB) {
        pnrbA = new CqSurfaceNURBS();
        pnrbB = new CqSurfaceNURBS();
        this.SplitNURBS(pnrbA, pnrbB, true);
        this.uSubdivideUserParameters(pnrbA, pnrbB);
    }

    public void vSubdivide(CqSurfaceNURBS pnrbA, CqSurfaceNURBS pnrbB) {
        pnrbA = new CqSurfaceNURBS();
        pnrbB = new CqSurfaceNURBS();
        this.SplitNURBS(pnrbA, pnrbB, false);
        this.vSubdivideUserParameters(pnrbA, pnrbB);
    }

    @Override
    public void NaturalDice(CqParameter pParameter, int uDiceSize, int vDiceSize, IqShaderData pData) {
        int iv = 0;
        while (iv <= vDiceSize) {
            float sv = (float)iv / (float)vDiceSize * (this.m_avKnots.get((int)this.m_cvVerts).value - this.m_avKnots.get((int)(this.m_vOrder - 1)).value) + this.m_avKnots.get((int)(this.m_vOrder - 1)).value;
            int iu = 0;
            while (iu <= uDiceSize) {
                int igrid = iv * (uDiceSize + 1) + iu;
                float su = (float)iu / (float)uDiceSize * (this.m_auKnots.get((int)this.m_cuVerts).value - this.m_auKnots.get((int)(this.m_uOrder - 1)).value) + this.m_auKnots.get((int)(this.m_uOrder - 1)).value;
                switch (pParameter.Type().getValue()) {
                    case 1: {
                        CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                        pData.SetValue(((p_float)this.Evaluate((float)su, (float)sv, pTParam)).value, igrid);
                        break;
                    }
                    case 2: {
                        CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                        pData.SetValue(((p_int)this.Evaluate((float)su, (float)sv, pTParam)).value, igrid);
                        break;
                    }
                    case 3: 
                    case 8: 
                    case 9: {
                        CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                        pData.SetValue((CqVector3D)this.Evaluate(su, sv, pTParam), igrid);
                        break;
                    }
                    case 7: {
                        CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                        pData.SetValue(new CqVector3D((CqVector4D)this.Evaluate(su, sv, pTParam)), igrid);
                        break;
                    }
                    case 5: {
                        CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                        pData.SetValue((CqColor)this.Evaluate(su, sv, pTParam), igrid);
                        break;
                    }
                    case 4: {
                        CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                        pData.SetValue(((p_String)this.Evaluate((float)su, (float)sv, pTParam)).value, igrid);
                        break;
                    }
                    case 11: {
                        CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                        pData.SetValue((CqMatrix)this.Evaluate(su, sv, pTParam), igrid);
                        break;
                    }
                }
                ++iu;
            }
            ++iv;
        }
    }

    @Override
    public void GenerateGeometricNormals(int uDiceSize, int vDiceSize, IqShaderData pNormals) {
        assert (this.P() != null);
        boolean CSO = this.pTransform().GetHandedness(this.pTransform().Time(0));
        boolean O = this.pAttributes().GetIntegerAttribute("System", "Orientation")[0] != 0;
        CqVector3D N = new CqVector3D();
        CqVector4D P = new CqVector4D();
        int iv = 0;
        while (iv <= vDiceSize) {
            float sv = (float)iv / (float)vDiceSize * (this.m_avKnots.get((int)this.m_cvVerts).value - this.m_avKnots.get((int)(this.m_vOrder - 1)).value) + this.m_avKnots.get((int)(this.m_vOrder - 1)).value;
            int iu = 0;
            while (iu <= uDiceSize) {
                float su = (float)iu / (float)uDiceSize * (this.m_auKnots.get((int)this.m_cuVerts).value - this.m_auKnots.get((int)(this.m_uOrder - 1)).value) + this.m_auKnots.get((int)(this.m_uOrder - 1)).value;
                int igrid = iv * (uDiceSize + 1) + iu;
                N.assignment(this.EvaluateWithNormal(su, sv, P));
                N = O == CSO ? N : N.mul(-1.0f);
                pNormals.SetNormal(N, igrid);
                ++iu;
            }
            ++iv;
        }
    }

    @Override
    public CqBound Bound() {
        CqVector3D vecA = new CqVector3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        CqVector3D vecB = new CqVector3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int cVerts = this.m_cuVerts * this.m_cvVerts;
        int i = 0;
        while (i < cVerts) {
            CqVector3D vecV = new CqVector3D(this.P().pValue_get(i, 0));
            if (vecV.x < vecA.x) {
                vecA.x(vecV.x);
            }
            if (vecV.y < vecA.y) {
                vecA.y(vecV.y);
            }
            if (vecV.x > vecB.x) {
                vecB.x(vecV.x);
            }
            if (vecV.y > vecB.y) {
                vecB.y(vecV.y);
            }
            if (vecV.z < vecA.z) {
                vecA.z(vecV.z);
            }
            if (vecV.z > vecB.z) {
                vecB.z(vecV.z);
            }
            ++i;
        }
        CqBound B = new CqBound();
        B.vecMin().assignment(vecA);
        B.vecMax().assignment(vecB);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        int cSplits = 0;
        if (this.fPatchMesh() && (this.cuSegments() > 1 || this.cvSegments() > 1)) {
            STLArray<CqSurfaceNURBS> S = new STLArray<CqSurfaceNURBS>(CqSurfaceNURBS.class);
            this.SubdivideSegments(S);
            int i = 0;
            while (i < S.size()) {
                S.get(i).SetSurfaceParameters(this);
                S.get(i).TrimLoops().aLoops().addAll(this.TrimLoops().aLoops());
                S.get((int)i).m_fDiceable = true;
                S.get((int)i).m_SplitDir.setValue(this.m_SplitDir.getValue());
                S.get((int)i).m_EyeSplitCount = this.m_EyeSplitCount;
                aSplits.add((CqBasicSurface)S.get(i));
                ++i;
            }
            return i;
        }
        CqSurfaceNURBS pNew1 = new CqSurfaceNURBS();
        CqSurfaceNURBS pNew2 = new CqSurfaceNURBS();
        this.SplitNURBS(pNew1, pNew2, this.m_SplitDir.getValue() == 0 || !this.m_fDiceable);
        for (CqParameter iUP : this.m_aUserParams) {
            if (iUP.Class().getValue() == 4) continue;
            CqParameter pNewA = iUP.Clone();
            CqParameter pNewB = iUP.Clone();
            iUP.Subdivide(pNewA, pNewB, this.SplitDir() == 0, this);
            pNew1.AddPrimitiveVariable(pNewA);
            pNew2.AddPrimitiveVariable(pNewB);
        }
        pNew1.SetSurfaceParameters(this);
        pNew2.SetSurfaceParameters(this);
        pNew1.TrimLoops().aLoops().clear();
        pNew2.TrimLoops().aLoops().clear();
        pNew1.TrimLoops().aLoops().addAll(this.TrimLoops().aLoops());
        pNew2.TrimLoops().aLoops().addAll(this.TrimLoops().aLoops());
        pNew1.m_fDiceable = true;
        pNew2.m_fDiceable = true;
        pNew1.m_SplitDir.setValue(this.m_SplitDir.getValue() == 0 ? 1 : 0);
        pNew2.m_SplitDir.setValue(this.m_SplitDir.getValue() == 0 ? 1 : 0);
        pNew1.m_EyeSplitCount = this.m_EyeSplitCount;
        pNew2.m_EyeSplitCount = this.m_EyeSplitCount;
        pNew1.SetfPatchMesh(false);
        pNew2.SetfPatchMesh(false);
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        cSplits = 2;
        if (!this.m_fDiceable) {
            STLVector<CqBasicSurface> aSplits0 = new STLVector<CqBasicSurface>(CqBasicSurface.class);
            STLVector<CqBasicSurface> aSplits1 = new STLVector<CqBasicSurface>(CqBasicSurface.class);
            cSplits = ((CqBasicSurface)aSplits.get(0)).Split(aSplits0);
            cSplits += ((CqBasicSurface)aSplits.get(1)).Split(aSplits1);
            aSplits.clear();
            aSplits.addAll(aSplits0);
            aSplits0.clear();
            aSplits.addAll(aSplits1);
        }
        return cSplits;
    }

    @Override
    public boolean Diceable() {
        int u;
        assert (this.P() != null);
        if (!this.m_fDiceable) {
            return false;
        }
        CqVector2D[] avecHull = new CqVector2D[this.m_cuVerts * this.m_cvVerts];
        float gs = 16.0f;
        float[] poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("System", "SqrtGridSize");
        if (poptGridSize != null) {
            gs = poptGridSize[0];
        }
        float gridsize = 1.0f;
        if ((double)gs >= 1.0) {
            gridsize = gs * gs;
        }
        float ShadingRateSqrt = this.pAttributes().GetFloatAttribute("System", "ShadingRateSqrt")[0];
        CqMatrix matCtoR = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), this.pTransform().matObjectToWorld(this.pTransform().Time(0)), RiGlobal.QGetRenderContext().Time());
        int i = 0;
        while (i < this.m_cuVerts * this.m_cvVerts) {
            CqVector3D vT = new CqVector3D(this.P().pValue_get(i, 0));
            vT = matCtoR.multiply(vT);
            avecHull[i] = new CqVector2D(vT);
            ++i;
        }
        float uLen = 0.0f;
        float vLen = 0.0f;
        float MaxuLen = 0.0f;
        float MaxvLen = 0.0f;
        int v = 0;
        while (v < this.m_cvVerts) {
            u = 0;
            while (u < this.m_cuVerts - 1) {
                uLen += avecHull[v * this.m_cuVerts + u + 1].sub(avecHull[v * this.m_cuVerts + u]).Magnitude();
                ++u;
            }
            if (uLen > MaxuLen) {
                MaxuLen = uLen;
            }
            uLen = 0.0f;
            ++v;
        }
        u = 0;
        while (u < this.m_cuVerts) {
            v = 0;
            while (v < this.m_cvVerts - 1) {
                vLen += avecHull[(v + 1) * this.m_cuVerts + u].sub(avecHull[v * this.m_cuVerts + u]).Magnitude();
                ++v;
            }
            if (vLen > MaxvLen) {
                MaxvLen = vLen;
            }
            vLen = 0.0f;
            ++u;
        }
        if (MaxvLen > gridsize || MaxuLen > gridsize) {
            this.m_SplitDir.setValue(MaxuLen > MaxvLen ? 0 : 1);
            avecHull = null;
            return false;
        }
        if (ShadingRateSqrt > 0.0f) {
            MaxuLen /= ShadingRateSqrt;
            MaxvLen /= ShadingRateSqrt;
        } else {
            MaxuLen = 0.0f;
            MaxvLen = 0.0f;
        }
        this.m_uDiceSize = Math.max(Math.round(MaxuLen), 1);
        this.m_vDiceSize = Math.max(Math.round(MaxvLen), 1);
        int[] binary = this.pAttributes().GetIntegerAttribute("dice", "binary");
        if (binary != null && binary[0] != 0) {
            this.m_uDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_uDiceSize);
            this.m_vDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_vDiceSize);
        }
        if (MaxuLen < 1.1920929E-7f || MaxvLen < 1.1920929E-7f) {
            this.m_fDiscard = true;
            avecHull = null;
            return false;
        }
        avecHull = null;
        this.m_SplitDir.setValue(MaxuLen > MaxvLen ? 0 : 1);
        if ((float)this.m_uDiceSize > gs) {
            return false;
        }
        return !((float)this.m_vDiceSize > gs);
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public void SetDefaultPrimitiveVariables(boolean bUseDef_st) {
        float u;
        int r;
        float v;
        int c;
        int i;
        int bUses = this.Uses();
        if (RiGlobal.USES(bUses, 12)) {
            this.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("u", new EqVariableType(1), p_float.class, p_float.class));
            this.u().SetSize(this.cVarying());
            float uinc = (this.m_umax - this.m_umin) / (float)this.cuSegments();
            int i2 = 0;
            int c2 = 0;
            while (c2 < this.cvSegments() + 1) {
                float uval = this.m_umin;
                int r2 = 0;
                while (r2 < this.cuSegments() + 1) {
                    this.u().pValue_get((int)0, (int)i2++).value = uval;
                    uval += uinc;
                    ++r2;
                }
                ++c2;
            }
        }
        if (RiGlobal.USES(bUses, 13)) {
            this.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("v", new EqVariableType(1), p_float.class, p_float.class));
            this.v().SetSize(this.cVarying());
            float vinc = (this.m_vmax - this.m_vmin) / (float)this.cvSegments();
            float vval = this.m_vmin;
            int i3 = 0;
            int c3 = 0;
            while (c3 < this.cvSegments() + 1) {
                int r3 = 0;
                while (r3 < this.cuSegments() + 1) {
                    this.v().pValue_get((int)0, (int)i3++).value = vval;
                    ++r3;
                }
                vval += vinc;
                ++c3;
            }
        }
        float[] pTC = this.pAttributes().GetFloatAttribute("System", "TextureCoordinates");
        CqVector2D st1 = new CqVector2D(pTC[0], pTC[1]);
        CqVector2D st2 = new CqVector2D(pTC[2], pTC[3]);
        CqVector2D st3 = new CqVector2D(pTC[4], pTC[5]);
        CqVector2D st4 = new CqVector2D(pTC[6], pTC[7]);
        if (RiGlobal.USES(bUses, 14) && !this.bHasVar(14) && bUseDef_st) {
            this.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("s", new EqVariableType(1), p_float.class, p_float.class));
            this.s().SetSize(this.cVarying());
            i = 0;
            c = 0;
            while (c <= this.cvSegments()) {
                v = 1.0f / (float)this.cvSegments() * (float)c;
                r = 0;
                while (r <= this.cuSegments()) {
                    u = 1.0f / (float)this.cuSegments() * (float)r;
                    this.s().pValue_get((int)0, (int)i++).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.x), new p_float((float)st2.x), new p_float((float)st3.x), new p_float((float)st4.x), (float)u, (float)v, p_float.class).value;
                    ++r;
                }
                ++c;
            }
        }
        if (RiGlobal.USES(bUses, 15) && !this.bHasVar(15) && bUseDef_st) {
            this.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("t", new EqVariableType(1), p_float.class, p_float.class));
            this.t().SetSize(this.cVarying());
            i = 0;
            c = 0;
            while (c <= this.cvSegments()) {
                v = 1.0f / (float)this.cvSegments() * (float)c;
                r = 0;
                while (r <= this.cuSegments()) {
                    u = 1.0f / (float)this.cuSegments() * (float)r;
                    this.t().pValue_get((int)0, (int)i++).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.y), new p_float((float)st2.y), new p_float((float)st3.y), new p_float((float)st4.y), (float)u, (float)v, p_float.class).value;
                    ++r;
                }
                ++c;
            }
        }
    }

    @Override
    public int cUniform() {
        int nuSegments = 1 + this.m_cuVerts - this.m_uOrder;
        int nvSegments = 1 + this.m_cvVerts - this.m_vOrder;
        return nuSegments * nvSegments;
    }

    @Override
    public int cVarying() {
        int nuSegments = 1 + this.m_cuVerts - this.m_uOrder;
        int nvSegments = 1 + this.m_cvVerts - this.m_vOrder;
        return (nuSegments + 1) * (nvSegments + 1);
    }

    @Override
    public int cVertex() {
        return this.m_cuVerts * this.m_cvVerts;
    }

    @Override
    public int cFaceVarying() {
        return 1;
    }

    @Override
    public final boolean bCanBeTrimmed() {
        return true;
    }

    @Override
    public final boolean bIsPointTrimmed(CqVector2D p) {
        return this.m_TrimLoops.TrimPoint(p);
    }

    @Override
    public final boolean bIsLineIntersecting(CqVector2D v1, CqVector2D v2) {
        return this.m_TrimLoops.LineIntersects(v1, v2);
    }

    @Override
    public int TrimDecimation(CqTrimCurve Curve) {
        float Len = 0.0f;
        float MaxLen = 0.0f;
        int cSegments = 0;
        CqMatrix matCtoR = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), this.pTransform().matObjectToWorld(this.pTransform().Time(0)), RiGlobal.QGetRenderContext().Time());
        int iTrimCurvePoint = 0;
        while (iTrimCurvePoint < Curve.cVerts() - 1) {
            CqVector3D vecCP = new CqVector3D();
            vecCP = Curve.CP(iTrimCurvePoint);
            float u = vecCP.x;
            float v = vecCP.y;
            vecCP = Curve.CP(iTrimCurvePoint + 1);
            float u2 = vecCP.x;
            float v2 = vecCP.y;
            CqVector3D vecP = new CqVector3D(this.Evaluate(u, v, this.P()));
            vecP = matCtoR.multiply(vecP);
            CqVector3D vecP2 = new CqVector3D(this.Evaluate(u2, v2, this.P()));
            Len = (vecP2 = matCtoR.multiply(vecP2)).sub(vecP).Magnitude();
            if (Len > MaxLen) {
                MaxLen = Len;
            }
            ++cSegments;
            ++iTrimCurvePoint;
        }
        float ShadingRateSqrt = this.pAttributes().GetFloatAttribute("System", "ShadingRateSqrt")[0];
        int SplitCount = (int)Math.max(MaxLen /= ShadingRateSqrt, 1.0f);
        return SplitCount * cSegments;
    }

    @Override
    public void PrepareTrimCurve() {
        this.m_TrimLoops.Prepare(this);
    }
}

