/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Vector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqLath;
import net.cellcomputing.himawari.library.CqMotionSpec;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqPolygonPoints;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqFaceLathList;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.AccessSupplier;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSubdivision2
extends CqMotionSpec<CqPolygonPoints> {
    private Vector<CqLath> m_apFacets = new Vector();
    private STLVector<Vector<CqLath>> m_aapVertices = new STLVector<Vector>(Vector.class);
    private Vector<CqLath> m_apLaths = new Vector();
    private HashMap<Integer, Boolean> m_mapHoles = new HashMap();
    private boolean m_bInterpolateBoundary = false;
    private HashMap<CqLath, Float> m_mapSharpEdges = new HashMap();
    private HashMap<CqLath, Float> m_mapSharpCorners = new HashMap();
    private boolean m_fFinalised = false;
    private static Method vertexIndex = AccessSupplier.getMethod(CqLath.class, "VertexIndex", new Class[0]);
    private static Method faceVertexIndex = AccessSupplier.getMethod(CqLath.class, "FaceVertexIndex", new Class[0]);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CqSubdivision2() {
        super(null, CqPolygonPoints.class);
    }

    public CqSubdivision2(CqPolygonPoints pPoints) {
        super(pPoints);
        this.AddTimeSlot(0.0f, pPoints);
        CqStats.STATS_INC(9);
    }

    public CqLath pFacet(int iIndex) {
        assert (iIndex < this.m_apFacets.size());
        return this.m_apFacets.get(iIndex);
    }

    public CqLath pVertex(int iIndex) {
        assert (iIndex < this.m_aapVertices.size() && ((Vector)this.m_aapVertices.get(iIndex)).size() >= 1);
        return (CqLath)((Vector)this.m_aapVertices.get(iIndex)).get(0);
    }

    public int cFacets() {
        return this.m_apFacets.size();
    }

    public int cLaths() {
        return this.m_apLaths.size();
    }

    public int cVertices() {
        return this.m_aapVertices.size();
    }

    public Vector<CqLath> apLaths() {
        return this.m_apLaths;
    }

    public CqPolygonPoints pPoints(int TimeIndex) {
        return (CqPolygonPoints)this.GetMotionObject(this.Time(TimeIndex));
    }

    public final CqPolygonPoints pPoints() {
        return this.pPoints(0);
    }

    public void Prepare(int cVerts) {
        this.m_aapVertices.resize(cVerts);
        this.m_fFinalised = false;
    }

    public CqLath AddFacet(int cVerts, int[] pIndices, int iFVIndex) {
        CqLath pLastLath = null;
        CqLath pFirstLath = null;
        int iVert = 0;
        while (iVert < cVerts) {
            CqLath pNewLath = new CqLath();
            pNewLath.SetVertexIndex(pIndices[iVert]);
            pNewLath.SetFaceVertexIndex(iFVIndex + iVert);
            if (pLastLath != null) {
                pNewLath.SetpClockwiseFacet(pLastLath);
            }
            this.m_apLaths.add(pNewLath);
            pLastLath = pNewLath;
            if (iVert == 0) {
                pFirstLath = pLastLath;
            }
            ((Vector)this.m_aapVertices.get(pIndices[iVert])).add(pLastLath);
            ++iVert;
        }
        pFirstLath.SetpClockwiseFacet(pLastLath);
        this.m_apFacets.add(pFirstLath);
        return pFirstLath;
    }

    public boolean Finalise() {
        for (Vector vector : this.m_aapVertices) {
            int iLath;
            CqLath pCurrent;
            int cLaths = vector.size();
            if (cLaths <= 1) continue;
            boolean[] aVisited = new boolean[cLaths];
            int cVisited = 0;
            CqLath pStart = pCurrent = (CqLath)vector.get(0);
            int iStart = 0;
            boolean fDone = false;
            while (!fDone) {
                int ccwVertex = pCurrent.ccf().VertexIndex();
                iLath = 0;
                iLath = 0;
                while (iLath < cLaths) {
                    if (!aVisited[iLath] && ((CqLath)vector.get(iLath)).cf().VertexIndex() == ccwVertex) {
                        pCurrent.SetpClockwiseVertex((CqLath)vector.get(iLath));
                        pCurrent = (CqLath)vector.get(iLath);
                        aVisited[iLath] = true;
                        ++cVisited;
                        break;
                    }
                    ++iLath;
                }
                boolean bl = fDone = iLath == cLaths;
            }
            if (pCurrent.cv() == null) {
                fDone = false;
                while (!fDone) {
                    int cwVertex = pStart.cf().VertexIndex();
                    iLath = 0;
                    iLath = 0;
                    while (iLath < cLaths) {
                        if (!aVisited[iLath] && ((CqLath)vector.get(iLath)).ccf().VertexIndex() == cwVertex) {
                            ((CqLath)vector.get(iLath)).SetpClockwiseVertex(pStart);
                            aVisited[iStart] = true;
                            ++cVisited;
                            pStart = (CqLath)vector.get(iLath);
                            iStart = iLath;
                            break;
                        }
                        ++iLath;
                    }
                    boolean bl = fDone = iLath == cLaths;
                }
            }
            aVisited[iStart] = true;
            if (++cVisited >= cLaths) continue;
            return false;
        }
        this.m_fFinalised = true;
        return true;
    }

    private static int modulo(int a, int b) {
        return a * b >= 0 ? a % b : a % b + b;
    }

    public void SubdivideFace(CqLath pFace, Vector<CqLath> apSubFaces) {
        assert (pFace != null);
        if (pFace.pFaceVertex() != null) {
            apSubFaces.clear();
            Vector<CqLath> aQvf = new Vector<CqLath>();
            pFace.pFaceVertex().Qvf(aQvf);
            for (CqLath iVF : aQvf) {
                apSubFaces.add(iVF.ccf().ccf());
            }
            return;
        }
        if (pFace.pParentFacet() != null) {
            Vector<CqLath> parentVertices = new Vector<CqLath>();
            pFace.pParentFacet().Qfv(parentVertices);
            Iterator iterator = parentVertices.iterator();
            while (iterator.hasNext()) {
                CqLath vertexIt;
                CqLath vertex = vertexIt = (CqLath)iterator.next();
                Vector<CqLath> vertexFaces = new Vector<CqLath>();
                vertex.Qvf(vertexFaces);
                for (CqLath faceIt : vertexFaces) {
                    CqLath face = faceIt;
                    if (face.pFaceVertex() != null) continue;
                    Vector<CqLath> dummySubFaces = new Vector<CqLath>();
                    this.SubdivideFace(face, dummySubFaces);
                }
            }
        }
        Vector<CqLath> aQfv = new Vector<CqLath>();
        pFace.Qfv(aQfv);
        int n = aQfv.size();
        int[] aVertices = new int[2 * n + 1];
        int[] aFVertices = new int[2 * n + 1];
        apSubFaces.clear();
        p_int iVert = new p_int(-1);
        p_int iFVert = new p_int(-1);
        this.AddFaceVertex(pFace, iVert, iFVert);
        aVertices[2 * n] = iVert.value;
        aFVertices[2 * n] = iFVert.value;
        int i = 0;
        while (i < n) {
            iVert.value = -1;
            iFVert.value = -2;
            if (aQfv.get(i).ec() != null && aQfv.get(i).ec().pMidVertex() != null) {
                iVert.value = aQfv.get(i).ec().pMidVertex().VertexIndex();
            }
            this.AddEdgeVertex(aQfv.get(i), iVert, iFVert);
            aVertices[i + n] = iVert.value;
            aFVertices[i + n] = iFVert.value;
            ++i;
        }
        i = 0;
        while (i < n) {
            iVert.value = -1;
            iFVert.value = -3;
            if (aQfv.get(i).pChildVertex() != null) {
                iVert.value = aQfv.get(i).pChildVertex().VertexIndex();
            }
            this.AddVertex(aQfv.get(i), iVert, iFVert);
            aVertices[i] = iVert.value;
            aFVertices[i] = iFVert.value;
            ++i;
        }
        SqFaceLathList[] apFaceLaths = new SqFaceLathList[n];
        int idx = 0;
        while (idx < n) {
            apFaceLaths[idx] = new SqFaceLathList();
            ++idx;
        }
        i = 0;
        while (i < n) {
            CqLath pLathA = apFaceLaths[i].pA = new CqLath(aVertices[i], aFVertices[i]);
            this.m_apLaths.add(pLathA);
            CqLath pLathB = apFaceLaths[i].pB = new CqLath(aVertices[CqSubdivision2.modulo(i + 1, n) + n], aFVertices[CqSubdivision2.modulo(i + 1, n) + n]);
            this.m_apLaths.add(pLathB);
            CqLath pLathC = apFaceLaths[i].pC = new CqLath(aVertices[2 * n], aFVertices[2 * n]);
            this.m_apLaths.add(pLathC);
            CqLath pLathD = apFaceLaths[i].pD = new CqLath(aVertices[i + n], aFVertices[i + n]);
            this.m_apLaths.add(pLathD);
            pLathA.SetpClockwiseFacet(pLathB);
            pLathB.SetpClockwiseFacet(pLathC);
            pLathC.SetpClockwiseFacet(pLathD);
            pLathD.SetpClockwiseFacet(pLathA);
            pLathA.SetpParentFacet(pFace);
            pLathB.SetpParentFacet(pFace);
            pLathC.SetpParentFacet(pFace);
            pLathD.SetpParentFacet(pFace);
            ((Vector)this.m_aapVertices.get(pLathA.VertexIndex())).add(pLathA);
            ((Vector)this.m_aapVertices.get(pLathB.VertexIndex())).add(pLathB);
            ((Vector)this.m_aapVertices.get(pLathC.VertexIndex())).add(pLathC);
            ((Vector)this.m_aapVertices.get(pLathD.VertexIndex())).add(pLathD);
            CqLath pNextV = aQfv.get(i);
            do {
                pNextV.SetpChildVertex(pLathA);
            } while ((pNextV = pNextV.cv()) != null && pNextV != aQfv.get(i));
            if (pNextV == null) {
                pNextV = aQfv.get(i).ccv();
                while (pNextV != null) {
                    assert (pNextV != aQfv.get(i));
                    pNextV.SetpChildVertex(pLathA);
                    pNextV = pNextV.ccv();
                }
            }
            aQfv.get(i).SetpMidVertex(pLathD);
            float sharpness = this.EdgeSharpness(aQfv.get(i));
            if (sharpness > 0.0f) {
                this.AddSharpEdge(pLathA, sharpness * sharpness);
            }
            if ((sharpness = this.EdgeSharpness(aQfv.get(CqSubdivision2.modulo(i + 1, n)))) > 0.0f) {
                this.AddSharpEdge(pLathB, sharpness * sharpness);
            }
            if (this.CornerSharpness(aQfv.get(i)) > 0.0f) {
                this.AddSharpCorner(pLathA, this.CornerSharpness(aQfv.get(i)));
            }
            CqLath pLathF = pLathA;
            int reorder = i;
            while (reorder-- > 0) {
                pLathF = pLathF.ccf();
            }
            apSubFaces.add(pLathF);
            this.m_apFacets.add(pLathF);
            ++i;
        }
        i = 0;
        while (i < n) {
            aQfv.get(i).SetpFaceVertex(apFaceLaths[i].pC);
            apFaceLaths[(i + 1) % n].pD.SetpClockwiseVertex(apFaceLaths[i].pB);
            apFaceLaths[i].pC.SetpClockwiseVertex(apFaceLaths[(i + 1) % n].pC);
            for (CqLath iVertLath : (Vector)this.m_aapVertices.get(apFaceLaths[i].pA.VertexIndex())) {
                if (iVertLath.cf().VertexIndex() == apFaceLaths[i].pD.VertexIndex()) {
                    apFaceLaths[i].pA.SetpClockwiseVertex(iVertLath);
                }
                if (iVertLath.ccf().VertexIndex() != apFaceLaths[i].pB.VertexIndex()) continue;
                iVertLath.SetpClockwiseVertex(apFaceLaths[i].pA);
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            for (CqLath iVertLath : (Vector)this.m_aapVertices.get(apFaceLaths[i].pB.VertexIndex())) {
                if (iVertLath.cf().VertexIndex() != apFaceLaths[i].pA.VertexIndex()) continue;
                apFaceLaths[i].pB.SetpClockwiseVertex(iVertLath);
            }
            for (CqLath iVertLath : (Vector)this.m_aapVertices.get(apFaceLaths[i].pD.VertexIndex())) {
                if (iVertLath.ccf().VertexIndex() != apFaceLaths[i].pA.VertexIndex()) continue;
                iVertLath.SetpClockwiseVertex(apFaceLaths[i].pD);
            }
            ++i;
        }
    }

    public boolean CanUsePatch(CqLath pFace) {
        if (pFace.cQfv() != 4) {
            return false;
        }
        Vector<CqLath> aQff = new Vector<CqLath>();
        Vector<CqLath> aQfv = new Vector<CqLath>();
        pFace.Qfv(aQfv);
        for (CqLath iFV : aQfv) {
            if (iFV.cQvv() != 4) {
                return false;
            }
            Vector<CqLath> aQve = new Vector<CqLath>();
            iFV.Qve(aQve);
            for (CqLath iVE : aQve) {
                if (this.EdgeSharpness(iVE) == 0.0f && this.CornerSharpness(iVE) == 0.0f) continue;
                return false;
            }
            CqLath pEnd = iFV.cv();
            while (iFV != pEnd) {
                if (pEnd == null) {
                    return false;
                }
                pEnd = pEnd.cv();
            }
        }
        pFace.Qff(aQff);
        if (aQff.size() != 9) {
            return false;
        }
        for (CqLath iFF : aQff) {
            if (iFF.cQfv() == 4) continue;
            return false;
        }
        for (CqLath iFV : aQfv) {
            Vector<CqLath> aQvv = new Vector<CqLath>();
            iFV.Qvv(aQvv);
            if (aQvv.get(0).FaceVertexIndex() == aQvv.get(1).FaceVertexIndex() == (aQvv.get(2).FaceVertexIndex() != 0) != (aQvv.get(3).FaceVertexIndex() != 0)) {
                return false;
            }
            if (iFV.ccv().ccf().FaceVertexIndex() != iFV.ccv().ccf().ccv().FaceVertexIndex()) {
                return false;
            }
            if (iFV.ccv().ccv().ccf().FaceVertexIndex() == iFV.ccv().ccv().ccf().ccv().FaceVertexIndex()) continue;
            return false;
        }
        return true;
    }

    public void SetInterpolateBoundary(boolean state) {
        this.m_bInterpolateBoundary = state;
    }

    public final void SetInterpolateBoundary() {
        this.SetInterpolateBoundary(true);
    }

    public boolean isInterpolateBoundary() {
        return this.m_bInterpolateBoundary;
    }

    public void SetHoleFace(int iFaceIndex) {
        this.m_mapHoles.put(iFaceIndex, true);
    }

    public boolean isHoleFace(int iFaceIndex) {
        return this.m_mapHoles.containsKey(iFaceIndex);
    }

    public void AddSharpEdge(CqLath pLath, float Sharpness) {
        this.m_mapSharpEdges.put(pLath, Float.valueOf(Sharpness));
    }

    public float EdgeSharpness(CqLath pLath) {
        if (this.m_mapSharpEdges.containsKey(pLath)) {
            return this.m_mapSharpEdges.get(pLath).floatValue();
        }
        return 0.0f;
    }

    public void AddSharpCorner(CqLath pLath, float Sharpness) {
        Vector<CqLath> aQve = new Vector<CqLath>();
        pLath.Qve(aQve);
        for (CqLath iVE : aQve) {
            this.m_mapSharpCorners.put(iVE, Float.valueOf(Sharpness));
        }
    }

    public float CornerSharpness(CqLath pLath) {
        if (this.m_mapSharpCorners.containsKey(pLath)) {
            return this.m_mapSharpCorners.get(pLath).floatValue();
        }
        return 0.0f;
    }

    public void AddVertex(CqLath pVertex, p_int iVIndex, p_int iFVIndex) {
        iFVIndex.value = 0;
        boolean fNewVertex = iVIndex.value < 0;
        int iTime = 0;
        while (iTime < this.iTimes()) {
            for (CqParameter iUP : this.pPoints(iTime).aUserParams()) {
                int iIndex = iUP.Size();
                if (iUP.Class().getValue() == 4 || iUP.Class().getValue() == 3) {
                    if (!fNewVertex) continue;
                    assert (iVIndex.value < 0 || iVIndex.value == iIndex);
                    iVIndex.value = iIndex;
                    iUP.SetSize(iIndex + 1);
                    this.m_aapVertices.resize(iVIndex.value + 1);
                } else {
                    if (iUP.Class().getValue() != 5) continue;
                    assert (iFVIndex.value == 0 || iFVIndex.value == iIndex);
                    iFVIndex.value = iIndex;
                    iUP.SetSize(iIndex + 1);
                }
                switch (iUP.Type().getValue()) {
                    case 1: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateVertexFloat(pParam, pVertex, iIndex);
                        break;
                    }
                    case 2: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateVertexInt(pParam, pVertex, iIndex);
                        break;
                    }
                    case 3: 
                    case 8: 
                    case 9: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateVertexVec3D(pParam, pVertex, iIndex);
                        break;
                    }
                    case 5: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateVertexColor(pParam, pVertex, iIndex);
                        break;
                    }
                    case 7: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateVertexVec4D(pParam, pVertex, iIndex);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                }
            }
            ++iTime;
        }
    }

    public void CreateVertexFloat(CqParameterTyped<p_float, p_float> pParam, CqLath pVertex, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            p_float S = new p_float(0.0f);
            p_float Q = new p_float(0.0f);
            p_float R = new p_float(0.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pVertex.isBoundaryVertex()) {
                    Vector<CqLath> apQve = new Vector<CqLath>();
                    pVertex.Qve(apQve);
                    if (apQve.size() == 2) {
                        pParam.pValue_get((int)iIndex, (int)arrayindex).value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                    } else {
                        Vector<CqLath> aQve = new Vector<CqLath>();
                        pVertex.Qve(aQve);
                        int cBoundaryEdges = 0;
                        for (CqLath iE : aQve) {
                            if (iE.ec() != null) continue;
                            R.value = iE.VertexIndex() == this.invokeMethod(pVertex, IndexFunction) ? (R.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iE.ccf(), (String)IndexFunction), (int)arrayindex).value) : (R.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iE, (String)IndexFunction), (int)arrayindex).value);
                            ++cBoundaryEdges;
                        }
                        assert (cBoundaryEdges == 2);
                        S.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                        pParam.pValue_get((int)iIndex, (int)arrayindex).value = (R.value + S.value * 6.0f) / 8.0f;
                    }
                } else if (this.CornerSharpness(pVertex) > 0.0f) {
                    pParam.pValue_get((int)iIndex, (int)arrayindex).value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                } else {
                    Vector<CqLath> aQve = new Vector<CqLath>();
                    pVertex.Qve(aQve);
                    CqLath hardEdge1 = null;
                    CqLath hardEdge2 = null;
                    CqLath hardEdge3 = null;
                    int se = 0;
                    for (CqLath iEdge : aQve) {
                        float h = this.EdgeSharpness(iEdge);
                        if (hardEdge1 == null || h > this.EdgeSharpness(hardEdge1)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = hardEdge1;
                            hardEdge1 = iEdge;
                        } else if (hardEdge2 == null || h > this.EdgeSharpness(hardEdge2)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = iEdge;
                        } else if (hardEdge3 == null || h > this.EdgeSharpness(hardEdge3)) {
                            hardEdge3 = iEdge;
                        }
                        if (!(h > 0.0f)) continue;
                        ++se;
                    }
                    p_float softPos = new p_float();
                    p_float semiSharpPos = new p_float();
                    p_float sharpPos = new p_float();
                    int n = aQve.size();
                    Vector<CqLath> aQvf = new Vector<CqLath>();
                    pVertex.Qvf(aQvf);
                    for (CqLath iF : aQvf) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        p_float Val = new p_float(0.0f);
                        for (CqLath iV : aQfv) {
                            Val.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iV, (String)IndexFunction), (int)arrayindex).value;
                        }
                        Val.value /= (float)aQfv.size();
                        Q.value += Val.value;
                    }
                    Q.value /= (float)aQvf.size();
                    Q.value /= (float)n;
                    p_float A = new p_float(pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value);
                    p_float B = new p_float(0.0f);
                    for (CqLath iE : aQve) {
                        B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)iE.ccf(), (String)IndexFunction), (int)arrayindex).value;
                        R.value += (A.value + B.value) / 2.0f;
                    }
                    R.value *= 2.0f;
                    R.value /= (float)n;
                    R.value /= (float)n;
                    S.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                    S.value *= (float)(n - 3);
                    S.value /= (float)n;
                    softPos.value = Q.value + R.value + S.value;
                    if (se >= 2) {
                        R.value = pParam.pValue_get((int)this.invokeMethod((CqLath)hardEdge1.ccf(), (String)IndexFunction), (int)arrayindex).value;
                        R.value += pParam.pValue_get((int)this.invokeMethod((CqLath)hardEdge2.ccf(), (String)IndexFunction), (int)arrayindex).value;
                        S.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                        semiSharpPos.value = (R.value + S.value * 6.0f) / 8.0f;
                    }
                    sharpPos.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                    p_float Pos = new p_float();
                    float h2 = hardEdge2 != null ? this.EdgeSharpness(hardEdge2) : 0.0f;
                    float h3 = hardEdge3 != null ? this.EdgeSharpness(hardEdge3) : 0.0f;
                    Pos.value = (1.0f - h2) * softPos.value;
                    Pos.value += (h2 - h3) * semiSharpPos.value;
                    Pos.value += h3 * sharpPos.value;
                    pParam.pValue_get((int)iIndex, (int)arrayindex).value = Pos.value;
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                p_float A = new p_float(pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value);
                pParam.pValue_get((int)iIndex, (int)arrayindex).value = A.value;
            }
            ++arrayindex;
        }
    }

    public void CreateVertexInt(CqParameterTyped<p_int, p_float> pParam, CqLath pVertex, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            p_int S = new p_int(0);
            p_int Q = new p_int(0);
            p_int R = new p_int(0);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pVertex.isBoundaryVertex()) {
                    Vector<CqLath> apQve = new Vector<CqLath>();
                    pVertex.Qve(apQve);
                    if (apQve.size() == 2) {
                        pParam.pValue_get((int)iIndex, (int)arrayindex).value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                    } else {
                        Vector<CqLath> aQve = new Vector<CqLath>();
                        pVertex.Qve(aQve);
                        int cBoundaryEdges = 0;
                        for (CqLath iE : aQve) {
                            if (iE.ec() != null) continue;
                            R.value = iE.VertexIndex() == this.invokeMethod(pVertex, IndexFunction) ? (R.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iE.ccf(), (String)IndexFunction), (int)arrayindex).value) : (R.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iE, (String)IndexFunction), (int)arrayindex).value);
                            ++cBoundaryEdges;
                        }
                        assert (cBoundaryEdges == 2);
                        S.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                        pParam.pValue_get((int)iIndex, (int)arrayindex).value = (R.value + S.value * 6) / 8;
                    }
                } else if (this.CornerSharpness(pVertex) > 0.0f) {
                    pParam.pValue_get((int)iIndex, (int)arrayindex).value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                } else {
                    Vector<CqLath> aQve = new Vector<CqLath>();
                    pVertex.Qve(aQve);
                    CqLath hardEdge1 = null;
                    CqLath hardEdge2 = null;
                    CqLath hardEdge3 = null;
                    int se = 0;
                    for (CqLath iEdge : aQve) {
                        float h = this.EdgeSharpness(iEdge);
                        if (hardEdge1 == null || h > this.EdgeSharpness(hardEdge1)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = hardEdge1;
                            hardEdge1 = iEdge;
                        } else if (hardEdge2 == null || h > this.EdgeSharpness(hardEdge2)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = iEdge;
                        } else if (hardEdge3 == null || h > this.EdgeSharpness(hardEdge3)) {
                            hardEdge3 = iEdge;
                        }
                        if (!(h > 0.0f)) continue;
                        ++se;
                    }
                    p_int softPos = new p_int();
                    p_int semiSharpPos = new p_int();
                    p_int sharpPos = new p_int();
                    int n = aQve.size();
                    Vector<CqLath> aQvf = new Vector<CqLath>();
                    pVertex.Qvf(aQvf);
                    for (CqLath iF : aQvf) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        p_int Val = new p_int(0);
                        for (CqLath iV : aQfv) {
                            Val.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iV, (String)IndexFunction), (int)arrayindex).value;
                        }
                        Val.value /= aQfv.size();
                        Q.value += Val.value;
                    }
                    Q.value /= aQvf.size();
                    Q.value /= n;
                    p_int A = new p_int(pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value);
                    p_int B = new p_int(0);
                    for (CqLath iE : aQve) {
                        B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)iE.ccf(), (String)IndexFunction), (int)arrayindex).value;
                        R.value = (int)((float)R.value + (float)(A.value + B.value) / 2.0f);
                    }
                    R.value *= 2;
                    R.value /= n;
                    R.value /= n;
                    S.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                    S.value *= n - 3;
                    S.value /= n;
                    softPos.value = Q.value + R.value + S.value;
                    if (se >= 2) {
                        R.value = pParam.pValue_get((int)this.invokeMethod((CqLath)hardEdge1.ccf(), (String)IndexFunction), (int)arrayindex).value;
                        R.value += pParam.pValue_get((int)this.invokeMethod((CqLath)hardEdge2.ccf(), (String)IndexFunction), (int)arrayindex).value;
                        S.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                        semiSharpPos.value = (R.value + S.value * 6) / 8;
                    }
                    sharpPos.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value;
                    p_int Pos = new p_int();
                    int h2 = hardEdge2 != null ? (int)this.EdgeSharpness(hardEdge2) : 0;
                    int h3 = hardEdge3 != null ? (int)this.EdgeSharpness(hardEdge3) : 0;
                    Pos.value = (1 - h2) * softPos.value;
                    Pos.value += (h2 - h3) * semiSharpPos.value;
                    Pos.value += h3 * sharpPos.value;
                    pParam.pValue_get((int)iIndex, (int)arrayindex).value = Pos.value;
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                p_int A = new p_int(pParam.pValue_get((int)this.invokeMethod((CqLath)pVertex, (String)IndexFunction), (int)arrayindex).value);
                pParam.pValue_get((int)iIndex, (int)arrayindex).value = A.value;
            }
            ++arrayindex;
        }
    }

    public void CreateVertexVec3D(CqParameterTyped<CqVector3D, CqVector3D> pParam, CqLath pVertex, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            CqVector3D S = new CqVector3D(0.0f);
            CqVector3D Q = new CqVector3D(0.0f);
            CqVector3D R = new CqVector3D(0.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pVertex.isBoundaryVertex()) {
                    Vector<CqLath> apQve = new Vector<CqLath>();
                    pVertex.Qve(apQve);
                    if (apQve.size() == 2) {
                        pParam.pValue_get(iIndex, arrayindex).assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    } else {
                        Vector<CqLath> aQve = new Vector<CqLath>();
                        pVertex.Qve(aQve);
                        int cBoundaryEdges = 0;
                        for (CqLath iE : aQve) {
                            if (iE.ec() != null) continue;
                            if (iE.VertexIndex() == this.invokeMethod(pVertex, IndexFunction)) {
                                R.assignAdd(pParam.pValue_get(this.invokeMethod(iE.ccf(), IndexFunction), arrayindex));
                            } else {
                                R.assignAdd(pParam.pValue_get(this.invokeMethod(iE, IndexFunction), arrayindex));
                            }
                            ++cBoundaryEdges;
                        }
                        assert (cBoundaryEdges == 2);
                        S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                        pParam.pValue_get(iIndex, arrayindex).assignment(R.add(S.mul(6.0f)).div(8.0f));
                    }
                } else if (this.CornerSharpness(pVertex) > 0.0f) {
                    pParam.pValue_get(iIndex, arrayindex).assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                } else {
                    Vector<CqLath> aQve = new Vector<CqLath>();
                    pVertex.Qve(aQve);
                    CqLath hardEdge1 = null;
                    CqLath hardEdge2 = null;
                    CqLath hardEdge3 = null;
                    int se = 0;
                    for (CqLath iEdge : aQve) {
                        float h = this.EdgeSharpness(iEdge);
                        if (hardEdge1 == null || h > this.EdgeSharpness(hardEdge1)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = hardEdge1;
                            hardEdge1 = iEdge;
                        } else if (hardEdge2 == null || h > this.EdgeSharpness(hardEdge2)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = iEdge;
                        } else if (hardEdge3 == null || h > this.EdgeSharpness(hardEdge3)) {
                            hardEdge3 = iEdge;
                        }
                        if (!(h > 0.0f)) continue;
                        ++se;
                    }
                    CqVector3D softPos = new CqVector3D();
                    CqVector3D semiSharpPos = new CqVector3D();
                    CqVector3D sharpPos = new CqVector3D();
                    int n = aQve.size();
                    Vector<CqLath> aQvf = new Vector<CqLath>();
                    pVertex.Qvf(aQvf);
                    for (CqLath iF : aQvf) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        CqVector3D Val = new CqVector3D(0.0f);
                        for (CqLath iV : aQfv) {
                            Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
                        }
                        Val.assignment(Val.div(aQfv.size()));
                        Q.assignAdd(Val);
                    }
                    Q.assignDiv(aQvf.size());
                    Q.assignDiv(n);
                    CqVector3D A = new CqVector3D(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    CqVector3D B = new CqVector3D(0.0f);
                    for (CqLath iE : aQve) {
                        B.assignment(pParam.pValue_get(this.invokeMethod(iE.ccf(), IndexFunction), arrayindex));
                        R.assignAdd(A.add(B).div(2.0f));
                    }
                    R.assignment(R.mul(2.0f));
                    R.assignDiv(n);
                    R.assignDiv(n);
                    S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    S.assignment(S.mul(n - 3));
                    S.assignDiv(n);
                    softPos.assignment(Q.add(R).add(S));
                    if (se >= 2) {
                        R.assignment(pParam.pValue_get(this.invokeMethod(hardEdge1.ccf(), IndexFunction), arrayindex));
                        R.assignment(R.add(pParam.pValue_get(this.invokeMethod(hardEdge2.ccf(), IndexFunction), arrayindex)));
                        S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                        semiSharpPos.assignment(R.add(S.mul(6.0f)).div(8.0f));
                    }
                    sharpPos.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    CqVector3D Pos = new CqVector3D();
                    float h2 = hardEdge2 != null ? this.EdgeSharpness(hardEdge2) : 0.0f;
                    float h3 = hardEdge3 != null ? this.EdgeSharpness(hardEdge3) : 0.0f;
                    Pos.assignment(softPos.mul(1.0f - h2));
                    Pos.assignment(Pos.add(semiSharpPos.mul(h2 - h3)));
                    Pos.assignment(Pos.add(sharpPos.mul(h3)));
                    pParam.pValue_get(iIndex, arrayindex).assignment(Pos);
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                CqVector3D A = new CqVector3D(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                pParam.pValue_get(iIndex, arrayindex).assignment(A);
            }
            ++arrayindex;
        }
    }

    public void CreateVertexVec4D(CqParameterTyped<CqVector4D, CqVector3D> pParam, CqLath pVertex, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            CqVector4D S = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
            CqVector4D Q = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
            CqVector4D R = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pVertex.isBoundaryVertex()) {
                    Vector<CqLath> apQve = new Vector<CqLath>();
                    pVertex.Qve(apQve);
                    if (apQve.size() == 2) {
                        pParam.pValue_get(iIndex, arrayindex).assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    } else {
                        Vector<CqLath> aQve = new Vector<CqLath>();
                        pVertex.Qve(aQve);
                        int cBoundaryEdges = 0;
                        for (CqLath iE : aQve) {
                            if (iE.ec() != null) continue;
                            if (iE.VertexIndex() == this.invokeMethod(pVertex, IndexFunction)) {
                                R.assignAdd(pParam.pValue_get(this.invokeMethod(iE.ccf(), IndexFunction), arrayindex));
                            } else {
                                R.assignAdd(pParam.pValue_get(this.invokeMethod(iE, IndexFunction), arrayindex));
                            }
                            ++cBoundaryEdges;
                        }
                        assert (cBoundaryEdges == 2);
                        S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                        pParam.pValue_get(iIndex, arrayindex).assignment(R.add(S.mul(6.0f)).div(8.0f));
                    }
                } else if (this.CornerSharpness(pVertex) > 0.0f) {
                    pParam.pValue_get(iIndex, arrayindex).assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                } else {
                    Vector<CqLath> aQve = new Vector<CqLath>();
                    pVertex.Qve(aQve);
                    CqLath hardEdge1 = null;
                    CqLath hardEdge2 = null;
                    CqLath hardEdge3 = null;
                    int se = 0;
                    for (CqLath iEdge : aQve) {
                        float h = this.EdgeSharpness(iEdge);
                        if (hardEdge1 == null || h > this.EdgeSharpness(hardEdge1)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = hardEdge1;
                            hardEdge1 = iEdge;
                        } else if (hardEdge2 == null || h > this.EdgeSharpness(hardEdge2)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = iEdge;
                        } else if (hardEdge3 == null || h > this.EdgeSharpness(hardEdge3)) {
                            hardEdge3 = iEdge;
                        }
                        if (!(h > 0.0f)) continue;
                        ++se;
                    }
                    CqVector4D softPos = new CqVector4D();
                    CqVector4D semiSharpPos = new CqVector4D();
                    CqVector4D sharpPos = new CqVector4D();
                    int n = aQve.size();
                    Vector<CqLath> aQvf = new Vector<CqLath>();
                    pVertex.Qvf(aQvf);
                    for (CqLath iF : aQvf) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        CqVector4D Val = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
                        for (CqLath iV : aQfv) {
                            Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
                        }
                        Val.assignment(Val.div(aQfv.size()));
                        Q.assignAdd(Val);
                    }
                    Q.assignDiv(aQvf.size());
                    Q.assignDiv(n);
                    CqVector4D A = new CqVector4D(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    CqVector4D B = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
                    for (CqLath iE : aQve) {
                        B.assignment(pParam.pValue_get(this.invokeMethod(iE.ccf(), IndexFunction), arrayindex));
                        R.assignAdd(A.add(B).div(2.0f));
                    }
                    R.assignment(R.mul(2.0f));
                    R.assignDiv(n);
                    R.assignDiv(n);
                    S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    S.assignment(S.mul(n - 3));
                    S.assignDiv(n);
                    softPos.assignment(Q.add(R).add(S));
                    if (se >= 2) {
                        R.assignment(pParam.pValue_get(this.invokeMethod(hardEdge1.ccf(), IndexFunction), arrayindex));
                        R.assignment(R.add(pParam.pValue_get(this.invokeMethod(hardEdge2.ccf(), IndexFunction), arrayindex)));
                        S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                        semiSharpPos.assignment(R.add(S.mul(6.0f)).div(8.0f));
                    }
                    sharpPos.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    CqVector4D Pos = new CqVector4D();
                    float h2 = hardEdge2 != null ? this.EdgeSharpness(hardEdge2) : 0.0f;
                    float h3 = hardEdge3 != null ? this.EdgeSharpness(hardEdge3) : 0.0f;
                    Pos.assignment(softPos.mul(1.0f - h2));
                    Pos.assignment(Pos.add(semiSharpPos.mul(h2 - h3)));
                    Pos.assignment(Pos.add(sharpPos.mul(h3)));
                    pParam.pValue_get(iIndex, arrayindex).assignment(Pos);
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                CqVector4D A = new CqVector4D(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                pParam.pValue_get(iIndex, arrayindex).assignment(A);
            }
            ++arrayindex;
        }
    }

    public void CreateVertexColor(CqParameterTyped<CqColor, CqColor> pParam, CqLath pVertex, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            CqColor S = new CqColor(0.0f);
            CqColor Q = new CqColor(0.0f);
            CqColor R = new CqColor(0.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pVertex.isBoundaryVertex()) {
                    Vector<CqLath> apQve = new Vector<CqLath>();
                    pVertex.Qve(apQve);
                    if (apQve.size() == 2) {
                        pParam.pValue_get(iIndex, arrayindex).assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    } else {
                        Vector<CqLath> aQve = new Vector<CqLath>();
                        pVertex.Qve(aQve);
                        int cBoundaryEdges = 0;
                        for (CqLath iE : aQve) {
                            if (iE.ec() != null) continue;
                            if (iE.VertexIndex() == this.invokeMethod(pVertex, IndexFunction)) {
                                R.assignAdd(pParam.pValue_get(this.invokeMethod(iE.ccf(), IndexFunction), arrayindex));
                            } else {
                                R.assignAdd(pParam.pValue_get(this.invokeMethod(iE, IndexFunction), arrayindex));
                            }
                            ++cBoundaryEdges;
                        }
                        assert (cBoundaryEdges == 2);
                        S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                        pParam.pValue_get(iIndex, arrayindex).assignment(R.add(S.mul(6.0f)).div(8.0f));
                    }
                } else if (this.CornerSharpness(pVertex) > 0.0f) {
                    pParam.pValue_get(iIndex, arrayindex).assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                } else {
                    Vector<CqLath> aQve = new Vector<CqLath>();
                    pVertex.Qve(aQve);
                    CqLath hardEdge1 = null;
                    CqLath hardEdge2 = null;
                    CqLath hardEdge3 = null;
                    int se = 0;
                    for (CqLath iEdge : aQve) {
                        float h = this.EdgeSharpness(iEdge);
                        if (hardEdge1 == null || h > this.EdgeSharpness(hardEdge1)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = hardEdge1;
                            hardEdge1 = iEdge;
                        } else if (hardEdge2 == null || h > this.EdgeSharpness(hardEdge2)) {
                            hardEdge3 = hardEdge2;
                            hardEdge2 = iEdge;
                        } else if (hardEdge3 == null || h > this.EdgeSharpness(hardEdge3)) {
                            hardEdge3 = iEdge;
                        }
                        if (!(h > 0.0f)) continue;
                        ++se;
                    }
                    CqColor softPos = new CqColor();
                    CqColor semiSharpPos = new CqColor();
                    CqColor sharpPos = new CqColor();
                    int n = aQve.size();
                    Vector<CqLath> aQvf = new Vector<CqLath>();
                    pVertex.Qvf(aQvf);
                    for (CqLath iF : aQvf) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        CqColor Val = new CqColor(0.0f);
                        for (CqLath iV : aQfv) {
                            Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
                        }
                        Val.assignment(Val.div(aQfv.size()));
                        Q.assignAdd(Val);
                    }
                    Q.assignDiv(aQvf.size());
                    Q.assignDiv(n);
                    CqColor A = new CqColor(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    CqColor B = new CqColor(0.0f);
                    for (CqLath iE : aQve) {
                        B.assignment(pParam.pValue_get(this.invokeMethod(iE.ccf(), IndexFunction), arrayindex));
                        R.assignAdd(A.add(B).div(2.0f));
                    }
                    R.assignment(R.mul(2.0f));
                    R.assignDiv(n);
                    R.assignDiv(n);
                    S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    S.assignment(S.mul(n - 3));
                    S.assignDiv(n);
                    softPos.assignment(Q.add(R).add(S));
                    if (se >= 2) {
                        R.assignment(pParam.pValue_get(this.invokeMethod(hardEdge1.ccf(), IndexFunction), arrayindex));
                        R.assignment(R.add(pParam.pValue_get(this.invokeMethod(hardEdge2.ccf(), IndexFunction), arrayindex)));
                        S.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                        semiSharpPos.assignment(R.add(S.mul(6.0f)).div(8.0f));
                    }
                    sharpPos.assignment(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                    CqColor Pos = new CqColor();
                    float h2 = hardEdge2 != null ? this.EdgeSharpness(hardEdge2) : 0.0f;
                    float h3 = hardEdge3 != null ? this.EdgeSharpness(hardEdge3) : 0.0f;
                    Pos.assignment(softPos.mul(1.0f - h2));
                    Pos.assignment(Pos.add(semiSharpPos.mul(h2 - h3)));
                    Pos.assignment(Pos.add(sharpPos.mul(h3)));
                    pParam.pValue_get(iIndex, arrayindex).assignment(Pos);
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                CqColor A = new CqColor(pParam.pValue_get(this.invokeMethod(pVertex, IndexFunction), arrayindex));
                pParam.pValue_get(iIndex, arrayindex).assignment(A);
            }
            ++arrayindex;
        }
    }

    public void AddEdgeVertex(CqLath pVertex, p_int iVIndex, p_int iFVIndex) {
        iFVIndex.value = 0;
        boolean fNewVertex = iVIndex.value < 0;
        int iTime = 0;
        while (iTime < this.iTimes()) {
            for (CqParameter iUP : this.pPoints(iTime).aUserParams()) {
                int iIndex = iUP.Size();
                if (iUP.Class().getValue() == 4 || iUP.Class().getValue() == 3) {
                    if (!fNewVertex) continue;
                    assert (iVIndex.value < 0 || iVIndex.value == iIndex);
                    iVIndex.value = iIndex;
                    iUP.SetSize(iIndex + 1);
                    this.m_aapVertices.resize(iVIndex.value + 1);
                } else {
                    if (iUP.Class().getValue() != 5) continue;
                    assert (iFVIndex.value == 0 || iFVIndex.value == iIndex);
                    iFVIndex.value = iIndex;
                    iUP.SetSize(iIndex + 1);
                }
                switch (iUP.Type().getValue()) {
                    case 1: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateEdgeVertexFloat(pParam, pVertex, iIndex);
                        break;
                    }
                    case 2: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateEdgeVertexInt(pParam, pVertex, iIndex);
                        break;
                    }
                    case 3: 
                    case 8: 
                    case 9: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateEdgeVertexVec3D(pParam, pVertex, iIndex);
                        break;
                    }
                    case 5: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateEdgeVertexColor(pParam, pVertex, iIndex);
                        break;
                    }
                    case 7: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateEdgeVertexVec4D(pParam, pVertex, iIndex);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                }
            }
            ++iTime;
        }
    }

    public void CreateEdgeVertexFloat(CqParameterTyped<p_float, p_float> pParam, CqLath pEdge, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            p_float A = new p_float(0.0f);
            p_float B = new p_float(0.0f);
            p_float C = new p_float(0.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pEdge.ec() != null) {
                    Vector<CqLath> aQef = new Vector<CqLath>();
                    pEdge.Qef(aQef);
                    for (CqLath iF : aQef) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        p_float Val = new p_float(0.0f);
                        for (CqLath iV : aQfv) {
                            Val.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iV, (String)IndexFunction), (int)arrayindex).value;
                        }
                        Val.value /= (float)aQfv.size();
                        C.value += Val.value;
                    }
                    C.value /= (float)aQef.size();
                    A.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge, (String)IndexFunction), (int)arrayindex).value;
                    B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge.ccf(), (String)IndexFunction), (int)arrayindex).value;
                    float h = this.EdgeSharpness(pEdge);
                    A.value = (1.0f + h) * (A.value + B.value) / 2.0f;
                    A.value = (A.value + (1.0f - h) * C.value) / 2.0f;
                } else {
                    A.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge, (String)IndexFunction), (int)arrayindex).value;
                    B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge.ccf(), (String)IndexFunction), (int)arrayindex).value;
                    A.value = (A.value + B.value) / 2.0f;
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                A.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge, (String)IndexFunction), (int)arrayindex).value;
                B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge.ccf(), (String)IndexFunction), (int)arrayindex).value;
                A.value = (A.value + B.value) / 2.0f;
            }
            pParam.pValue_get((int)iIndex, (int)arrayindex).value = A.value;
            ++arrayindex;
        }
    }

    public void CreateEdgeVertexInt(CqParameterTyped<p_int, p_float> pParam, CqLath pEdge, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            p_int A = new p_int(0);
            p_int B = new p_int(0);
            p_int C = new p_int(0);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pEdge.ec() != null) {
                    Vector<CqLath> aQef = new Vector<CqLath>();
                    pEdge.Qef(aQef);
                    for (CqLath iF : aQef) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        p_int Val = new p_int(0);
                        for (CqLath iV : aQfv) {
                            Val.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iV, (String)IndexFunction), (int)arrayindex).value;
                        }
                        Val.value /= aQfv.size();
                        C.value += Val.value;
                    }
                    C.value /= aQef.size();
                    A.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge, (String)IndexFunction), (int)arrayindex).value;
                    B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge.ccf(), (String)IndexFunction), (int)arrayindex).value;
                    int h = (int)this.EdgeSharpness(pEdge);
                    A.value = (1 + h) * (A.value + B.value) / 2;
                    A.value = (A.value + (1 - h) * C.value) / 2;
                } else {
                    A.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge, (String)IndexFunction), (int)arrayindex).value;
                    B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge.ccf(), (String)IndexFunction), (int)arrayindex).value;
                    A.value = (A.value + B.value) / 2;
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                A.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge, (String)IndexFunction), (int)arrayindex).value;
                B.value = pParam.pValue_get((int)this.invokeMethod((CqLath)pEdge.ccf(), (String)IndexFunction), (int)arrayindex).value;
                A.value = (A.value + B.value) / 2;
            }
            pParam.pValue_get((int)iIndex, (int)arrayindex).value = A.value;
            ++arrayindex;
        }
    }

    public void CreateEdgeVertexVec3D(CqParameterTyped<CqVector3D, CqVector3D> pParam, CqLath pEdge, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            CqVector3D A = new CqVector3D(0.0f);
            CqVector3D B = new CqVector3D(0.0f);
            CqVector3D C = new CqVector3D(0.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pEdge.ec() != null) {
                    Vector<CqLath> aQef = new Vector<CqLath>();
                    pEdge.Qef(aQef);
                    for (CqLath iF : aQef) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        CqVector3D Val = new CqVector3D(0.0f);
                        for (CqLath iV : aQfv) {
                            Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
                        }
                        Val.assignment(Val.div(aQfv.size()));
                        C.assignAdd(Val);
                    }
                    C.assignment(C.div(aQef.size()));
                    A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                    B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                    float h = this.EdgeSharpness(pEdge);
                    A.assignment(A.add(B).mul(1.0f + h).div(2.0f));
                    A.assignment(A.add(C.mul(1.0f - h)).div(2.0f));
                } else {
                    A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                    B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                    A.assignment(A.add(B).div(2.0f));
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                A.assignment(A.add(B).div(2.0f));
            }
            pParam.pValue_get(iIndex, arrayindex).assignment(A);
            ++arrayindex;
        }
    }

    public void CreateEdgeVertexVec4D(CqParameterTyped<CqVector4D, CqVector3D> pParam, CqLath pEdge, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            CqVector4D A = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
            CqVector4D B = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
            CqVector4D C = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pEdge.ec() != null) {
                    Vector<CqLath> aQef = new Vector<CqLath>();
                    pEdge.Qef(aQef);
                    for (CqLath iF : aQef) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        CqVector4D Val = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
                        for (CqLath iV : aQfv) {
                            Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
                        }
                        Val.assignment(Val.div(aQfv.size()));
                        C.assignAdd(Val);
                    }
                    C.assignment(C.div(aQef.size()));
                    A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                    B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                    float h = this.EdgeSharpness(pEdge);
                    A.assignment(A.add(B).mul(1.0f + h).div(2.0f));
                    A.assignment(A.add(C.mul(1.0f - h)).div(2.0f));
                } else {
                    A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                    B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                    A.assignment(A.add(B).div(2.0f));
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                A.assignment(A.add(B).div(2.0f));
            }
            pParam.pValue_get(iIndex, arrayindex).assignment(A);
            ++arrayindex;
        }
    }

    public void CreateEdgeVertexColor(CqParameterTyped<CqColor, CqColor> pParam, CqLath pEdge, int iIndex) {
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            String IndexFunction;
            CqColor A = new CqColor(0.0f);
            CqColor B = new CqColor(0.0f);
            CqColor C = new CqColor(0.0f);
            if (pParam.Class().getValue() == 4) {
                IndexFunction = pParam.Class().getValue() == 4 ? "VertexIndex" : "FaceVertexIndex";
                if (pEdge.ec() != null) {
                    Vector<CqLath> aQef = new Vector<CqLath>();
                    pEdge.Qef(aQef);
                    for (CqLath iF : aQef) {
                        Vector<CqLath> aQfv = new Vector<CqLath>();
                        iF.Qfv(aQfv);
                        CqColor Val = new CqColor(0.0f);
                        for (CqLath iV : aQfv) {
                            Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
                        }
                        Val.assignment(Val.div(aQfv.size()));
                        C.assignAdd(Val);
                    }
                    C.assignment(C.div(aQef.size()));
                    A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                    B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                    float h = this.EdgeSharpness(pEdge);
                    A.assignment(A.add(B).mul(1.0f + h).div(2.0f));
                    A.assignment(A.add(C.mul(1.0f - h)).div(2.0f));
                } else {
                    A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                    B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                    A.assignment(A.add(B).div(2.0f));
                }
            } else {
                IndexFunction = pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
                A.assignment(pParam.pValue_get(this.invokeMethod(pEdge, IndexFunction), arrayindex));
                B.assignment(pParam.pValue_get(this.invokeMethod(pEdge.ccf(), IndexFunction), arrayindex));
                A.assignment(A.add(B).div(2.0f));
            }
            pParam.pValue_get(iIndex, arrayindex).assignment(A);
            ++arrayindex;
        }
    }

    public void AddFaceVertex(CqLath pVertex, p_int iVIndex, p_int iFVIndex) {
        iVIndex.value = 0;
        iFVIndex.value = 0;
        int iTime = 0;
        while (iTime < this.iTimes()) {
            for (CqParameter iUP : this.pPoints(iTime).aUserParams()) {
                if (iUP.Class().getValue() == 2) continue;
                int iIndex = iUP.Size();
                iUP.SetSize(iIndex + 1);
                if (iUP.Class().getValue() == 4 || iUP.Class().getValue() == 3) {
                    assert (iVIndex.value == 0 || iVIndex.value == iIndex);
                    iVIndex.value = iIndex;
                } else if (iUP.Class().getValue() == 5) {
                    assert (iFVIndex.value == 0 || iFVIndex.value == iIndex);
                    iFVIndex.value = iIndex;
                }
                switch (iUP.Type().getValue()) {
                    case 1: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateFaceVertexFloat(pParam, pVertex, iIndex);
                        break;
                    }
                    case 2: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateFaceVertexInt(pParam, pVertex, iIndex);
                        break;
                    }
                    case 3: 
                    case 8: 
                    case 9: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateFaceVertexVec3D(pParam, pVertex, iIndex);
                        break;
                    }
                    case 5: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateFaceVertexColor(pParam, pVertex, iIndex);
                        break;
                    }
                    case 7: {
                        CqParameterTyped pParam = (CqParameterTyped)iUP;
                        this.CreateFaceVertexVec4D(pParam, pVertex, iIndex);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                }
            }
            ++iTime;
        }
        this.m_aapVertices.resize(iVIndex.value + 1);
    }

    public void CreateFaceVertexFloat(CqParameterTyped<p_float, p_float> pParam, CqLath pFace, int iIndex) {
        String IndexFunction = pParam.Class().getValue() == 4 || pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
        Vector<CqLath> aQfv = new Vector<CqLath>();
        pFace.Qfv(aQfv);
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            p_float Val = new p_float(0.0f);
            for (CqLath iV : aQfv) {
                assert (this.invokeMethod(iV, IndexFunction) >= 0 && this.invokeMethod(iV, IndexFunction) < pParam.Size());
                Val.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iV, (String)IndexFunction), (int)arrayindex).value;
            }
            Val.value /= (float)aQfv.size();
            pParam.pValue_get((int)iIndex, (int)arrayindex).value = Val.value;
            ++arrayindex;
        }
    }

    public void CreateFaceVertexInt(CqParameterTyped<p_int, p_float> pParam, CqLath pFace, int iIndex) {
        String IndexFunction = pParam.Class().getValue() == 4 || pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
        Vector<CqLath> aQfv = new Vector<CqLath>();
        pFace.Qfv(aQfv);
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            p_int Val = new p_int(0);
            for (CqLath iV : aQfv) {
                assert (this.invokeMethod(iV, IndexFunction) >= 0 && this.invokeMethod(iV, IndexFunction) < pParam.Size());
                Val.value += pParam.pValue_get((int)this.invokeMethod((CqLath)iV, (String)IndexFunction), (int)arrayindex).value;
            }
            Val.value /= aQfv.size();
            pParam.pValue_get((int)iIndex, (int)arrayindex).value = Val.value;
            ++arrayindex;
        }
    }

    public void CreateFaceVertexVec3D(CqParameterTyped<CqVector3D, CqVector3D> pParam, CqLath pFace, int iIndex) {
        String IndexFunction = pParam.Class().getValue() == 4 || pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
        Vector<CqLath> aQfv = new Vector<CqLath>();
        pFace.Qfv(aQfv);
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            CqVector3D Val = new CqVector3D(0.0f);
            for (CqLath iV : aQfv) {
                assert (this.invokeMethod(iV, IndexFunction) >= 0 && this.invokeMethod(iV, IndexFunction) < pParam.Size());
                Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
            }
            Val.assignment(Val.div(aQfv.size()));
            pParam.pValue_get(iIndex, arrayindex).assignment(Val);
            ++arrayindex;
        }
    }

    public void CreateFaceVertexVec4D(CqParameterTyped<CqVector4D, CqVector3D> pParam, CqLath pFace, int iIndex) {
        String IndexFunction = pParam.Class().getValue() == 4 || pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
        Vector<CqLath> aQfv = new Vector<CqLath>();
        pFace.Qfv(aQfv);
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            CqVector4D Val = new CqVector4D(0.0f, 0.0f, 0.0f, 1.0f);
            for (CqLath iV : aQfv) {
                assert (this.invokeMethod(iV, IndexFunction) >= 0 && this.invokeMethod(iV, IndexFunction) < pParam.Size());
                Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
            }
            Val.assignment(Val.div(aQfv.size()));
            pParam.pValue_get(iIndex, arrayindex).assignment(Val);
            ++arrayindex;
        }
    }

    public void CreateFaceVertexColor(CqParameterTyped<CqColor, CqColor> pParam, CqLath pFace, int iIndex) {
        String IndexFunction = pParam.Class().getValue() == 4 || pParam.Class().getValue() == 3 ? "VertexIndex" : "FaceVertexIndex";
        Vector<CqLath> aQfv = new Vector<CqLath>();
        pFace.Qfv(aQfv);
        int arraysize = 0;
        arraysize = pParam.Count();
        int arrayindex = 0;
        while (arrayindex < arraysize) {
            CqColor Val = new CqColor(0.0f);
            for (CqLath iV : aQfv) {
                assert (this.invokeMethod(iV, IndexFunction) >= 0 && this.invokeMethod(iV, IndexFunction) < pParam.Size());
                Val.assignAdd(pParam.pValue_get(this.invokeMethod(iV, IndexFunction), arrayindex));
            }
            Val.assignment(Val.div(aQfv.size()));
            pParam.pValue_get(iIndex, arrayindex).assignment(Val);
            ++arrayindex;
        }
    }

    @Override
    public void ClearMotionObject(CqPolygonPoints A) {
    }

    @Override
    public CqPolygonPoints ConcatMotionObjects(CqPolygonPoints A, CqPolygonPoints B) {
        return A;
    }

    @Override
    public CqPolygonPoints LinearInterpolateMotionObjects(float Fraction, CqPolygonPoints A, CqPolygonPoints B) {
        return A;
    }

    public void OutputMesh(String fname, Vector<CqLath> paFaces) {
        PrintStream file;
        try {
            file = new PrintStream(fname);
        }
        catch (FileNotFoundException e) {
            HimawariLogger.outputException(e);
            file = System.out;
        }
        Vector<CqLath> aQfv = new Vector<CqLath>();
        int i = 0;
        while (i < this.cVertices()) {
            CqVector3D vec = new CqVector3D(this.pPoints().P().pValue_get(0, this.pVertex(i).VertexIndex()));
            file.println("v " + vec.x + " " + vec.y + " " + vec.z);
            ++i;
        }
        i = 0;
        while (i < this.cFacets()) {
            if (this.pFacet(i).pFaceVertex() == null) {
                this.pFacet(i).Qfv(aQfv);
                file.print("f ");
                int j = 0;
                while (j < aQfv.size()) {
                    file.print(String.valueOf(aQfv.get(j).VertexIndex() + 1) + " ");
                    ++j;
                }
                file.println();
            }
            ++i;
        }
        if (paFaces != null) {
            file.println("g CurrentFace");
            i = 0;
            while (i < paFaces.size()) {
                paFaces.get(i).Qfv(aQfv);
                file.print("f ");
                int j = 0;
                while (j < aQfv.size()) {
                    file.print(String.valueOf(aQfv.get(j).VertexIndex() + 1) + " ");
                    ++j;
                }
                file.println();
                ++i;
            }
        }
        file.close();
    }

    public void OutputMesh(String fname) {
        this.OutputMesh(fname, null);
    }

    public void OutputInfo(String fname, Vector<CqLath> paFaces) {
        PrintStream file;
        try {
            file = new PrintStream(fname);
        }
        catch (FileNotFoundException e) {
            HimawariLogger.outputException(e);
            file = System.out;
        }
        Vector<CqLath> paLaths = paFaces;
        if (paLaths == null) {
            paLaths = this.m_apFacets;
        }
        paLaths = this.m_apLaths;
        CqMatrix matCameraToObject0 = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "object", new CqMatrix(), this.pPoints().pTransform().matObjectToWorld(this.pPoints().pTransform().Time(0)), this.pPoints().pTransform().Time(0));
        int i = 0;
        while (i < paLaths.size()) {
            CqLath pL = paLaths.get(i);
            file.print(String.valueOf(i) + " - " + pL + " - " + pL.VertexIndex() + " - " + pL.FaceVertexIndex() + " - (cf) ");
            if (pL.cf() != null) {
                file.print("" + pL.cf());
            } else {
                file.print("***");
            }
            file.print(" - (cv) ");
            if (pL.cv() != null) {
                file.print("" + pL.cv());
            } else {
                file.print("***");
            }
            CqVector3D vecP = new CqVector3D(this.pPoints().P().pValue_get(pL.VertexIndex(), 0));
            vecP = matCameraToObject0.multiply(vecP);
            file.print("[P=" + vecP + ")");
            file.println();
            ++i;
        }
        file.close();
    }

    private int invokeMethod(CqLath instance, String methodName) {
        try {
            if (methodName.equals("VertexIndex")) {
                return (Integer)vertexIndex.invoke((Object)instance, new Object[0]);
            }
            if (methodName.equals("FaceVertexIndex")) {
                return (Integer)faceVertexIndex.invoke((Object)instance, new Object[0]);
            }
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
        }
        return 0;
    }
}

