/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqBoundList;
import net.cellcomputing.himawari.library.CqBucket;
import net.cellcomputing.himawari.library.CqHitTestCache;
import net.cellcomputing.himawari.library.CqMicroPolygon;
import net.cellcomputing.himawari.library.CqMovingMicroPolygonKey;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqSampleData;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class CqMicroPolygonMotion
extends CqMicroPolygon {
    private CqBoundList m_BoundList = new CqBoundList();
    private boolean m_BoundReady = false;
    private STLVector<p_float> m_Times = new STLVector<p_float>(p_float.class);
    private STLVector<CqMovingMicroPolygonKey> m_Keys = new STLVector<CqMovingMicroPolygonKey>(CqMovingMicroPolygonKey.class);
    private boolean m_fTrimmed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void AppendKey(CqVector3D vA, CqVector3D vB, CqVector3D vC, CqVector3D vD, float time) {
        CqMovingMicroPolygonKey pMP = new CqMovingMicroPolygonKey(vA, vB, vC, vD);
        this.m_Times.add(new p_float(time));
        this.m_Keys.add(pMP);
        if (this.m_Times.size() == 1) {
            this.m_Bound = new CqBound(pMP.GetTotalBound());
        } else {
            this.m_Bound.Encapsulate(pMP.GetTotalBound());
        }
    }

    public void DeleteVariables(boolean all) {
    }

    public void CalculateTotalBound() {
        assert (this.m_Keys.get(0) != null);
        this.m_Bound.assignment(((CqMovingMicroPolygonKey)this.m_Keys.get(0)).GetTotalBound());
        for (CqMovingMicroPolygonKey i : this.m_Keys) {
            this.m_Bound.Encapsulate(i.GetTotalBound());
        }
    }

    public CqBound GetTotalBound() {
        return new CqBound(this.m_Bound);
    }

    public int cSubBounds() {
        if (!this.m_BoundReady) {
            this.BuildBoundList();
        }
        return this.m_BoundList.Size();
    }

    public CqBound SubBound(int iIndex, p_float time) {
        if (!this.m_BoundReady) {
            this.BuildBoundList();
        }
        assert (iIndex < this.m_BoundList.Size());
        time.value = this.m_BoundList.GetTime(iIndex);
        return this.m_BoundList.GetBound(iIndex);
    }

    /*
     * Unable to fully structure code
     */
    public void BuildBoundList() {
        opentime = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Shutter", (int)0).value;
        closetime = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Shutter", (int)1).value;
        shadingrate = this.pGrid().pAttributes().GetFloatAttribute("System", "ShadingRate")[0];
        this.m_BoundList.Clear();
        if (!CqMicroPolygonMotion.$assertionsDisabled && this.m_Keys.get(0) == null) {
            throw new AssertionError();
        }
        dx = Math.abs(((CqMovingMicroPolygonKey)this.m_Keys.firstElement()).m_Point0.x - ((CqMovingMicroPolygonKey)this.m_Keys.lastElement()).m_Point0.x);
        dy = Math.abs(((CqMovingMicroPolygonKey)this.m_Keys.firstElement()).m_Point0.y - ((CqMovingMicroPolygonKey)this.m_Keys.lastElement()).m_Point0.y);
        d = shadingrate > 0.0f ? (int)((dx + dy) / shadingrate) + 1 : 1;
        timeRanges = CqBucket.NumTimeRanges();
        divisions = Math.min(d, timeRanges);
        dt = (closetime - opentime) / (float)divisions;
        time = opentime + dt;
        startKey = 0;
        endKey = 1;
        bound = new CqBound(((CqMovingMicroPolygonKey)this.m_Keys.get(startKey)).GetTotalBound());
        this.m_BoundList.SetSize(divisions);
        i = 0;
        ** GOTO lbl45
        {
            ++endKey;
            do {
                if (time > ((p_float)this.m_Times.get((int)endKey)).value && endKey < this.m_Keys.size() - 1) continue block0;
                endKey_1 = endKey - 1;
                end0 = ((CqMovingMicroPolygonKey)this.m_Keys.get(endKey_1)).GetTotalBound();
                end0Time = ((p_float)this.m_Times.get((int)endKey_1)).value;
                end1 = ((CqMovingMicroPolygonKey)this.m_Keys.get(endKey)).GetTotalBound();
                end1Time = ((p_float)this.m_Times.get((int)endKey)).value;
                mix = (time - end0Time) / (end1Time - end0Time);
                mid = new CqBound(end0);
                mid.vecMin().assignAdd(end1.vecMin().sub(end0.vecMin()).mul(mix));
                mid.vecMax().assignAdd(end1.vecMax().sub(end0.vecMax()).mul(mix));
                bound.Encapsulate(mid);
                while (startKey < endKey_1) {
                    bound.Encapsulate(((CqMovingMicroPolygonKey)this.m_Keys.get(++startKey)).GetTotalBound());
                }
                this.m_BoundList.Set(i, bound, time - dt);
                bound.assignment(mid);
                time += dt;
                ++i;
lbl45:
                // 2 sources

            } while (i < divisions);
        }
        this.m_BoundReady = true;
    }

    public boolean Sample(SqSampleData sample, p_float D, float time, boolean UsingDof) {
        CqVector2D vecSample = sample.m_Position;
        CqHitTestCache hitTestCache = new CqHitTestCache();
        CqVector3D[] points = new CqVector3D[4];
        int i = 0;
        while (i < 4) {
            points[i] = new CqVector3D();
            ++i;
        }
        int iIndex = 0;
        float Fraction = 0.0f;
        boolean Exact = true;
        if (time > ((p_float)this.m_Times.firstElement()).value) {
            if (time >= ((p_float)this.m_Times.lastElement()).value) {
                iIndex = this.m_Times.size() - 1;
            } else {
                iIndex = 0;
                while (time >= ((p_float)this.m_Times.get((int)(iIndex + 1))).value) {
                    ++iIndex;
                }
                Fraction = (time - ((p_float)this.m_Times.get((int)iIndex)).value) / (((p_float)this.m_Times.get((int)(iIndex + 1))).value - ((p_float)this.m_Times.get((int)iIndex)).value);
                boolean bl = Exact = ((p_float)this.m_Times.get((int)iIndex)).value == time;
            }
        }
        if (Exact) {
            CqMovingMicroPolygonKey pMP1 = (CqMovingMicroPolygonKey)this.m_Keys.get(iIndex);
            points[1].assignment(pMP1.m_Point0);
            points[2].assignment(pMP1.m_Point1);
            points[3].assignment(pMP1.m_Point2);
            points[0].assignment(pMP1.m_Point3);
        } else {
            float F1 = 1.0f - Fraction;
            CqMovingMicroPolygonKey pMP1 = (CqMovingMicroPolygonKey)this.m_Keys.get(iIndex);
            CqMovingMicroPolygonKey pMP2 = (CqMovingMicroPolygonKey)this.m_Keys.get(iIndex + 1);
            points[1].assignment(pMP1.m_Point0.mul(F1).add(pMP2.m_Point0.mul(Fraction)));
            points[2].assignment(pMP1.m_Point1.mul(F1).add(pMP2.m_Point1.mul(Fraction)));
            points[3].assignment(pMP1.m_Point2.mul(F1).add(pMP2.m_Point2.mul(Fraction)));
            points[0].assignment(pMP1.m_Point3.mul(F1).add(pMP2.m_Point3.mul(Fraction)));
        }
        if (UsingDof) {
            CqVector2D coc = new CqVector2D();
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[0].z, coc);
            points[0].x(points[0].x - coc.x * sample.m_DofOffset.x);
            points[0].y(points[0].y - coc.y * sample.m_DofOffset.y);
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[1].z, coc);
            points[1].x(points[1].x - coc.x * sample.m_DofOffset.x);
            points[1].y(points[1].y - coc.y * sample.m_DofOffset.y);
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[2].z, coc);
            points[2].x(points[2].x - coc.x * sample.m_DofOffset.x);
            points[2].y(points[2].y - coc.y * sample.m_DofOffset.y);
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[3].z, coc);
            points[3].x(points[3].x - coc.x * sample.m_DofOffset.x);
            points[3].y(points[3].y - coc.y * sample.m_DofOffset.y);
        }
        this.CacheHitTestValues(hitTestCache, points);
        if (this.fContains(vecSample, D, time)) {
            this.IsTrimmed();
            if (this.pGrid().fTriangular()) {
                CqVector3D vA = new CqVector3D();
                CqVector3D vB = new CqVector3D();
                this.pGrid().TriangleSplitPoints(vA, vB, time);
                float Ax = vA.x;
                float Ay = vA.y;
                float Bx = vB.x;
                float By = vB.y;
                float v = (Ay - By) * vecSample.x + (Bx - Ax) * vecSample.y + (Ax * By - Bx * Ay);
                if (v <= 0.0f) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void MarkTrimmed() {
        this.m_fTrimmed = true;
    }

    public boolean IsMoving() {
        return true;
    }

    public final boolean IsDegenerate() {
        return ((CqMovingMicroPolygonKey)this.m_Keys.get(0)).IsDegenerate();
    }

    public int cKeys() {
        return this.m_Keys.size();
    }

    public float Time(int index) {
        assert (index < this.m_Times.size());
        return ((p_float)this.m_Times.get((int)index)).value;
    }

    public CqMovingMicroPolygonKey Key(int index) {
        assert (index < this.m_Keys.size());
        return (CqMovingMicroPolygonKey)this.m_Keys.get(index);
    }
}

