/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqQuadric;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqHyperboloid
extends CqQuadric {
    private CqVector3D m_Point1 = new CqVector3D();
    private CqVector3D m_Point2 = new CqVector3D();
    private float m_ThetaMin;
    private float m_ThetaMax;
    static /* synthetic */ Class class$0;

    public CqHyperboloid() {
        this(new CqVector3D(0.0f, 0.0f, 0.0f), new CqVector3D(0.0f, 0.0f, 1.0f), 0.0f, 1.0f);
    }

    public CqHyperboloid(CqVector3D point1) {
        this(point1, new CqVector3D(0.0f, 0.0f, 1.0f), 0.0f, 1.0f);
    }

    public CqHyperboloid(CqVector3D point1, CqVector3D point2) {
        this(point1, point2, 0.0f, 1.0f);
    }

    public CqHyperboloid(CqVector3D point1, CqVector3D point2, float thetamin) {
        this(point1, point2, thetamin, 1.0f);
    }

    public CqHyperboloid(CqVector3D point1, CqVector3D point2, float thetamin, float thetamax) {
        this.m_Point1.assignment(point1);
        this.m_Point2.assignment(point2);
        this.m_ThetaMin = thetamin;
        this.m_ThetaMax = thetamax;
    }

    public CqHyperboloid(CqHyperboloid From) {
        this.assignment(From);
    }

    @Override
    public void destruct() {
    }

    @Override
    public CqBound Bound() {
        STLVector<CqVector3D> curve = new STLVector<CqVector3D>(CqVector3D.class);
        CqVector3D vA = new CqVector3D(0.0f, 0.0f, 0.0f);
        CqVector3D vB = new CqVector3D(0.0f, 0.0f, 1.0f);
        curve.add(new CqVector3D(this.m_Point1));
        curve.add(new CqVector3D(this.m_Point2));
        CqMatrix matRot = new CqMatrix((float)Math.toRadians(this.m_ThetaMin), vB);
        for (CqVector3D i : curve) {
            i.assignment(matRot.multiply(i));
        }
        CqBound B = new CqBound(this.RevolveForBound(curve, vA, vB, (float)Math.toRadians(this.m_ThetaMax - this.m_ThetaMin)));
        B.Transform(this.m_matTx);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqVector3D DicePoint(int u, int v) {
        float theta = (float)Math.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        float vv = (float)v / (float)this.m_vDiceSize;
        CqVector3D p = new CqVector3D(this.m_Point1.mul(1.0f - vv).add(this.m_Point2.mul(vv)));
        return new CqVector3D((float)((double)p.x * Math.cos(theta)) - (float)((double)p.y * Math.sin(theta)), (float)((double)p.x * Math.sin(theta)) + (float)((double)p.y * Math.cos(theta)), p.z);
    }

    @Override
    public CqVector3D DicePoint(int u, int v, CqVector3D Normal) {
        float theta = (float)Math.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        float sin_theta = (float)Math.sin(theta);
        float cos_theta = (float)Math.cos(theta);
        float vv = (float)v / (float)this.m_vDiceSize;
        CqVector3D p = new CqVector3D(this.m_Point1.mul(1.0f - vv).add(this.m_Point2.mul(vv)));
        float dxdu = -p.x * this.m_ThetaMax * sin_theta - p.y * this.m_ThetaMax * cos_theta;
        float dydu = p.x * this.m_ThetaMax * cos_theta - p.y * this.m_ThetaMax * sin_theta;
        float dzdu = 0.0f;
        CqVector3D a = new CqVector3D(dxdu, dydu, dzdu);
        CqVector3D p2p1 = this.m_Point2.sub(this.m_Point1);
        float dxdv = p2p1.x * cos_theta - p2p1.y * sin_theta;
        float dydv = p2p1.x * sin_theta + p2p1.y * cos_theta;
        float dzdv = p2p1.z;
        CqVector3D b = new CqVector3D(dxdv, dydv, dzdv);
        Normal.assignment(a.mod(b));
        Normal.Unit();
        return new CqVector3D(p.x * cos_theta - p.y * sin_theta, p.x * sin_theta + p.y * cos_theta, p.z);
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        float arccent = (float)((double)(this.m_ThetaMin + this.m_ThetaMax) * 0.5);
        CqVector3D midpoint = new CqVector3D(this.m_Point1.add(this.m_Point2).div(2.0f));
        CqHyperboloid pNew1 = new CqHyperboloid(this);
        CqHyperboloid pNew2 = new CqHyperboloid(this);
        if (u) {
            pNew1.m_ThetaMax = arccent;
            pNew2.m_ThetaMin = arccent;
        } else {
            pNew1.m_Point2.assignment(midpoint);
            pNew2.m_Point1.assignment(midpoint);
        }
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        return 2;
    }

    public CqHyperboloid assignment(CqHyperboloid From) {
        super.assignment(From);
        this.m_Point1.assignment(From.m_Point1);
        this.m_Point2.assignment(From.m_Point2);
        this.m_ThetaMin = From.m_ThetaMin;
        this.m_ThetaMax = From.m_ThetaMax;
        return this;
    }
}

