/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public strictfp class FrameBufferPanel
extends JPanel {
    private static final long serialVersionUID = -983819772199207027L;
    private BufferedImage image;
    private BufferedImage checkImage;
    private Rectangle2D.Double image_size;
    private TexturePaint checkPaint;
    private static int CHECK_SIZE = 32;
    private static int CHECK_HALF_SIZE = CHECK_SIZE / 2;

    public FrameBufferPanel(BufferedImage image) {
        this.image = image;
        this.setSize(image.getWidth(), image.getHeight());
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        this.createCheckerImage(image);
    }

    private void createCheckerImage(BufferedImage image) {
        if (image.getType() == 2) {
            this.checkImage = new BufferedImage(CHECK_SIZE, CHECK_SIZE, 2);
            Graphics g = this.checkImage.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(CHECK_HALF_SIZE, CHECK_HALF_SIZE, CHECK_HALF_SIZE, CHECK_HALF_SIZE);
            g.fillRect(0, 0, CHECK_HALF_SIZE, CHECK_HALF_SIZE);
            g.setColor(Color.GRAY);
            g.fillRect(CHECK_HALF_SIZE, 0, CHECK_HALF_SIZE, CHECK_HALF_SIZE);
            g.fillRect(0, CHECK_HALF_SIZE, CHECK_HALF_SIZE, CHECK_HALF_SIZE);
            this.checkPaint = new TexturePaint(this.checkImage, new Rectangle2D.Double(0.0, 0.0, CHECK_SIZE, CHECK_SIZE));
            this.image_size = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image.getType() == 2) {
            this.paintCheckMark(g);
        }
        g.drawImage(this.image, 0, 0, this);
    }

    private void paintCheckMark(Graphics g) {
        ((Graphics2D)g).setPaint(this.checkPaint);
        ((Graphics2D)g).fill(this.image_size);
    }
}

