/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import slothLib.NLP.IMorphologicalAnalyzer;
import slothLib.NLP.MeCab;
import slothLib.NLP.MeCabResult;
import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;

public class MeCabServer
implements IMorphologicalAnalyzer {
    private static Process p = null;
    private static PrintWriter pw;
    private static LineNumberReader lnr;
    private static String meCabPath;
    private static String meCabRcPath;
    private static int restartCount;
    private static int doneCount;
    private static Object lockObject;

    static {
        meCabPath = null;
        meCabRcPath = null;
        restartCount = 1000;
        doneCount = 0;
        lockObject = new Object();
    }

    public MeCabServer() throws SlothLibException {
        MeCabServer.setMeCabPath(MeCab._getMeCabPath());
        MeCabServer.setMeCabRcPath(MeCab._getMeCabRcPath());
    }

    public MeCabServer(String meCabPath, String meCabRcPath) {
        MeCabServer.meCabPath = meCabPath;
        MeCabServer.meCabRcPath = meCabRcPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeCabResult doMeCab(String text) throws SlothLibException {
        StringBuffer sb = new StringBuffer();
        Object object = lockObject;
        synchronized (object) {
            String[] splitText;
            if (p == null || PortUtil.processExited(p)) {
                p = null;
                MeCabServer.startProcess();
            }
            String[] stringArray = splitText = text.split("\\n");
            int n = splitText.length;
            int n2 = 0;
            while (n2 < n) {
                String input = stringArray[n2];
                String inputTrim = input.trim();
                if (!PortUtil.isNullOrEmpty(inputTrim)) {
                    pw.println(inputTrim);
                    try {
                        String line;
                        while (!(line = lnr.readLine()).equals("EOS") && line != null) {
                            sb.append(String.valueOf(line) + "\n");
                        }
                    }
                    catch (IOException e) {
                        throw new SlothLibException(e);
                    }
                    sb.append("EOS\n");
                }
                ++n2;
            }
        }
        if (doneCount++ >= restartCount) {
            MeCabServer.stopProcess();
        }
        return new MeCabResult(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startProcess() throws SlothLibException {
        Object object = lockObject;
        synchronized (object) {
            if (p == null) {
                try {
                    ArrayList<String> cmds = new ArrayList<String>();
                    cmds.add(MeCabServer.getMeCabPath());
                    if (MeCabServer.getMeCabRcPath() != null) {
                        cmds.add("-r");
                        cmds.add(MeCabServer.getMeCabRcPath());
                    }
                    ProcessBuilder pb = new ProcessBuilder(cmds);
                    p = pb.start();
                    lnr = new LineNumberReader(new InputStreamReader(p.getInputStream(), MeCab.getMeCabEncoding()));
                    pw = new PrintWriter((Writer)new OutputStreamWriter(p.getOutputStream(), MeCab.getMeCabEncoding()), true);
                }
                catch (IOException e) {
                    p = null;
                    throw new SlothLibException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopProcess() {
        Object object = lockObject;
        synchronized (object) {
            if (p != null) {
                p.destroy();
                p = null;
                doneCount = 0;
            }
        }
    }

    @Override
    public MeCabResult doAnalyze(String text) throws SlothLibException {
        return MeCabServer.doMeCab(text);
    }

    public static String getMeCabPath() {
        return meCabPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMeCabPath(String value) throws SlothLibException {
        if (!PortUtil.fileExists(value)) {
            throw new SlothLibException("mecab.exe\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + value);
        }
        Object object = lockObject;
        synchronized (object) {
            meCabPath = value;
        }
    }

    public static String getMeCabRcPath() {
        return meCabRcPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMeCabRcPath(String value) throws SlothLibException {
        if (!PortUtil.fileExists(value)) {
            throw new SlothLibException("mecabrc\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + value);
        }
        Object object = lockObject;
        synchronized (object) {
            meCabRcPath = value;
        }
    }

    public static int getRestartCount() {
        return restartCount;
    }

    public static void setRestartCount(int value) {
        restartCount = value;
    }
}

