/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.vector;

import slothLib.linearAlgebra.vector.AbstractVector;
import slothLib.linearAlgebra.vector.IVector;

public class VectorOperator {
    private static void CheckDimension(IVector vector1, IVector vector2) {
        if (vector1.dimension() != vector2.dimension()) {
            throw new IllegalArgumentException("2\u3064\u306e\u30d9\u30af\u30c8\u30eb\u306e\u6b21\u5143\u306f\u540c\u3058\u3067\u306a\u304f\u3066\u306f\u3044\u3051\u307e\u305b\u3093\u3002");
        }
    }

    public static double getMaxNorm(IVector vector) {
        double d = 0.0;
        int i = 0;
        while (i < vector.dimension()) {
            if (d < Math.abs(vector.get(i))) {
                d = Math.abs(vector.get(i));
            }
            ++i;
        }
        return d;
    }

    public static double getPNorm(IVector vector, double p) {
        if (p < 1.0) {
            throw new IllegalArgumentException("p\u306f1\u3088\u308a\u5927\u304d\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        double d = 0.0;
        int i = 0;
        while (i < vector.dimension()) {
            d += Math.pow(vector.get(i), p);
            ++i;
        }
        return Math.pow(d, 1.0 / p);
    }

    public static double getEuclideanDistance(IVector vector) {
        double d = 0.0;
        int i = 0;
        while (i < vector.dimension()) {
            d += Math.pow(vector.get(i), 2.0);
            ++i;
        }
        return Math.sqrt(d);
    }

    public static double getEuclideanDistance(IVector vector1, IVector vector2) {
        VectorOperator.CheckDimension(vector1, vector2);
        double d = 0.0;
        int i = 0;
        while (i < vector1.dimension()) {
            d += Math.pow(vector1.get(i) - vector2.get(i), 2.0);
            ++i;
        }
        return Math.sqrt(d);
    }

    public static double getManhattanDistance(IVector vector1, IVector vector2) {
        VectorOperator.CheckDimension(vector1, vector2);
        double d = 0.0;
        int i = 0;
        while (i < vector1.dimension()) {
            d += Math.abs(vector1.get(i) - vector2.get(i));
            ++i;
        }
        return d;
    }

    public static double getInnerProduct(IVector vector1, IVector vector2) {
        VectorOperator.CheckDimension(vector1, vector2);
        double ip = 0.0;
        int i = 0;
        while (i < vector1.dimension()) {
            ip += vector1.get(i) * vector2.get(i);
            ++i;
        }
        return ip;
    }

    public static double getCosine(IVector vector1, IVector vector2) {
        VectorOperator.CheckDimension(vector1, vector2);
        double ip = VectorOperator.getInnerProduct(vector1, vector2);
        double cos = ip / (VectorOperator.getEuclideanDistance(vector1) * VectorOperator.getEuclideanDistance(vector2));
        return cos;
    }

    public static double getJaccardCoefficient(IVector vector1, IVector vector2) {
        double v1 = 0.0;
        double v2 = 0.0;
        double inner = VectorOperator.getInnerProduct(vector1, vector2);
        VectorOperator.CheckDimension(vector1, vector2);
        int i = 0;
        while (i < vector1.dimension()) {
            v1 += vector1.get(i) * vector1.get(i);
            v2 += vector2.get(i) * vector2.get(i);
            ++i;
        }
        return inner / (v1 + v2 - inner);
    }

    public static double getDiceCoefficient(IVector vector1, IVector vector2) {
        double v1 = 0.0;
        double v2 = 0.0;
        VectorOperator.CheckDimension(vector1, vector2);
        int i = 0;
        while (i < vector1.dimension()) {
            v1 += vector1.get(i) * vector1.get(i);
            v2 += vector2.get(i) * vector2.get(i);
            ++i;
        }
        return 2.0 * VectorOperator.getInnerProduct(vector1, vector2) / v1 / v2;
    }

    public static IVector add(IVector vector1, IVector vector2) {
        VectorOperator.CheckDimension(vector1, vector2);
        IVector r = (IVector)vector1.clone();
        int i = 0;
        while (i < vector2.dimension()) {
            r.set(i, r.get(i) + vector2.get(i));
            ++i;
        }
        return r;
    }

    public static IVector subtract(IVector vector1, IVector vector2) {
        VectorOperator.CheckDimension(vector1, vector2);
        return VectorOperator.add(vector1, VectorOperator.negate(vector2));
    }

    public static IVector negate(IVector vector) {
        AbstractVector r = (AbstractVector)vector.clone();
        int i = 0;
        while (i < vector.dimension()) {
            r.set(i, -vector.get(i));
            ++i;
        }
        return r;
    }

    public static IVector multiply(double scalar, IVector vector) {
        IVector r = (IVector)vector.clone();
        int i = 0;
        while (i < vector.dimension()) {
            r.set(i, scalar * r.get(i));
            ++i;
        }
        return r;
    }
}

