/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.IVideoSearch;
import slothLib.web.search.WebSearchException;
import slothLib.web.search.YahooJpVideoElement;
import slothLib.web.search.YahooJpVideoSearchResult;

public class YahooJpVideoSearch
implements IVideoSearch {
    private String applicationID;
    private SearchType type;
    private SearchFormat format;
    private boolean adultOk;
    private String[] site;
    private Proxy proxy;
    Map<String, Boolean> alreadyGotURL = new HashMap<String, Boolean>();

    public YahooJpVideoSearch(String applicationID) {
        this.applicationID = applicationID;
        this.type = SearchType.all;
        this.format = SearchFormat.any;
        this.adultOk = false;
        this.site = null;
    }

    @Override
    public YahooJpVideoSearchResult doSearch(String query, int resultNum) throws WebSearchException {
        return this.doSearch(query, resultNum, 1);
    }

    public YahooJpVideoSearchResult doSearch(String query, int resultNum, int start) throws WebSearchException {
        return this.doSearchOver(query, resultNum, start);
    }

    public long getTotalNumber(String query) throws WebSearchException {
        return this.doSearch(query, 10).getTotalResultsAvailable();
    }

    private YahooJpVideoSearchResult doSearchOriginal(String query, int results, int start) throws WebSearchException {
        String requestURL = this.MakeRequestURL(query, this.type, results, start, this.format, this.adultOk, this.site);
        Document xmlDoc = PortUtil.getDocumentFromURL(requestURL, this.proxy);
        Element xmlRoot = xmlDoc.getDocumentElement();
        long totalResultsAvailable = Long.parseLong(xmlRoot.getAttribute("totalResultsAvailable"));
        int totalResultsReturned = Integer.parseInt(xmlRoot.getAttribute("totalResultsReturned"));
        int firstResultPosition = Integer.parseInt(xmlRoot.getAttribute("firstResultPosition"));
        ArrayList<YahooJpVideoElement> resultElementList = new ArrayList<YahooJpVideoElement>();
        NodeList xmlResultList = xmlRoot.getElementsByTagName("Result");
        int rank = 1;
        String firstURL = this.getElementString(((Element)xmlResultList.item(0)).getElementsByTagName("Url"));
        if (this.alreadyGotURL.containsKey(firstURL)) {
            return new YahooJpVideoSearchResult(query, 0L, 0, -1, new YahooJpVideoElement[0]);
        }
        this.alreadyGotURL.put(firstURL, true);
        int i = 0;
        while (i < xmlResultList.getLength()) {
            Element xmlResult = (Element)xmlResultList.item(i);
            String title = this.getElementString(xmlResult.getElementsByTagName("Title"));
            String summary = this.getElementString(xmlResult.getElementsByTagName("Summary"));
            String url = this.getElementString(xmlResult.getElementsByTagName("Url"));
            String clickUrl = this.getElementString(xmlResult.getElementsByTagName("ClickUrl"));
            String refererUrl = this.getElementString(xmlResult.getElementsByTagName("RefererUrl"));
            String fileSize = this.getElementString(xmlResult.getElementsByTagName("FileSize"));
            String fileFormat = this.getElementString(xmlResult.getElementsByTagName("FileFormat"));
            String height = this.getElementString(xmlResult.getElementsByTagName("Height"));
            String width = this.getElementString(xmlResult.getElementsByTagName("Width"));
            String duration = this.getElementString(xmlResult.getElementsByTagName("Duration"));
            String streaming = this.getElementString(xmlResult.getElementsByTagName("Streaming"));
            String channels = this.getElementString(xmlResult.getElementsByTagName("Channels"));
            String restrictions = this.getElementString(xmlResult.getElementsByTagName("Restrictions"));
            String thumbnailUrl = "";
            String thumbnailHeight = "";
            String thumbnailWidth = "";
            String publisher = this.getElementString(xmlResult.getElementsByTagName("Publisher"));
            String copyright = this.getElementString(xmlResult.getElementsByTagName("Copyright"));
            NodeList xmlCacheNode = xmlResult.getElementsByTagName("Thumbnail");
            if (xmlCacheNode != null) {
                int j = 0;
                while (j < xmlCacheNode.getLength()) {
                    Element xmlCacheElement = (Element)xmlCacheNode.item(j);
                    thumbnailUrl = this.getElementString(xmlCacheElement.getElementsByTagName("Url"));
                    thumbnailHeight = this.getElementString(xmlCacheElement.getElementsByTagName("Height"));
                    thumbnailWidth = this.getElementString(xmlCacheElement.getElementsByTagName("Width"));
                    ++j;
                }
            }
            YahooJpVideoElement result = new YahooJpVideoElement(rank, title, summary, url, clickUrl, refererUrl, fileSize, fileFormat, height, width, duration, channels, streaming, thumbnailUrl, thumbnailHeight, thumbnailWidth, publisher, restrictions, copyright);
            resultElementList.add(result);
            ++rank;
            ++i;
        }
        return new YahooJpVideoSearchResult(query, totalResultsAvailable, totalResultsReturned, firstResultPosition, resultElementList.toArray(new YahooJpVideoElement[0]));
    }

    private YahooJpVideoSearchResult doSearchOver(String query, int results, int start) throws WebSearchException {
        YahooJpVideoSearchResult r;
        int loop = (results - 1) / 50;
        ArrayList<YahooJpVideoElement> result = new ArrayList<YahooJpVideoElement>();
        long totalResultsAvailable = 0L;
        int i = 0;
        while (i < loop) {
            r = this.doSearchOriginal(query, 50, i * 50 + 1);
            if (r.getFirstResultPosition() == -1) break;
            totalResultsAvailable = r.getTotalResultsAvailable();
            result.addAll(PortUtil.toList(r.getResultElements()));
            ++i;
        }
        r = this.doSearchOriginal(query, results - loop * 50, loop * 50 + 1);
        result.addAll(PortUtil.toList(r.getResultElements()));
        if (r.getFirstResultPosition() != -1) {
            totalResultsAvailable = r.getTotalResultsAvailable();
        }
        return new YahooJpVideoSearchResult(query, totalResultsAvailable, result.size(), 1, result.toArray(new YahooJpVideoElement[0]));
    }

    private String getElementString(NodeList nodeList) {
        if (nodeList.getLength() == 0) {
            return "";
        }
        return nodeList.item(0).getTextContent();
    }

    private String MakeRequestURL(String query, SearchType type, int results, int start, SearchFormat format, boolean adultOk, String[] site) {
        String strType = "";
        String strFormat = "";
        String strAdult = "";
        String strSite = "";
        switch (type) {
            case all: {
                break;
            }
            case any: {
                strType = "&type=any";
                break;
            }
            case phrase: {
                strType = "&type=phrase";
            }
        }
        switch (format) {
            case any: {
                break;
            }
            case avi: {
                strFormat = "&format=avi";
                break;
            }
            case flash: {
                strFormat = "&format=flash";
                break;
            }
            case mpeg: {
                strFormat = "&format=mpeg";
                break;
            }
            case msmedia: {
                strFormat = "&format=msmedia";
                break;
            }
            case quicktime: {
                strFormat = "&format=quicktime";
                break;
            }
            case realmedia: {
                strFormat = "&format=realmedia";
            }
        }
        if (adultOk) {
            strAdult = "&adulat_ok=1";
        }
        if (site != null) {
            if (site.length > 30) {
                throw new IllegalArgumentException("site\u306b\u6307\u5b9a\u3067\u304d\u308b\u30c9\u30e1\u30a4\u30f3\u306f30\u500b\u307e\u3067\u3067\u3059site");
            }
            String[] stringArray = site;
            int n = site.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                strSite = String.valueOf(strSite) + "&site=" + s;
                ++n2;
            }
        }
        String requestURL = "http://api.search.yahoo.co.jp/VideoSearchService/V1/videoSearch?appid=" + this.applicationID + "&query=" + query + strType + "&results=" + results + "&start=" + start + strFormat + strAdult + strSite;
        return PortUtil.absoluteUri(requestURL);
    }

    public void setType(SearchType value) {
        this.type = value;
    }

    public void setFormat(SearchFormat value) {
        this.format = value;
    }

    public void setAdultOk(boolean value) {
        this.adultOk = value;
    }

    public void setSite(String[] value) {
        this.site = value;
    }

    public void setProxy(String value) {
        this.proxy = PortUtil.isNullOrEmpty(value) ? null : PortUtil.createProxy(value);
    }

    public String getProxy() {
        return PortUtil.getProxyURL(this.proxy);
    }

    public static enum SearchFormat {
        any,
        avi,
        flash,
        mpeg,
        msmedia,
        quicktime,
        realmedia;

    }

    public static enum SearchType {
        all,
        any,
        phrase;

    }
}

