/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import com.microsoft.schemas.msnsearch._2005._09.fex.MSNSearchServiceStub;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.axis2.client.Options;
import slothLib.SlothLib;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.IWebSearch;
import slothLib.web.search.LiveWebElement;
import slothLib.web.search.LiveWebSearchResult;
import slothLib.web.search.WebSearchException;

public class LiveWebSearch
implements IWebSearch {
    private String appID;
    private SearchFlags searchFlags = SearchFlags.None;
    private SafeSearchOptions safeSearchOptions = SafeSearchOptions.Moderate;
    private Language language = Language.Japanese;
    private String fileType = "";
    public static final String KEY_PROP = "slothlib.web.search.LiveWebSearch.key";

    static {
        SlothLib.init();
    }

    public LiveWebSearch(String appID) {
        this.appID = appID;
    }

    public LiveWebSearch() throws WebSearchException {
        String tmp = System.getProperty(KEY_PROP);
        if (tmp == null) {
            throw new WebSearchException("cannot find property: slothlib.web.search.LiveWebSearch.key");
        }
        this.appID = tmp.trim();
    }

    @Override
    public LiveWebSearchResult doSearch(String query, int resultNum) throws WebSearchException {
        try {
            return this.doSearchOver(query, resultNum);
        }
        catch (RemoteException e) {
            throw new WebSearchException(e);
        }
    }

    private MSNSearchServiceStub.SearchFlags createSearchFlags(MSNSearchServiceStub.SearchFlags_type0 type0) {
        MSNSearchServiceStub.SearchFlags flags = new MSNSearchServiceStub.SearchFlags();
        flags.setSearchFlags_type0(new MSNSearchServiceStub.SearchFlags_type0[]{type0});
        return flags;
    }

    private MSNSearchServiceStub.ResultFieldMask createMask(MSNSearchServiceStub.ResultFieldMask_type0 type0) {
        MSNSearchServiceStub.ResultFieldMask mask = new MSNSearchServiceStub.ResultFieldMask();
        mask.setResultFieldMask_type0(new MSNSearchServiceStub.ResultFieldMask_type0[]{type0});
        return mask;
    }

    private LiveWebSearchResult doSearchOriginal(String query, int resultNum, int offset, int trueResultNum) throws RemoteException {
        MSNSearchServiceStub searchService = new MSNSearchServiceStub();
        MSNSearchServiceStub.SearchRequest searchRequest = new MSNSearchServiceStub.SearchRequest();
        searchRequest.setAppID(this.appID);
        Options option = searchService._getServiceClient().getOptions();
        option.setProperty("__HTTP_PROTOCOL_VERSION__", (Object)"HTTP/1.0");
        option.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        searchService._getServiceClient().setOptions(option);
        switch (this.language) {
            case Japanese: {
                searchRequest.setCultureInfo("ja-JP");
                break;
            }
            case English: {
                searchRequest.setCultureInfo("en-US");
            }
        }
        searchRequest.setQuery(query);
        switch (this.safeSearchOptions) {
            case Moderate: {
                searchRequest.setSafeSearch(MSNSearchServiceStub.SafeSearchOptions.Moderate);
                break;
            }
            case Strict: {
                searchRequest.setSafeSearch(MSNSearchServiceStub.SafeSearchOptions.Strict);
                break;
            }
            case None: {
                searchRequest.setSafeSearch(MSNSearchServiceStub.SafeSearchOptions.Off);
            }
        }
        switch (this.searchFlags) {
            case DisableHostCollapsing: {
                searchRequest.setFlags(this.createSearchFlags(MSNSearchServiceStub.SearchFlags_type0.DisableHostCollapsing));
                break;
            }
            case MarkQueryWords: {
                searchRequest.setFlags(this.createSearchFlags(MSNSearchServiceStub.SearchFlags_type0.MarkQueryWords));
                break;
            }
            case None: {
                searchRequest.setFlags(this.createSearchFlags(MSNSearchServiceStub.SearchFlags_type0.None));
            }
        }
        int arraySize = 1;
        MSNSearchServiceStub.SourceRequest[] sourceRequests = new MSNSearchServiceStub.SourceRequest[arraySize];
        sourceRequests[0] = new MSNSearchServiceStub.SourceRequest();
        sourceRequests[0].setCount(25);
        sourceRequests[0].setOffset(offset);
        sourceRequests[0].setResultFields(this.createMask(MSNSearchServiceStub.ResultFieldMask_type0.All));
        sourceRequests[0].setSource(MSNSearchServiceStub.SourceType.Web);
        if (!PortUtil.isNullOrEmpty(this.fileType)) {
            sourceRequests[0].setFileType(this.fileType);
        }
        MSNSearchServiceStub.ArrayOfSourceRequestRequests array = new MSNSearchServiceStub.ArrayOfSourceRequestRequests();
        array.setSourceRequest(sourceRequests);
        searchRequest.setRequests(array);
        MSNSearchServiceStub.Search search = new MSNSearchServiceStub.Search();
        search.setRequest(searchRequest);
        MSNSearchServiceStub.SearchResponse0 searchResponse = searchService.Search(search);
        long totalNumber = 0L;
        ArrayList<LiveWebElement> resultElements = new ArrayList<LiveWebElement>();
        MSNSearchServiceStub.ArrayOfSourceResponseResponses results = searchResponse.getResponse().getResponses();
        MSNSearchServiceStub.SourceResponse[] sourceResponseArray = results.getSourceResponse();
        int n = sourceResponseArray.length;
        int n2 = 0;
        while (n2 < n) {
            MSNSearchServiceStub.Result[] elements;
            MSNSearchServiceStub.SourceResponse response = sourceResponseArray[n2];
            totalNumber = response.getTotal();
            int count = 0;
            MSNSearchServiceStub.Result[] resultArray = elements = response.getResults().getResult();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                MSNSearchServiceStub.Result re = resultArray[n4];
                LiveWebElement element = new LiveWebElement(this.safeGet(re.getTitle()), this.safeGet(re.getDescription()), this.safeGet(re.getUrl()), this.safeGet(re.getDisplayUrl()), this.safeGet(re.getCacheUrl()), this.safeGet(re.getSearchTags()));
                resultElements.add(element);
                if (++count >= trueResultNum) break;
                ++n4;
            }
            ++n2;
        }
        return new LiveWebSearchResult(query, totalNumber, resultElements.toArray(new LiveWebElement[0]));
    }

    private String safeGet(String str) {
        return PortUtil.isNullOrEmpty(str) ? "" : str;
    }

    private LiveWebSearchResult doSearchOver(String query, int resultNum) throws RemoteException {
        int loop = (resultNum - 1) / 25;
        long total = 0L;
        ArrayList<LiveWebElement> resultElements = new ArrayList<LiveWebElement>();
        int i = 0;
        while (i < loop) {
            resultElements.addAll(Arrays.asList(this.doSearchOriginal(query, 25, 25 * i, 25).getResultElements()));
            ++i;
        }
        LiveWebSearchResult searchResult = this.doSearchOriginal(query, 25, loop * 25, resultNum - loop * 25);
        total = searchResult.getTotalNumber();
        resultElements.addAll(Arrays.asList(searchResult.getResultElements()));
        return new LiveWebSearchResult(query, total, resultElements.toArray(new LiveWebElement[0]));
    }

    public SearchFlags getSearchFlag() {
        return this.searchFlags;
    }

    public void setSerachFlag(SearchFlags value) {
        this.searchFlags = value;
    }

    public SafeSearchOptions getSafeSearchOption() {
        return this.safeSearchOptions;
    }

    public void setSafeSearchOption(SafeSearchOptions value) {
        this.safeSearchOptions = value;
    }

    public Language getSearchLanguage() {
        return this.language;
    }

    public void setSearchLanguage(Language value) {
        this.language = value;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String value) {
        this.fileType = value;
    }

    public static enum Language {
        Japanese,
        English;

    }

    public static enum SafeSearchOptions {
        Moderate,
        Strict,
        None;

    }

    public static enum SearchFlags {
        DisableHostCollapsing,
        MarkQueryWords,
        None;

    }
}

