/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.util.regex.Pattern;
import slothLib.NLP.AbstractMorphemeFilter;
import slothLib.NLP.IMorpheme;

public class PosFilter
extends AbstractMorphemeFilter {
    private Pattern regexInclude = null;
    private Pattern regexExclude = null;

    public PosFilter(String[] includePos, String[] excludePos) {
        String includePosRegex = null;
        if (includePos != null) {
            StringBuffer sbInclude = new StringBuffer();
            int i = 0;
            while (i < includePos.length) {
                sbInclude.append(includePos[i]);
                sbInclude.append("|");
                ++i;
            }
            sbInclude.deleteCharAt(sbInclude.length() - 1);
            includePosRegex = sbInclude.toString();
        }
        String excludePosRegex = null;
        if (excludePos != null) {
            StringBuffer sbExclude = new StringBuffer();
            int i = 0;
            while (i < excludePos.length) {
                sbExclude.append(excludePos[i]);
                sbExclude.append("|");
                ++i;
            }
            sbExclude.deleteCharAt(sbExclude.length() - 1);
            excludePosRegex = sbExclude.toString();
        }
        this.Initialize(includePosRegex, excludePosRegex);
    }

    public PosFilter(String[] includePos) {
        this(includePos, null);
    }

    public PosFilter(String includePosRegex, String excludePosRegex) {
        this.Initialize(includePosRegex, excludePosRegex);
    }

    public PosFilter(String includePosRegex) {
        this(includePosRegex, null);
    }

    private void Initialize(String includePosRegex, String excludePosRegex) {
        if (includePosRegex != null && includePosRegex.length() > 0) {
            this.regexInclude = Pattern.compile("^(" + includePosRegex + ").*?$");
        }
        if (excludePosRegex != null && excludePosRegex.length() > 0) {
            this.regexExclude = Pattern.compile("^(" + excludePosRegex + ").*?$");
        }
    }

    @Override
    public IMorpheme doFilter(IMorpheme morpheme) {
        String pos = morpheme.getPOS();
        if (pos == null || pos.length() == 0) {
            return null;
        }
        if (!(this.regexInclude != null && !this.regexInclude.matcher(pos).matches() || this.regexExclude != null && this.regexExclude.matcher(pos).matches())) {
            return morpheme;
        }
        return null;
    }
}

