/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed.parser;

import java.io.IOException;
import java.io.PushbackReader;
import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedLineOption;
import net.morilib.sed.SedSubstituteFlags;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.cmd.SedSCommand;

public class SedSParser
implements SedCommandParser {
    public SedCommand parse(SedCommandBundle b, PushbackReader rd, SedLineOption l) throws IOException {
        int c;
        StringBuffer fl = new StringBuffer();
        int d = rd.read();
        if (d < 0) {
            throw new SedSyntaxException();
        }
        String pt = this.parseStr(rd, d);
        String rp = this.parseStr(rd, d);
        while ((c = rd.read()) >= 0) {
            if (c == 10 || c == 59 || c == 125) {
                rd.unread(c);
                break;
            }
            fl.appendCodePoint(c);
        }
        return new SedSCommand(pt, rp, new SedSubstituteFlags(fl.toString()));
    }

    String parseStr(PushbackReader rd, int d) throws IOException {
        int c;
        StringBuffer pt = new StringBuffer();
        boolean esc = false;
        while ((c = rd.read()) != d || esc) {
            if (c < 0) {
                throw new SedSyntaxException();
            }
            if (!esc) {
                esc = c == 92;
                if (esc) continue;
                pt.appendCodePoint(c);
                continue;
            }
            if (c == d) {
                pt.appendCodePoint(c);
                esc = false;
                continue;
            }
            switch (c) {
                case 110: {
                    pt.append('\n');
                    break;
                }
                case 114: {
                    pt.append('\r');
                    break;
                }
                case 116: {
                    pt.append('\t');
                    break;
                }
                case 98: {
                    pt.append('\b');
                    break;
                }
                case 102: {
                    pt.append('\f');
                    break;
                }
                case 92: {
                    pt.append('\\');
                    break;
                }
                default: {
                    pt.append('\\').appendCodePoint(c);
                }
            }
            esc = false;
        }
        return pt.toString();
    }
}

