/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.morilib.sed.Sed;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.gui.CharsetComboBox;
import net.morilib.sed.gui.GrepFrame;
import net.morilib.sed.gui.SedOutputDialog;
import net.morilib.sed.gui.SedQuestionCommand;
import net.morilib.sed.parser.SedSimpleCommandParser;
import net.morilib.sed.pattern.SedBasicRegexEngine;
import net.morilib.unix.glob.WildcardFileFilter;
import net.morilib.unix.regex.BasicPatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedFrame
extends JFrame {
    private JTextField t1 = new JTextField(50);
    private JTextArea t2 = new JTextArea();
    private JComboBox c3 = new JComboBox();
    private JFileChooser f1 = new JFileChooser();
    private JCheckBox c1 = new JCheckBox("apply for subfolders");
    private JCheckBox c2 = new JCheckBox("not display the pattern space");
    private JCheckBox c4 = new JCheckBox("without modification");
    private JMenuBar mb = new JMenuBar();
    private JFileChooser f2 = new JFileChooser("open a script");
    private JFileChooser f3 = new JFileChooser("save the script");
    private CharsetComboBox cs1 = new CharsetComboBox();
    private CharsetComboBox cs2 = new CharsetComboBox();
    private File script;
    private SedImmediate immediate = new SedImmediate();
    private SedOutputDialog dialog;
    private SedCommandBundle bundle;
    private SedQuestionCommand qcmd;

    boolean addfs(List<File> fs, File f, boolean dir) {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File g = fileArray[n2];
                if (g.isFile() || g.isDirectory() && dir) {
                    fs.add(g);
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    void warnbox(String s) {
        JOptionPane.showMessageDialog(this, s, "sedafter", 2);
    }

    void errbox(String s) {
        JOptionPane.showMessageDialog(this, s, "sedafter", 0);
    }

    void infobox(String ... ss) {
        StringBuffer b = new StringBuffer();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            b.append(s).append('\n');
            ++n2;
        }
        JOptionPane.showMessageDialog(this, b.toString(), "sedafter", 1);
    }

    void exec1() {
        LinkedList<File> fs = new LinkedList<File>();
        String s = this.t1.getText();
        Object sf = this.c3.getSelectedItem();
        if (s == null || s.equals("")) {
            this.warnbox("path required");
            return;
        }
        if (sf == null || sf.equals("")) {
            this.warnbox("file filter required");
            return;
        }
        this.dialog.inittable();
        WildcardFileFilter ff = new WildcardFileFilter(sf.toString());
        try {
            fs.add(new File(this.t1.getText()));
            while (!fs.isEmpty()) {
                File f = (File)fs.remove(0);
                if (!this.addfs(fs, f, this.c1.isSelected()) || !ff.accept(f)) continue;
                this.qcmd.path = f.toString();
                if (this.c4.isSelected()) {
                    Sed.executeOnlyInput(this.bundle, this.t2.getText(), f, this.cs1.getSelectedCharset(), SedBasicRegexEngine.getInstance(), !this.c2.isSelected());
                    continue;
                }
                Sed.executeAndOverwrite(this.bundle, this.t2.getText(), f, this.cs1.getSelectedCharset(), this.cs2.getSelectedCharset(), SedBasicRegexEngine.getInstance(), !this.c2.isSelected());
            }
            this.dialog.showDialog();
            this.infobox("execute completed");
        }
        catch (IOException e) {
            this.errbox("I/O error");
        }
        catch (SedSyntaxException e) {
            this.errbox("script syntax error");
        }
        catch (BasicPatternSyntaxException e) {
            this.errbox("script syntax error");
        }
    }

    private void closeq(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void load1(File f) {
        block6: {
            StringWriter wr = new StringWriter();
            InputStreamReader rd = null;
            char[] a = new char[2048];
            try {
                try {
                    int l;
                    rd = new InputStreamReader(new FileInputStream(f));
                    while ((l = rd.read(a)) >= 0) {
                        wr.write(a, 0, l);
                    }
                    wr.flush();
                    this.t2.setText(wr.toString());
                }
                catch (IOException e) {
                    this.errbox("I/O error");
                    this.closeq(rd);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeq(rd);
                throw throwable;
            }
            this.closeq(rd);
        }
    }

    private void save1(File f) {
        block5: {
            OutputStreamWriter wr = null;
            try {
                try {
                    wr = new OutputStreamWriter(new FileOutputStream(f));
                    wr.write(this.t2.getText());
                    ((Writer)wr).flush();
                }
                catch (IOException e) {
                    this.errbox("I/O error");
                    this.closeq(wr);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeq(wr);
                throw throwable;
            }
            this.closeq(wr);
        }
    }

    SedFrame() {
        super("sedafter");
        GridBagConstraints ct = new GridBagConstraints();
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(750, 300));
        this.setSize(750, 450);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        p1.setLayout(new GridBagLayout());
        this.f1.setFileSelectionMode(2);
        ct.gridheight = 1;
        ct.gridwidth = 1;
        ct.weighty = 1.0;
        ct.weightx = 1.0;
        ct.fill = 1;
        p1.add((Component)new JLabel("Path:"), ct);
        ct.weightx = 8.0;
        p1.add((Component)this.t1, ct);
        ct.weightx = 1.0;
        ct.gridwidth = 0;
        JButton b1 = new JButton("File");
        b1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.f1.showDialog(SedFrame.this, "open");
                File f = SedFrame.this.f1.getSelectedFile();
                if (f != null) {
                    SedFrame.this.t1.setText(f.toString());
                }
            }
        });
        p1.add((Component)b1, ct);
        ct.gridwidth = 1;
        p1.add((Component)new JLabel("Filter:"), ct);
        ct.gridwidth = 0;
        this.c3.addItem("*");
        this.c3.setEditable(true);
        p1.add((Component)this.c3, ct);
        ct.gridwidth = 2;
        p2.add(this.c1);
        p2.add(this.c2);
        p2.add(this.c4);
        p1.add((Component)p2, ct);
        b1 = new JButton("immediate");
        ct.gridwidth = 0;
        b1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.immediate.setVisible(true);
            }
        });
        p1.add((Component)b1, ct);
        ct.gridwidth = 0;
        p3.setLayout(new GridLayout(2, 2));
        p3.add(new JLabel("Input Encoding"));
        p3.add(new JLabel("Output Encoding"));
        p3.add(this.cs1);
        p3.add(this.cs2);
        p1.add((Component)p3, ct);
        cp.add((Component)p1, "North");
        cp.add((Component)new JScrollPane(this.t2), "Center");
        JButton b2 = new JButton("execute");
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.exec1();
            }
        });
        cp.add((Component)b2, "South");
        JMenu m1 = new JMenu("File");
        JMenuItem i1 = new JMenuItem("Open File...");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.f2.showOpenDialog(SedFrame.this);
                File f = SedFrame.this.f2.getSelectedFile();
                if (f != null) {
                    File file = f;
                    SedFrame.this.script = file;
                    SedFrame.this.load1(file);
                }
            }
        });
        i1.setMnemonic('o');
        i1.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        m1.add(i1);
        i1 = new JMenuItem("Save");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.save1(SedFrame.this.script);
            }
        });
        i1.setMnemonic('s');
        i1.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        m1.add(i1);
        i1 = new JMenuItem("Save As...");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.f3.showOpenDialog(SedFrame.this);
                File f = SedFrame.this.f3.getSelectedFile();
                if (f != null) {
                    File file = f;
                    SedFrame.this.script = file;
                    SedFrame.this.save1(file);
                }
            }
        });
        i1.setMnemonic('a');
        m1.add(i1);
        this.mb.add(m1);
        m1 = new JMenu("Help");
        i1 = new JMenuItem("Show Immediate Window");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.immediate.setVisible(true);
            }
        });
        m1.add(i1);
        i1 = new JMenuItem("About Sedafter");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SedFrame.this.infobox("Sedafter Version 0.0.0", "Copyright 2013 Yuichiro Moriguchi", "This software under Apache 2.0 License");
            }
        });
        m1.add(i1);
        this.mb.add(m1);
        this.setJMenuBar(this.mb);
        this.dialog = new SedOutputDialog(this);
        this.bundle = SedCommandBundle.newInstance();
        this.qcmd = new SedQuestionCommand();
        this.qcmd.dialog = this.dialog;
        this.bundle.put(63, (SedCommandParser)new SedSimpleCommandParser(this.qcmd));
    }

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("--grep")) {
            new GrepFrame().setVisible(true);
        } else {
            new SedFrame().setVisible(true);
        }
    }

    class SedImmediate
    extends JDialog {
        JTextArea left;
        JTextArea right;

        SedImmediate() {
            super((Frame)SedFrame.this, "sedafter - immediate");
            this.left = new JTextArea();
            this.right = new JTextArea();
            Container cp = this.getContentPane();
            JSplitPane s1 = new JSplitPane(1);
            this.setDefaultCloseOperation(1);
            this.setSize(500, 400);
            this.right.setEditable(false);
            s1.setLeftComponent(new JScrollPane(this.left));
            s1.setRightComponent(new JScrollPane(this.right));
            s1.setResizeWeight(0.5);
            JButton b1 = new JButton("execute");
            b1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        ((SedFrame)((SedImmediate)SedImmediate.this).SedFrame.this).qcmd.path = "(immediate)";
                        SedFrame.this.dialog.inittable();
                        String s = Sed.execute(SedFrame.this.bundle, SedFrame.this.t2.getText(), SedImmediate.this.left.getText(), null, null, SedBasicRegexEngine.getInstance(), !SedFrame.this.c2.isSelected());
                        SedImmediate.this.right.setText(s);
                        SedFrame.this.dialog.showDialog();
                    }
                    catch (IOException e) {
                        SedFrame.this.errbox("I/O error");
                    }
                    catch (SedSyntaxException e) {
                        SedFrame.this.errbox("script syntax error");
                    }
                    catch (BasicPatternSyntaxException e) {
                        SedFrame.this.errbox("script syntax error");
                    }
                }
            });
            cp.setLayout(new BorderLayout());
            cp.add((Component)s1, "Center");
            cp.add((Component)b1, "South");
        }
    }
}

