/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed.cmd;

import java.io.IOException;
import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;
import net.morilib.sed.Tr;

public class SedYCommand
implements SedCommand {
    private String before;
    private String after;

    public SedYCommand(String before, String after) {
        this.before = before;
        this.after = after;
    }

    public String getLongDescription() {
        return "translate";
    }

    public char getName() {
        return 'y';
    }

    public void process(SedSpace s, SedLineBuffer rd) throws IOException {
        s.setPatternSpace(Tr.tr(this.before, this.after, s.toString()));
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public int hashCode() {
        return this.before.hashCode() * 17 + this.after.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SedYCommand) {
            return this.before.equals(((SedYCommand)o).before) && this.after.equals(((SedYCommand)o).after);
        }
        return false;
    }

    public String toString() {
        return "y/" + this.before + "/" + this.after + "/";
    }
}

