/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;
import net.morilib.tr.Tr;


public class SedYCommand implements SedCommand {

	private String before, after;

	public SedYCommand(String before, String after) {
		this.before = before;
		this.after  = after;
	}

	public String getLongDescription() {
		return "translate";
	}

	public char getName() {
		return 'y';
	}

	public void process(SedSpace s,
			SedLineBuffer rd) throws IOException {
		s.setPatternSpace(Tr.tr(before, after, s.toString()));
	}

	public String getBefore() {
		return before;
	}

	public String getAfter() {
		return after;
	}

	public int hashCode() {
		return before.hashCode() * 17 + after.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof SedYCommand) {
			return (before.equals(((SedYCommand)o).before) &&
					after.equals(((SedYCommand)o).after));
		}
		return false;
	}

	public String toString() {
		return "y/" + before + "/" + after + "/";
	}

}
